/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.mouse;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import mausoleum.alert.Alert;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class SelectGenotypeRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int BREITE = UIDef.getScaled(300);
    private static final int HOEHE = UIDef.getScaled(300);
    private static final int INTER_LINE = UIDef.getScaled(5);
    private static final int LINE_HEIGHT = UIDef.getScaled(26);
    private static final int LABEL_WIDTH = UIDef.getScaled(100);
    private static final int COMBO_WIDTH = BREITE - 3 * UIDef.RAND - LABEL_WIDTH;
    private InspectorPanel ivPanel = null;
    private Vector ivMice = null;
    private Vector ivLocusLines = new Vector();

    public static void setGenotype(Vector mice, InspectorPanel inspectorPanel) {
        LocusAndAlleles[] laaArray;
        Line line;
        long lineID;
        String group = IDObject.commonGroup(mice);
        if (group != null && (lineID = Mouse.getCommonMouseRefID(mice, "MOS_LINEID", 0L, 0L)) > 0L && (line = ((Mouse)mice.firstElement()).getLine()) != null && !line.isBreeder() && (laaArray = (LocusAndAlleles[])line.get("LIN_LOCIALLELES")) != null && laaArray.length != 0) {
            int sexmode = 3;
            int mcs = Mouse.getCommonSex(mice, 0, -1);
            if (mcs == 1) {
                sexmode = 1;
            } else if (mcs == 2) {
                sexmode = 2;
            }
            try {
                new SelectGenotypeRequester(mice, laaArray, sexmode, inspectorPanel, group, false);
            }
            catch (IllegalArgumentException e) {
                Alert.showAlert(e.getMessage(), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setGenotype(Vector mice, Line line) {
        LocusAndAlleles[] laaArray = (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
        if (laaArray != null && laaArray.length != 0) {
            int sexmode = 4;
            try {
                new SelectGenotypeRequester(mice, laaArray, sexmode, null, line.getGroup(), true);
            }
            catch (IllegalArgumentException e) {
                Alert.showAlert(e.getMessage(), true);
            }
        }
    }

    private SelectGenotypeRequester(Vector mice, LocusAndAlleles[] laaArray, int sexmode, InspectorPanel inspectorPanel, String group, boolean stressRuleMode) throws IllegalArgumentException {
        super((Frame)Inspector.getInspector(), BREITE, HOEHE);
        this.ivMice = mice;
        this.ivPanel = inspectorPanel;
        this.setTitle(Babel.get("SETGENOTYPE"));
        int y = UIDef.RAND;
        int i = 0;
        while (i < laaArray.length) {
            LocusZeile ll = new LocusZeile(laaArray[i], sexmode, group, stressRuleMode);
            this.ivLocusLines.addElement(ll);
            ++i;
        }
        int maxlw = LABEL_WIDTH;
        int maxrw = COMBO_WIDTH;
        Iterator iterator = this.ivLocusLines.iterator();
        while (iterator.hasNext()) {
            LocusZeile lz = (LocusZeile)iterator.next();
            int w = ((LocusZeile)lz).ivLocusNameLabel.getPreferredSize().width;
            if (w > maxlw) {
                maxlw = w;
            }
            if ((w = ((LocusZeile)lz).ivGenotypesCombo.getPreferredSize().width) <= maxrw) continue;
            maxrw = w;
        }
        int x1 = UIDef.RAND;
        int x2 = x1 + maxlw + UIDef.INNER_RAND;
        int gesw = x2 + maxrw + UIDef.RAND;
        Iterator iterator2 = this.ivLocusLines.iterator();
        while (iterator2.hasNext()) {
            LocusZeile ll = (LocusZeile)iterator2.next();
            this.addAndApplyBounds(ll.ivLocusNameLabel, x1, y, maxlw, LINE_HEIGHT);
            this.addAndApplyBounds(ll.ivGenotypesCombo, x2, y, maxrw, LINE_HEIGHT);
            y += LINE_HEIGHT + INTER_LINE;
        }
        this.applyBounds(this.ivOkButton, UIDef.RAND, y, gesw - 2 * UIDef.RAND, UIDef.BUT_HEIGHT);
        this.setInnerSize(gesw, y += UIDef.BUT_HEIGHT + UIDef.RAND);
        this.setVisible(true);
    }

    public void OKPressed() {
        block8: {
            block7: {
                if (this.ivPanel == null) break block7;
                String commonGroup = IDObject.commonGroup(this.ivMice);
                if (commonGroup == null) break block8;
                boolean somethingChanged = false;
                Iterator iter = this.ivLocusLines.iterator();
                while (iter.hasNext()) {
                    LocusZeile ll = (LocusZeile)iter.next();
                    somethingChanged |= ll.somethingChanged();
                }
                if (!somethingChanged) break block8;
                StringBuffer msb = new StringBuffer();
                Iterator iter2 = this.ivLocusLines.iterator();
                while (iter2.hasNext()) {
                    LocusZeile ll = (LocusZeile)iter2.next();
                    msb.append(ll.getYourCommand(this.ivMice));
                }
                iter2 = this.ivMice.iterator();
                while (iter2.hasNext()) {
                    Mouse mouse = (Mouse)iter2.next();
                    boolean komplett = true;
                    Iterator iter22 = this.ivLocusLines.iterator();
                    while (iter22.hasNext()) {
                        LocusZeile ll = (LocusZeile)iter22.next();
                        if (ll.isMouseCompleteForLocus(mouse)) continue;
                        komplett = false;
                    }
                    if (!komplett) continue;
                    TaskExtended.addTaskFinishsToComBuff(mouse, mouse.getTaskKey(), "TASK_AC_GENOTYPE", 0L, msb, MyDate.HEUTE);
                }
                String com = msb.toString().trim();
                if (com.length() == 0) break block8;
                InspectorCommandSender.executeCommand(com, commonGroup);
                break block8;
            }
            if (this.ivMice != null && !this.ivMice.isEmpty() && this.ivLocusLines != null && !this.ivLocusLines.isEmpty()) {
                Hashtable<Long, LocusAndAlleles> lalHT = new Hashtable<Long, LocusAndAlleles>(this.ivLocusLines.size());
                Iterator iter = this.ivLocusLines.iterator();
                while (iter.hasNext()) {
                    LocusZeile ll = (LocusZeile)iter.next();
                    LocusAndAlleles lal = ll.getSelectedLAL();
                    lalHT.put(new Long(lal.ivLocusID), lal);
                }
                iter = this.ivMice.iterator();
                while (iter.hasNext()) {
                    this.manageMouse((Mouse)iter.next(), lalHT);
                }
            }
        }
        super.OKPressed();
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    private void manageMouse(Mouse mouse, Hashtable lalHT) {
        Hashtable<Long, LocusAndAlleles> mlalHT = new Hashtable<Long, LocusAndAlleles>(lalHT.size());
        LocusAndAlleles[] lalarr = (LocusAndAlleles[])mouse.get("MOS_LOCUSGENOTYPES");
        if (lalarr != null) {
            int i = 0;
            while (i < lalarr.length) {
                mlalHT.put(new Long(lalarr[i].ivLocusID), lalarr[i]);
                ++i;
            }
        }
        Enumeration<Object> en = lalHT.keys();
        while (en.hasMoreElements()) {
            Long key = (Long)en.nextElement();
            LocusAndAlleles lal = (LocusAndAlleles)lalHT.get(key);
            if (lal.ivAllele == null) {
                mlalHT.remove(key);
                continue;
            }
            if (lal.ivAllele.length == 1 && lal.ivAllele[0].equals("@DONIX@")) continue;
            mlalHT.put(key, lal);
        }
        if (mlalHT.isEmpty()) {
            mouse.set("MOS_LOCUSGENOTYPES", null);
        } else {
            lalarr = new LocusAndAlleles[mlalHT.size()];
            int pos = 0;
            en = mlalHT.elements();
            while (en.hasMoreElements()) {
                lalarr[pos] = (LocusAndAlleles)en.nextElement();
                ++pos;
            }
            mouse.set("MOS_LOCUSGENOTYPES", lalarr);
        }
    }

    class LocusZeile {
        private LocusAndAlleles ivLAL = null;
        private JLabel ivLocusNameLabel = null;
        private JComboBox ivGenotypesCombo = null;
        private Vector ivPossibleLocusAndAlleles = null;
        private boolean ivStressRuleMode = false;

        private LocusZeile(LocusAndAlleles lal, int sexmode, String group, boolean stressRuleMode) {
            this.ivLAL = lal;
            this.ivStressRuleMode = stressRuleMode;
            Locus locus = (Locus)ObjectStore.getClientObject(14, this.ivLAL.ivLocusID, group);
            if (locus == null) {
                throw new IllegalArgumentException("Locus undefined");
            }
            String locusName = locus.getBrowseName();
            this.ivLocusNameLabel = new JLabel(locusName);
            this.ivLocusNameLabel.setFont(FontManager.getFont("SSB14"));
            this.ivLocusNameLabel.setOpaque(false);
            this.ivPossibleLocusAndAlleles = locus.getListOfGenotypes(sexmode, this.ivLAL.ivAllele, false);
            Vector<String> displayGenotypes = new Vector<String>();
            if (stressRuleMode) {
                displayGenotypes.addElement("<html><b>" + Babel.get("DOESNTMATTER") + "</b></html>");
            } else {
                displayGenotypes.addElement("<html><b>" + Babel.get("DONTCHANGE") + "</b></html>");
                displayGenotypes.addElement("<html><b>" + Babel.get("REMOVEGENOTYPE") + "</b></html>");
            }
            int i = 0;
            while (i < this.ivPossibleLocusAndAlleles.size()) {
                LocusAndAlleles laa = (LocusAndAlleles)this.ivPossibleLocusAndAlleles.elementAt(i);
                displayGenotypes.addElement(laa.toGenotypeStringMultiFont(group));
                ++i;
            }
            this.ivGenotypesCombo = new JComboBox(displayGenotypes);
            this.ivGenotypesCombo.setFont(FontManager.getFont("SSP12"));
        }

        private boolean somethingChanged() {
            return this.ivGenotypesCombo.getSelectedIndex() != 0;
        }

        private LocusAndAlleles getSelectedLAL() {
            int selind = this.ivGenotypesCombo.getSelectedIndex();
            if (this.ivStressRuleMode) {
                if (selind == 0) {
                    return new LocusAndAlleles(this.ivLAL.ivLocusID, "@DONIX@");
                }
                return (LocusAndAlleles)this.ivPossibleLocusAndAlleles.elementAt(selind - 1);
            }
            if (selind == 1) {
                return new LocusAndAlleles(this.ivLAL.ivLocusID);
            }
            if (selind == 0) {
                return new LocusAndAlleles(this.ivLAL.ivLocusID, "@DONIX@");
            }
            return (LocusAndAlleles)this.ivPossibleLocusAndAlleles.elementAt(selind - 2);
        }

        private String getYourCommand(Vector mice) {
            StringBuffer msb = new StringBuffer();
            LocusAndAlleles toSend = this.getSelectedLAL();
            if (toSend.ivAllele != null && toSend.ivAllele.length == 1 && toSend.ivAllele[0].equals("@DONIX@")) {
                return "";
            }
            String transferString = Base64Manager.encodeBase64(toSend.getTransportString());
            int i = 0;
            while (i < mice.size()) {
                Mouse mausi = (Mouse)mice.elementAt(i);
                msb.append(CommandManagerExecutive.getServiceRoomTag(mausi, ""));
                msb.append("MCLocG").append(" ");
                msb.append(mausi.getID()).append(" ");
                msb.append(transferString).append("\n");
                ++i;
            }
            return msb.toString();
        }

        private boolean isMouseCompleteForLocus(Mouse mouse) {
            int ind = this.ivGenotypesCombo.getSelectedIndex();
            if (ind == -1) {
                return false;
            }
            if (ind == 1) {
                return false;
            }
            if (this.ivGenotypesCombo.getSelectedIndex() > 1) {
                return true;
            }
            return Mouse.isGenotypeComplete(mouse, this.ivLAL.ivLocusID);
        }
    }
}

