/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.preferences;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import mausoleum.cage.Cage;
import mausoleum.rack.frame.CageDisplayManager;
import mausoleum.rack.frame.RackGraphicsManager;

public class CageMaskIcons {
    private static final int IMAGE_RAND = 5;
    private static final int ANZ_CAGES = 2;
    private static Color[] cvCCol1 = new Color[]{new Color(20, 212, 255)};
    private static Color[] cvCCol2 = Cage.mattiereFarben(cvCCol1);
    private static int cvDurchsichtig = new Color(0, 0, 0, 0).getRGB();
    private static Icon[] cvImages = null;
    private static final int IMAGE_HEIGHT = 10 + RackGraphicsManager.CAGELABEL_CAGE_HEIGHT;

    static {
        cvImages = new Icon[4];
        CageMaskIcons.cvImages[0] = new ImageIcon(CageMaskIcons.getImage(0));
        CageMaskIcons.cvImages[1] = new ImageIcon(CageMaskIcons.getImage(1));
        CageMaskIcons.cvImages[2] = new ImageIcon(CageMaskIcons.getImage(2));
        CageMaskIcons.cvImages[3] = new ImageIcon(CageMaskIcons.getImage(3));
    }

    public static Icon getIcon(int mode) {
        if (mode >= 0 && mode < cvImages.length) {
            return cvImages[mode];
        }
        return null;
    }

    private static Image getImage(int mode) {
        int cw = RackGraphicsManager.CAGELABEL_CAGE_WIDTH - 4;
        int ch = RackGraphicsManager.CAGELABEL_CAGE_HEIGHT;
        int width = 5 + 2 * (cw + 5);
        BufferedImage img = new BufferedImage(width, IMAGE_HEIGHT, 2);
        DataBuffer db = img.getRaster().getDataBuffer();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < IMAGE_HEIGHT) {
                int pos = y * width + x;
                db.setElem(pos, cvDurchsichtig);
                ++y;
            }
            ++x;
        }
        Graphics g = img.getGraphics();
        int dx1 = 5;
        int dx2 = 10 + RackGraphicsManager.CAGELABEL_CAGE_WIDTH;
        int dy = 5;
        CageDisplayManager.fillGrayNormalCage(g, dx1, dy, cw, ch);
        CageDisplayManager.fillNormalCage(g, dx1, dy, cw, ch, mode, cvCCol1, "42", false, false, true, mode, null);
        CageDisplayManager.drawNormalBorder(g, dx1, dy, cw, ch, mode, true);
        Color[] fremdFarben = cvCCol1;
        if (mode == 3) {
            fremdFarben = cvCCol2;
        }
        CageDisplayManager.fillGrayNormalCage(g, dx2, dy, cw, ch);
        CageDisplayManager.fillNormalCage(g, dx2, dy, cw, ch, mode, fremdFarben, "43", false, false, false, mode, null);
        CageDisplayManager.drawNormalBorder(g, dx2, dy, cw, ch, mode, false);
        return img;
    }
}

