/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.preferences;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.ui.UIDef;

public class LabelPrinterPane
extends RequesterPane
implements ActionListener,
ListCellRenderer {
    private static final long serialVersionUID = 23323L;
    private JList ivUsedModesList = null;
    private JList ivNotUsedModesList = null;
    private JLabel ivObjectLabel = new JLabel();
    private MGButton ivMoveObjectUpButton = MGButton.getRequesterButton(Babel.get("MOVEUPOBJECT"));
    private MGButton ivMoveObjectDownButton = MGButton.getRequesterButton(Babel.get("MOVEDOWNOBJECT"));
    private MGButton ivUseColumnButton = MGButton.getRequesterButton(Babel.get("USE_PRINTER"));
    private MGButton ivDontUseColumnButton = MGButton.getRequesterButton(Babel.get("DONT_USE_PRINTER"));
    private MGButton ivUseAsDefaultButton = MGButton.getRequesterButton(Babel.get("USE_AS_DEFAULT"));
    private JComponent[] ivButs = new JComponent[]{this.ivUseColumnButton, this.ivDontUseColumnButton, this.ivUseAsDefaultButton, this.ivMoveObjectUpButton, this.ivMoveObjectDownButton};
    private BorderPanel ivUnusedPanel;
    private BorderPanel ivUsedPanel;
    private final Vector ivUsed = new Vector();
    private final Vector ivNotUsed = new Vector();
    private String ivMainMode = null;
    private boolean ivReact = true;
    private int ivBoppelWidth = 0;

    public LabelPrinterPane() {
        super(null);
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int innerWidth = d.width - 2 * UIDef.RAND;
                int innerHeight = d.height - 2 * UIDef.RAND;
                int panelHeight = innerHeight - UIDef.BUT_HEIGHT - UIDef.INNER_RAND;
                int panelWidth = (innerWidth - UIDef.INNER_RAND) / 2;
                int y = UIDef.RAND;
                LabelPrinterPane.this.ivUnusedPanel.setBounds(UIDef.RAND, y, panelWidth, panelHeight);
                LabelPrinterPane.this.ivUsedPanel.setBounds(UIDef.RAND + innerWidth - panelWidth, y, panelWidth, panelHeight);
                UIDef.distributeButtonsCheckPrefWidth(LabelPrinterPane.this.ivButs, UIDef.RAND, y += panelHeight + UIDef.INNER_RAND, UIDef.BUT_HEIGHT, innerWidth);
            }
        });
        this.ivObjectLabel.setFont(FontManager.getFont("SSB12"));
        this.ivObjectLabel.setHorizontalTextPosition(4);
        this.ivUsedModesList = new JList(this.ivUsed);
        this.ivUsedModesList.setSelectionMode(0);
        this.ivUsedModesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (LabelPrinterPane.this.ivReact) {
                    LabelPrinterPane.this.ivUseColumnButton.setEnabled(false);
                    int ind = LabelPrinterPane.this.ivUsedModesList.getSelectedIndex();
                    String selValue = (String)LabelPrinterPane.this.ivUsedModesList.getSelectedValue();
                    LabelPrinterPane.this.ivDontUseColumnButton.setEnabled(ind != -1 && LabelPrinterPane.this.ivUsed.size() > 1 && !selValue.equals(LabelPrinterPane.this.ivMainMode));
                    LabelPrinterPane.this.ivMoveObjectUpButton.setEnabled(ind > 0);
                    LabelPrinterPane.this.ivMoveObjectDownButton.setEnabled(ind != -1 && ind < LabelPrinterPane.this.ivUsedModesList.getModel().getSize() - 1);
                    LabelPrinterPane.this.ivReact = false;
                    LabelPrinterPane.this.ivNotUsedModesList.clearSelection();
                    LabelPrinterPane.this.ivUseAsDefaultButton.setEnabled(ind != -1 && !selValue.equals(LabelPrinterPane.this.ivMainMode));
                    LabelPrinterPane.this.ivReact = true;
                }
            }
        });
        this.ivUsedModesList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                if (LabelPrinterPane.this.ivUsedModesList.locationToIndex(p) != -1 && p.x < LabelPrinterPane.this.ivBoppelWidth) {
                    LabelPrinterPane.this.setPreferredPrinter();
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Point p = e.getPoint();
                    if (LabelPrinterPane.this.ivUsedModesList.locationToIndex(p) != -1) {
                        LabelPrinterPane.this.setPreferredPrinter();
                    }
                }
            }
        });
        this.ivUsedModesList.setCellRenderer(this);
        this.ivNotUsedModesList = new JList(this.ivNotUsed);
        this.ivNotUsedModesList.setSelectionMode(0);
        this.ivNotUsedModesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (LabelPrinterPane.this.ivReact) {
                    LabelPrinterPane.this.ivMoveObjectUpButton.setEnabled(false);
                    LabelPrinterPane.this.ivMoveObjectDownButton.setEnabled(false);
                    LabelPrinterPane.this.ivDontUseColumnButton.setEnabled(false);
                    LabelPrinterPane.this.ivUseAsDefaultButton.setEnabled(false);
                    int ind = LabelPrinterPane.this.ivNotUsedModesList.getSelectedIndex();
                    LabelPrinterPane.this.ivUseColumnButton.setEnabled(ind != -1);
                    LabelPrinterPane.this.ivReact = false;
                    LabelPrinterPane.this.ivUsedModesList.clearSelection();
                    LabelPrinterPane.this.ivReact = true;
                }
            }
        });
        this.ivNotUsedModesList.setCellRenderer(this);
        this.ivUnusedPanel = new BorderPanel(new JScrollPane(this.ivNotUsedModesList), Babel.get("UNUSED_CAGE_PRINTERS"), FontManager.getFont("SSB14"));
        this.add(this.ivUnusedPanel);
        this.ivUsedPanel = new BorderPanel(new JScrollPane(this.ivUsedModesList), Babel.get("USED_CAGE_PRINTERS"), FontManager.getFont("SSB14"));
        this.add(this.ivUsedPanel);
        this.prepareBut(this.ivUseColumnButton, "UC");
        this.prepareBut(this.ivDontUseColumnButton, "DUC");
        this.prepareBut(this.ivMoveObjectUpButton, "UP");
        this.prepareBut(this.ivMoveObjectDownButton, "DOWN");
        this.prepareBut(this.ivUseAsDefaultButton, "DEFAULT");
        this.ivBoppelWidth = ImageProvider.getBulletIcon(Color.red).getIconWidth() + this.ivObjectLabel.getIconTextGap();
    }

    private void prepareBut(MGButton but, String actionCommand) {
        but.setFont(FontManager.getFont("SSB13"));
        but.setActionCommand(actionCommand);
        but.addActionListener(this);
        but.setEnabled(false);
        this.add(but);
    }

    private void setPreferredPrinter() {
        this.ivMainMode = (String)this.ivUsedModesList.getSelectedValue();
        this.ivDontUseColumnButton.setEnabled(false);
        this.ivUseAsDefaultButton.setEnabled(false);
        this.ivUsedModesList.repaint();
    }

    public void adapt(HashSet excludedPrinters, String mainMode) {
        String[] allPrinters = LabelPrinter.getNames(true);
        this.ivUsed.clear();
        this.ivNotUsed.clear();
        this.ivNotUsed.addAll(excludedPrinters);
        int i = 0;
        while (i < allPrinters.length) {
            this.ivUsed.add(allPrinters[i]);
            ++i;
        }
        this.ivUsedModesList.setListData(this.ivUsed);
        this.ivNotUsedModesList.setListData(this.ivNotUsed);
        this.ivMainMode = this.ivUsed.contains(mainMode) ? mainMode : (String)this.ivUsed.firstElement();
        this.repaint();
    }

    public String getMainMode() {
        return this.ivMainMode;
    }

    public HashSet getExcludedPrinters() {
        HashSet res = new HashSet();
        Iterator itt = this.ivNotUsed.iterator();
        while (itt.hasNext()) {
            res.add(itt.next());
        }
        return res;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String mode;
        String displayValue = mode = (String)value;
        this.ivObjectLabel.setText(" " + displayValue + " ");
        if (list == this.ivUsedModesList) {
            if (mode.equals(this.ivMainMode)) {
                this.ivObjectLabel.setIcon(ImageProvider.getBulletIcon(Color.red));
            } else {
                this.ivObjectLabel.setIcon(ImageProvider.CLEAR_BULLET_ICON);
            }
        } else {
            this.ivObjectLabel.setIcon(null);
        }
        if (isSelected) {
            this.ivObjectLabel.setOpaque(true);
            this.ivObjectLabel.setBackground(UIDef.SELECTED_BACKGROUND);
        } else {
            this.ivObjectLabel.setOpaque(false);
            this.ivObjectLabel.setBackground(null);
        }
        return this.ivObjectLabel;
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("UP")) {
            int ind = this.ivUsedModesList.getSelectedIndex();
            if (ind > 0) {
                Object drueber = this.ivUsed.elementAt(ind - 1);
                this.ivUsed.setElementAt(this.ivUsed.elementAt(ind), ind - 1);
                this.ivUsed.setElementAt(drueber, ind);
                this.ivUsedModesList.setSelectedIndex(ind - 1);
                this.ivUsedModesList.repaint();
            }
        } else if (comm.equals("DOWN")) {
            int ind = this.ivUsedModesList.getSelectedIndex();
            if (ind < this.ivUsed.size() - 1) {
                Object drunter = this.ivUsed.elementAt(ind + 1);
                this.ivUsed.setElementAt(this.ivUsed.elementAt(ind), ind + 1);
                this.ivUsed.setElementAt(drunter, ind);
                this.ivUsedModesList.setSelectedIndex(ind + 1);
                this.ivUsedModesList.repaint();
            }
        } else if (comm.equals("UC")) {
            int ind = this.ivNotUsedModesList.getSelectedIndex();
            if (ind != -1) {
                this.ivUsed.addElement(this.ivNotUsed.elementAt(ind));
                this.ivNotUsed.removeElementAt(ind);
                this.ivUsedModesList.setListData(this.ivUsed);
                this.ivNotUsedModesList.setListData(this.ivNotUsed);
                this.ivNotUsedModesList.clearSelection();
                this.ivUsedModesList.setSelectedIndex(this.ivUsed.size() - 1);
                this.ivUsedModesList.repaint();
                this.ivNotUsedModesList.repaint();
            }
        } else if (comm.equals("DUC")) {
            int ind = this.ivUsedModesList.getSelectedIndex();
            if (ind != -1 && this.ivUsed.size() > 1) {
                this.ivNotUsed.addElement(this.ivUsed.elementAt(ind));
                this.ivUsed.removeElementAt(ind);
                this.ivUsedModesList.setListData(this.ivUsed);
                this.ivNotUsedModesList.setListData(this.ivNotUsed);
                this.ivUsedModesList.clearSelection();
                this.ivNotUsedModesList.setSelectedIndex(this.ivNotUsed.size() - 1);
                this.ivUsedModesList.repaint();
                this.ivNotUsedModesList.repaint();
            }
        } else if (comm.equals("DEFAULT")) {
            this.setPreferredPrinter();
        }
    }
}

