/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.privileges;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.requester.privileges.EditablePrivilege;
import mausoleum.ui.UIDef;

public class EditPrivilegeDialog
extends JDialog
implements TableModel,
TableCellRenderer {
    private static final long serialVersionUID = 11233214234L;
    private Vector ivFactoryPrivileges = null;
    private Vector ivWorkPrivileges = null;
    private Vector ivSavedPrivileges = null;
    private JTable ivPrivilegeTable = null;
    private JScrollPane ivPrivilegePane = null;
    private MGButton ivOKButton = new MGButton(Babel.get("YES"));
    private MGButton ivNOButton = new MGButton(Babel.get("NO"));
    private MGButton ivRevertSavedButton = new MGButton(Babel.get("REVERT_SAVED"));
    private MGButton ivRevertFactoryButton = new MGButton(Babel.get("REVERT_FACTORY"));
    private String[] ivFactoryFirstLineString = new String[1];
    private HashMap ivFactoryFirstLine = new HashMap();
    private JLabel ivLabel = new JLabel("qQyA");
    public MGButton ivColHeaderLabel = new MGButton();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static String getValidPrivileges() {
        String[] factoryFirstLineString = new String[1];
        HashMap factoryFirstLine = new HashMap();
        Vector factoryPrivileges = EditablePrivilege.extractPriviliges(FileManager.getStringFromFile("data/privileges64.txt"), factoryFirstLine, factoryFirstLineString);
        Vector savedPrivileges = EditablePrivilege.extractPriviliges(FileManager.getStringContentFromServer("data/privileges64_OVR.txt"), factoryFirstLine, null);
        Vector workPrivileges = EditPrivilegeDialog.mergeFactoryAndSaved(factoryPrivileges, savedPrivileges);
        StringBuilder msb = new StringBuilder();
        msb.append(factoryFirstLineString[0]);
        Iterator iterator = workPrivileges.iterator();
        while (iterator.hasNext()) {
            EditablePrivilege edp = (EditablePrivilege)iterator.next();
            msb.append("\n");
            msb.append(edp.getTransport(factoryFirstLine));
        }
        return msb.toString();
    }

    private static Vector mergeFactoryAndSaved(Vector factoryPrivileges, Vector savedPrivileges) {
        Vector workPrivileges = new Vector(factoryPrivileges.size());
        EditPrivilegeDialog.makeWork(true, workPrivileges, factoryPrivileges, savedPrivileges);
        return workPrivileges;
    }

    private static void makeWork(boolean withMerge, Vector workPrivileges, Vector factoryPrivileges, Vector savedPrivileges) {
        workPrivileges.clear();
        Iterator iterator = factoryPrivileges.iterator();
        while (iterator.hasNext()) {
            EditablePrivilege factoryEditablePrivilege = (EditablePrivilege)iterator.next();
            EditablePrivilege workEditablePrivilege = new EditablePrivilege(factoryEditablePrivilege);
            if (withMerge) {
                EditablePrivilege.mergePrivilege(workEditablePrivilege, savedPrivileges);
            }
            workPrivileges.add(workEditablePrivilege);
        }
    }

    private static void showPrivileges(String label, Vector privileges) {
        if (privileges != null && !privileges.isEmpty()) {
            StringBuilder msb = new StringBuilder();
            msb.append("|");
            int i = 0;
            while (i < User.ROLE_NAMES.length) {
                msb.append("|").append(User.ROLE_NAMES[i]);
                ++i;
            }
            System.out.println(msb.toString());
            Iterator iterator = privileges.iterator();
            while (iterator.hasNext()) {
                EditablePrivilege priv = (EditablePrivilege)iterator.next();
                System.out.println(priv.toTableString("|"));
            }
        }
    }

    public EditPrivilegeDialog(JFrame sender) {
        super((Frame)sender, true);
        this.setTitle(Babel.get("EDIT_PRIVILEGES"));
        RequesterPane rp = new RequesterPane(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int iw = d.width - 2 * UIDef.RAND;
                int ih = d.height - 2 * UIDef.RAND;
                int th = ih - 2 * UIDef.BUT_HEIGHT - 2 * UIDef.INNER_RAND;
                int lbw = (iw - UIDef.INNER_RAND) / 2;
                int rbw = iw - UIDef.INNER_RAND - lbw;
                int x = UIDef.RAND;
                int x2 = x + lbw + UIDef.INNER_RAND;
                int y = UIDef.RAND;
                EditPrivilegeDialog.this.ivPrivilegePane.setBounds(x, y, iw, th);
                EditPrivilegeDialog.this.ivRevertSavedButton.setBounds(x, y += th + UIDef.INNER_RAND, lbw, UIDef.BUT_HEIGHT);
                EditPrivilegeDialog.this.ivRevertFactoryButton.setBounds(x2, y, rbw, UIDef.BUT_HEIGHT);
                EditPrivilegeDialog.this.ivNOButton.setBounds(x, y += UIDef.BUT_HEIGHT + UIDef.INNER_RAND, lbw, UIDef.BUT_HEIGHT);
                EditPrivilegeDialog.this.ivOKButton.setBounds(x2, y, rbw, UIDef.BUT_HEIGHT);
            }
        });
        this.setContentPane(rp);
        this.ivFactoryPrivileges = EditablePrivilege.extractPriviliges(FileManager.getStringFromFile("data/privileges64.txt"), this.ivFactoryFirstLine, this.ivFactoryFirstLineString);
        this.ivSavedPrivileges = EditablePrivilege.extractPriviliges(FileManager.getStringContentFromServer("data/privileges64_OVR.txt"), this.ivFactoryFirstLine, null);
        this.ivWorkPrivileges = new Vector(this.ivFactoryPrivileges.size());
        this.makeWork(true);
        this.ivPrivilegeTable = new JTable(this);
        this.ivPrivilegeTable.getTableHeader().setReorderingAllowed(false);
        this.ivPrivilegeTable.setRowHeight(this.ivLabel.getPreferredSize().height);
        this.ivColHeaderLabel.setFont(FontManager.getFont("SSB10"));
        this.ivPrivilegeTable.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable arg0, Object value, boolean arg2, boolean arg3, int arg4, int arg5) {
                EditPrivilegeDialog.this.ivColHeaderLabel.setText((String)value);
                return EditPrivilegeDialog.this.ivColHeaderLabel;
            }
        });
        this.ivPrivilegeTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int row = EditPrivilegeDialog.this.ivPrivilegeTable.rowAtPoint(e.getPoint());
                int col = EditPrivilegeDialog.this.ivPrivilegeTable.columnAtPoint(e.getPoint());
                if (row >= 0 && row < EditPrivilegeDialog.this.ivWorkPrivileges.size()) {
                    EditablePrivilege edp;
                    String[] showableRoles = User.getShowableRoles();
                    if ((col -= 2) >= 0 && col < showableRoles.length && (edp = (EditablePrivilege)EditPrivilegeDialog.this.ivWorkPrivileges.elementAt(row)).toggle(showableRoles[col])) {
                        EditPrivilegeDialog.this.ivPrivilegePane.repaint();
                    }
                }
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.ivPrivilegeTable.setDefaultRenderer(clazz, this);
        this.ivPrivilegePane = new JScrollPane(this.ivPrivilegeTable);
        this.getContentPane().add(this.ivPrivilegePane);
        this.ivRevertSavedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                EditPrivilegeDialog.this.makeWork(true);
                EditPrivilegeDialog.this.ivPrivilegePane.repaint();
            }
        });
        this.getContentPane().add(this.ivRevertSavedButton);
        this.ivRevertFactoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                EditPrivilegeDialog.this.makeWork(false);
                EditPrivilegeDialog.this.ivPrivilegePane.repaint();
            }
        });
        this.getContentPane().add(this.ivRevertFactoryButton);
        this.ivNOButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                EditPrivilegeDialog.this.dispose();
            }
        });
        this.getContentPane().add(this.ivNOButton);
        this.ivOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                EditPrivilegeDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    StringBuilder msb = new StringBuilder();
                    msb.append(EditPrivilegeDialog.this.ivFactoryFirstLineString[0]);
                    Iterator iterator = EditPrivilegeDialog.this.ivWorkPrivileges.iterator();
                    while (iterator.hasNext()) {
                        EditablePrivilege edp = (EditablePrivilege)iterator.next();
                        msb.append("\n");
                        msb.append(edp.getTransport(EditPrivilegeDialog.this.ivFactoryFirstLine));
                    }
                    String content = msb.toString();
                    FileManager.saveStringContentToServer("data/privileges64_OVR.txt", content, null, UserManager.getFirstGroup());
                    Privileges.init(content);
                }
                catch (Exception e) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("mausoleum.requester.privileges.EditPrivilegeDialog");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Could not save standard Privileges", e, clazz);
                }
                EditPrivilegeDialog.this.setCursor(Cursor.getDefaultCursor());
                EditPrivilegeDialog.this.dispose();
            }
        });
        this.getContentPane().add(this.ivOKButton);
        WindowUtils.bringUpCenteredDialog(this, UIDef.getScaled(900), UIDef.getScaled(600), true);
    }

    private void makeWork(boolean withMerge) {
        EditPrivilegeDialog.makeWork(withMerge, this.ivWorkPrivileges, this.ivFactoryPrivileges, this.ivSavedPrivileges);
    }

    public void addTableModelListener(TableModelListener arg0) {
    }

    public Class getColumnClass(int arg0) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public int getColumnCount() {
        return User.getShowableRoles().length + 2;
    }

    public String getColumnName(int arg0) {
        if (arg0 == 0) {
            return Babel.get("CATEGORY");
        }
        if (arg0 == 1) {
            return Babel.get("PRIVILEGE");
        }
        return User.getShowableRoles()[arg0 - 2];
    }

    public int getRowCount() {
        return this.ivWorkPrivileges != null ? this.ivWorkPrivileges.size() : 0;
    }

    public Object getValueAt(int arg0, int arg1) {
        return null;
    }

    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    public void removeTableModelListener(TableModelListener arg0) {
    }

    public void setValueAt(Object arg0, int arg1, int arg2) {
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        EditablePrivilege ep = (EditablePrivilege)this.ivWorkPrivileges.elementAt(row);
        String key = null;
        key = column == 0 ? "CATEGORY" : (column == 1 ? "FUNCTION" : User.getShowableRoles()[column - 2]);
        if (row % 2 == 0) {
            this.ivLabel.setBackground(UIDef.GERADE_ROW_COL);
            this.ivLabel.setOpaque(true);
        } else {
            this.ivLabel.setBackground(null);
            this.ivLabel.setOpaque(false);
        }
        String roleTooltip = ep.adaptLabel(key, this.ivLabel);
        if (roleTooltip != null) {
            StringBuilder msb = new StringBuilder("<HTML><body text=\"#000000\">");
            msb.append(ep.getGeneralString(true));
            msb.append(" [").append(ep.getGeneralString(false)).append("]");
            msb.append(": <b>").append(roleTooltip).append("</b> ");
            msb.append(Babel.get("FOR")).append(" ").append(this.getColumnName(column));
            msb.append("</body>");
            this.ivLabel.setToolTipText(msb.toString());
        }
        return this.ivLabel;
    }
}

