/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.privileges;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import mausoleum.gui.ColorManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.helper.Zeile;

public class EditablePrivilege {
    public final String ivFunction;
    public final String ivCategory;
    public final HashMap ivStatusByRole = new HashMap(10);
    public final HashMap ivDescrByLang = new HashMap(10);

    public static Vector extractPriviliges(String fileCont, HashMap firstLine, String[] firstLineTarget) {
        Vector<EditablePrivilege> res = new Vector<EditablePrivilege>();
        if (fileCont != null) {
            boolean firstlineFound = false;
            Vector lines = StringHelper.splitStringByAny(fileCont, "\n");
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                if (line.trim().length() == 0) continue;
                Zeile z = new Zeile(line, '\t');
                if (!firstlineFound && z.getStringB64(0, "").startsWith("@")) {
                    firstlineFound = true;
                    if (firstLineTarget != null) {
                        firstLineTarget[0] = line;
                    }
                    if (!firstLine.isEmpty()) continue;
                    int i = 0;
                    while (i < z.size()) {
                        String val = z.getStringB64(i, "");
                        if (val.trim().length() != 0) {
                            if (val.startsWith("@")) {
                                val = val.substring(1, val.length()).trim();
                            }
                            firstLine.put(val.trim(), new Integer(i));
                        }
                        ++i;
                    }
                    continue;
                }
                res.add(new EditablePrivilege(line, firstLine));
            }
        }
        return res;
    }

    public static void mergePrivilege(EditablePrivilege target, Vector savedPrivileges) {
        if (savedPrivileges != null && !savedPrivileges.isEmpty()) {
            EditablePrivilege foundSavedPrivilege = null;
            Iterator<Object> iterator = savedPrivileges.iterator();
            while (iterator.hasNext() && foundSavedPrivilege == null) {
                EditablePrivilege edp = (EditablePrivilege)iterator.next();
                if (!edp.ivCategory.equals(target.ivCategory) || !edp.ivFunction.equals(target.ivFunction)) continue;
                foundSavedPrivilege = edp;
            }
            if (foundSavedPrivilege != null) {
                iterator = target.ivStatusByRole.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String factoryVal = (String)target.ivStatusByRole.get(key);
                    String savedVal = (String)foundSavedPrivilege.ivStatusByRole.get(key);
                    if (("x".equals(factoryVal) || "".equals(factoryVal)) && ("x".equals(factoryVal) || "".equals(factoryVal))) {
                        target.ivStatusByRole.put(key, savedVal);
                    }
                    if (factoryVal.equalsIgnoreCase(savedVal)) continue;
                    if ("A".equals(savedVal)) {
                        if (factoryVal.equals("x") || factoryVal.equals("")) {
                            target.ivStatusByRole.put(key, "x");
                            continue;
                        }
                        if (!factoryVal.equals("#")) continue;
                        target.ivStatusByRole.put(key, "#");
                        continue;
                    }
                    if ("#".equals(savedVal)) {
                        if (factoryVal.equals("x") || factoryVal.equals("")) {
                            target.ivStatusByRole.put(key, "");
                            continue;
                        }
                        if (!factoryVal.equals("A")) continue;
                        target.ivStatusByRole.put(key, "A");
                        continue;
                    }
                    if ("x".equals(savedVal)) {
                        if (!factoryVal.equals("A") && !factoryVal.equals("#")) continue;
                        target.ivStatusByRole.put(key, factoryVal);
                        continue;
                    }
                    if (!"".equals(savedVal) || !factoryVal.equals("A") && !factoryVal.equals("#")) continue;
                    target.ivStatusByRole.put(key, factoryVal);
                }
            }
        }
    }

    public EditablePrivilege(String line, HashMap firstLine) {
        Zeile z = new Zeile(line, '\t');
        this.ivFunction = z.getStringB64(EditablePrivilege.getCol("FUNCTION", firstLine, -1), null);
        this.ivCategory = z.getStringB64(EditablePrivilege.getCol("CATEGORY", firstLine, -1), null);
        String[] editableRoles = User.getEditableRoles();
        int i = 0;
        while (i < editableRoles.length) {
            int col = EditablePrivilege.getCol(editableRoles[i], firstLine, -1);
            if (col != -1) {
                this.ivStatusByRole.put(editableRoles[i], z.getStringB64(col, "").trim());
            }
            ++i;
        }
        Iterator iterator = Babel.AVAILABLE_LANGUAGES_SHORT.iterator();
        while (iterator.hasNext()) {
            String lang = (String)iterator.next();
            int col = EditablePrivilege.getCol(lang, firstLine, -1);
            if (col == -1) continue;
            this.ivDescrByLang.put(lang, z.getStringB64(col, ""));
        }
    }

    public EditablePrivilege(EditablePrivilege model) {
        String key;
        this.ivFunction = model.ivFunction;
        this.ivCategory = model.ivCategory;
        Iterator iterator = model.ivDescrByLang.keySet().iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            this.ivDescrByLang.put(key, model.ivDescrByLang.get(key));
        }
        iterator = model.ivStatusByRole.keySet().iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            this.ivStatusByRole.put(key, model.ivStatusByRole.get(key));
        }
    }

    public String getTransport(HashMap firstLine) {
        String[] arr = new String[firstLine.size()];
        int i = 0;
        while (i < arr.length) {
            arr[i] = "";
            ++i;
        }
        arr[EditablePrivilege.getCol((String)"FUNCTION", (HashMap)firstLine, (int)-1)] = this.ivFunction;
        arr[EditablePrivilege.getCol((String)"CATEGORY", (HashMap)firstLine, (int)-1)] = this.ivCategory;
        String[] editableRoles = User.getEditableRoles();
        int i2 = 0;
        while (i2 < editableRoles.length) {
            int col = EditablePrivilege.getCol(editableRoles[i2], firstLine, -1);
            if (col != -1) {
                arr[col] = (String)this.ivStatusByRole.get(editableRoles[i2]);
            }
            ++i2;
        }
        Iterator iterator = Babel.AVAILABLE_LANGUAGES_SHORT.iterator();
        while (iterator.hasNext()) {
            String lang = (String)iterator.next();
            int col = EditablePrivilege.getCol(lang, firstLine, -1);
            if (col == -1) continue;
            arr[col] = (String)this.ivDescrByLang.get(lang);
        }
        StringBuilder msb = new StringBuilder();
        int i3 = 0;
        while (i3 < arr.length) {
            if (i3 != 0) {
                msb.append("\t");
            }
            msb.append(Base64Manager.encodeBase64(arr[i3]));
            ++i3;
        }
        return msb.toString();
    }

    private static int getCol(String key, HashMap firstLine, int defVal) {
        Integer col = (Integer)firstLine.get(key);
        return col == null ? defVal : col;
    }

    public String toString() {
        return String.valueOf(this.ivCategory) + ":" + this.ivFunction + " " + this.ivStatusByRole;
    }

    public String toTableString(String sep) {
        StringBuilder msb = new StringBuilder();
        msb.append(this.ivCategory).append(sep);
        msb.append(this.ivFunction);
        int i = 0;
        while (i < User.ROLE_NAMES.length) {
            String status = (String)this.ivStatusByRole.get(User.ROLE_NAMES[i]);
            msb.append(sep).append(status != null ? status : "");
            ++i;
        }
        return msb.toString();
    }

    public boolean toggle(String role) {
        String s = (String)this.ivStatusByRole.get(role);
        if (s == null || "".equals(s)) {
            this.ivStatusByRole.put(role, "x");
            return true;
        }
        if ("x".equals(s)) {
            this.ivStatusByRole.put(role, "");
            return true;
        }
        return false;
    }

    public String getGeneralString(boolean forFunction) {
        String res = null;
        if (forFunction) {
            String lang = Babel.cvUserLangue != null ? Babel.cvUserLangue : "en";
            res = (String)this.ivDescrByLang.get(lang);
            if (res == null || res.trim().length() == 0) {
                res = (String)this.ivDescrByLang.get("en");
            }
        } else {
            res = this.ivCategory;
            int ind = this.ivCategory.indexOf("_");
            if (ind != -1) {
                res = this.ivCategory.substring(ind + 1, this.ivCategory.length());
                res = Babel.get(res);
            }
        }
        return res;
    }

    public String adaptLabel(String key, JLabel label) {
        String tooltip = null;
        label.setText(null);
        label.setIcon(null);
        label.setToolTipText(null);
        if ("FUNCTION".equals(key)) {
            label.setText(" " + this.getGeneralString(true) + " ");
            label.setFont(FontManager.getTableFont(true, false, 1.0));
            label.setHorizontalAlignment(2);
            label.setForeground(Color.black);
        } else if ("CATEGORY".equals(key)) {
            label.setText(" " + this.getGeneralString(false) + " ");
            label.setFont(FontManager.getTableFont(true, false, 1.0));
            label.setHorizontalAlignment(2);
            label.setForeground(Color.black);
        } else {
            String res = (String)this.ivStatusByRole.get(key);
            if (res != null && res.trim().length() != 0) {
                if ("A".equals(res)) {
                    label.setBackground(ColorManager.getColorFromString("limegreen"));
                    label.setOpaque(true);
                    label.setIcon(ImageProvider.getBulletIcon(Color.green));
                    label.setHorizontalAlignment(0);
                    tooltip = Babel.get("PRIV_ALWAYS_ALLOWED");
                } else if ("x".equals(res)) {
                    label.setIcon(ImageProvider.getBulletIcon(Color.green));
                    label.setHorizontalAlignment(0);
                    tooltip = Babel.get("PRIV_ALLOWED");
                } else if ("#".equals(res)) {
                    label.setBackground(ColorManager.getColorFromNumberString("B4B4B4"));
                    label.setOpaque(true);
                    tooltip = Babel.get("PRIV_NEVER_ALLOWED");
                }
            } else {
                tooltip = Babel.get("PRIV_NOT_ALLOWED");
            }
        }
        return tooltip;
    }
}

