/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.rack;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.JComponent;
import mausoleum.helper.FontManager;
import mausoleum.rack.Rack;
import mausoleum.rack.frame.CageDisplayManager;
import mausoleum.rack.frame.PolygonManager;
import mausoleum.rack.frame.RackGraphicsManager;
import mausoleum.ui.UIDef;

public class RackConflictComponent
extends JComponent {
    private static final long serialVersionUID = 1186186186L;
    private static final int CAGE_WIDTH = RackGraphicsManager.MINIMUM_CAGE_WIDTH;
    private static final int CAGE_HEIGHT = RackGraphicsManager.MINIMUM_CAGE_HEIGHT;
    private static final int CAGE_SEP = RackGraphicsManager.CAGESEP;
    private static final int BIG_MARGIN = RackGraphicsManager.BIG_MARGIN;
    private static final int SMALL_MARGIN = RackGraphicsManager.SMALL_MARGIN;
    private static final int TOP_MARGIN = UIDef.getScaled(30);
    private static final Polygon CAGE_POLY = PolygonManager.getPolygon(CAGE_WIDTH, CAGE_HEIGHT, 0, 1);
    private final int ivSides;
    private final int ivRows;
    private final int ivColumns;
    private final boolean[] ivServiceOccupieds;
    private final boolean[] ivGroupOccupieds;
    private final int ivOneSideWidth;
    private final int ivOneSideHeight;
    private final Dimension ivWantedSize;

    public RackConflictComponent(int sides, int rows, int columns, boolean[] serviceOccupieds, boolean[] groupOccupies) {
        this.ivSides = sides;
        this.ivRows = rows;
        this.ivColumns = columns;
        this.ivServiceOccupieds = serviceOccupieds;
        this.ivGroupOccupieds = groupOccupies;
        this.ivOneSideWidth = SMALL_MARGIN + this.ivColumns * CAGE_WIDTH + (this.ivColumns - 1) * CAGE_SEP + SMALL_MARGIN;
        this.ivOneSideHeight = SMALL_MARGIN + this.ivRows * CAGE_HEIGHT + (this.ivRows - 1) * CAGE_SEP + SMALL_MARGIN;
        int totWidth = this.ivOneSideWidth;
        if (this.ivSides == 2) {
            totWidth = 2 * this.ivOneSideWidth + BIG_MARGIN;
        }
        int totHeight = TOP_MARGIN + this.ivOneSideHeight;
        this.ivWantedSize = new Dimension(totWidth + 2, totHeight + 2);
        this.setOpaque(false);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.ivWantedSize;
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(Color.black);
        g.drawRect(0, 0, d.width - 1, d.height - 1);
        int y = TOP_MARGIN + SMALL_MARGIN;
        int x = SMALL_MARGIN;
        this.paintOneSide(x, y, 0, g, true);
        if (this.ivSides == 2) {
            this.paintOneSide(x += this.ivOneSideWidth + BIG_MARGIN, y, 1, g, false);
        }
    }

    private void paintOneSide(int lx, int oy, int side, Graphics g, boolean front) {
        String titel = Babel.get("FRONT");
        if (!front) {
            titel = Babel.get("BACK");
        }
        g.setFont(FontManager.getFont("SSB14"));
        FontMetrics fm = g.getFontMetrics();
        int sw = fm.stringWidth(titel);
        int tx = (this.ivOneSideWidth - sw) / 2;
        g.drawString(titel, tx, oy - 10);
        int y = oy;
        int r = 0;
        while (r < this.ivRows) {
            int x = lx;
            int c = 0;
            while (c < this.ivColumns) {
                int pos = Rack.calcPos(side, r, c, this.ivRows, this.ivColumns);
                Color bg = null;
                if (this.ivServiceOccupieds[pos] && this.ivGroupOccupieds[pos]) {
                    bg = Color.red;
                } else if (this.ivServiceOccupieds[pos]) {
                    bg = Color.green;
                } else if (this.ivGroupOccupieds[pos]) {
                    bg = Color.yellow;
                }
                if (bg != null) {
                    g.setColor(bg);
                    CAGE_POLY.translate(x, y);
                    g.fillPolygon(CAGE_POLY);
                    CAGE_POLY.translate(-x, -y);
                    CageDisplayManager.drawPolygon(g, CAGE_POLY, null, x, y, Color.black, Color.white);
                } else {
                    CageDisplayManager.drawPolygon(g, CAGE_POLY, null, x, y, CageDisplayManager.MATT_WHITE_COL, CageDisplayManager.MATT_BLACK_COL);
                }
                x += CAGE_WIDTH + CAGE_SEP;
                ++c;
            }
            y += CAGE_HEIGHT + CAGE_SEP;
            ++r;
        }
    }
}

