/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.rack;

import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.main.DefaultManager;
import mausoleum.rack.Rack;
import mausoleum.rack.frame.CageDisplayManager;
import mausoleum.rack.frame.PolygonManager;
import mausoleum.requester.rack.RackServiceLegendList;

public class RackServiceDisplayComponent
extends JComponent {
    private static final long serialVersionUID = 11234L;
    private Object[] ivMasterArray = null;
    private Image ivImage = null;

    public void adapt(Long rackID, int mode, RackServiceLegendList rsll) {
        String s = (String)RequestManager.createSendAndGetObjectIfFinished((byte)59, rackID, "service", new Integer(mode));
        this.ivMasterArray = s == null ? null : (Object[])IDObjectXMLHandler.getObject(s);
        rsll.adapt(mode, this.ivMasterArray);
        this.createImage();
        this.repaint();
    }

    public void dispose() {
        this.ivMasterArray = null;
        this.ivImage = null;
    }

    public void paint(Graphics g) {
        if (this.ivImage != null) {
            g.drawImage(this.ivImage, 0, 0, null);
        }
        super.paintBorder(g);
    }

    public void createImage() {
        Dimension d = this.getSize();
        if (d != null && d.width > 0 && d.height > 0) {
            this.ivImage = new BufferedImage(d.width, d.height, 1);
            Graphics g = this.ivImage.getGraphics();
            while (g == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                g = this.ivImage.getGraphics();
            }
            MausoleumImageStore.fillDimWithImage(g, "inspectorButton", d);
            if (this.ivMasterArray != null && this.ivMasterArray[0] != null && this.ivMasterArray[3] != null) {
                int[] gdesc = (int[])this.ivMasterArray[0];
                Object[] rackArr = (Object[])this.ivMasterArray[3];
                int sides = gdesc[0];
                int cols = gdesc[1];
                int rows = gdesc[2];
                int rand = 10;
                int zw = 3;
                int x = rand;
                int y = rand;
                int horPlatz = (d.width - (sides - 1) * rand) / sides;
                int cw = (horPlatz - 2 * rand - (cols - 1) * zw) / cols;
                int ch = (d.height - 2 * rand - (rows - 1) * zw) / rows;
                if (cw > 2 * ch) {
                    cw = ch * 2;
                } else {
                    ch = cw / 2;
                }
                int oneWidth = cols * cw + (cols - 1) * zw + 2 * rand;
                int oneHeight = rows * ch + (rows - 1) * zw + 2 * rand;
                int fullwWidth = sides * oneWidth + (sides - 1) * rand;
                int xoff = (d.width - fullwWidth) / 2;
                int yoff = (d.height - oneHeight) / 2;
                int fieldStart = xoff;
                int side = 0;
                while (side < sides) {
                    y = yoff + rand;
                    int row = 0;
                    while (row < rows) {
                        x = fieldStart + rand;
                        int col = 0;
                        while (col < cols) {
                            int pos = Rack.calcPos(side, row, col, rows, cols);
                            Object[] cageArr = (Object[])rackArr[pos];
                            if (cageArr != null) {
                                Color[] colArr = null;
                                Object[] colArrPrev = (Object[])cageArr[0];
                                if (colArrPrev != null) {
                                    colArr = new Color[colArrPrev.length];
                                    int i = 0;
                                    while (i < colArrPrev.length) {
                                        colArr[i] = (Color)colArrPrev[i];
                                        ++i;
                                    }
                                }
                                CageDisplayManager.fillNormalCage(g, x, y, cw, ch, 0, colArr, (String)cageArr[1], false, false, true, DefaultManager.getCageDisplayMode(), null);
                                CageDisplayManager.drawNormalBorder(g, x, y, cw, ch, 0, true);
                            } else {
                                CageDisplayManager.drawPolygon(g, PolygonManager.getPolygon(cw, ch, 0, 1), null, x, y, CageDisplayManager.MATT_WHITE_COL, CageDisplayManager.MATT_BLACK_COL);
                            }
                            x += cw + zw;
                            ++col;
                        }
                        y += ch + zw;
                        ++row;
                    }
                    fieldStart += oneWidth + rand;
                    ++side;
                }
            }
        }
    }
}

