/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.rack;

import de.hannse.netobjects.tools.StringHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.ColorMode;
import mausoleum.gui.MusterColor;
import mausoleum.helper.FontManager;
import mausoleum.helper.HTMLEncoder;
import mausoleum.ui.UIDef;

public class RackServiceLegendList
extends JList {
    private static final long serialVersionUID = 1423L;
    private static final Vector LEER = new Vector();
    private static final Dimension COLOR_DIM = new Dimension(UIDef.getScaled(18), UIDef.getScaled(18));
    public JScrollPane ivScrollPane = null;
    public JLabel ivListLabel = new JLabel();
    public JLabel ivListColorLabel = null;
    public JPanel ivListPanel = null;
    private Object[] ivColors = null;
    private Object[] ivStrings = null;

    public RackServiceLegendList() {
        super(LEER);
        this.ivScrollPane = new JScrollPane(this);
        this.ivListLabel.setFont(FontManager.getFont("SSB13"));
        this.ivListLabel.setOpaque(false);
        this.ivListColorLabel = new JLabel(){
            private static final long serialVersionUID = 13434L;

            public void paint(Graphics g) {
                Dimension d = this.getSize();
                int w = d.width;
                int h = d.height;
                Color bg = this.getBackground();
                if (bg instanceof MusterColor) {
                    MusterColor mc = (MusterColor)bg;
                    mc.fill(0, 0, w, h, g);
                } else {
                    g.setColor(bg);
                    g.fillRect(0, 0, w, h);
                }
                g.setColor(Color.black);
                g.drawRect(0, 0, w - 1, h - 1);
            }
        };
        this.ivListColorLabel.setPreferredSize(COLOR_DIM);
        this.ivListColorLabel.setMinimumSize(COLOR_DIM);
        this.ivListColorLabel.setOpaque(true);
        this.ivListPanel = new JPanel(new BorderLayout());
        this.ivListPanel.add("West", this.ivListColorLabel);
        this.ivListPanel.add("Center", this.ivListLabel);
        this.ivListPanel.setOpaque(false);
        this.ivListPanel.setBorder(new EmptyBorder(1, 3, 6, 3));
        this.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean arg3, boolean arg4) {
                RackServiceLegendList.this.ivListLabel.setText((String)value);
                RackServiceLegendList.this.ivListColorLabel.setBackground((Color)RackServiceLegendList.this.ivColors[index]);
                return RackServiceLegendList.this.ivListPanel;
            }
        });
    }

    public void adapt(int mode, Object[] masterArray) {
        this.ivColors = null;
        this.ivStrings = null;
        if (masterArray != null) {
            if (masterArray[1] != null && masterArray[2] != null) {
                this.ivColors = (Object[])masterArray[1];
                this.ivStrings = RackServiceLegendList.hmtlIt((Object[])masterArray[2]);
            } else {
                ColorMode cmode = CageColorManager.getColorMode(mode);
                if (cmode != null && !cmode.hasVaryingColorColorCodes()) {
                    this.ivColors = cmode.getColorsForDefaultLegend();
                    this.ivStrings = RackServiceLegendList.hmtlIt(cmode.getStringsForDefaultLegend());
                }
            }
        }
        if (this.ivStrings == null) {
            this.setListData(LEER);
        } else {
            this.setListData(this.ivStrings);
        }
        this.repaint();
    }

    private static Object[] hmtlIt(Object[] arr) {
        if (arr != null && arr.length != 0) {
            Object[] res = new Object[arr.length];
            int i = 0;
            while (i < res.length) {
                if (arr[i] instanceof String && !((String)arr[i]).startsWith("<html>")) {
                    String s = HTMLEncoder.convertToHTML((String)arr[i]);
                    s = StringHelper.gSub(s, "\n", "<br>&nbsp;", false);
                    s = StringHelper.gSub(s, "  ", " ", false);
                    res[i] = "<html><body>&nbsp;" + s + "</body></html>";
                } else {
                    res[i] = arr[i];
                }
                ++i;
            }
            return res;
        }
        return arr;
    }
}

