/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.result;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mausoleum.alert.Alert;
import mausoleum.experiment.Experiment;
import mausoleum.gui.ImageComponent;
import mausoleum.gui.MGButton;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FileHelper;
import mausoleum.helper.ImageCreator;
import mausoleum.helper.ImageHelper;
import mausoleum.inspector.Inspector;
import mausoleum.requester.result.EnterResultPanel;
import mausoleum.result.ResultObjectImage;
import mausoleum.ui.UIDef;

public class EnterResultPanelImage
extends EnterResultPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private MGButton ivButton = MGButton.getInspectorActionButton(Babel.get("DEFINEIMAGE"), "DEFINE");
    private ImageComponent ivImageComponent = new ImageComponent();
    private JTextArea ivTextArea = new JTextArea();
    private JScrollPane ivScrollPane = new JScrollPane(this.ivTextArea);
    private String ivFilename = null;
    private Image ivImageBig = null;
    private Image ivImageTiny = null;
    private Dimension ivOrigDim = null;
    private Dimension ivTinyDim = null;

    public EnterResultPanelImage() {
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = parent.getSize();
                int icw = 70 + UIDef.INNER_RAND;
                if (((EnterResultPanelImage)EnterResultPanelImage.this).ivButton.getPreferredSize().width > icw) {
                    icw = ((EnterResultPanelImage)EnterResultPanelImage.this).ivButton.getPreferredSize().width;
                }
                int ich = 70 + UIDef.INNER_RAND;
                int bheight = d.height - 3 * UIDef.INNER_RAND - ich;
                int bpos = 2 * UIDef.INNER_RAND + ich;
                EnterResultPanelImage.this.ivImageComponent.setBounds(UIDef.INNER_RAND, UIDef.INNER_RAND, icw, ich);
                EnterResultPanelImage.this.ivButton.setBounds(UIDef.INNER_RAND, bpos, icw, bheight);
                EnterResultPanelImage.this.ivScrollPane.setBounds(2 * UIDef.INNER_RAND + icw, UIDef.INNER_RAND, d.width - 3 * UIDef.INNER_RAND - icw, d.height - 2 * UIDef.INNER_RAND);
            }
        });
        this.add(this.ivButton);
        this.add(this.ivImageComponent);
        this.add(this.ivScrollPane);
        this.ivTextArea.setLineWrap(true);
        this.ivTextArea.setWrapStyleWord(true);
        this.ivTextArea.setMargin(new Insets(2, 2, 2, 2));
        this.ivButton.addActionListener(this);
    }

    protected void adaptToExperiment(Experiment expi) {
        this.ivImageComponent.setImage(null);
        this.ivFilename = null;
        this.ivImageBig = null;
        this.ivImageTiny = null;
        this.ivTextArea.setText("");
    }

    protected Object getResult() {
        if (this.ivImageTiny == null) {
            return null;
        }
        ResultObjectImage erg = new ResultObjectImage();
        erg.ivOrigFilename = this.ivFilename;
        erg.ivOrigDim = this.ivOrigDim;
        erg.ivThumbDim = this.ivTinyDim;
        erg.ivComment = Base64Manager.encodeBase64(this.ivTextArea.getText().trim());
        try {
            BufferedImage tImage = new BufferedImage(this.ivOrigDim.width, this.ivOrigDim.height, 1);
            Graphics2D graphics2D = tImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(this.ivImageBig, 0, 0, null);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(tImage);
            param.setQuality(0.8f, false);
            encoder.setJPEGEncodeParam(param);
            encoder.encode(tImage);
            out.flush();
            out.close();
            erg.ivOrigData = out.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
        erg.ivThumbData = new int[this.ivTinyDim.width * this.ivTinyDim.height];
        PixelGrabber pg = new PixelGrabber(this.ivImageTiny, 0, 0, this.ivTinyDim.width, this.ivTinyDim.height, erg.ivThumbData, 0, this.ivTinyDim.width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            Alert.showAlert(Babel.get("ALERT_FILE_DISAPPEARED"), true);
            return null;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            Alert.showAlert(Babel.get("ALERT_FILE_DISAPPEARED"), true);
            return null;
        }
        return erg;
    }

    protected boolean isResultOK(Object result) {
        return result != null;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String filename = FileHelper.getImagePath(Inspector.getInspector());
            if (filename != null) {
                this.ivFilename = filename;
                this.ivImageBig = ImageCreator.loadImage(this.ivFilename);
                if (this.ivImageBig != null) {
                    double faktor;
                    int bigWidth = this.ivImageBig.getWidth(null);
                    int bigHeight = this.ivImageBig.getHeight(null);
                    if (bigWidth > 1024 || bigHeight > 1024) {
                        Alert.showAlert(Babel.get("ALERT_IMAGE_TOO_BIG"), true);
                        double faktorX = 1024.0 / (double)bigWidth;
                        double faktorY = 1024.0 / (double)bigHeight;
                        faktor = faktorX;
                        if (faktorY < faktor) {
                            faktor = faktorY;
                        }
                        bigWidth = (int)(faktor * (double)bigWidth);
                        bigHeight = (int)(faktor * (double)bigHeight);
                        byte[] buffv = ImageHelper.getJPEGFromSimpleImage(this.ivImageBig, 1.0f, 0);
                        FileManager.saveBytesToFile("vorher.jpg", buffv);
                        this.ivImageBig = this.ivImageBig.getScaledInstance(bigWidth, bigHeight, 4);
                        while (this.ivImageBig.getWidth(null) <= 0) {
                            Thread.sleep(100L);
                        }
                        buffv = ImageHelper.getJPEGFromSimpleImage(this.ivImageBig, 1.0f, 0);
                        FileManager.saveBytesToFile("nachher.jpg", buffv);
                    }
                    this.ivOrigDim = new Dimension(bigWidth, bigHeight);
                    double fx = (double)bigWidth / 70.0;
                    double fy = (double)bigHeight / 70.0;
                    faktor = fx;
                    if (fy > fx) {
                        faktor = fy;
                    }
                    int wWidth = (int)((double)bigWidth / faktor);
                    int wHeight = (int)((double)bigHeight / faktor);
                    this.ivTinyDim = new Dimension(wWidth, wHeight);
                    this.ivImageTiny = ImageCreator.getScaledInstance(this.ivImageBig, wWidth, wHeight, 4);
                    this.ivImageComponent.setImage(this.ivImageTiny);
                } else {
                    this.ivImageComponent.setImage(null);
                }
            }
        }
        catch (Exception ex) {
            Log.error("Problem while loading image", ex, this);
        }
    }
}

