/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.result;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.experiment.Experiment;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.gui.documents.IntegerDocument;
import mausoleum.helper.FontManager;
import mausoleum.requester.result.EnterResultPanel;
import mausoleum.ui.UIDef;

public class EnterResultPanelInteger
extends EnterResultPanel
implements AdjustmentListener,
CaretListener {
    private static final long serialVersionUID = 1L;
    private static final int MARGIN = UIDef.getScaled(4);
    private static final int SCROLL_WIDTH = UIDef.getScaled(150);
    private static final int FIELD_WIDTH = UIDef.getScaled(50);
    private static final int FIELD_HEIGHT = UIDef.getScaled(30);
    private JScrollBar ivScrollBar = new JScrollBar(0);
    private KomfortTextField ivIntegerField = new KomfortTextField();
    private int ivLowerLimit;
    private int ivUpperLimit;
    private int ivValue;

    public EnterResultPanelInteger() {
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = parent.getSize();
                int y = (d.height - FIELD_HEIGHT) / 2;
                int gesw = SCROLL_WIDTH + MARGIN + FIELD_WIDTH;
                int x = (d.width - gesw) / 2;
                EnterResultPanelInteger.this.ivScrollBar.setBounds(x, y, SCROLL_WIDTH, FIELD_HEIGHT);
                EnterResultPanelInteger.this.ivIntegerField.setBounds(x + SCROLL_WIDTH + MARGIN, y, FIELD_WIDTH, FIELD_HEIGHT);
            }
        });
        this.add(this.ivScrollBar);
        this.ivIntegerField.setHorizontalAlignment(4);
        this.ivIntegerField.setFont(FontManager.getFont("SSB12"));
        this.ivIntegerField.setDocument(new IntegerDocument(this.ivIntegerField));
        this.add(this.ivIntegerField);
        this.ivScrollBar.addAdjustmentListener(this);
        this.ivIntegerField.addCaretListener(this);
    }

    protected void adaptToExperiment(Experiment expi) {
        Object[] posValues = (Object[])expi.get("EXP_POSV");
        if (posValues.length == 2) {
            Integer lowi = (Integer)posValues[0];
            Integer uppi = (Integer)posValues[1];
            this.ivLowerLimit = lowi;
            this.ivUpperLimit = uppi;
            this.ivValue = (this.ivLowerLimit + this.ivUpperLimit) / 2;
            int vis = 1;
            this.ivScrollBar.setValues(this.ivValue, vis, this.ivLowerLimit, this.ivUpperLimit + vis);
            this.ivIntegerField.setText(Integer.toString(this.ivValue));
        }
    }

    protected boolean isResultOK(Object result) {
        Integer inti;
        int i;
        return result != null && result instanceof Integer && (i = (inti = (Integer)result).intValue()) >= this.ivLowerLimit && i <= this.ivUpperLimit;
    }

    protected Object getResult() {
        return this.ivIntegerField.getInteger();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.ivValue = this.ivScrollBar.getValue();
        this.ivIntegerField.setText(Integer.toString(this.ivValue));
    }

    public void caretUpdate(CaretEvent e) {
        try {
            int val = Integer.parseInt(this.ivIntegerField.getText().trim());
            if (val != this.ivValue) {
                this.ivValue = val;
                this.ivScrollBar.setValue(this.ivValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

