/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.result;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.definitionlists.Microorganism;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MGButton;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.rack.Rack;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.result.RackHealthReportChangeKeimeRequester;
import mausoleum.requester.result.RackHealthReportGeneralsRequester;
import mausoleum.result.rackhealthreport.RResHealthReport;
import mausoleum.result.rackhealthreport.RResWrapper;
import mausoleum.ui.UIDef;

public class RackHealthReportRacksRequester
extends BasicRequester {
    private static final long serialVersionUID = 145343846L;
    private static final int TEXTPANE_HEIGHT = UIDef.getScaled(40);
    private JTabbedPane ivRacksTabbedPane = new JTabbedPane();
    private HashMap ivPanelsByRack = new HashMap();
    private Vector ivPanels = new Vector();

    private static String[] getAnzesArr(int max) {
        String[] anzes = new String[max + 1];
        int i = 0;
        while (i <= max) {
            anzes[i] = Integer.toString(i);
            ++i;
        }
        return anzes;
    }

    public RackHealthReportRacksRequester(Frame sender, RackHealthReportGeneralsRequester.GeneralMicroorganismResult gmr, Vector racks, RResWrapper wrapper, boolean keimChangePossible) {
        super(sender, 10, 10);
        this.setResizable(true);
        this.ivRacksTabbedPane.setOpaque(false);
        this.getContentPane().add(this.ivRacksTabbedPane);
        Iterator iterator = racks.iterator();
        while (iterator.hasNext()) {
            Rack rack = (Rack)iterator.next();
            RHRRMOPanel panel = new RHRRMOPanel(gmr, wrapper);
            RHRRMOOberPanel opanel = new RHRRMOOberPanel(panel, gmr, keimChangePossible);
            this.ivPanels.add(opanel);
            this.ivPanelsByRack.put(rack, opanel);
            this.ivRacksTabbedPane.addTab(rack.getName(), opanel);
        }
        this.setResizable(true);
        this.getContentPane().setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = parent.getSize();
                int x = UIDef.RAND;
                int y = UIDef.RAND;
                int iw = d.width - 2 * UIDef.RAND;
                int ih = d.height - 2 * UIDef.RAND;
                int oh = ih - UIDef.BUT_HEIGHT - UIDef.INNER_RAND;
                RackHealthReportRacksRequester.this.ivRacksTabbedPane.setBounds(x, y, iw, oh);
                RackHealthReportRacksRequester.this.ivOkButton.setBounds(x, y += oh + UIDef.INNER_RAND, iw, UIDef.BUT_HEIGHT);
            }
        });
        this.checkBut();
        WindowUtils.bringUpCenteredDialog(this, UIDef.getScaled(600), UIDef.getScaled(500), true);
    }

    public RackHealthReportGeneralsRequester.GeneralMicroorganismResult getChangedResult(RackHealthReportGeneralsRequester.GeneralMicroorganismResult vorlage) {
        RHRRMOOberPanel opanel = (RHRRMOOberPanel)this.ivPanels.firstElement();
        return opanel.ivSubPanel.generateResult(vorlage);
    }

    public void checkBut() {
        boolean enabled = true;
        Iterator iterator = this.ivPanels.iterator();
        while (iterator.hasNext() && enabled) {
            RHRRMOOberPanel rop = (RHRRMOOberPanel)iterator.next();
            RHRRMOPanel panel = rop.ivSubPanel;
            enabled &= panel.okAllowed();
        }
        this.ivOkButton.setEnabled(enabled);
    }

    public void fillInitStrings(HashMap initStringsByRack, RackHealthReportGeneralsRequester.GeneralMicroorganismResult vorlageResult) {
        StringBuilder msb = new StringBuilder();
        Iterator iterator = this.ivPanelsByRack.keySet().iterator();
        while (iterator.hasNext()) {
            Rack rack = (Rack)iterator.next();
            RHRRMOOberPanel rop = (RHRRMOOberPanel)this.ivPanelsByRack.get(rack);
            RHRRMOPanel panel = rop.ivSubPanel;
            int anzChecked = panel.ivAnzBox.getSelectedIndex();
            msb.setLength(0);
            RResHealthReport.fillReqInitString(msb, 0L, rack.getID(), vorlageResult.ivDate, vorlageResult.ivPerformer, anzChecked);
            int i = 0;
            while (i < vorlageResult.ivMicroorganisms.length) {
                int anz;
                if (i != 0) {
                    msb.append(RResHealthReport.MicroRes.TRENNER);
                }
                if ((anz = panel.ivAnzCombos[i].getSelectedIndex()) < 0) {
                    anz = 0;
                }
                RResHealthReport.MicroRes.fillInitString(vorlageResult.ivMicroorganisms[i].ivID, vorlageResult.ivMethods[i].ivID, anz, msb);
                ++i;
            }
            msb.append("|");
            String details = panel.ivDetailsPane.getText();
            msb.append(details != null ? Base64Manager.encodeBase64(details) : "");
            msb.append("|");
            initStringsByRack.put(rack, Base64Manager.encodeBase64(msb.toString()));
            msb.setLength(0);
        }
        this.ivPanelsByRack.clear();
        this.ivPanelsByRack = null;
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    public void OKPressed() {
        super.OKPressed();
    }

    public class RHRRMOOberPanel
    extends JPanel {
        private static final long serialVersionUID = 1352367L;
        private MGButton ivChangeButton = null;
        private RackHealthReportGeneralsRequester.GeneralMicroorganismResult ivGMR = null;
        public RHRRMOPanel ivSubPanel = null;
        private JScrollPane ivScrollPane = null;

        public RHRRMOOberPanel(RHRRMOPanel subPanel, RackHealthReportGeneralsRequester.GeneralMicroorganismResult gmr, boolean keimChangePossible) {
            super(new BorderLayout());
            this.ivScrollPane = new JScrollPane(subPanel);
            this.ivGMR = gmr;
            this.ivSubPanel = subPanel;
            this.add("Center", this.ivScrollPane);
            if (keimChangePossible) {
                this.ivChangeButton = new MGButton(Babel.get("ARHR_CHANGE_KEIME"));
                this.ivChangeButton.addActionListener(new ActionListener(this){
                    final /* synthetic */ RHRRMOOberPanel this$1;
                    {
                        this.this$1 = rHRRMOOberPanel;
                    }

                    public void actionPerformed(ActionEvent e) {
                        RackHealthReportGeneralsRequester.GeneralMicroorganismResult tgmr = this.this$1.ivSubPanel.generateResult(RHRRMOOberPanel.access$0(this.this$1));
                        RackHealthReportChangeKeimeRequester req = new RackHealthReportChangeKeimeRequester(WindowUtils.getJDialog(RHRRMOOberPanel.access$1(this.this$1)), tgmr);
                        if (req.ivWarOK) {
                            RackHealthReportGeneralsRequester.GeneralMicroorganismResult gmr = req.ivResult;
                            int neuAnz = gmr.ivMicroorganisms.length;
                            JLabel[] nameLabels = new JLabel[neuAnz];
                            JComboBox[] anzCombos = new JComboBox[neuAnz];
                            int[] keimIDs = new int[neuAnz];
                            int i = 0;
                            while (i < gmr.ivMicroorganisms.length) {
                                Microorganism.Keim keim = (Microorganism.Keim)gmr.ivMicroorganisms[i];
                                keimIDs[i] = keim.ivID;
                                int index = ArrayHelper.findIndexInArray(keim.ivID, RHRRMOPanel.access$0(this.this$1.ivSubPanel));
                                if (index != -1) {
                                    nameLabels[i] = RHRRMOPanel.access$1(this.this$1.ivSubPanel)[index];
                                    anzCombos[i] = RHRRMOPanel.access$2(this.this$1.ivSubPanel)[index];
                                } else {
                                    String[] anzes = RackHealthReportRacksRequester.access$0(RHRRMOPanel.access$3(this.this$1.ivSubPanel).getSelectedIndex());
                                    anzCombos[i] = new JComboBox<String>(anzes);
                                    anzCombos[i].setEnabled(anzes.length > 0);
                                    ListDefinition ld = keim.getMethodDefinition();
                                    String method = ld != null ? ld.toString() : "?";
                                    nameLabels[i] = new JLabel(String.valueOf(keim.toString()) + " (" + method + ")" + (keim.ivFelasaRelevant ? " " + Babel.get("GETN_FELASA") : ""));
                                }
                                if (i % 2 == 0) {
                                    nameLabels[i].setOpaque(true);
                                    nameLabels[i].setBackground(ColorManager.getLighterColor(UIDef.BLUE_COLOR));
                                    anzCombos[i].setOpaque(true);
                                    anzCombos[i].setBackground(ColorManager.getLighterColor(UIDef.BLUE_COLOR));
                                } else {
                                    nameLabels[i].setOpaque(false);
                                    nameLabels[i].setBackground(null);
                                    anzCombos[i].setOpaque(false);
                                    anzCombos[i].setBackground(null);
                                }
                                ++i;
                            }
                            this.this$1.ivSubPanel.resetComponents(nameLabels, anzCombos, keimIDs);
                            RHRRMOOberPanel.access$2(this.this$1).setViewportView(this.this$1.ivSubPanel);
                        }
                    }
                });
                this.add("South", this.ivChangeButton);
            }
        }

        static /* synthetic */ RackHealthReportGeneralsRequester.GeneralMicroorganismResult access$0(RHRRMOOberPanel rHRRMOOberPanel) {
            return rHRRMOOberPanel.ivGMR;
        }

        static /* synthetic */ MGButton access$1(RHRRMOOberPanel rHRRMOOberPanel) {
            return rHRRMOOberPanel.ivChangeButton;
        }

        static /* synthetic */ JScrollPane access$2(RHRRMOOberPanel rHRRMOOberPanel) {
            return rHRRMOOberPanel.ivScrollPane;
        }
    }

    public class RHRRMOPanel
    extends JPanel {
        private static final long serialVersionUID = 11863454L;
        private JLabel ivTopLabel = new JLabel(Babel.get("ARHR_COUNT_CHECKED_MICE"));
        private JComboBox ivAnzBox = null;
        private JLabel[] ivNameLabels = null;
        private JComboBox[] ivAnzCombos = null;
        private int[] ivKeimIDs = null;
        private JTextPane ivDetailsPane = new JTextPane();
        private JScrollPane ivDetailsScrollPane = new JScrollPane(this.ivDetailsPane);
        private JLabel ivDetailsLabel = new JLabel(Babel.get("RESULTDETAILS"));
        private Dimension ivPrefSize = null;

        public RHRRMOPanel(RackHealthReportGeneralsRequester.GeneralMicroorganismResult gmr, RResWrapper wrapper) {
            this.setOpaque(true);
            this.setBackground(Color.white);
            String[] anzes = new String[]{};
            this.ivNameLabels = new JLabel[gmr.ivMicroorganisms.length];
            this.ivAnzCombos = new JComboBox[gmr.ivMicroorganisms.length];
            this.ivKeimIDs = new int[gmr.ivMicroorganisms.length];
            int i = 0;
            while (i < this.ivNameLabels.length) {
                Microorganism.Keim keim = (Microorganism.Keim)gmr.ivMicroorganisms[i];
                this.ivKeimIDs[i] = keim.ivID;
                this.ivNameLabels[i] = new JLabel(String.valueOf(keim.toString()) + " (" + gmr.ivMethods[i].toString() + ")" + (keim.ivFelasaRelevant ? " " + Babel.get("GETN_FELASA") : ""));
                this.add(this.ivNameLabels[i]);
                this.ivAnzCombos[i] = new JComboBox<String>(anzes);
                this.ivAnzCombos[i].setEnabled(false);
                this.add(this.ivAnzCombos[i]);
                if (i % 2 == 0) {
                    this.ivNameLabels[i].setOpaque(true);
                    this.ivNameLabels[i].setBackground(ColorManager.getLighterColor(UIDef.BLUE_COLOR));
                    this.ivAnzCombos[i].setOpaque(true);
                    this.ivAnzCombos[i].setBackground(ColorManager.getLighterColor(UIDef.BLUE_COLOR));
                }
                this.ivNameLabels[i].setForeground(keim.getFG());
                ++i;
            }
            this.ivDetailsPane.setForeground(Color.black);
            this.ivDetailsPane.setBackground(Color.white);
            this.ivDetailsPane.setFont(FontManager.getFont("SSB12"));
            this.ivDetailsPane.setText(gmr.ivDetails != null ? gmr.ivDetails : "");
            this.ivDetailsPane.setCaretPosition(0);
            this.add(this.ivDetailsScrollPane);
            this.add(this.ivDetailsLabel);
            String[] possMax = new String[20];
            possMax[0] = "";
            int i2 = 1;
            while (i2 < possMax.length) {
                possMax[i2] = " " + i2 + " ";
                ++i2;
            }
            this.ivAnzBox = new JComboBox<String>(possMax);
            this.ivAnzBox.addActionListener(new ActionListener(this){
                final /* synthetic */ RHRRMOPanel this$1;
                {
                    this.this$1 = rHRRMOPanel;
                }

                public void actionPerformed(ActionEvent e) {
                    int index = RHRRMOPanel.access$3(this.this$1).getSelectedIndex();
                    this.this$1.adaptAnz(index);
                    RHRRMOPanel.access$9(this.this$1).checkBut();
                }
            });
            if (wrapper != null) {
                this.ivAnzBox.setSelectedIndex(wrapper.ivHealthReport.ivNumChecked);
                i2 = 0;
                while (i2 < wrapper.ivHealthReport.ivMicroResults.length) {
                    this.ivAnzCombos[i2].setEnabled(true);
                    this.ivAnzCombos[i2].setSelectedIndex(wrapper.ivHealthReport.ivMicroResults[i2].ivFound);
                    ++i2;
                }
            }
            this.add(this.ivTopLabel);
            this.add(this.ivAnzBox);
            this.calcPrefSize();
            this.setLayout(new SimpleLayoutManager(this){
                final /* synthetic */ RHRRMOPanel this$1;
                {
                    this.this$1 = rHRRMOPanel;
                }

                public void layoutContainer(Container parent) {
                    int y = UIDef.INNER_RAND;
                    int rw = RHRRMOPanel.access$3((RHRRMOPanel)this.this$1).getPreferredSize().width;
                    int iw = parent.getSize().width - 2 * UIDef.INNER_RAND;
                    int lw = iw - UIDef.INNER_RAND - rw;
                    int lx = UIDef.INNER_RAND;
                    int rx = lx + lw + UIDef.INNER_RAND;
                    RHRRMOPanel.access$4(this.this$1).setBounds(lx, y, lw, UIDef.LINE_HEIGHT);
                    RHRRMOPanel.access$3(this.this$1).setBounds(rx, y, rw, UIDef.LINE_HEIGHT);
                    y += UIDef.LINE_HEIGHT + 2 * UIDef.RAND;
                    int i = 0;
                    while (i < RHRRMOPanel.access$1(this.this$1).length) {
                        RHRRMOPanel.access$1(this.this$1)[i].setBounds(lx, y, lw, UIDef.LINE_HEIGHT);
                        RHRRMOPanel.access$2(this.this$1)[i].setBounds(rx, y, rw, UIDef.LINE_HEIGHT);
                        y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
                        ++i;
                    }
                    int labw = RHRRMOPanel.access$5((RHRRMOPanel)this.this$1).getPreferredSize().width;
                    RHRRMOPanel.access$5(this.this$1).setBounds(lx, y, labw, UIDef.LINE_HEIGHT);
                    RHRRMOPanel.access$6(this.this$1).setBounds(lx + labw + UIDef.INNER_RAND, y, iw - labw - UIDef.INNER_RAND, RackHealthReportRacksRequester.access$1());
                }

                public Dimension preferredLayoutSize(Container parent) {
                    return new Dimension(parent.getSize().width, RHRRMOPanel.access$7((RHRRMOPanel)this.this$1).height);
                }
            });
        }

        private void calcPrefSize() {
            int y = UIDef.INNER_RAND;
            y += UIDef.LINE_HEIGHT + 2 * UIDef.RAND;
            y += this.ivNameLabels.length * (UIDef.LINE_HEIGHT + UIDef.INNER_RAND);
            this.ivPrefSize = new Dimension(100, y += TEXTPANE_HEIGHT);
        }

        public void resetComponents(JLabel[] nameLabels, JComboBox[] anzCombos, int[] keimIds) {
            int i;
            if (this.ivNameLabels != null) {
                i = 0;
                while (i < this.ivNameLabels.length) {
                    this.remove(this.ivNameLabels[i]);
                    ++i;
                }
            }
            if (this.ivAnzCombos != null) {
                i = 0;
                while (i < this.ivAnzCombos.length) {
                    this.remove(this.ivAnzCombos[i]);
                    ++i;
                }
            }
            this.ivNameLabels = nameLabels;
            this.ivAnzCombos = anzCombos;
            this.ivKeimIDs = keimIds;
            if (this.ivNameLabels != null) {
                i = 0;
                while (i < this.ivNameLabels.length) {
                    this.add(this.ivNameLabels[i]);
                    ++i;
                }
            }
            if (this.ivAnzCombos != null) {
                i = 0;
                while (i < this.ivAnzCombos.length) {
                    this.add(this.ivAnzCombos[i]);
                    ++i;
                }
            }
            this.calcPrefSize();
            LayoutManager lm = this.getLayout();
            this.setLayout(lm);
        }

        public boolean okAllowed() {
            return this.ivAnzBox.getSelectedIndex() != 0;
        }

        public Dimension getPreferredSize() {
            return this.ivPrefSize;
        }

        public void adaptAnz(int max) {
            if (max == 0) {
                String[] anzes = new String[]{};
                int i = 0;
                while (i < this.ivAnzCombos.length) {
                    this.ivAnzCombos[i].setModel(new DefaultComboBoxModel<String>(anzes));
                    this.ivAnzCombos[i].setEnabled(false);
                    ++i;
                }
            } else {
                String[] anzes = RackHealthReportRacksRequester.getAnzesArr(max);
                int i = 0;
                while (i < this.ivAnzCombos.length) {
                    int prevsel = this.ivAnzCombos[i].getSelectedIndex();
                    this.ivAnzCombos[i].setModel(new DefaultComboBoxModel<String>(anzes));
                    if (prevsel >= anzes.length) {
                        prevsel = anzes.length - 1;
                    }
                    this.ivAnzCombos[i].setSelectedIndex(prevsel);
                    this.ivAnzCombos[i].setEnabled(true);
                    ++i;
                }
            }
        }

        public RackHealthReportGeneralsRequester.GeneralMicroorganismResult generateResult(RackHealthReportGeneralsRequester.GeneralMicroorganismResult vorlage) {
            ListDefinition[] microorganisms = new ListDefinition[this.ivKeimIDs.length];
            ListDefinition[] methods = new ListDefinition[this.ivKeimIDs.length];
            int i = 0;
            while (i < this.ivKeimIDs.length) {
                microorganisms[i] = Microorganism.getKeim(this.ivKeimIDs[i]);
                methods[i] = vorlage.getMethod((Microorganism.Keim)microorganisms[i]);
                ++i;
            }
            return new RackHealthReportGeneralsRequester.GeneralMicroorganismResult(vorlage.ivPerformer, vorlage.ivDate, microorganisms, methods, this.ivDetailsPane.getText());
        }

        static /* synthetic */ int[] access$0(RHRRMOPanel rHRRMOPanel) {
            return rHRRMOPanel.ivKeimIDs;
        }

        static /* synthetic */ JLabel[] access$1(RHRRMOPanel rHRRMOPanel) {
            return rHRRMOPanel.ivNameLabels;
        }

        static /* synthetic */ JLabel access$4(RHRRMOPanel rHRRMOPanel) {
            return rHRRMOPanel.ivTopLabel;
        }

        static /* synthetic */ JLabel access$5(RHRRMOPanel rHRRMOPanel) {
            return rHRRMOPanel.ivDetailsLabel;
        }

        static /* synthetic */ JScrollPane access$6(RHRRMOPanel rHRRMOPanel) {
            return rHRRMOPanel.ivDetailsScrollPane;
        }

        static /* synthetic */ Dimension access$7(RHRRMOPanel rHRRMOPanel) {
            return rHRRMOPanel.ivPrefSize;
        }

        static /* synthetic */ RackHealthReportRacksRequester access$9(RHRRMOPanel rHRRMOPanel) {
            return rHRRMOPanel.RackHealthReportRacksRequester.this;
        }
    }
}

