/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.result;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import mausoleum.alert.Alert;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.calendar.CalendarPanel;
import mausoleum.result.MResult;
import mausoleum.result.SpecialResult;
import mausoleum.result.SpecialResultHelper;
import mausoleum.result.SpecialResultPanel;
import mausoleum.ui.UIDef;

public class SpecialResultRequester
extends BasicRequester {
    private static final long serialVersionUID = 11881689443435L;
    private static final HashMap PANELS_BY_SPECIAL_RESULT = new HashMap();
    private static final int NAME_HEIGHT = UIDef.getScaled(28);
    private static final int COMBO_WIDTH = UIDef.getScaled(240);
    private static final HashMap BOUNDS_BY_EXP_TYPE = new HashMap();
    private JLabel ivPerformerLabel = null;
    private JTextField ivPerformerField = null;
    private BorderPanel ivResultBorderPanel = null;
    private final SpecialResultPanel ivSpecResPanel;
    private CalendarPanel ivCalendarPanel = null;
    private MGButton ivNoButton1 = null;
    private MGButton ivNoButton2 = null;
    private final Vector ivMaeuse;
    private final int ivDatumOverride;
    private final long ivExpID;
    private final Vector ivPresetValuesForEachMouse;
    public String ivNoButtonBabelIfPressed = null;
    private Dimension ivMiniDim = new Dimension(0, 0);
    private Dimension ivMaxiDim = new Dimension(0, 0);
    public String[] ivCommands = null;
    public String[] ivGroups = null;
    public Object[] ivExtraObjects = null;

    public static void maximizeIt(int w, int h, Dimension d) {
        if (w > d.width) {
            d.width = w;
        }
        d.height += h;
    }

    public SpecialResultRequester(Frame sender, SpecialResult specRes, MyDate minimum, Vector maeuse, String specResBabel, int datumOverride, HashMap presetValues, Vector presetValuesForEachMouse, boolean mitPerformerField, String specialOKBabel, String noButtonBabel, String noButton2Babel, Font buttonFont) {
        super(sender, 10, 10);
        this.setResizable(true);
        this.getContentPane().setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = parent.getSize();
                int x = UIDef.RAND;
                int y = UIDef.RAND;
                int iw = d.width - 2 * UIDef.RAND;
                int ih = d.height - 2 * UIDef.RAND;
                if (SpecialResultRequester.this.ivPerformerLabel != null) {
                    int lw = iw - UIDef.INNER_RAND - COMBO_WIDTH;
                    SpecialResultRequester.this.ivPerformerLabel.setBounds(x, y, lw, NAME_HEIGHT);
                    SpecialResultRequester.this.ivPerformerField.setBounds(x + lw + UIDef.INNER_RAND, y, COMBO_WIDTH, NAME_HEIGHT);
                    y += NAME_HEIGHT + UIDef.INNER_RAND;
                }
                int panH = ih - (SpecialResultRequester.this.ivPerformerLabel != null ? NAME_HEIGHT + UIDef.INNER_RAND : 0) - (SpecialResultRequester.this.ivCalendarPanel != null ? CalendarPanel.HOEHE + UIDef.INNER_RAND : 0) - (UIDef.BUT_HEIGHT + UIDef.INNER_RAND) - UIDef.INNER_RAND;
                SpecialResultRequester.this.ivResultBorderPanel.setBounds(x, y, iw, panH);
                y += panH + UIDef.INNER_RAND;
                if (SpecialResultRequester.this.ivCalendarPanel != null) {
                    int lw = (iw - CalendarPanel.BREITE) / 2;
                    SpecialResultRequester.this.ivCalendarPanel.setBounds(x + lw, y, CalendarPanel.BREITE, CalendarPanel.HOEHE);
                    y += CalendarPanel.HOEHE + UIDef.INNER_RAND;
                }
                int anzButtons = 1;
                if (SpecialResultRequester.this.ivNoButton1 != null) {
                    ++anzButtons;
                }
                if (SpecialResultRequester.this.ivNoButton2 != null) {
                    ++anzButtons;
                }
                if (anzButtons == 1) {
                    SpecialResultRequester.this.ivOkButton.setBounds(x, y, iw, UIDef.BUT_HEIGHT);
                } else {
                    int lbw = (iw - (anzButtons - 1) * UIDef.INNER_RAND) / anzButtons;
                    int rbw = iw - (anzButtons - 1) * UIDef.INNER_RAND - (anzButtons - 1) * lbw;
                    SpecialResultRequester.this.ivOkButton.setBounds(x, y, lbw, UIDef.BUT_HEIGHT);
                    x += lbw + UIDef.INNER_RAND;
                    if (SpecialResultRequester.this.ivNoButton != null) {
                        int w = anzButtons == 2 ? lbw : rbw;
                        SpecialResultRequester.this.ivNoButton1.setBounds(x, y, w, UIDef.BUT_HEIGHT);
                        x += w + UIDef.INNER_RAND;
                    }
                    if (SpecialResultRequester.this.ivNoButton2 != null) {
                        SpecialResultRequester.this.ivNoButton1.setBounds(x, y, rbw, UIDef.BUT_HEIGHT);
                    }
                }
            }
        });
        SpecialResultPanel specResPanel = (SpecialResultPanel)PANELS_BY_SPECIAL_RESULT.get(specRes);
        if (specResPanel == null) {
            specResPanel = new SpecialResultPanel(specRes);
            PANELS_BY_SPECIAL_RESULT.put(specRes, specResPanel);
        }
        this.ivExpID = specRes.ivExperimentID;
        this.ivSpecResPanel = specResPanel;
        specResPanel.clearALLComponents();
        this.ivPresetValuesForEachMouse = presetValuesForEachMouse;
        if (presetValues != null) {
            SpecialResultHelper.digestPrestValues(specResPanel, presetValues);
        }
        this.ivMaeuse = maeuse;
        if (mitPerformerField) {
            this.ivPerformerLabel = new JLabel(Babel.get("REPORTED_BY"));
            this.ivPerformerLabel.setFont(FontManager.getFont("SSB14"));
            this.getContentPane().add(this.ivPerformerLabel);
            this.ivPerformerField = new JTextField();
            this.ivPerformerField.setFont(FontManager.getFont("SSB14"));
            this.ivPerformerField.setText(UserManager.getNameOfUser());
            this.getContentPane().add(this.ivPerformerField);
            int mw = this.ivPerformerLabel.getPreferredSize().width + UIDef.INNER_RAND + COMBO_WIDTH;
            int mh = NAME_HEIGHT + UIDef.INNER_RAND;
            SpecialResultRequester.maximizeIt(mw, mh, this.ivMiniDim);
            SpecialResultRequester.maximizeIt(mw, mh, this.ivMaxiDim);
        }
        this.ivDatumOverride = datumOverride;
        boolean wantsCalendar = this.ivDatumOverride == Integer.MIN_VALUE;
        JScrollPane jsp = new JScrollPane(specResPanel);
        jsp.setOpaque(false);
        jsp.getViewport().setOpaque(false);
        jsp.getVerticalScrollBar().setUnitIncrement(4);
        this.ivResultBorderPanel = new BorderPanel(jsp, Babel.get(specResBabel));
        this.getContentPane().add(this.ivResultBorderPanel);
        int mw = this.ivSpecResPanel.getPreferredSize().width + UIDef.getScaled(40);
        int mxh = this.ivSpecResPanel.getPreferredSize().height + UIDef.getScaled(50);
        int mnh = UIDef.getScaled(200);
        SpecialResultRequester.maximizeIt(mw, mnh + UIDef.INNER_RAND, this.ivMiniDim);
        SpecialResultRequester.maximizeIt(mw + UIDef.getScaled(30), mxh + UIDef.INNER_RAND, this.ivMaxiDim);
        if (wantsCalendar) {
            this.ivCalendarPanel = new CalendarPanel(minimum, MyDate.getMyDate(System.currentTimeMillis()));
            SpecialResultRequester.maximizeIt(CalendarPanel.BREITE, CalendarPanel.HOEHE + UIDef.INNER_RAND, this.ivMiniDim);
            SpecialResultRequester.maximizeIt(CalendarPanel.BREITE, CalendarPanel.HOEHE + UIDef.INNER_RAND, this.ivMaxiDim);
            this.getContentPane().add(this.ivCalendarPanel);
        }
        if (specialOKBabel != null) {
            this.ivOkButton.setText(Babel.get(specialOKBabel));
        }
        if (buttonFont != null) {
            this.ivOkButton.setFont(buttonFont);
        }
        this.getContentPane().add(this.ivOkButton);
        ActionListener al = null;
        if (noButtonBabel != null || noButton2Babel != null) {
            al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SpecialResultRequester.this.ivNoButtonBabelIfPressed = e.getActionCommand();
                    SpecialResultRequester.this.ivWarOK = false;
                    SpecialResultRequester.this.dispose();
                }
            };
        }
        if (noButtonBabel != null) {
            this.ivNoButton1 = MGButton.getRequesterButton(Babel.get(noButtonBabel));
            this.ivNoButton1.setActionCommand(noButtonBabel);
            this.ivNoButton1.addActionListener(al);
            if (buttonFont != null) {
                this.ivNoButton1.setFont(buttonFont);
            }
            this.getContentPane().add(this.ivNoButton1);
        }
        if (noButton2Babel != null) {
            this.ivNoButton2 = MGButton.getRequesterButton(Babel.get(noButton2Babel));
            this.ivNoButton2.setActionCommand(noButton2Babel);
            this.ivNoButton2.addActionListener(al);
            if (buttonFont != null) {
                this.ivNoButton2.setFont(buttonFont);
            }
            this.getContentPane().add(this.ivNoButton2);
        }
        SpecialResultRequester.maximizeIt(UIDef.getScaled(400), UIDef.BUT_HEIGHT, this.ivMiniDim);
        SpecialResultRequester.maximizeIt(UIDef.getScaled(400), UIDef.BUT_HEIGHT, this.ivMaxiDim);
        specRes.dialogIsShown();
        this.ivMiniDim.width += 2 * UIDef.RAND;
        this.ivMiniDim.height += 2 * UIDef.RAND;
        this.ivMaxiDim.width += 2 * UIDef.RAND;
        this.ivMaxiDim.height += 2 * UIDef.RAND;
        int ww = this.ivMiniDim.width;
        int wh = this.ivMaxiDim.height;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (screen.height - UIDef.getScaled(90) < wh) {
            wh = screen.height - UIDef.getScaled(90);
        }
        this.pack();
        Insets innis = this.getInsets();
        this.ivMiniDim.width += innis.left + innis.right;
        this.ivMiniDim.height += innis.top + innis.bottom;
        this.ivMaxiDim.width += innis.left + innis.right;
        this.ivMaxiDim.height += innis.top + innis.bottom;
        this.setMinimumSize(this.ivMiniDim);
        this.setMaximumSize(this.ivMaxiDim);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Component c = (Component)e.getSource();
                Dimension d = c.getSize();
                boolean changed = false;
                if (d.width < ((SpecialResultRequester)SpecialResultRequester.this).ivMiniDim.width) {
                    d.width = ((SpecialResultRequester)SpecialResultRequester.this).ivMiniDim.width;
                    changed = true;
                }
                if (d.width > ((SpecialResultRequester)SpecialResultRequester.this).ivMaxiDim.width) {
                    d.width = ((SpecialResultRequester)SpecialResultRequester.this).ivMaxiDim.width;
                    changed = true;
                }
                if (d.height < ((SpecialResultRequester)SpecialResultRequester.this).ivMiniDim.height) {
                    d.height = ((SpecialResultRequester)SpecialResultRequester.this).ivMiniDim.height;
                    changed = true;
                }
                if (d.height > ((SpecialResultRequester)SpecialResultRequester.this).ivMaxiDim.height) {
                    d.height = ((SpecialResultRequester)SpecialResultRequester.this).ivMaxiDim.height;
                    changed = true;
                }
                if (changed) {
                    c.setSize(d);
                    super.componentResized(e);
                }
                BOUNDS_BY_EXP_TYPE.put(new Long(SpecialResultRequester.this.ivExpID), c.getBounds());
            }

            public void componentMoved(ComponentEvent e) {
                Component c = (Component)e.getSource();
                BOUNDS_BY_EXP_TYPE.put(new Long(SpecialResultRequester.this.ivExpID), c.getBounds());
            }
        });
        Rectangle rect = (Rectangle)BOUNDS_BY_EXP_TYPE.get(new Long(this.ivExpID));
        if (rect != null) {
            this.setBounds(rect);
            this.setVisible(true);
        } else {
            WindowUtils.bringUpCenteredDialog(this, ww, wh, true);
        }
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    public void OKPressed() {
        String result = SpecialResultHelper.getStringRepresentationForResult(this.ivSpecResPanel.ivSpecialResult);
        if (result == null) {
            Alert.showAlert(Babel.get("RESULT_NO_VALUE"), true);
            return;
        }
        String performer = this.ivPerformerField != null ? this.ivPerformerField.getText().trim() : UserManager.getNameOfUser();
        this.ivCommands = new String[this.ivMaeuse.size()];
        this.ivGroups = new String[this.ivMaeuse.size()];
        this.ivExtraObjects = new Object[this.ivMaeuse.size()];
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < this.ivMaeuse.size()) {
            Mouse maus = (Mouse)this.ivMaeuse.elementAt(i);
            if (this.ivPresetValuesForEachMouse != null) {
                SpecialResultHelper.clearComponents(this.ivSpecResPanel.ivSpecialResult, false);
                HashMap hm = (HashMap)this.ivPresetValuesForEachMouse.elementAt(i);
                SpecialResultHelper.digestPrestValues(this.ivSpecResPanel, hm);
                result = SpecialResultHelper.getStringRepresentationForResult(this.ivSpecResPanel.ivSpecialResult);
            }
            msb.setLength(0);
            msb.append(CommandManagerExecutive.getServiceRoomTag(maus, ""));
            msb.append("MRES_NEW").append(" ").append(maus.getID());
            MResult mresult = new MResult(this.ivSpecResPanel.ivSpecialResult.ivExperimentID);
            mresult.ivResTyp = this.ivSpecResPanel.ivSpecialResult.ivResultTyp;
            mresult.ivPerformer = performer;
            mresult.ivResult = result;
            mresult.ivDate = this.ivCalendarPanel != null ? this.ivCalendarPanel.getSelectedDatumInt() : this.ivDatumOverride;
            TaskExtended.addTaskFinishsToComBuff(maus, maus.getTaskKey(), "TASK_AC_RESULT", this.ivExpID, msb, mresult.ivDate);
            this.ivGroups[i] = maus.getGroup();
            this.ivCommands[i] = msb.toString();
            this.ivExtraObjects[i] = mresult;
            ++i;
        }
        super.OKPressed();
    }
}

