/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.std;

import de.hannse.netobjects.util.Babel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import mausoleum.gui.MGButton;
import mausoleum.helper.FontManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.ui.UIDef;

public class MausoOptionPane
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static int MODE_OK_AND_NO = 1;
    public static int MODE_OK = 2;
    public static int MODE_NO = 3;
    public static int MODE_NIX = 4;
    private boolean ivWarOK = false;

    public static boolean showOptionPane(Component sender, JComponent innerComp, int okNoMode) {
        return MausoOptionPane.showOptionPane(sender, innerComp, okNoMode, null, null, null, null);
    }

    public static boolean showOptionPane(Component sender, JComponent innerComp, int okNoMode, String titel) {
        return MausoOptionPane.showOptionPane(sender, innerComp, okNoMode, titel, null, null, null);
    }

    public static boolean showOptionPane(Component sender, JComponent innerComp, int okNoMode, String titel, String compPrefix) {
        return MausoOptionPane.showOptionPane(sender, innerComp, okNoMode, titel, null, compPrefix, null);
    }

    public static boolean showOptionPane(Component sender, JComponent innerComp, int okNoMode, String titel, JTextField retOKField, String compPrefix, JComponent retOKComp) {
        JDialog dia = WindowUtils.getJDialog(sender);
        if (dia != null) {
            return new MausoOptionPane((JDialog)dia, (JComponent)innerComp, (int)okNoMode, (String)titel, (JTextField)retOKField, (String)compPrefix, (JComponent)retOKComp).ivWarOK;
        }
        JFrame fra = WindowUtils.getJFrame(sender);
        if (fra != null) {
            return new MausoOptionPane((Frame)fra, (JComponent)innerComp, (int)okNoMode, (String)titel, (JTextField)retOKField, (String)compPrefix, (JComponent)retOKComp).ivWarOK;
        }
        return false;
    }

    public static String select(String[] arr, Object prevVal, Component sender, String titel, String compPrefix) {
        if (arr != null) {
            JComboBox<String> choiceCombo = new JComboBox<String>(arr);
            choiceCombo.setPreferredSize(new Dimension(250, 24));
            choiceCombo.setFont(FontManager.getFont("SSB12"));
            if (prevVal != null && prevVal instanceof String) {
                choiceCombo.setSelectedItem(prevVal);
            }
            if (MausoOptionPane.showOptionPane(sender, choiceCombo, MODE_OK_AND_NO, titel, null, compPrefix, null)) {
                String s = arr[choiceCombo.getSelectedIndex()];
                return s;
            }
        }
        return null;
    }

    public static String typeIn(Object prevVal, Component sender, String titel, String compPrefix) {
        JTextField tf = new JTextField();
        tf.setPreferredSize(new Dimension(250, 24));
        tf.setFont(FontManager.getFont("SSB12"));
        if (prevVal != null && prevVal instanceof String) {
            tf.setText((String)prevVal);
        }
        if (MausoOptionPane.showOptionPane(sender, tf, MODE_OK_AND_NO, titel, tf, compPrefix, null)) {
            return tf.getText();
        }
        return null;
    }

    private MausoOptionPane(Frame sender, JComponent innerComp, int okNoMode, String titel, JTextField retOKField, String compPrefix) {
        super(sender, titel == null ? Babel.get("REQUEST") : titel, true);
        this.init(innerComp, okNoMode, retOKField, compPrefix, null);
    }

    private MausoOptionPane(Frame sender, JComponent innerComp, int okNoMode, String titel, JTextField retOKField, String compPrefix, JComponent retOKComponent) {
        super(sender, titel == null ? Babel.get("REQUEST") : titel, true);
        this.init(innerComp, okNoMode, retOKField, compPrefix, retOKComponent);
    }

    private MausoOptionPane(JDialog sender, JComponent innerComp, int okNoMode, String titel, JTextField retOKField, String compPrefix) {
        super(sender, titel == null ? Babel.get("REQUEST") : titel, true);
        this.init(innerComp, okNoMode, retOKField, compPrefix, null);
    }

    private MausoOptionPane(JDialog sender, JComponent innerComp, int okNoMode, String titel, JTextField retOKField, String compPrefix, JComponent retOKComponent) {
        super(sender, titel == null ? Babel.get("REQUEST") : titel, true);
        this.init(innerComp, okNoMode, retOKField, compPrefix, retOKComponent);
    }

    private void init(JComponent innerComp, int okNoMode, JTextField retOKField, String compPrefix, JComponent retOKComponent) {
        JPanel back = new JPanel(){
            private static final long serialVersionUID = 123L;

            public void paint(Graphics g) {
                MausoleumImageStore.fillDimWithImage(g, "inspectorButton", this.getSize());
                super.paintChildren(g);
            }
        };
        back.setLayout(null);
        this.setContentPane(back);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MausoOptionPane.this.exit(false);
            }
        });
        Dimension dim = innerComp.getPreferredSize();
        int compX = UIDef.RAND;
        if (compPrefix != null) {
            JLabel lab = new JLabel(compPrefix);
            lab.setFont(FontManager.getFont("SSB12"));
            Dimension d = lab.getPreferredSize();
            lab.setBounds(UIDef.RAND, UIDef.RAND, d.width, UIDef.LINE_HEIGHT);
            compX += d.width + UIDef.INNER_RAND;
            back.add(lab);
        }
        int breite = compX + dim.width + UIDef.RAND;
        int innerBreite = breite - 2 * UIDef.RAND;
        int hoehe = dim.height + 2 * UIDef.RAND + (okNoMode != MODE_NIX ? UIDef.RAND + UIDef.BUT_HEIGHT : 0);
        innerComp.setBounds(compX, UIDef.RAND, dim.width, dim.height);
        back.add(innerComp);
        if (okNoMode == MODE_OK_AND_NO) {
            MGButton okButton = this.getOK();
            back.add(okButton);
            MGButton noButton = this.getNO();
            back.add(noButton);
            int lw = (innerBreite - UIDef.INNER_RAND) / 2;
            int rw = innerBreite - UIDef.INNER_RAND - lw;
            okButton.setBounds(UIDef.RAND, UIDef.RAND + dim.height + UIDef.RAND, lw, UIDef.BUT_HEIGHT);
            noButton.setBounds(UIDef.RAND + lw + UIDef.INNER_RAND, UIDef.RAND + dim.height + UIDef.RAND, rw, UIDef.BUT_HEIGHT);
        } else if (okNoMode == MODE_OK) {
            MGButton okButton = this.getOK();
            back.add(okButton);
            okButton.setBounds(UIDef.RAND, UIDef.RAND + dim.height + UIDef.RAND, innerBreite, UIDef.BUT_HEIGHT);
        } else if (okNoMode == MODE_NO) {
            MGButton noButton = this.getNO();
            back.add(noButton);
            noButton.setBounds(UIDef.RAND, UIDef.RAND + dim.height + UIDef.RAND, innerBreite, UIDef.BUT_HEIGHT);
        }
        if (retOKField != null) {
            this.addReturnEqualsOKKeyListener(retOKField);
        }
        if (retOKComponent != null) {
            this.addReturnEqualsOKKeyListenerComp(retOKComponent);
        }
        WindowUtils.bringUpCenteredDialog(this, breite, hoehe, true);
    }

    public void addReturnEqualsOKKeyListener(JTextField tf) {
        tf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MausoOptionPane.this.exit(true);
            }
        });
    }

    public void addReturnEqualsOKKeyListenerComp(JComponent tf) {
        tf.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    e.consume();
                    MausoOptionPane.this.exit(true);
                }
            }
        });
    }

    public void addReturnEqualsOKKeyListener(JTextArea tf) {
        tf.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    e.consume();
                    MausoOptionPane.this.exit(true);
                }
            }
        });
    }

    public void exit(boolean ok) {
        this.ivWarOK = ok;
        this.dispose();
    }

    private MGButton getOK() {
        MGButton okButton = MGButton.getRequesterButton(Babel.get("YES"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MausoOptionPane.this.exit(true);
            }
        });
        okButton.setFont(FontManager.getFont("SSB14"));
        return okButton;
    }

    private MGButton getNO() {
        MGButton noButton = MGButton.getRequesterButton(Babel.get("NO"));
        noButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MausoOptionPane.this.exit(false);
            }
        });
        noButton.setFont(FontManager.getFont("SSB14"));
        return noButton;
    }
}

