/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.strain;

import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mausoleum.gui.DoubleField;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.gui.SimpleList;
import mausoleum.helper.FontManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.NumberFormatter;
import mausoleum.helper.WindowUtils;
import mausoleum.requester.std.MausoOptionPane;
import mausoleum.ui.UIDef;
import mausoleum.ui.table.NiceRegularTable;

public class StrainSelector
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int BREITE = UIDef.getScaled(700);
    private static final int HOEHE = UIDef.getScaled(300);
    private static final int BUT_HOEHE = UIDef.getScaled(30);
    private static final int LINE_HOEHE = UIDef.getScaled(24);
    private static final int SLIDER_HOEHE = UIDef.getScaled(70);
    private static final int FPS_MIN = 1;
    private static final int FPS_MAX = 21;
    private static final int FPS_MITTE = 11;
    private static final int FPS_INIT = 11;
    public static final Double NUESCHT = new Double(Double.NaN);
    private JTabbedPane ivTabbedPane = new JTabbedPane();
    private MGButton ivOK1 = MGButton.getRequesterButton(Babel.get("YES"));
    private MGButton ivNO1 = MGButton.getRequesterButton(Babel.get("NO"));
    private MGButton ivNS1 = MGButton.getRequesterButton(Babel.get("SEL_NOSTRAIN"));
    private JComboBox ivCombo1 = null;
    private JLabel ivLabel1s1 = new JLabel(Babel.get("Strain"));
    private MGButton ivOK2 = MGButton.getRequesterButton(Babel.get("YES"));
    private MGButton ivNO2 = MGButton.getRequesterButton(Babel.get("NO"));
    private MGButton ivNS2 = MGButton.getRequesterButton(Babel.get("SEL_NOSTRAIN"));
    private JSlider ivSlider = null;
    private JComboBox ivCombo2a = null;
    private JComboBox ivCombo2b = null;
    private JLabel ivLabel2a = new JLabel();
    private JLabel ivLabel2b = new JLabel();
    private JLabel ivLabel2s1 = new JLabel(String.valueOf(Babel.get("Strain")) + " 1");
    private JLabel ivLabel2s2 = new JLabel(String.valueOf(Babel.get("Strain")) + " 2");
    private MGButton ivOK3 = MGButton.getRequesterButton(Babel.get("YES"));
    private MGButton ivNO3 = MGButton.getRequesterButton(Babel.get("NO"));
    private MGButton ivNS3 = MGButton.getRequesterButton(Babel.get("SEL_NOSTRAIN"));
    private JTable ivDetailsTable = null;
    private JScrollPane ivDetailsPane = null;
    private MGButton ivAddComplBut = null;
    private MGButton ivRemComplBut = null;
    private MGButton ivEditComplBut = null;
    private final Vector ivIDs;
    private double ivLinks = 0.0;
    private double ivRechts = 0.0;
    public boolean ivWarOK = false;
    public IndexObject[] ivRes = null;
    private Vector ivComplNames = null;
    private Vector ivComplIDs = null;
    private Vector ivComplNamesSEL = null;
    private Vector ivComplIDsSEL = null;
    private Vector ivComplPercSEL = null;
    private JList ivComplSRCList = null;
    private JScrollPane ivComplSRCPane = null;
    private JLabel ivTableLabel = new JLabel();
    private DoubleField ivDoubleField = null;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Vector<String> strainNames = new Vector<String>();
        strainNames.add("Hallo");
        strainNames.add("Huhu");
        strainNames.add("Hihi");
        Vector<Long> strainIDs = new Vector<Long>();
        strainIDs.add(new Long(1L));
        strainIDs.add(new Long(2L));
        strainIDs.add(new Long(3L));
        new StrainSelector(new Frame(), strainNames, strainIDs, true, true);
        System.exit(0);
    }

    public StrainSelector(Frame sender, Vector strainNames, Vector strainIDs, boolean mitSimple, boolean mitSimpleMixture) {
        super(sender, true);
        RequesterPane panel;
        this.ivIDs = strainIDs;
        this.ivTabbedPane.setOpaque(false);
        this.ivTabbedPane.setBackground(new Color(220, 220, 220, 70));
        this.setContentPane(new RequesterPane(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int r = UIDef.RAND;
                StrainSelector.this.ivTabbedPane.setBounds(r, r, d.width - 2 * r, d.height - 2 * r);
            }
        }));
        this.setIconImage(MausoleumImageStore.getLogo());
        this.getContentPane().add(this.ivTabbedPane);
        if (mitSimple) {
            panel = new RequesterPane(new SimpleLayoutManager(){

                public void layoutContainer(Container arg0) {
                    Dimension d = arg0.getSize();
                    int r = UIDef.INNER_RAND;
                    int iw = d.width - 2 * r;
                    int ih = d.height - 2 * r;
                    int oh = ih - r - BUT_HOEHE;
                    int oo = (oh - LINE_HOEHE) / 2;
                    int uy = d.height - r - BUT_HOEHE;
                    int slx = UIDef.getScaled(40);
                    int slw = UIDef.getScaled(70);
                    int cx = slx + slw + r;
                    int cw = iw - cx - slx;
                    StrainSelector.this.ivLabel1s1.setBounds(slx, r + oo, slw, LINE_HOEHE);
                    StrainSelector.this.ivCombo1.setBounds(cx, r + oo, cw, LINE_HOEHE);
                    int blw = (iw - 2 * r) / 3;
                    int brw = iw - 2 * (r + blw);
                    int x = r;
                    StrainSelector.this.ivNS1.setBounds(x, uy, blw, BUT_HOEHE);
                    StrainSelector.this.ivOK1.setBounds(x += blw + r, uy, blw, BUT_HOEHE);
                    StrainSelector.this.ivNO1.setBounds(x += blw + r, uy, brw, BUT_HOEHE);
                }
            });
            panel.setOpaque(false);
            this.ivCombo1 = new JComboBox(strainNames);
            panel.add(this.ivCombo1);
            this.ivOK1.addActionListener(this);
            panel.add(this.ivOK1);
            this.ivNO1.addActionListener(this);
            panel.add(this.ivNO1);
            this.ivNS1.addActionListener(this);
            panel.add(this.ivNS1);
            this.ivLabel1s1.setFont(FontManager.getFont("SSB11"));
            panel.add(this.ivLabel1s1);
            this.ivTabbedPane.add((Component)panel, Babel.get("STRAIN_SIMPLE"));
        }
        if (mitSimpleMixture) {
            panel = new RequesterPane(new SimpleLayoutManager(){

                public void layoutContainer(Container arg0) {
                    Dimension d = arg0.getSize();
                    int r = UIDef.INNER_RAND;
                    int iw = d.width - 2 * r;
                    int ih = d.height - 2 * r;
                    int oh = ih - r - BUT_HOEHE;
                    int oo = (oh - 3 * LINE_HOEHE - 3 * r - SLIDER_HOEHE) / 2;
                    int uy = d.height - r - BUT_HOEHE;
                    int lw = (iw - r) / 2;
                    int rw = iw - r - lw;
                    int y = r + oo;
                    StrainSelector.this.ivLabel2s1.setBounds(r, y, lw, LINE_HOEHE);
                    StrainSelector.this.ivLabel2s2.setBounds(r + lw + r, y, rw, LINE_HOEHE);
                    StrainSelector.this.ivCombo2a.setBounds(r, y += LINE_HOEHE + r, lw, LINE_HOEHE);
                    StrainSelector.this.ivCombo2b.setBounds(r + lw + r, y, rw, LINE_HOEHE);
                    StrainSelector.this.ivLabel2a.setBounds(r, y += LINE_HOEHE + r, lw, LINE_HOEHE);
                    StrainSelector.this.ivLabel2b.setBounds(r + lw + r, y, rw, LINE_HOEHE);
                    StrainSelector.this.ivSlider.setBounds(r, y += LINE_HOEHE + r, iw, SLIDER_HOEHE);
                    y = uy;
                    int blw = (iw - 2 * r) / 3;
                    int brw = iw - 2 * (r + blw);
                    int x = r;
                    StrainSelector.this.ivNS2.setBounds(x, y, blw, BUT_HOEHE);
                    StrainSelector.this.ivOK2.setBounds(x += blw + r, y, blw, BUT_HOEHE);
                    StrainSelector.this.ivNO2.setBounds(x += blw + r, y, brw, BUT_HOEHE);
                }
            });
            panel.setOpaque(false);
            this.ivLabel2s1.setFont(FontManager.getFont("SSB11"));
            this.ivLabel2s1.setFont(FontManager.getFont("SSB11"));
            this.ivLabel2s1.setHorizontalAlignment(0);
            this.ivLabel2s2.setHorizontalAlignment(0);
            panel.add(this.ivLabel2s1);
            panel.add(this.ivLabel2s2);
            this.ivSlider = new JSlider(0, 1, 21, 11);
            this.ivSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent arg0) {
                    StrainSelector.this.setLabels();
                }
            });
            this.ivSlider.setMajorTickSpacing(1);
            this.ivSlider.setPaintTicks(true);
            this.ivSlider.setOpaque(false);
            this.ivSlider.setSnapToTicks(true);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            labelTable.put(new Integer(1), new JLabel("F11"));
            labelTable.put(new Integer(2), new JLabel("F10"));
            labelTable.put(new Integer(3), new JLabel("F9"));
            labelTable.put(new Integer(4), new JLabel("F8"));
            labelTable.put(new Integer(5), new JLabel("F7"));
            labelTable.put(new Integer(6), new JLabel("F6"));
            labelTable.put(new Integer(7), new JLabel("F5"));
            labelTable.put(new Integer(8), new JLabel("F4"));
            labelTable.put(new Integer(9), new JLabel("F3"));
            labelTable.put(new Integer(10), new JLabel("F2"));
            labelTable.put(new Integer(11), new JLabel("F1"));
            labelTable.put(new Integer(12), new JLabel("F2"));
            labelTable.put(new Integer(13), new JLabel("F3"));
            labelTable.put(new Integer(14), new JLabel("F4"));
            labelTable.put(new Integer(15), new JLabel("F5"));
            labelTable.put(new Integer(16), new JLabel("F6"));
            labelTable.put(new Integer(17), new JLabel("F7"));
            labelTable.put(new Integer(18), new JLabel("F8"));
            labelTable.put(new Integer(19), new JLabel("F9"));
            labelTable.put(new Integer(20), new JLabel("F10"));
            labelTable.put(new Integer(21), new JLabel("F11"));
            this.ivSlider.setLabelTable(labelTable);
            this.ivSlider.setFont(FontManager.getFont("SSB11"));
            this.ivSlider.setPaintLabels(true);
            panel.add(this.ivSlider);
            this.ivLabel2a.setFont(FontManager.getFont("SSB14"));
            this.ivLabel2a.setHorizontalAlignment(0);
            this.ivLabel2b.setFont(FontManager.getFont("SSB14"));
            this.ivLabel2b.setHorizontalAlignment(0);
            panel.add(this.ivLabel2a);
            panel.add(this.ivLabel2b);
            this.ivCombo2a = new JComboBox(strainNames);
            this.ivCombo2a.addActionListener(this);
            panel.add(this.ivCombo2a);
            this.ivCombo2b = new JComboBox(strainNames);
            this.ivCombo2b.addActionListener(this);
            panel.add(this.ivCombo2b);
            this.ivOK2.addActionListener(this);
            panel.add(this.ivOK2);
            this.ivNO2.addActionListener(this);
            panel.add(this.ivNO2);
            this.ivNS2.addActionListener(this);
            panel.add(this.ivNS2);
            this.ivTabbedPane.add((Component)panel, Babel.get("STRAIN_SIMPLE_MIXTURE"));
            panel = new RequesterPane(new SimpleLayoutManager(){

                public void layoutContainer(Container arg0) {
                    int sph;
                    Dimension d = arg0.getSize();
                    int r = UIDef.INNER_RAND;
                    int iw = d.width - 2 * r;
                    int ih = d.height - 2 * r;
                    int oh = ih - r - BUT_HOEHE;
                    int spw = (iw - r) / 3;
                    int tpw = iw - r - spw;
                    int tph = sph = oh - r - UIDef.BUT_HEIGHT;
                    int uy = r + oh + r;
                    int x = r;
                    int y1 = r;
                    int y2 = y1 + sph + r;
                    StrainSelector.this.ivComplSRCPane.setBounds(x, y1, spw, sph);
                    StrainSelector.this.ivAddComplBut.setBounds(x, y2, spw, UIDef.BUT_HEIGHT);
                    StrainSelector.this.ivDetailsPane.setBounds(x += spw + UIDef.INNER_RAND, y1, tpw, tph);
                    int lbw = (tpw - UIDef.INNER_RAND) / 2;
                    int rbw = tpw - UIDef.INNER_RAND - lbw;
                    StrainSelector.this.ivRemComplBut.setBounds(x, y2, lbw, UIDef.BUT_HEIGHT);
                    StrainSelector.this.ivEditComplBut.setBounds(x += lbw + UIDef.INNER_RAND, y2, rbw, UIDef.BUT_HEIGHT);
                    int blw = (iw - 2 * r) / 3;
                    int brw = iw - 2 * (r + blw);
                    x = r;
                    StrainSelector.this.ivNS3.setBounds(x, uy, blw, BUT_HOEHE);
                    StrainSelector.this.ivOK3.setBounds(x += blw + r, uy, blw, BUT_HOEHE);
                    StrainSelector.this.ivNO3.setBounds(x += blw + r, uy, brw, BUT_HOEHE);
                }
            });
            panel.setOpaque(false);
            this.ivOK3.addActionListener(this);
            panel.add(this.ivOK3);
            this.ivNO3.addActionListener(this);
            panel.add(this.ivNO3);
            this.ivNS3.addActionListener(this);
            panel.add(this.ivNS3);
            this.ivComplNames = new Vector(strainNames);
            this.ivComplIDs = new Vector(strainIDs);
            this.ivComplNamesSEL = new Vector();
            this.ivComplIDsSEL = new Vector();
            this.ivComplPercSEL = new Vector();
            this.ivComplSRCList = new SimpleList();
            this.ivComplSRCList.setListData(this.ivComplNames);
            this.ivComplSRCList.setSelectionMode(0);
            this.ivComplSRCPane = new JScrollPane(this.ivComplSRCList);
            this.ivComplSRCList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        StrainSelector.this.ivAddComplBut.setEnabled(StrainSelector.this.ivComplSRCList.getSelectedIndex() != -1);
                    }
                }
            });
            panel.add(this.ivComplSRCPane);
            this.ivAddComplBut = MGButton.getRequesterButton(Babel.get("ADD"));
            this.ivAddComplBut.setFont(FontManager.getFont("SSB11"));
            this.ivAddComplBut.setEnabled(false);
            this.ivAddComplBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int ind = StrainSelector.this.ivComplSRCList.getSelectedIndex();
                    if (ind != -1) {
                        String name = (String)StrainSelector.this.ivComplNames.elementAt(ind);
                        Long id = (Long)StrainSelector.this.ivComplIDs.elementAt(ind);
                        StrainSelector.this.ivComplNames.remove(ind);
                        StrainSelector.this.ivComplIDs.remove(ind);
                        StrainSelector.this.ivComplNamesSEL.insertElementAt(name, 0);
                        StrainSelector.this.ivComplIDsSEL.insertElementAt(id, 0);
                        StrainSelector.this.ivComplPercSEL.insertElementAt(NUESCHT, 0);
                        StrainSelector.this.ivComplSRCList.setListData(StrainSelector.this.ivComplNames);
                        StrainSelector.this.calcPercentage();
                    }
                }
            });
            panel.add(this.ivAddComplBut);
            this.ivDetailsTable = new NiceRegularTable(new TableModel(){

                public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                }

                public void removeTableModelListener(TableModelListener l) {
                }

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }

                public Object getValueAt(int rowIndex, int columnIndex) {
                    if (columnIndex == 0) {
                        return (String)StrainSelector.this.ivComplNamesSEL.elementAt(rowIndex);
                    }
                    Double d = (Double)StrainSelector.this.ivComplPercSEL.elementAt(rowIndex);
                    if (d.isNaN()) {
                        return "";
                    }
                    return NumberFormatter.STRAIN_FROMATTER.format(d);
                }

                public int getRowCount() {
                    return StrainSelector.this.ivComplNamesSEL.size();
                }

                public String getColumnName(int columnIndex) {
                    return columnIndex == 0 ? Babel.get("STRAIN") : Babel.get("FS_SERV_PERCENT");
                }

                public int getColumnCount() {
                    return 2;
                }

                public Class getColumnClass(int columnIndex) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz;
                }

                public void addTableModelListener(TableModelListener l) {
                }
            });
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.ivDetailsTable.setDefaultRenderer(clazz, new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    boolean lastRow = row == StrainSelector.this.ivComplPercSEL.size() - 1;
                    boolean lastPerc = column == 1 && lastRow;
                    StrainSelector.this.ivTableLabel.setText(" " + value + " ");
                    StrainSelector.this.ivTableLabel.setOpaque(isSelected);
                    StrainSelector.this.ivTableLabel.setFont(FontManager.getFont(lastPerc ? "SSP11" : "SSB11"));
                    StrainSelector.this.ivTableLabel.setHorizontalAlignment(column == 0 ? 2 : 4);
                    StrainSelector.this.ivTableLabel.setBackground(isSelected ? (lastRow ? UIDef.OLD_BACKGROUND : UIDef.SELECTED_BACKGROUND) : null);
                    return StrainSelector.this.ivTableLabel;
                }
            });
            this.ivDetailsTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = StrainSelector.this.ivDetailsTable.rowAtPoint(e.getPoint())) != -1 && row < StrainSelector.this.ivComplPercSEL.size() - 1) {
                        StrainSelector.this.editCompl();
                    }
                }
            });
            this.ivDetailsTable.setSelectionMode(0);
            this.ivDetailsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int ind = StrainSelector.this.ivDetailsTable.getSelectedRow();
                        if (ind == -1) {
                            StrainSelector.this.ivRemComplBut.setEnabled(false);
                            StrainSelector.this.ivEditComplBut.setEnabled(false);
                        } else {
                            StrainSelector.this.ivRemComplBut.setEnabled(true);
                            StrainSelector.this.ivEditComplBut.setEnabled(ind < StrainSelector.this.ivComplNamesSEL.size() - 1);
                        }
                    }
                }
            });
            this.ivDetailsPane = new JScrollPane(this.ivDetailsTable);
            this.ivDetailsPane.setOpaque(false);
            panel.add(this.ivDetailsPane);
            this.ivRemComplBut = MGButton.getRequesterButton(Babel.get("REMOVE"));
            this.ivRemComplBut.setFont(FontManager.getFont("SSB11"));
            this.ivRemComplBut.setEnabled(false);
            this.ivRemComplBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int ind = StrainSelector.this.ivDetailsTable.getSelectedRow();
                    if (ind != -1) {
                        String name = (String)StrainSelector.this.ivComplNamesSEL.elementAt(ind);
                        Long id = (Long)StrainSelector.this.ivComplIDsSEL.elementAt(ind);
                        StrainSelector.this.ivComplNamesSEL.remove(ind);
                        StrainSelector.this.ivComplIDsSEL.remove(ind);
                        StrainSelector.this.ivComplPercSEL.remove(ind);
                        StrainSelector.this.ivComplNames.add(name);
                        StrainSelector.this.ivComplIDs.add(id);
                        StrainSelector.this.ivComplSRCList.setListData(StrainSelector.this.ivComplNames);
                        StrainSelector.this.calcPercentage();
                    }
                }
            });
            panel.add(this.ivRemComplBut);
            this.ivEditComplBut = MGButton.getRequesterButton(Babel.get("EDIT"));
            this.ivEditComplBut.setFont(FontManager.getFont("SSB11"));
            this.ivEditComplBut.setEnabled(false);
            this.ivEditComplBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StrainSelector.this.editCompl();
                }
            });
            panel.add(this.ivEditComplBut);
            this.ivTabbedPane.add((Component)panel, Babel.get("STRAIN_COMPLEX_MIXTURE"));
            this.ivDoubleField = new DoubleField(true);
            this.ivDoubleField.setPreferredSize(new Dimension(150, UIDef.FIELD_HEIGHT));
            this.ivDoubleField.setFont(FontManager.getFont("SSB11"));
        }
        this.setLabels();
        this.checkOKButtons();
        WindowUtils.bringUpCenteredDialog(this, BREITE, HOEHE, true);
    }

    private void editCompl() {
        int ind = this.ivDetailsTable.getSelectedRow();
        if (ind != -1) {
            Double newD;
            Double oldD = (Double)this.ivComplPercSEL.elementAt(ind);
            if (oldD.isNaN()) {
                this.ivDoubleField.setText("");
            } else {
                this.ivDoubleField.setDouble(oldD * 100.0);
            }
            this.ivDoubleField.setSelectionStart(0);
            this.ivDoubleField.setSelectionEnd(this.ivDoubleField.getText().length());
            if (MausoOptionPane.showOptionPane(this.ivEditComplBut, this.ivDoubleField, MausoOptionPane.MODE_OK_AND_NO, Babel.get("FS_SERV_PERCENT")) && !(newD = new Double(this.ivDoubleField.getDouble(Double.NaN))).equals(oldD)) {
                if (!newD.isNaN()) {
                    if (newD > 100.0) {
                        return;
                    }
                    this.ivComplPercSEL.setElementAt(new Double(newD / 100.0), ind);
                } else {
                    this.ivComplPercSEL.setElementAt(newD, ind);
                }
                this.calcPercentage();
            }
        }
    }

    private void calcPercentage() {
        if (!this.ivComplPercSEL.isEmpty()) {
            double sum = 0.0;
            int i = 0;
            while (i < this.ivComplPercSEL.size() - 1) {
                Double d = (Double)this.ivComplPercSEL.elementAt(i);
                if (!d.isNaN()) {
                    sum += d.doubleValue();
                }
                ++i;
            }
            Double calcVal = sum < 1.0 ? new Double(1.0 - sum) : NUESCHT;
            this.ivComplPercSEL.setElementAt(calcVal, this.ivComplPercSEL.size() - 1);
        }
        this.ivDetailsTable.tableChanged(new TableModelEvent(this.ivDetailsTable.getModel()));
        this.checkOKButtons();
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return false;
    }

    private void checkOKButtons() {
        if (this.ivOK2 != null) {
            this.ivOK2.setEnabled(this.ivCombo2a.getSelectedIndex() != this.ivCombo2b.getSelectedIndex());
        }
        if (this.ivOK3 != null) {
            boolean ok;
            boolean bl = ok = this.ivComplPercSEL != null && !this.ivComplPercSEL.isEmpty();
            if (ok) {
                Iterator iterator = this.ivComplPercSEL.iterator();
                while (iterator.hasNext()) {
                    Double d = (Double)iterator.next();
                    if (!d.isNaN()) continue;
                    ok = false;
                }
            }
            this.ivOK3.setEnabled(ok);
        }
    }

    private void setLabels() {
        if (this.ivLabel2a != null && this.ivLabel2b != null) {
            int val = this.ivSlider.getValue();
            String bruchLinks = null;
            String bruchRechts = null;
            if (val < 11) {
                this.ivRechts = Math.pow(2.0, (double)(val - 11) - 1.0);
                this.ivLinks = 1.0 - this.ivRechts;
                int nenner = (int)Math.pow(2.0, 11 - val + 1);
                bruchRechts = "1/" + nenner;
                bruchLinks = String.valueOf(nenner - 1) + "/" + nenner;
            } else {
                this.ivLinks = Math.pow(2.0, (double)(11 - val) - 1.0);
                this.ivRechts = 1.0 - this.ivLinks;
                int nenner = (int)Math.pow(2.0, val - 11 + 1);
                bruchRechts = "1/" + nenner;
                bruchLinks = String.valueOf(nenner - 1) + "/" + nenner;
            }
            this.ivLabel2a.setText(String.valueOf(NumberFormatter.STRAIN_FROMATTER.format(this.ivLinks)) + " // " + bruchLinks);
            this.ivLabel2b.setText(String.valueOf(NumberFormatter.STRAIN_FROMATTER.format(this.ivRechts)) + " // " + bruchRechts);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ivOK1) {
            this.ivRes = new IndexObject[1];
            Long idL = (Long)this.ivIDs.elementAt(this.ivCombo1.getSelectedIndex());
            this.ivRes[0] = new IndexObject(8, idL, 1.0);
            this.ivWarOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.ivOK2) {
            this.ivRes = new IndexObject[2];
            Long idL = (Long)this.ivIDs.elementAt(this.ivCombo2a.getSelectedIndex());
            this.ivRes[0] = new IndexObject(8, idL, this.ivLinks);
            idL = (Long)this.ivIDs.elementAt(this.ivCombo2b.getSelectedIndex());
            this.ivRes[1] = new IndexObject(8, idL, this.ivRechts);
            this.ivWarOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.ivOK3) {
            int anz = this.ivComplIDsSEL.size();
            this.ivRes = new IndexObject[anz];
            int i = 0;
            while (i < anz) {
                Long idL = (Long)this.ivComplIDsSEL.elementAt(i);
                Double d = (Double)this.ivComplPercSEL.elementAt(i);
                this.ivRes[i] = new IndexObject(8, idL, d);
                ++i;
            }
            this.ivWarOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.ivNO1 || e.getSource() == this.ivNO2 || e.getSource() == this.ivNO3) {
            this.setVisible(false);
        } else if (e.getSource() == this.ivNS1 || e.getSource() == this.ivNS2 || e.getSource() == this.ivNS3) {
            this.ivRes = null;
            this.ivWarOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.ivCombo2a || e.getSource() == this.ivCombo2b) {
            this.checkOKButtons();
        }
    }
}

