/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.task;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.MFLabel;
import mausoleum.gui.MGButton;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.helper.FontManager;
import mausoleum.mouse.TaskExtended;
import mausoleum.mouse.TaskWorkFlow;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.task.TaskRequester;
import mausoleum.task.standards.StandardTask;
import mausoleum.ui.UIDef;

public class WorkFlowRequester
extends BasicRequester
implements TreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final int INNER_BREITE = UIDef.getScaled(700);
    private static final int X_1 = UIDef.RAND;
    private static final int LAB_WIDTH = UIDef.getScaled(110);
    private static final int X_2 = X_1 + LAB_WIDTH + UIDef.RAND;
    private static final int FIELD_WIDTH = INNER_BREITE - LAB_WIDTH - UIDef.RAND;
    private static final int BREITE = INNER_BREITE + 2 * UIDef.RAND;
    private static final int TREE_HOEHE = UIDef.getScaled(400);
    private static final int HOEHE = UIDef.RAND + UIDef.LINE_HEIGHT + UIDef.INNER_RAND + TREE_HOEHE + UIDef.INNER_RAND + UIDef.BUT_HEIGHT + UIDef.RAND;
    private final KomfortTextField ivNameField = new KomfortTextField();
    private final JTree ivTree;
    private final MGButton ivAddButton = new MGButton(Babel.get("ADD"));
    private final MGButton ivEditButton = new MGButton(Babel.get("EDIT"));
    private final MGButton ivRemoveButton = new MGButton(Babel.get("REMOVE"));
    private final JLabel ivRootLabel = new JLabel();
    private final MFLabel ivDayLabel = new MFLabel("", FontManager.getTableFont(false, true, 1.0));
    private final MFLabel ivTimeLabel = new MFLabel("", FontManager.getTableFont(false, true, 1.0));
    private final MFLabel ivNameLabel = new MFLabel("", FontManager.getTableFont(true, true, 1.0));
    private final MausoleumTableLabel ivRenderLabel = new MausoleumTableLabel();
    private MFLabel[] ivMFLArr = new MFLabel[]{this.ivDayLabel, this.ivTimeLabel, this.ivNameLabel};
    private final TaskWorkFlow ivRoot;

    public WorkFlowRequester(JFrame sender, StandardTask model) {
        super((Frame)sender, BREITE, HOEHE);
        this.setTitle(model != null ? Babel.get("EDIT_WORKFLOW") : Babel.get("CREATE_WORKFLOW"));
        int y = UIDef.RAND;
        this.addPermanentLabel(Babel.get("NAME"), X_1, y, UIDef.LINE_HEIGHT);
        this.addAndApplyBounds(this.ivNameField, X_2, y, FIELD_WIDTH, UIDef.LINE_HEIGHT);
        y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
        if (model != null) {
            this.ivNameField.setText(model.ivDescrBabel);
            this.ivRoot = new TaskWorkFlow(Base64Manager.getDecodedString(model.ivWorkFlowDef));
        } else {
            this.ivRoot = new TaskWorkFlow(-3, "", "", 0, 0);
        }
        this.ivTree = new JTree();
        this.ivTree.setModel(new DefaultTreeModel(this.ivRoot));
        this.ivTree.setCellRenderer(this);
        this.ivTree.setRowHeight(0);
        this.addAndApplyBounds(new JScrollPane(this.ivTree), X_1, y, INNER_BREITE, TREE_HOEHE);
        y += TREE_HOEHE + UIDef.INNER_RAND;
        int anzButs = 5;
        int lbw = (INNER_BREITE - (anzButs - 1) * UIDef.INNER_RAND) / anzButs;
        int rbw = INNER_BREITE - (anzButs - 1) * (UIDef.INNER_RAND + lbw);
        int x = X_1;
        this.ivAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TaskWorkFlow twf = WorkFlowRequester.this.getSelectedTWF();
                if (twf != null) {
                    TaskRequester tr = new TaskRequester(null, 1, null, 1, UserManager.getUser().getGroup(), null);
                    if (tr.ivWarOK) {
                        TaskWorkFlow ntwf = new TaskWorkFlow(tr.getTaskProc(-1), tr.getDescription(), tr.getDetails(), 0, TaskExtended.TIME_INTS[tr.ivTimeCombo.getSelectedIndex()], tr.getPeriodEnd(Integer.MIN_VALUE), tr.getPeriodFrequency(0));
                        twf.add(ntwf);
                        DefaultTreeModel dtm = (DefaultTreeModel)WorkFlowRequester.this.ivTree.getModel();
                        dtm.nodeStructureChanged(twf);
                    }
                }
            }
        });
        this.addAndApplyBounds(this.ivAddButton, x, y, lbw, UIDef.BUT_HEIGHT);
        this.ivEditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TaskWorkFlow twf = WorkFlowRequester.this.getSelectedTWF();
                if (twf != null && twf != WorkFlowRequester.this.ivRoot) {
                    TaskRequester tr = new TaskRequester(null, 1, null, 1, UserManager.getUser().getGroup(), twf);
                    if (tr.ivWarOK) {
                        twf.ivStandardTaskID = tr.getTaskProc(-1);
                        twf.ivDescription = tr.getDescription();
                        twf.ivDetails = tr.getDetails();
                        twf.ivDayOffset = 0;
                        twf.ivTime = TaskExtended.TIME_INTS[tr.ivTimeCombo.getSelectedIndex()];
                        twf.ivDayOffsetEnd = tr.getPeriodEnd(Integer.MIN_VALUE);
                        twf.ivFrequency = tr.getPeriodFrequency(0);
                        DefaultTreeModel dtm = (DefaultTreeModel)WorkFlowRequester.this.ivTree.getModel();
                        dtm.nodeStructureChanged(twf);
                    }
                }
            }
        });
        this.addAndApplyBounds(this.ivEditButton, x += lbw + UIDef.INNER_RAND, y, lbw, UIDef.BUT_HEIGHT);
        this.ivRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TaskWorkFlow twf = WorkFlowRequester.this.getSelectedTWF();
                if (twf != null && twf != WorkFlowRequester.this.ivRoot && twf.ivSuperNode != null) {
                    twf.ivSuperNode.remove(twf);
                    DefaultTreeModel dtm = (DefaultTreeModel)WorkFlowRequester.this.ivTree.getModel();
                    dtm.nodeStructureChanged(twf);
                }
            }
        });
        this.addAndApplyBounds(this.ivRemoveButton, x += lbw + UIDef.INNER_RAND, y, lbw, UIDef.BUT_HEIGHT);
        this.addAndApplyBounds(this.ivOkButton, x += lbw + UIDef.INNER_RAND, y, lbw, UIDef.BUT_HEIGHT);
        this.addAndApplyBounds(this.ivNoButton, x += lbw + UIDef.INNER_RAND, y, rbw, UIDef.BUT_HEIGHT);
        this.ivRenderLabel.setMultiFontStrings(this.ivMFLArr, true);
    }

    public boolean okAndNoWanted() {
        return true;
    }

    private void checkButs() {
    }

    private TaskWorkFlow getSelectedTWF() {
        TreePath tp = this.ivTree.getSelectionPath();
        if (tp != null) {
            return (TaskWorkFlow)tp.getLastPathComponent();
        }
        return null;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TaskWorkFlow twf = (TaskWorkFlow)value;
        this.ivNameLabel.ivBackground = null;
        if (twf.ivStandardTaskID == -3) {
            this.ivRootLabel.setText("ROOT");
            this.ivRootLabel.setOpaque(selected);
            this.ivRootLabel.setBackground(selected ? UIDef.SELECTED_BACKGROUND : null);
            return this.ivRootLabel;
        }
        StringBuilder msb = new StringBuilder(" ");
        if (twf.ivStandardTaskID == -1) {
            msb.append(twf.ivDescription);
        } else {
            StandardTask st = StandardTask.findTask(UserManager.getUser().getGroup(), twf.ivStandardTaskID);
            if (st != null) {
                msb.append(st.getDescription(true));
                Color bg = st.ivTriangleColor;
                this.ivNameLabel.ivBackground = bg != null ? bg : (selected ? UIDef.SELECTED_BACKGROUND : Color.white);
            } else {
                msb.append("???");
                Color color = this.ivNameLabel.ivBackground = selected ? UIDef.SELECTED_BACKGROUND : Color.white;
            }
        }
        if (twf.ivDetails != null) {
            msb.append(" : ").append(twf.ivDetails);
        }
        msb.append(" ");
        this.ivNameLabel.ivString = msb.toString();
        this.ivDayLabel.ivString = "Day offset: " + twf.ivDayOffset;
        String time = StringHelper.getStringForInt(twf.ivTime, TaskExtended.TIME_INTS, TaskExtended.TIME_STRINGS_SHORT, true, "");
        this.ivTimeLabel.ivString = " " + time + " ";
        this.ivDayLabel.ivBackground = selected ? UIDef.SELECTED_BACKGROUND : Color.white;
        this.ivTimeLabel.ivBackground = selected ? UIDef.SELECTED_BACKGROUND : Color.white;
        this.ivRenderLabel.setMultiFontStrings(this.ivMFLArr, true);
        return this.ivRenderLabel;
    }
}

