/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.result;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.experiment.Experiment;
import mausoleum.inspector.Inspector;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.result.GPSCoordinates;
import mausoleum.result.ResultObjectImage;

public class MResult
implements Serializable {
    public static final long serialVersionUID = -9083185963290878852L;
    public static final int THUMB_SIZE = 70;
    public static final int MAX_IMAGE_SIZE = 1024;
    public static final long EXTRA_EXP_ID_HEALTHREPORT = -42L;
    public static final long EXTRA_EXP_ID_TIERSCHUTZREPORT_WURF = -43L;
    public static final long EXTRA_EXP_ID_TIERSCHUTZREPORT_ABSETZEN = -44L;
    public static final long EXTRA_EXP_ID_TIERSCHUTZREPORT_EINZELTIER = -45L;
    public static final long EXTRA_EXP_ID_EMBRYO_TRANSFER = -46L;
    public static final int TYPE_HEALTHREPORT_CECAD = 1001;
    public static final int TYPE_EMBRYO_TRANSFER_D1 = 3001;
    public static final int TYPE_TS_LINE_BEURTEILUNG_NEUER_WURF = 2001;
    public static final int TYPE_TS_LINE_BEURTEILUNG_ABSETZEN = 2002;
    public static final int TYPE_TS_LINE_BEURTEILUNG_EINZELTIER = 2003;
    public static final long[] NON_STANDARD_EXP_IDS = new long[]{-42L, -43L, -44L, -45L, -46L};
    public static final int[] HEALTH_REPORT_TYPES = new int[]{1001};
    private static final DecimalFormat DEC_FORMAT = new DecimalFormat("##############0.##");
    public long ivPseudoID = 0L;
    public long ivExpID = 0L;
    public int ivResTyp = 0;
    public int ivDate = Integer.MIN_VALUE;
    public String ivPerformer = "";
    public Object ivResult = null;

    public static boolean isRegularResult(MResult result) {
        return ArrayHelper.findLongInArray(result.ivExpID, NON_STANDARD_EXP_IDS) == -1;
    }

    public static boolean isMultiInputAllowed(long expID) {
        if (expID == -42L) {
            return true;
        }
        if (expID == -44L || expID == -45L || expID == -43L) {
            return TierSchutz.isMultiInputAllowed(expID);
        }
        return true;
    }

    public static int getSymptomListType(Mouse mouse) {
        Vector v2;
        int res = 1;
        if (mouse != null && (v2 = (Vector)mouse.get("MOS_MRESULTS")) != null) {
            int latest = Integer.MIN_VALUE;
            Iterator iterator = v2.iterator();
            while (iterator.hasNext()) {
                MResult mres = (MResult)iterator.next();
                if (mres.getExperimentID() != -42L || mres.ivDate == Integer.MIN_VALUE || mres.ivDate <= latest) continue;
                latest = mres.ivDate;
                String s = (String)mres.ivResult;
                res = 3;
                int i = 0;
                while (i < s.length() && res == 3) {
                    if (s.charAt(i) != '|') {
                        res = 2;
                    }
                    ++i;
                }
            }
        }
        return res;
    }

    public MResult() {
    }

    public MResult(long expID) {
        this.ivExpID = expID;
    }

    public MResult(MResult model, int date, String performer) {
        this.ivPseudoID = model.ivPseudoID;
        this.ivExpID = model.ivExpID;
        this.ivResTyp = model.ivResTyp;
        this.ivDate = date;
        this.ivPerformer = performer;
        this.ivResult = model.ivResult;
    }

    public long getExperimentID() {
        return this.ivExpID;
    }

    public Experiment getExperiment(String mouseGroup) {
        String group = this.ivExpID <= 5000L ? mouseGroup : "service";
        return (Experiment)ObjectStore.getObjectDeadOrAlive(12, this.ivExpID, group, null, false);
    }

    public Object getRepresentation(boolean stringOnly, String group) {
        switch (this.ivResTyp) {
            case 1: {
                Boolean b = (Boolean)this.ivResult;
                if (b.booleanValue()) {
                    return Babel.get("TRUE");
                }
                return Babel.get("FALSE");
            }
            case 2: {
                Integer inti = (Integer)this.ivResult;
                return Integer.toString(inti);
            }
            case 3: {
                Double doubli = (Double)this.ivResult;
                return DEC_FORMAT.format(doubli);
            }
            case 4: 
            case 5: {
                return this.ivResult;
            }
            case 7: {
                GPSCoordinates gpsCoor = (GPSCoordinates)this.ivResult;
                return gpsCoor.getTableString();
            }
            case 6: {
                if (stringOnly) {
                    return "Image";
                }
                try {
                    ResultObjectImage roi = (ResultObjectImage)this.ivResult;
                    if (roi.ivImage == null) {
                        roi.ivImage = Inspector.getInspector().createImage(new MemoryImageSource(roi.ivThumbDim.width, roi.ivThumbDim.height, roi.ivThumbData, 0, roi.ivThumbDim.width));
                    }
                    return roi.ivImage;
                }
                catch (Exception e) {
                    return "Image";
                }
            }
        }
        return "";
    }

    public String getUnit(String group) {
        String unit = null;
        Experiment exp = this.getExperiment(group);
        if (exp != null) {
            switch (exp.getInt("EXP_TYPE")) {
                case 2: 
                case 3: {
                    unit = exp.getString("EXP_UNIT");
                    break;
                }
            }
        }
        return unit != null ? unit : "";
    }

    public boolean searchMatch(Object testObj, int type) {
        if (testObj != null && type != -1) {
            if (type == 1) {
                return testObj.equals(this.ivResult);
            }
            if (type == 2) {
                if (testObj instanceof int[]) {
                    int[] arr = (int[])testObj;
                    Integer ival = (Integer)this.ivResult;
                    if (ival != null) {
                        int iival = ival;
                        return iival >= arr[0] && iival <= arr[1];
                    }
                } else if (testObj instanceof Integer) {
                    return testObj.equals(this.ivResult);
                }
            } else if (type == 3) {
                if (testObj instanceof double[]) {
                    double[] arr = (double[])testObj;
                    Double dval = (Double)this.ivResult;
                    if (dval != null) {
                        double ddval = dval;
                        return ddval >= arr[0] && ddval <= arr[1];
                    }
                } else if (testObj instanceof Double) {
                    return testObj.equals(this.ivResult);
                }
            } else {
                if (type == 4) {
                    return testObj.equals(this.ivResult);
                }
                if (type == 5) {
                    String s = (String)this.ivResult;
                    return s != null ? s.toLowerCase().contains((String)testObj) : false;
                }
                if (type == 8) {
                    return true;
                }
            }
        }
        return false;
    }
}

