/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.result;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import mausoleum.helper.Zeile;
import mausoleum.result.SpecResultComboItem;

public abstract class SpecialResult
implements ActionListener {
    public final long ivExperimentID;
    public final int ivResultTyp;
    protected final int ivAnzCols;
    public final TreeMap ivInputComponentsByColKey = new TreeMap();
    public final HashMap ivInputCountComponentsByColKey = new HashMap();
    protected final HashSet ivActiveCols = new HashSet();
    protected final HashSet ivVisibleCols = new HashSet();
    protected final HashMap ivTypeByCol = new HashMap();
    protected final HashMap ivBabelByCol = new HashMap();
    public final HashSet ivColKeysToClearForEachMouse = new HashSet();
    protected final HashMap ivComboItemsByCol = new HashMap();
    protected final HashMap ivExtraBabelsByCol = new HashMap();
    public final HashSet ivColKeysWithMouseCount = new HashSet();
    public final HashMap ivMetaData = new HashMap();

    public SpecialResult(int anzCols, long experimentID, int resultTyp) {
        this.ivAnzCols = anzCols;
        this.ivExperimentID = experimentID;
        this.ivResultTyp = resultTyp;
        this.addLines();
    }

    public abstract void addLines();

    public abstract String getTitelBabel();

    public abstract HashMap getPresetValues(Vector var1);

    public abstract Vector getPresetValuesForEachMouse(Vector var1);

    public abstract boolean wantsPerformerEditable();

    public HashMap getMetaHash(Zeile z) {
        return null;
    }

    public String getTabRepresentation(int colKey, String group, HashMap metaHash) {
        return "";
    }

    public boolean isColForMetaHash(int colKey) {
        return false;
    }

    public void panelWasPrepared() {
    }

    public void dialogIsShown() {
    }

    public void componentsWereCleared() {
    }

    protected void addElement(int col, Integer type, String babel, boolean active, boolean visible, SpecResultComboItem[] comboItems, String extraBabel) {
        Integer key = new Integer(col);
        this.ivTypeByCol.put(key, type);
        this.ivBabelByCol.put(key, babel);
        if (active) {
            this.ivActiveCols.add(key);
        }
        if (visible) {
            this.ivVisibleCols.add(key);
        }
        if (comboItems != null) {
            this.ivComboItemsByCol.put(key, comboItems);
        }
        if (extraBabel != null) {
            this.ivExtraBabelsByCol.put(key, extraBabel);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String ac = e.getActionCommand();
        if (ac != null && ac.startsWith("_CNT_")) {
            this.countComboSelected((JComboBox)e.getSource());
        }
    }

    public void countComboSelected(JComboBox cntCombo) {
        String ac = cntCombo.getActionCommand();
        Object ooo = this.ivInputComponentsByColKey.get(new Integer(ac.substring("_CNT_".length(), ac.length())));
        if (ooo != null && ooo instanceof JComponent) {
            JComponent jc = (JComponent)ooo;
            jc.setVisible(cntCombo.getSelectedIndex() != 0);
        }
    }

    public Vector rearrangeVisibleRows(Vector keys) {
        return keys;
    }
}

