/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.result.embryotransfer;

import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import mausoleum.gui.DatumField;
import mausoleum.gui.FlexGridLayout;
import mausoleum.gui.IntegerField;
import mausoleum.gui.MGButton;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.sensitives.CSStrain;
import mausoleum.line.Line;
import mausoleum.line.LineManager;
import mausoleum.mouse.Mouse;
import mausoleum.requester.SelectIDObjectRequester;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.result.embryotransfer.EnterResultPanelForDefinedExperiment;
import mausoleum.result.embryotransfer.MResEmbryoTransfer;
import mausoleum.ui.UIDef;

public class EnterEmbryoTransferPanel
extends EnterResultPanelForDefinedExperiment {
    private static final long serialVersionUID = 0xAB6BBAL;
    private static final HashMap SEL_LINES_BY_GROUP = new HashMap();
    private static final HashMap SEL_STRAINS_BY_GROUP = new HashMap();
    private static int cvTransferTypeIndex = -1;
    private static int cvEmbryoStageIndex = -1;
    private static int cvDate = Integer.MIN_VALUE;
    private final String ivGroup;
    private final JComboBox ivLinesCombo;
    private final Vector ivLines;
    private final JTextField ivStrainTextField = new JTextField();
    private IndexObject[] ivStrainArray = null;
    private final JComboBox ivTransferTypeCombo = new JComboBox<String>(Babel.get(MResEmbryoTransfer.TYPE_BABELS, true));
    private final JComboBox ivEmbryoStageCombo = new JComboBox<String>(Babel.get(MResEmbryoTransfer.STAGE_BABELS, true));
    private final IntegerField ivNumTransferredField = new IntegerField(true);
    private final DatumField ivPlugDateField = new DatumField();

    public EnterEmbryoTransferPanel(Mouse mouse, MResEmbryoTransfer editObject) {
        super(new FlexGridLayout(6, 2, UIDef.INNER_RAND, UIDef.INNER_RAND, true, false, false, true));
        this.ivGroup = mouse.getGroup();
        this.ivLines = LineManager.cvInstance.getActualObjectVector(this.ivGroup, true, true);
        int siz = this.ivLines.size() + 1;
        int indToSelect = -1;
        String[] arr = new String[siz];
        arr[0] = Babel.get("");
        int i = 0;
        while (i < this.ivLines.size()) {
            Line line = (Line)this.ivLines.elementAt(i);
            if (editObject != null && line.getID() == editObject.ivLineID) {
                indToSelect = i + 1;
            }
            arr[i + 1] = line.getBrowseNameInclServicePrefixAndEarTagPrefix();
            ++i;
        }
        MGButton but = new MGButton(" ... ");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int ind;
                Line selLine = SelectIDObjectRequester.getSelectedLine(Inspector.getInspector(), EnterEmbryoTransferPanel.this.ivLines, false);
                if (selLine != null && (ind = EnterEmbryoTransferPanel.this.ivLines.indexOf(selLine)) != -1) {
                    EnterEmbryoTransferPanel.this.ivLinesCombo.setSelectedIndex(ind + 1);
                }
            }
        });
        this.ivLinesCombo = new JComboBox<String>(arr);
        if (indToSelect != -1) {
            this.ivLinesCombo.setSelectedIndex(indToSelect);
        }
        this.ivLinesCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                EnterEmbryoTransferPanel.this.selChanged();
            }
        });
        JPanel p = new JPanel(new BorderLayout());
        p.add("Center", this.ivLinesCombo);
        p.add("East", but);
        this.add(new JLabel(Babel.get("MR_ET_LINE")));
        this.add(p);
        this.ivStrainTextField.setEnabled(false);
        this.ivStrainTextField.setBorder(new LineBorder(Color.black));
        this.ivStrainTextField.setFont(FontManager.getFont("SSB11"));
        this.ivStrainTextField.setOpaque(false);
        but = new MGButton(" ... ");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexObject[] res = CSStrain.selectStrain(EnterEmbryoTransferPanel.this.ivGroup);
                if (res == null || res.length != 0) {
                    EnterEmbryoTransferPanel.this.ivStrainArray = res;
                    String display = "";
                    if (EnterEmbryoTransferPanel.this.ivStrainArray != null) {
                        display = IndexObject.getDisplayString(EnterEmbryoTransferPanel.this.ivStrainArray, EnterEmbryoTransferPanel.this.ivGroup, 8, false, false, true);
                    }
                    EnterEmbryoTransferPanel.this.ivStrainTextField.setText(display);
                    EnterEmbryoTransferPanel.this.selChanged();
                }
            }
        });
        if (editObject != null) {
            this.ivStrainArray = editObject.ivStrains;
            String display = "";
            if (this.ivStrainArray != null) {
                display = IndexObject.getDisplayString(this.ivStrainArray, this.ivGroup, 8, false, false, true);
            }
            this.ivStrainTextField.setText(display);
        }
        p = new JPanel(new BorderLayout());
        p.add("Center", this.ivStrainTextField);
        p.add("East", but);
        this.add(new JLabel(Babel.get("MR_ET_STRAIN")));
        this.add(p);
        this.add(new JLabel(Babel.get("MR_ET_TRANSFER_TYPE")));
        if (editObject != null && (indToSelect = ArrayHelper.findIndexInArray(editObject.ivTransferType, MResEmbryoTransfer.TYPE_INTS)) != -1) {
            this.ivTransferTypeCombo.setSelectedIndex(indToSelect);
        }
        this.add(this.ivTransferTypeCombo);
        this.add(new JLabel(Babel.get("MR_ET_NUM_TRANSFERRED")));
        if (editObject != null) {
            this.ivNumTransferredField.setInt(editObject.ivNumTransferred);
        }
        this.add(this.ivNumTransferredField);
        this.add(new JLabel(Babel.get("MR_ET_EMBRYO_STAGE")));
        if (editObject != null && (indToSelect = ArrayHelper.findIndexInArray(editObject.ivEmbryoStage, MResEmbryoTransfer.STAGE_INTS)) != -1) {
            this.ivEmbryoStageCombo.setSelectedIndex(indToSelect);
        }
        this.add(this.ivEmbryoStageCombo);
        but = new MGButton(" ... ");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Date date = CalendarRequester.getDate(null, null, new MyDate(new GregorianCalendar()));
                if (date != null) {
                    EnterEmbryoTransferPanel.this.ivPlugDateField.setDatum((int)(date.getTime() / 86400000L));
                }
            }
        });
        if (editObject != null) {
            if (editObject.ivPlugDayAtTransfer != Integer.MIN_VALUE && editObject.ivPlugDayAtTransfer != -1) {
                this.ivPlugDateField.setDatum(editObject.ivPlugDayAtTransfer);
            }
        } else {
            Date plugDate = mouse.getDate("MOS_PLUGDATE");
            if (plugDate != null) {
                this.ivPlugDateField.setDatum((int)(plugDate.getTime() / 86400000L));
            }
        }
        this.ivPlugDateField.setBorder(new LineBorder(Color.black));
        this.ivPlugDateField.setFont(FontManager.getFont("SSB11"));
        this.ivPlugDateField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                EnterEmbryoTransferPanel.this.ivPlugDateField.setDatum(EnterEmbryoTransferPanel.this.ivPlugDateField.getDatum(Integer.MIN_VALUE));
            }
        });
        p = new JPanel(new BorderLayout());
        p.add("Center", this.ivPlugDateField);
        p.add("East", but);
        this.add(new JLabel(Babel.get("MR_ET_PLUG_DAY")));
        this.add(p);
        if (editObject != null) {
            this.selChanged();
        } else {
            IndexObject[] strainArr;
            int ind;
            Line prevSelLine;
            if (cvTransferTypeIndex != -1) {
                this.ivTransferTypeCombo.setSelectedIndex(cvTransferTypeIndex);
            }
            if (cvEmbryoStageIndex != -1) {
                this.ivEmbryoStageCombo.setSelectedIndex(cvEmbryoStageIndex);
            }
            if ((prevSelLine = (Line)SEL_LINES_BY_GROUP.get(this.ivGroup)) != null && (ind = this.ivLines.indexOf(prevSelLine)) != -1) {
                this.ivLinesCombo.setSelectedIndex(ind + 1);
            }
            if ((strainArr = (IndexObject[])SEL_STRAINS_BY_GROUP.get(this.ivGroup)) != null) {
                this.ivStrainArray = strainArr;
                this.ivStrainTextField.setText(IndexObject.getDisplayString(this.ivStrainArray, this.ivGroup, 8, false, false, true));
            }
        }
    }

    public int getPreferedDate() {
        return cvDate;
    }

    private void selChanged() {
        if (this.ivActionListener != null) {
            this.ivActionListener.actionPerformed(new ActionEvent(this, 0, "SEL"));
        }
    }

    public void addAdditionalCommand(Mouse mouse, StringBuffer msb, int date) {
    }

    public boolean isOkAllowed() {
        return this.ivLinesCombo.getSelectedIndex() != 0 && this.ivStrainArray != null;
    }

    public Object getResult(int transferDate) {
        this.storeForLaterReuse(transferDate);
        return new MResEmbryoTransfer((Line)this.ivLines.elementAt(this.ivLinesCombo.getSelectedIndex() - 1), this.ivStrainArray, MResEmbryoTransfer.TYPE_INTS[this.ivTransferTypeCombo.getSelectedIndex()], this.ivNumTransferredField.getInt(0), MResEmbryoTransfer.STAGE_INTS[this.ivEmbryoStageCombo.getSelectedIndex()], null, -1L, this.ivPlugDateField.getDatum(Integer.MIN_VALUE), transferDate).getInitString();
    }

    public void storeForLaterReuse(int transferDate) {
        cvTransferTypeIndex = this.ivTransferTypeCombo.getSelectedIndex();
        cvEmbryoStageIndex = this.ivEmbryoStageCombo.getSelectedIndex();
        cvDate = transferDate;
        SEL_LINES_BY_GROUP.put(this.ivGroup, (Line)this.ivLines.elementAt(this.ivLinesCombo.getSelectedIndex() - 1));
        SEL_STRAINS_BY_GROUP.put(this.ivGroup, this.ivStrainArray);
    }
}

