/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.result.rackhealthreport;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import mausoleum.alert.Alert;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.definitionlists.Microorganism;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.OpenStandardFiles;
import mausoleum.helper.Zeile;
import mausoleum.main.ProcessDefinition;
import mausoleum.rack.Rack;
import mausoleum.rack.RackManager;
import mausoleum.result.rackhealthreport.RResWrapper;
import mausoleum.room.Room;

public class RResHealthReport {
    public static final int ACTION_ADD = 1;
    public static final int ACTION_REMOVE = 2;
    public static final int ACTION_CHANGE = 3;
    private static final String FILEPATH = String.valueOf(GroupFileManager.getResultsPath("service")) + "/rackresults.stxt";
    private static final HashMap RESULTS_BY_RACK = new HashMap();
    public long ivPseudoID = 0L;
    public long ivRackID = 0L;
    public int ivDate = Integer.MIN_VALUE;
    public String ivPerformer = "";
    public int ivNumChecked = -1;
    public MicroRes[] ivMicroResults = null;
    public String ivDetails = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void init() {
        if (ProcessDefinition.isClient()) {
            String s;
            RESULTS_BY_RACK.clear();
            if (Privileges.hasPrivilege("RCK_VIEW_HEALTHREPORT") && (s = FileManager.getStringContentFromServer(FILEPATH)) != null && s.length() != 0) {
                try {
                    BufferedReader br = new BufferedReader(new StringReader(s));
                    String line = br.readLine();
                    while (line != null) {
                        if (line.length() != 0) {
                            RResHealthReport rres = new RResHealthReport(line);
                            Long key = new Long(rres.ivRackID);
                            Vector<RResHealthReport> v = (Vector<RResHealthReport>)RESULTS_BY_RACK.get(key);
                            if (v == null) {
                                v = new Vector<RResHealthReport>();
                                RESULTS_BY_RACK.put(key, v);
                            }
                            v.add(rres);
                        }
                        line = br.readLine();
                    }
                    br.close();
                }
                catch (Exception e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.result.rackhealthreport.RResHealthReport");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Problem reading Rack Results", e, clazz);
                }
            }
        }
    }

    public static synchronized boolean performRackResAction(int action, long healthReportID, String initString) {
        if (ProcessDefinition.isServer()) {
            switch (action) {
                case 1: {
                    return RResHealthReport.appendRackHealthReport(initString);
                }
                case 2: {
                    return RResHealthReport.removeRackHealthReport(healthReportID);
                }
                case 3: {
                    boolean res = RResHealthReport.removeRackHealthReport(healthReportID);
                    return res ? RResHealthReport.appendRackHealthReport(initString) : false;
                }
            }
            return false;
        }
        return false;
    }

    public static void addHealthReportWrappers(Vector racks, Vector target) {
        RResHealthReport.addHealthReportWrappers(racks, target, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static void addHealthReportWrappers(Vector racks, Vector target, int minDate, int maxDate) {
        target.clear();
        Iterator iterator = racks.iterator();
        while (iterator.hasNext()) {
            Vector v;
            Rack rack = (Rack)iterator.next();
            if (!rack.isServiceGroupObject() || (v = (Vector)RESULTS_BY_RACK.get(rack.getLongID())) == null) continue;
            Iterator iterator2 = v.iterator();
            while (iterator2.hasNext()) {
                RResHealthReport rres = (RResHealthReport)iterator2.next();
                if (minDate != Integer.MIN_VALUE && minDate > rres.ivDate || maxDate != Integer.MIN_VALUE && maxDate < rres.ivDate) continue;
                target.add(new RResWrapper(rack, rres));
            }
        }
    }

    public static void makeReport(Room room, Vector iracks, int minDate, int maxDate) {
        Vector racks = new Vector();
        if (iracks != null) {
            racks.addAll(iracks);
        }
        if (room != null) {
            racks.addAll(RackManager.getRacksInRoom(room.getID()));
        }
        if (!racks.isEmpty()) {
            Vector wrappers = new Vector();
            RResHealthReport.addHealthReportWrappers(racks, wrappers, minDate, maxDate);
            if (!wrappers.isEmpty()) {
                TreeMap<Integer, Vector<RResWrapper>> reportSammlerByDate = new TreeMap<Integer, Vector<RResWrapper>>();
                TreeSet sortedMicroInfos = new TreeSet();
                Iterator iterator = wrappers.iterator();
                while (iterator.hasNext()) {
                    RResWrapper wrapper = (RResWrapper)iterator.next();
                    Integer key = new Integer(wrapper.ivHealthReport.ivDate);
                    Vector<RResWrapper> v = (Vector<RResWrapper>)reportSammlerByDate.get(key);
                    if (v == null) {
                        v = new Vector<RResWrapper>();
                        reportSammlerByDate.put(key, v);
                    }
                    v.add(wrapper);
                    MicroSortable.fillSortables(wrapper, sortedMicroInfos);
                }
                String repDir = "temp";
                FileManager.prepareDirs(repDir);
                String filePath = String.valueOf(repDir) + "/RackHealthReport_" + new MyDate(new GregorianCalendar()).getDateTimeForFileName() + "_" + MilliSpender.getMillis() + ".xls";
                try {
                    WritableWorkbook workbook = Workbook.createWorkbook(new File(filePath));
                    WritableSheet sheet = workbook.createSheet(Babel.get("RACK_HEALTH_REPORTS"), 0);
                    int row = 1;
                    sheet.addCell(new Label(2, row++, Babel.get("PERFORMEDBY")));
                    sheet.addCell(new Label(2, row++, Babel.get("ARHR_COUNT_CHECKED_MICE")));
                    Iterator iterator2 = sortedMicroInfos.iterator();
                    while (iterator2.hasNext()) {
                        MicroSortable ms = (MicroSortable)iterator2.next();
                        sheet.addCell(new Label(0, row, ms.ivKeimTypInfo));
                        sheet.addCell(new Label(1, row, ms.ivFELASA ? "[F]" : ""));
                        sheet.addCell(new Label(2, row, ms.ivMicroInfo));
                        ++row;
                    }
                    int col = 3;
                    int anzChecked = 0;
                    int anzFound = 0;
                    TreeSet<String> resNames = new TreeSet<String>();
                    StringBuilder msb = new StringBuilder();
                    StringBuilder detailsSb = new StringBuilder();
                    Vector<String> detailsVector = new Vector<String>();
                    Iterator iterator3 = reportSammlerByDate.keySet().iterator();
                    while (iterator3.hasNext()) {
                        Integer dateI = (Integer)iterator3.next();
                        row = 0;
                        sheet.addCell(new Label(col, row++, DatumFormat.getJustDateString(dateI)));
                        Vector sammler = (Vector)reportSammlerByDate.get(dateI);
                        anzChecked = 0;
                        anzFound = 0;
                        resNames.clear();
                        msb.setLength(0);
                        detailsVector.clear();
                        Iterator iterator22 = sammler.iterator();
                        while (iterator22.hasNext()) {
                            RResWrapper wrapper = (RResWrapper)iterator22.next();
                            anzChecked += wrapper.ivHealthReport.ivNumChecked;
                            resNames.add(wrapper.ivHealthReport.ivPerformer);
                            String details = wrapper.ivHealthReport.ivDetails;
                            if (details == null || details.trim().length() == 0) continue;
                            detailsSb.setLength(0);
                            if (racks.size() > 1) {
                                Rack rack = (Rack)ObjectStore.getObjectDeadOrAlive(3, wrapper.ivRackID, "service", null, false);
                                detailsSb.append(Babel.get("RACK")).append(" ").append(rack != null ? rack.getBrowseNameWITHOUTServicePrefix() : "?").append(": ");
                            }
                            detailsSb.append(details);
                            detailsVector.add(detailsSb.toString());
                        }
                        iterator22 = resNames.iterator();
                        while (iterator22.hasNext()) {
                            String s = (String)iterator22.next();
                            if (msb.length() != 0) {
                                msb.append(", ");
                            }
                            msb.append(s);
                        }
                        sheet.addCell(new Label(col, row++, msb.toString()));
                        sheet.addCell(new Number(col, row++, (double)anzChecked));
                        iterator22 = sortedMicroInfos.iterator();
                        while (iterator22.hasNext()) {
                            MicroSortable ms = (MicroSortable)iterator22.next();
                            anzFound = -1;
                            Iterator iterator32 = sammler.iterator();
                            while (iterator32.hasNext()) {
                                RResWrapper wrapper = (RResWrapper)iterator32.next();
                                MicroRes[] keimResultate = wrapper.ivHealthReport.ivMicroResults;
                                int i = 0;
                                while (i < keimResultate.length) {
                                    if (keimResultate[i].ivMicroOrganismID == ms.ivMicroOrganismID && keimResultate[i].ivCheckMethodID == ms.ivCheckMethodID) {
                                        anzFound = anzFound == -1 ? keimResultate[i].ivFound : (anzFound += keimResultate[i].ivFound);
                                    }
                                    ++i;
                                }
                            }
                            if (anzFound != -1) {
                                sheet.addCell(new Number(col, row, (double)anzFound));
                            }
                            ++row;
                        }
                        if (!detailsVector.isEmpty()) {
                            iterator22 = detailsVector.iterator();
                            while (iterator22.hasNext()) {
                                sheet.addCell(new Label(col, row++, (String)iterator22.next()));
                            }
                        }
                        ++col;
                    }
                    workbook.write();
                    workbook.close();
                    OpenStandardFiles.openStandardFile(filePath);
                    return;
                }
                catch (Exception e) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("mausoleum.mouse.tierschutz.TierSchutzReportD2");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Problem writing TierschutzReportD2", e, clazz);
                }
            }
        }
        Alert.showAlert(Babel.get("NO_DATA_AVAILABLE"), true);
    }

    private static boolean appendRackHealthReport(String initString) {
        FileManager.pureAppend(FILEPATH, String.valueOf(initString) + "\n");
        return true;
    }

    private static boolean removeRackHealthReport(long healthReportID) {
        String filePath = FILEPATH;
        try {
            String prefix = String.valueOf(healthReportID) + "|";
            StringBuilder msb = new StringBuilder();
            BufferedReader br = new BufferedReader(new FileReader(filePath));
            String line = br.readLine();
            while (line != null) {
                if (!line.startsWith(prefix)) {
                    msb.append(line).append("\n");
                }
                line = br.readLine();
            }
            br.close();
            FileManager.saveStringToFile(filePath, msb.toString());
            return true;
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.result.rackhealthreport.RResHealthReport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Could not remove rackHealthReport", e, clazz);
            return false;
        }
    }

    public RResHealthReport() {
        this.ivPseudoID = MilliSpender.getMillis();
    }

    public RResHealthReport(int numChecked, MicroRes[] microResults) {
        this.ivPseudoID = MilliSpender.getMillis();
        this.ivNumChecked = numChecked;
        this.ivMicroResults = microResults;
    }

    public RResHealthReport(String initString) {
        Zeile z = new Zeile(initString, '|');
        int col = 0;
        this.ivPseudoID = z.getLong(col++, -1L);
        this.ivRackID = z.getLong(col++, -1L);
        this.ivDate = z.getInt(col++, Integer.MIN_VALUE);
        this.ivPerformer = z.getStringB64(col++, "");
        this.ivNumChecked = z.getInt(col++, -1);
        Zeile z2 = new Zeile(z.getString(col++, ""), MicroRes.TRENNER);
        this.ivMicroResults = new MicroRes[z2.size()];
        int i = 0;
        while (i < this.ivMicroResults.length) {
            this.ivMicroResults[i] = new MicroRes(z2.getString(i, null));
            ++i;
        }
        this.ivDetails = z.getStringB64(col++, null);
    }

    public Object[] getTableRepresentation(String group, String lang, int[] itemsPerLine) {
        Vector sammler = new Vector();
        int i = 0;
        while (i < this.ivMicroResults.length) {
            if (i == 0 && itemsPerLine != null) {
                itemsPerLine[0] = this.ivMicroResults[i].getTableRepItemsPerLine();
            }
            this.ivMicroResults[i].addTableRep(sammler, this.ivNumChecked);
            ++i;
        }
        Object[] res = new Object[sammler.size()];
        int i2 = 0;
        Iterator iterator = sammler.iterator();
        while (iterator.hasNext()) {
            res[i2++] = iterator.next();
        }
        sammler.clear();
        sammler = null;
        return res;
    }

    public String getInitString() {
        StringBuilder msb = new StringBuilder();
        RResHealthReport.fillReqInitString(msb, this.ivPseudoID, this.ivRackID, this.ivDate, this.ivPerformer, this.ivNumChecked);
        int i = 0;
        while (i < this.ivMicroResults.length) {
            if (i != 0) {
                msb.append(MicroRes.TRENNER);
            }
            msb.append(this.ivMicroResults[i]);
            ++i;
        }
        msb.append("|");
        msb.append(this.ivDetails != null ? Base64Manager.encodeBase64(this.ivDetails) : "");
        msb.append("|");
        return msb.toString();
    }

    public static void fillReqInitString(StringBuilder msb, long pseudoID, long rackID, int date, String performer, int numChecked) {
        msb.append(pseudoID).append("|");
        msb.append(rackID).append("|");
        msb.append(date).append("|");
        msb.append(Base64Manager.encodeBase64(performer)).append("|");
        msb.append(numChecked).append("|");
    }

    public static class MicroRes {
        public static char TRENNER = (char)35;
        public int ivMicroOrganismID = -1;
        public int ivCheckMethodID = -1;
        public int ivFound = -1;

        public static void fillInitString(int moID, int methID, int anz, StringBuilder msb) {
            msb.append(moID).append(",");
            msb.append(methID).append(",");
            msb.append(anz);
        }

        public MicroRes(int microOrgID, int checkMethodID, int numFound) {
            this.ivMicroOrganismID = microOrgID;
            this.ivCheckMethodID = checkMethodID;
            this.ivFound = numFound;
        }

        public MicroRes(String initString) {
            Zeile z = new Zeile(initString, ',');
            this.ivMicroOrganismID = z.getInt(0, -1);
            this.ivCheckMethodID = z.getInt(1, -1);
            this.ivFound = z.getInt(2, -1);
        }

        public void addTableRep(Vector sammler, int checked) {
            String micro = ListDefinition.getToString("service", 8, this.ivMicroOrganismID, "?");
            String meth = ListDefinition.getToString("service", 9, this.ivCheckMethodID, "?");
            Microorganism.Keim keim = Microorganism.getKeim(this.ivMicroOrganismID);
            String keimTyp = keim != null ? keim.getTypString() : null;
            sammler.add(String.valueOf(keimTyp != null ? "[" + keimTyp + "] " : "") + micro + " (" + meth + ")");
            sammler.add(String.valueOf(this.ivFound) + "/" + checked);
            sammler.add(this.ivFound == 0 ? "0" : "1");
        }

        public int getTableRepItemsPerLine() {
            return 3;
        }

        public String getMicroInfo() {
            String micro = ListDefinition.getToString("service", 8, this.ivMicroOrganismID, "?");
            String meth = ListDefinition.getToString("service", 9, this.ivCheckMethodID, "?");
            return String.valueOf(micro) + " (" + meth + ")";
        }

        public String toString() {
            StringBuilder msb = new StringBuilder();
            MicroRes.fillInitString(this.ivMicroOrganismID, this.ivCheckMethodID, this.ivFound, msb);
            return msb.toString();
        }
    }

    public static class MicroSortable
    implements Comparable {
        public int ivMicroOrganismID = -1;
        public int ivCheckMethodID = -1;
        public int ivMicroTyp = -1;
        public boolean ivFELASA = false;
        public String ivMicroInfo = null;
        public String ivKeimTypInfo = null;

        public static void fillFS(RResWrapper wrapper, int[] byKeimArray, HashSet checkedKeimeF, HashSet checkedKeimeNF) {
            int i = 0;
            while (i < wrapper.ivHealthReport.ivMicroResults.length) {
                MicroRes r = wrapper.ivHealthReport.ivMicroResults[i];
                Integer keimKey = new Integer(r.ivMicroOrganismID);
                Microorganism.Keim keim = Microorganism.getKeim(r.ivMicroOrganismID);
                if (keim != null) {
                    int pos = keim.ivKeimTyp * 2 + (keim.ivFelasaRelevant ? 1 : 0);
                    if (pos >= 0 && pos < byKeimArray.length) {
                        if (byKeimArray[pos] == -1) {
                            byKeimArray[pos] = 0;
                        }
                        if (r.ivFound != 0) {
                            int n = pos;
                            byKeimArray[n] = byKeimArray[n] + 1;
                        }
                    }
                    if (keim.ivFelasaRelevant) {
                        if (!checkedKeimeF.contains(keimKey)) {
                            checkedKeimeF.add(keimKey);
                        }
                    } else if (!checkedKeimeNF.contains(keimKey)) {
                        checkedKeimeNF.add(keimKey);
                    }
                }
                ++i;
            }
        }

        public static void fillSortables(RResWrapper wrapper, TreeSet target) {
            int i = 0;
            while (i < wrapper.ivHealthReport.ivMicroResults.length) {
                MicroRes r = wrapper.ivHealthReport.ivMicroResults[i];
                MicroSortable ms = new MicroSortable();
                ms.ivMicroOrganismID = r.ivMicroOrganismID;
                ms.ivCheckMethodID = r.ivCheckMethodID;
                Microorganism.Keim keim = Microorganism.getKeim(ms.ivMicroOrganismID);
                if (keim != null) {
                    ms.ivMicroTyp = keim.ivKeimTyp;
                    ms.ivFELASA = keim.ivFelasaRelevant;
                }
                ms.ivKeimTypInfo = StringHelper.getStringForInt(keim.ivKeimTyp, Microorganism.KEIM_TYPES, Microorganism.KEIM_TYP_BABELS, true, "?");
                ms.ivMicroInfo = r.getMicroInfo();
                target.add(ms);
                ++i;
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof MicroSortable) {
                MicroSortable ms = (MicroSortable)obj;
                return this.ivMicroOrganismID == ms.ivMicroOrganismID && this.ivCheckMethodID == ms.ivCheckMethodID;
            }
            return false;
        }

        public int compareTo(Object o) {
            if (o instanceof MicroSortable) {
                MicroSortable ms = (MicroSortable)o;
                if (this.ivMicroTyp < ms.ivMicroTyp) {
                    return -1;
                }
                if (this.ivMicroTyp > ms.ivMicroTyp) {
                    return 1;
                }
                if (this.ivFELASA && !ms.ivFELASA) {
                    return -1;
                }
                if (!this.ivFELASA && ms.ivFELASA) {
                    return 1;
                }
                return this.ivMicroInfo.compareToIgnoreCase(ms.ivMicroInfo);
            }
            return 0;
        }
    }
}

