/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.room;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import java.awt.Color;
import java.util.HashSet;
import java.util.Vector;
import mausoleum.building.Building;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.objectstore.QuotableIDObject;

public class Room
extends QuotableIDObject {
    public static final long serialVersionUID = -9083185963290878852L;
    public static final int SECURITY_UNKNOWN = 0;
    public static final int SECURITY_LOW = 100;
    public static final int SECURITY_MEDIUM = 200;
    public static final int SECURITY_HIGH = 300;
    public static final int SECURITY_SUPER = 500;
    public static final String LAB_SECURITY_UNKNOWN = "SECURITY_UNKNOWN";
    public static final String LAB_SECURITY_LOW = "SECURITY_LOW";
    public static final String LAB_SECURITY_MEDIUM = "SECURITY_MEDIUM";
    public static final String LAB_SECURITY_HIGH = "SECURITY_HIGH";
    public static final String LAB_SECURITY_SUPER = "SECURITY_SUPER";
    public static int[] SECURITY_INTS;
    public static String[] SECURITY_STRINGS;
    public static Color[] SECURITY_COLORS;
    public static final String ROM_PREFIX = "ROM_";
    public static final String ROOM_NAME = "ROM_NAME";
    public static final String DESCRIPTION = "ROM_DESC";
    public static final String SECURITY = "ROM_SECURITY";
    public static final String BUILDING_ID = "ROM_BUILDING";
    public static final String ACCESSIBLE = "ROM_ACCESSIBLE";
    public static final String BAUBESONDERHEITEN = "ROM_BBS";
    public static final String[] ATTRIBUTES_ROOM;
    public static final String[] ORDERED_ATTRIBUTES;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        int[] nArray = new int[5];
        nArray[1] = 100;
        nArray[2] = 200;
        nArray[3] = 300;
        nArray[4] = 500;
        SECURITY_INTS = nArray;
        SECURITY_STRINGS = new String[]{LAB_SECURITY_UNKNOWN, LAB_SECURITY_LOW, LAB_SECURITY_MEDIUM, LAB_SECURITY_HIGH, LAB_SECURITY_SUPER};
        SECURITY_COLORS = new Color[]{Color.white, Color.green, Color.yellow, Color.red, Color.magenta};
        String[] stringArray = new String[12];
        stringArray[0] = ROOM_NAME;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        stringArray[2] = DESCRIPTION;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz2.getName();
        stringArray[4] = SECURITY;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[5] = clazz3.getName();
        stringArray[6] = BUILDING_ID;
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[7] = clazz4.getName();
        stringArray[8] = ACCESSIBLE;
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[9] = clazz5.getName();
        stringArray[10] = BAUBESONDERHEITEN;
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[11] = clazz6.getName();
        ATTRIBUTES_ROOM = stringArray;
        ORDERED_ATTRIBUTES = new String[]{"IDO_ID", "IDO_START_DATE", "IDO_END_DATE", "IDO_VERSION", "IDO_UNIQUELONG", "IDO_VISIBLE", "IDO_NEVER_EXISTED", "IDO_OGROUP", "IDO_FKEY", "IDO_DOK", "IDO_SERVID", "IDO_UGROUPS", "IDO_UGROUPIDS", "IDO_SUBTYP", ROOM_NAME, DESCRIPTION, SECURITY, BUILDING_ID, "QIO_GNAMES", "QIO_QUOTA", ACCESSIBLE, BAUBESONDERHEITEN};
    }

    public String getName(String nullVal) {
        if (ProcessDefinition.isClient() && this.isSharedWithOtherGroups() && !MausoleumClient.isServiceCaretaker()) {
            return "[S] " + this.getString(ROOM_NAME, nullVal);
        }
        return this.getString(ROOM_NAME, nullVal);
    }

    public String getName() {
        return this.getName("Room " + this.getID());
    }

    public String getBrowseName() {
        return this.getName();
    }

    public Building getBuilding() {
        if ("service".equals(this.getGroup())) {
            return (Building)ObjectStore.getObjectDeadOrAlive(22, this.getLong(BUILDING_ID, 0L), this.getString("IDO_GROUP"), null, false);
        }
        return null;
    }

    public long getBuildingID(long defVal) {
        Building building = this.getBuilding();
        if (building != null) {
            return building.getID(defVal);
        }
        return defVal;
    }

    public void addBrowserLines(Vector target, String group, HashSet wantedObjectTypes) {
        super.addBrowserLines(target, group, wantedObjectTypes);
        target.add("Name = " + this.getString(ROOM_NAME, ""));
        String s = this.getString(DESCRIPTION, null);
        if (s != null && s.trim().length() != 0) {
            target.add("Description\t\t" + Base64Manager.encodeBase64(s));
        }
    }

    public Long getServiceRoomID() {
        if (this.isAlive()) {
            if (this.getGroup().equals("service")) {
                return (Long)this.get("IDO_ID");
            }
            return (Long)this.get("IDO_SERVID");
        }
        return null;
    }

    public boolean isRoomAccesibilityRestricted() {
        if (MausoleumClient.isRegularOrTGService()) {
            return !this.isAccessibleForGroups();
        }
        return false;
    }

    public boolean isAccessibleForGroups() {
        return this.getBoolean(ACCESSIBLE, true);
    }
}

