/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search;

import de.hannse.netobjects.user.UserManager;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.mouse.XSObject;
import mausoleum.search.SearchAssistant;
import mausoleum.search.SearchPanel;
import mausoleum.search.SearchResponder;
import mausoleum.search.extendedsearch.XSLine;
import mausoleum.search.extendedsearch.XSLineBornAfter;
import mausoleum.search.extendedsearch.XSLineBornBefore;
import mausoleum.search.extendedsearch.XSLineComment;
import mausoleum.search.extendedsearch.XSLineDatabase;
import mausoleum.search.extendedsearch.XSLineDeathMode;
import mausoleum.search.extendedsearch.XSLineDiedAfter;
import mausoleum.search.extendedsearch.XSLineDiedBefore;
import mausoleum.search.extendedsearch.XSLineEarTag;
import mausoleum.search.extendedsearch.XSLineExperiment;
import mausoleum.search.extendedsearch.XSLineGenotype;
import mausoleum.search.extendedsearch.XSLineLine;
import mausoleum.search.extendedsearch.XSLineOwner;
import mausoleum.search.extendedsearch.XSLineSex;
import mausoleum.search.extendedsearch.XSLineStrain;
import mausoleum.tables.MausoleumTable;
import mausoleum.ui.UIDef;

public class ExtendedMouseSearchPanel
extends RequesterPane
implements ActionListener,
SearchResponder,
SearchPanel {
    private static final long serialVersionUID = 3840958337543579551L;
    private static final int BUT_HEIGHT = UIDef.getScaled(40);
    private final SearchAssistant ivAssistant;
    private XSObject ivXSObject = new XSObject();
    private Vector ivXSLines = new Vector();
    private JTextPane ivTextPane = new JTextPane();
    private JScrollPane ivScrollPane = new JScrollPane(this.ivTextPane);

    protected ExtendedMouseSearchPanel() {
        super(null);
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int rx = UIDef.INNER_RAND + XSLine.TOT_WIDTH + UIDef.INNER_RAND;
                ExtendedMouseSearchPanel.this.ivScrollPane.setBounds(rx, UIDef.INNER_RAND, d.width - UIDef.INNER_RAND - rx, UIDef.getScaled(60));
                ExtendedMouseSearchPanel.this.ivAssistant.getChangingPanel().setBounds(rx, 2 * UIDef.INNER_RAND + UIDef.getScaled(60), d.width - UIDef.INNER_RAND - rx, d.height - (3 * UIDef.INNER_RAND + UIDef.getScaled(60)));
            }
        });
        this.ivAssistant = new SearchAssistant(this);
        this.ivXSObject.ivGroup = UserManager.getFirstGroup();
        this.add(this.ivAssistant.getChangingPanel());
        this.ivAssistant.ivButton.setBounds(UIDef.INNER_RAND, UIDef.INNER_RAND, XSLine.TOT_WIDTH, BUT_HEIGHT);
        this.ivAssistant.ivButton.addActionListener(this);
        this.add(this.ivAssistant.ivButton);
        int y = 2 * UIDef.INNER_RAND + BUT_HEIGHT;
        ExtendedMouseSearchPanel mp = this;
        this.ivXSLines.addElement(new XSLineDatabase(this, mp, y));
        this.ivXSLines.addElement(new XSLineOwner(this, mp, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, this.ivXSObject.ivGroup));
        this.ivXSLines.addElement(new XSLineBornBefore(this, mp, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND));
        this.ivXSLines.addElement(new XSLineBornAfter(this, mp, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND));
        this.ivXSLines.addElement(new XSLineDiedBefore(this, mp, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND));
        this.ivXSLines.addElement(new XSLineDiedAfter(this, mp, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND));
        this.ivXSLines.addElement(new XSLineDeathMode(this, mp, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND));
        this.ivXSLines.addElement(new XSLineEarTag(this, mp, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND));
        this.ivXSLines.addElement(new XSLineSex(this, mp, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND));
        this.ivXSLines.addElement(new XSLineStrain(this, mp, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, this.ivXSObject.ivGroup));
        this.ivXSLines.addElement(new XSLineLine(this, mp, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, this.ivXSObject.ivGroup));
        this.ivXSLines.addElement(new XSLineGenotype(this, mp, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, this.ivXSObject.ivGroup));
        this.ivXSLines.addElement(new XSLineExperiment(this, mp, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND));
        this.ivXSLines.addElement(new XSLineComment(this, mp, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND));
        this.ivTextPane.setText(this.ivXSObject.getDescription());
        this.ivTextPane.setEditable(false);
        this.ivTextPane.setEnabled(false);
        this.ivTextPane.setSelectedTextColor(Color.black);
        this.ivTextPane.setForeground(Color.black);
        this.ivTextPane.setDisabledTextColor(Color.black);
        this.ivTextPane.setBackground(Color.white);
        this.ivTextPane.setFont(FontManager.getFont("SSB12"));
        this.add(this.ivScrollPane);
    }

    public void dispose() {
        this.ivAssistant.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("STOP")) {
            this.ivAssistant.stopIt();
        } else if (comm.equals("SEARCH")) {
            XSObject xxs = new XSObject();
            xxs.ivGroup = UserManager.getFirstGroup();
            int i = 0;
            while (i < this.ivXSLines.size()) {
                XSLine xsl = (XSLine)this.ivXSLines.elementAt(i);
                xsl.fillXSObject(xxs);
                ++i;
            }
            this.ivAssistant.performSearch(xxs);
        } else if (comm.equals("CLEAR")) {
            this.ivAssistant.clearIt();
        } else if (comm.equals("SEL")) {
            int i = 0;
            while (i < this.ivXSLines.size()) {
                XSLine xsl = (XSLine)this.ivXSLines.elementAt(i);
                xsl.fillXSObject(this.ivXSObject);
                ++i;
            }
            this.ivTextPane.setText(this.ivXSObject.getDescription());
        }
    }

    public void searchWillStart() {
        int i = 0;
        while (i < this.ivXSLines.size()) {
            XSLine xsl = (XSLine)this.ivXSLines.elementAt(i);
            xsl.enable(false);
            ++i;
        }
    }

    public void searchWasStopped() {
    }

    public void searchWasFinished() {
    }

    public void tableWasCleared() {
        int i = 0;
        while (i < this.ivXSLines.size()) {
            XSLine xsl = (XSLine)this.ivXSLines.elementAt(i);
            xsl.enable(true);
            ++i;
        }
    }

    public void adaptToTab() {
        MausoleumTable mt = this.ivAssistant.getTableIfVisible();
        if (mt != null) {
            Inspector.adjustToTable(mt);
        }
    }
}

