/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search;

import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.VerticalText;
import mausoleum.gui.WindowMinimalSizer;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.main.MausoleumClient;
import mausoleum.search.ExtendedMouseSearchPanel;
import mausoleum.search.ProfessionalMouseSearchPanel;
import mausoleum.search.SearchPanel;
import mausoleum.search.SimpleMouseSearchPanel;
import mausoleum.search.profisearch.display.MausoleumSearcher;
import mausoleum.ui.UIDef;

public class SearchFrame
extends JFrame {
    private static final long serialVersionUID = 1333L;
    public static final int MODE_SIMPLE = 0;
    public static final int MODE_EXTENDED = 1;
    public static final int MODE_PROFESSIONAL = 2;
    private static final int MIN_HOEHE = UIDef.getScaled(500);
    private static final int MIN_BREITE = UIDef.getScaled(800);
    private static final int HOEHE = UIDef.getScaled(600);
    private static final int BREITE = UIDef.getScaled(850);
    private static SearchFrame cvInstance = null;
    private JTabbedPane ivTabbedPane = new JTabbedPane(2);

    public static void showMouseSearch(int mode) {
        if (cvInstance == null) {
            MausoleumSearcher.init();
            cvInstance = new SearchFrame();
        }
        SearchFrame.cvInstance.ivTabbedPane.setSelectedIndex(mode);
        WindowUtils.bringUpFrame(cvInstance);
    }

    public static void hideIt() {
        if (cvInstance != null) {
            cvInstance.setVisible(false);
        }
    }

    public static void destroyIt() {
        if (cvInstance != null) {
            int i = 0;
            while (i < SearchFrame.cvInstance.ivTabbedPane.getTabCount()) {
                Component c = SearchFrame.cvInstance.ivTabbedPane.getTabComponentAt(i);
                if (c instanceof ExtendedMouseSearchPanel) {
                    ExtendedMouseSearchPanel emsp = (ExtendedMouseSearchPanel)c;
                    emsp.dispose();
                } else if (!(c instanceof ProfessionalMouseSearchPanel)) {
                    boolean cfr_ignored_0 = c instanceof SimpleMouseSearchPanel;
                }
                ++i;
            }
            SearchFrame.cvInstance.ivTabbedPane.removeAll();
            cvInstance = null;
        }
    }

    private SearchFrame() {
        super(Babel.get("SEARCH_BIG"));
        this.setContentPane(new RequesterPane(new BorderLayout()));
        this.getContentPane().add("Center", this.ivTabbedPane);
        this.ivTabbedPane.addTab(null, VerticalText.getIcon(Babel.get("SIMPLE")), new SimpleMouseSearchPanel());
        if (MausoleumClient.isRegularOrTGService()) {
            this.ivTabbedPane.addTab(null, VerticalText.getIcon(Babel.get("EXTENDED")), new ExtendedMouseSearchPanel());
            this.ivTabbedPane.addTab(null, VerticalText.getIcon(Babel.get("PROFESSIONAL")), new ProfessionalMouseSearchPanel());
        }
        this.setSize(BREITE, HOEHE);
        this.setIconImage(MausoleumImageStore.getLogo());
        new WindowMinimalSizer(this, MIN_BREITE, MIN_HOEHE, true);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                SearchFrame.this.adaptToTab();
            }
        });
        this.ivTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SearchFrame.this.adaptToTab();
            }
        });
        WindowUtils.setRememberedBounds(this, new Rectangle(20, 20, BREITE, HOEHE));
    }

    private void adaptToTab() {
        SearchPanel sp = (SearchPanel)((Object)this.ivTabbedPane.getSelectedComponent());
        if (sp != null) {
            sp.adaptToTab();
        }
    }
}

