/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.extendedsearch;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mausoleum.mouse.XSObject;
import mausoleum.ui.UIDef;

public abstract class XSLine
implements ActionListener {
    private static final int LEFTX = UIDef.INNER_RAND;
    private static final int LEFTW = UIDef.getScaled(95);
    private static final int MIDDLEX = LEFTX + LEFTW + UIDef.INNER_RAND;
    private static final int MIDDLEW = UIDef.getScaled(50);
    private static final int RIGHTX = MIDDLEX + MIDDLEW + UIDef.INNER_RAND;
    private static final int RIGHTW = UIDef.getScaled(210);
    public static final int TOT_WIDTH = LEFTW + MIDDLEW + RIGHTW + 2 * UIDef.INNER_RAND;
    protected JLabel ivLabel = null;
    protected JComboBox ivComboBox = null;
    protected JCheckBox ivCheckBox = null;
    protected JComponent ivExtra = null;
    protected int ivLastSelIndex = 0;
    protected ActionListener ivActionListener;

    public XSLine(String label, ActionListener al) {
        this.ivActionListener = al;
        this.ivLabel = new JLabel(label);
        this.ivLabel.setOpaque(false);
        this.ivLabel.setForeground(Color.black);
        if (this.wantsCheckBox()) {
            this.ivCheckBox = new JCheckBox("not");
            this.ivCheckBox.setOpaque(false);
            this.ivCheckBox.setFocusPainted(false);
            this.ivCheckBox.addActionListener(this);
        }
    }

    public void dispose() {
        this.ivLabel = null;
        this.ivComboBox = null;
        this.ivCheckBox = null;
        this.ivActionListener = null;
        this.ivExtra = null;
    }

    public abstract void fillXSObject(XSObject var1);

    protected void arrangeComponents(JPanel jp, int y) {
        if (this.ivLabel != null) {
            jp.add(this.ivLabel);
            this.ivLabel.setBounds(LEFTX, y, LEFTW, UIDef.LINE_HEIGHT);
        }
        if (this.ivCheckBox != null) {
            jp.add(this.ivCheckBox);
            this.ivCheckBox.setBounds(MIDDLEX, y, MIDDLEW, UIDef.LINE_HEIGHT);
        }
        if (this.ivComboBox != null) {
            jp.add(this.ivComboBox);
            if (this.ivExtra != null) {
                jp.add(this.ivExtra);
                int ww = this.ivExtra.getPreferredSize().width;
                this.ivComboBox.setBounds(RIGHTX, y, RIGHTW - ww, UIDef.LINE_HEIGHT);
                this.ivExtra.setBounds(RIGHTX + RIGHTW - ww, y, ww, UIDef.LINE_HEIGHT);
            } else {
                this.ivComboBox.setBounds(RIGHTX, y, RIGHTW, UIDef.LINE_HEIGHT);
            }
        }
    }

    public void enable(boolean enable) {
        if (this.ivComboBox != null) {
            this.ivComboBox.setEnabled(enable);
        }
        if (this.ivCheckBox != null) {
            this.ivCheckBox.setEnabled(enable);
        }
        if (this.ivExtra != null) {
            this.ivExtra.setEnabled(enable);
        }
    }

    public boolean wantsCheckBox() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        this.ivActionListener.actionPerformed(new ActionEvent(this, 0, "SEL"));
    }
}

