/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.basic;

import de.hannse.netobjects.util.XMLNode;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import mausoleum.mouse.Mouse;
import mausoleum.search.profisearch.basic.SDNode;

public class SDGrouper
extends SDNode {
    public static final int TYP_AND = 0;
    public static final int TYP_OR = 1;
    public final Vector ivKids = new Vector();
    public int ivType = 0;
    public int ivMode = 0;

    public SDGrouper() {
    }

    public SDGrouper(boolean isAnd) {
        this.ivType = isAnd ? 0 : 1;
    }

    public boolean isAnd() {
        return this.ivType == 0;
    }

    public void prepareForSearch(boolean onServer) {
        Enumeration en = this.children();
        while (en.hasMoreElements()) {
            SDNode node = (SDNode)en.nextElement();
            node.prepareForSearch(onServer);
        }
    }

    public void searchFinished(boolean onServer) {
        Enumeration en = this.children();
        while (en.hasMoreElements()) {
            SDNode node = (SDNode)en.nextElement();
            node.searchFinished(onServer);
        }
    }

    public String getAttributeXML() {
        String attr = "typ=\"" + (this.isAnd() ? "and" : "or") + "\"";
        if (this.ivMode != 0) {
            attr = String.valueOf(attr) + " mode=\"" + this.ivMode + "\"";
        }
        return attr;
    }

    public String getKidXML(int tab) {
        StringBuffer msb = new StringBuffer();
        Iterator iter = this.ivKids.iterator();
        while (iter.hasNext()) {
            SDNode kid = (SDNode)iter.next();
            msb.append(kid.getXML(tab));
        }
        return msb.toString();
    }

    public void init(XMLNode node) {
        Vector kids;
        this.ivType = node.getAttributeValue("typ", "and").equals("and") ? 0 : 1;
        String s = node.getAttributeValue("mode", null);
        if (s != null) {
            try {
                this.ivMode = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((kids = node.getKidVector()) != null && !kids.isEmpty()) {
            Iterator iter = kids.iterator();
            while (iter.hasNext()) {
                XMLNode kidNode = (XMLNode)iter.next();
                SDNode kid = SDGrouper.initFromNode(kidNode);
                if (kid == null) continue;
                this.addKid(kid);
            }
        }
    }

    public boolean isFullyDefined() {
        if (this.ivKids.isEmpty()) {
            return false;
        }
        Iterator iterator = this.ivKids.iterator();
        while (iterator.hasNext()) {
            SDNode node = (SDNode)iterator.next();
            if (node.isFullyDefined()) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        Iterator iter = this.ivKids.iterator();
        while (iter.hasNext()) {
            SDNode node = (SDNode)iter.next();
            node.dispose();
        }
        super.dispose();
    }

    public void addKid(SDNode node) {
        this.ivKids.add(node);
        node.ivSuperNode = this;
    }

    public String getDescription() {
        return this.ivType == 0 ? "AND" : "OR";
    }

    public boolean match(Object o) {
        if (this.ivKids.isEmpty()) {
            return this.invertIN(true);
        }
        boolean isOR = this.ivType == 1;
        Iterator iter = this.ivKids.iterator();
        while (iter.hasNext()) {
            SDNode node = (SDNode)iter.next();
            if (node.doMatch(o) != isOR) continue;
            return this.invertIN(isOR);
        }
        return this.invertIN(!isOR);
    }

    public boolean checkWithIndex(Long id, String index) {
        if (this.ivKids.isEmpty()) {
            return this.invertIN(true);
        }
        boolean isOR = this.ivType == 1;
        Iterator iter = this.ivKids.iterator();
        while (iter.hasNext()) {
            SDNode node = (SDNode)iter.next();
            if (node.checkWithIndex(id, index) != isOR) continue;
            return this.invertIN(isOR);
        }
        return this.invertIN(!isOR);
    }

    public void addWheres(Vector target, Vector columns) {
        Vector wheres = new Vector();
        Iterator iter = this.ivKids.iterator();
        while (iter.hasNext()) {
            SDNode node = (SDNode)iter.next();
            node.addWheres(wheres, columns);
        }
        if (!wheres.isEmpty()) {
            StringBuilder msb = new StringBuilder();
            if (this.ivNOT) {
                msb.append(" NOT ");
            }
            msb.append("(");
            int i = 0;
            while (i < wheres.size()) {
                if (i != 0) {
                    msb.append(this.isAnd() ? " AND " : " OR ");
                }
                msb.append(wheres.elementAt(i));
                ++i;
            }
            msb.append(")");
            target.add(msb.toString());
            msb.setLength(0);
            msb = null;
        }
    }

    public boolean checkAfterIndex(Object mouseOrHM) {
        Mouse mausi;
        if (mouseOrHM instanceof Mouse && !(mausi = (Mouse)mouseOrHM).existed()) {
            return false;
        }
        if (this.ivKids.isEmpty()) {
            return this.invertIN(true);
        }
        boolean isOR = this.ivType == 1;
        Iterator iter = this.ivKids.iterator();
        while (iter.hasNext()) {
            boolean res;
            SDNode node = (SDNode)iter.next();
            boolean bl = res = node.afterIndexCheckNecessary() ? node.doMatch(mouseOrHM) : true;
            if (res != isOR) continue;
            return this.invertIN(isOR);
        }
        return this.invertIN(!isOR);
    }

    public boolean afterIndexCheckNecessary() {
        if (!this.ivKids.isEmpty()) {
            Iterator iter = this.ivKids.iterator();
            while (iter.hasNext()) {
                SDNode node = (SDNode)iter.next();
                if (!node.afterIndexCheckNecessary()) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration children() {
        return this.ivKids.elements();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int arg0) {
        if (arg0 >= 0 && arg0 < this.ivKids.size()) {
            return (TreeNode)this.ivKids.elementAt(arg0);
        }
        return null;
    }

    public int getChildCount() {
        return this.ivKids.size();
    }

    public int getIndex(TreeNode arg0) {
        return this.ivKids.indexOf(arg0);
    }

    public boolean isLeaf() {
        return false;
    }
}

