/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.display;

import de.hannse.netobjects.util.MyDate;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.MGButton;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManager;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.search.profisearch.display.MausoleumSearcher;
import mausoleum.search.profisearch.display.SearchDateDialog;
import mausoleum.ui.UIDef;

public class SDDateSelector
extends JPanel {
    private static final long serialVersionUID = 11515L;
    private static final int BUT_WIDTH = UIDef.getScaled(20);
    private KomfortTextField ivTextField = new KomfortTextField();
    private MGButton ivSelectButton = new MGButton("...");
    private int ivDatum = Integer.MIN_VALUE;
    private final boolean ivMitVariablen;
    private final boolean ivInDieZukunft;
    private long ivTageRest = 0L;

    public SDDateSelector(boolean mitVariablen, boolean inDieZukunft) {
        this.ivMitVariablen = mitVariablen;
        this.ivInDieZukunft = inDieZukunft;
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int lw = d.width - BUT_WIDTH;
                SDDateSelector.this.ivTextField.setBounds(0, 0, lw, d.height);
                SDDateSelector.this.ivSelectButton.setBounds(lw, 0, BUT_WIDTH, d.height);
            }

            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(UIDef.getScaled(100), UIDef.LINE_HEIGHT);
            }
        });
        this.ivTextField.setBorder(MausoleumSearcher.FIELD_BORDER);
        this.ivTextField.setFont(FontManager.getFont("SSB11"));
        this.ivTextField.setEnabled(false);
        this.add("Center", this.ivTextField);
        this.ivSelectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MyDate maximum;
                MyDate jetzt = MyDate.getMyDate(System.currentTimeMillis());
                MyDate minimum = SDDateSelector.this.ivInDieZukunft ? jetzt : null;
                MyDate myDate = maximum = SDDateSelector.this.ivInDieZukunft ? null : jetzt;
                if (SDDateSelector.this.ivMitVariablen) {
                    int datum = SearchDateDialog.getDate(null, minimum, maximum);
                    if (datum != Integer.MIN_VALUE) {
                        SDDateSelector.this.setDatum(datum);
                    }
                } else {
                    Date date = CalendarRequester.getDate(null, minimum, maximum);
                    if (date != null) {
                        SDDateSelector.this.setDatum((int)(date.getTime() / 86400000L));
                    }
                }
            }
        });
        this.add("East", this.ivSelectButton);
    }

    public void setDatum(int datum) {
        this.ivDatum = datum;
        if (datum == Integer.MIN_VALUE) {
            this.ivTextField.setText("");
        } else {
            this.ivTextField.setText(" " + DatumFormat.getJustDateString(this.ivDatum) + " ");
        }
    }

    public void setEnabled(boolean enabled) {
        this.ivTextField.setEnabled(enabled);
        this.ivSelectButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setTimestamp(long datum) {
        if (datum == Long.MIN_VALUE) {
            this.ivDatum = Integer.MIN_VALUE;
            this.ivTageRest = 0L;
            this.ivTextField.setText("");
        } else {
            this.ivDatum = (int)(datum / 86400000L);
            this.ivTageRest = datum - (long)this.ivDatum * 86400000L;
            this.ivTextField.setText(" " + DatumFormat.getJustDateString(this.ivDatum) + " ");
        }
    }

    public long getTimeStamp() {
        if (this.ivDatum == Integer.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return (long)this.ivDatum * 86400000L + this.ivTageRest;
    }

    public int getDatum() {
        return this.ivDatum;
    }

    public JTextField getTextField() {
        return this.ivTextField;
    }
}

