/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.searcher;

import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.util.Babel;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JComponent;
import mausoleum.helper.ZeileAbstr;
import mausoleum.main.ProcessDefinition;
import mausoleum.search.profisearch.basic.SDSearcher;
import mausoleum.search.profisearch.basic.SDSearcherDATE;
import mausoleum.search.profisearch.display.SDDateSelector;

public abstract class MausoSearcherDate
extends SDSearcherDATE {
    public static SDDateSelector cvFirstSelector = ProcessDefinition.isClient() ? new SDDateSelector(true, false) : null;
    public static SDDateSelector cvSecondSelector = ProcessDefinition.isClient() ? new SDDateSelector(true, false) : null;

    public static void init() {
        SDSearcher.register(new SearcherBirthday());
        SDSearcher.register(new SearcherExitday());
        SDSearcher.register(new SearcherStartday());
    }

    public JComponent[] getDialogComponent() {
        if (this.needsTwoObjects()) {
            JComponent[] carr = new JComponent[]{cvFirstSelector, cvSecondSelector};
            return carr;
        }
        if (this.needsObject()) {
            JComponent[] carr = new JComponent[]{cvFirstSelector};
            return carr;
        }
        return null;
    }

    public void fillComponents(JComponent[] carr) {
        if (carr != null) {
            if (this.needsTwoObjects() && carr.length == 2) {
                this.fillComponent((Integer)this.ivVal, carr[0]);
                this.fillComponent((Integer)this.ivSecondVal, carr[1]);
            }
            if (this.needsObject() && carr.length >= 1) {
                this.fillComponent((Integer)this.ivVal, carr[0]);
            }
        }
    }

    private void fillComponent(Integer val, JComponent c) {
        if (val != null) {
            ((SDDateSelector)c).setDatum(val);
        } else {
            ((SDDateSelector)c).setDatum(Integer.MIN_VALUE);
        }
    }

    public void fillFromComponents(JComponent[] carr) {
        this.ivVal = null;
        this.ivSecondVal = null;
        if (carr != null && carr.length == 1) {
            this.ivVal = this.getDatum(carr[0]);
        } else if (carr != null && carr.length == 2) {
            this.ivVal = this.getDatum(carr[0]);
            this.ivSecondVal = this.getDatum(carr[1]);
        }
    }

    private Integer getDatum(JComponent sd) {
        try {
            int datum = ((SDDateSelector)sd).getDatum();
            if (datum != Integer.MIN_VALUE) {
                return new Integer(datum);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Object getComparableObject(Object primaryObject, String tag) {
        Object ooo = null;
        if (primaryObject instanceof IDObject) {
            IDObject ido = (IDObject)primaryObject;
            ooo = ido.get(tag);
        } else if (primaryObject instanceof HashMap) {
            HashMap hm = (HashMap)primaryObject;
            ooo = hm.get(tag);
        }
        if (ooo != null) {
            if (ooo instanceof Date) {
                Date d = (Date)ooo;
                return new Integer((int)(d.getTime() / 86400000L));
            }
            if (ooo instanceof Integer) {
                Integer inti = (Integer)ooo;
                return inti;
            }
            if (ooo instanceof Long) {
                Long longi = (Long)ooo;
                return new Integer((int)(longi / 86400000L));
            }
        }
        return null;
    }

    public static class SearcherBirthday
    extends MausoSearcherDate {
        public boolean checkWithIndex(Long id, String index) {
            int date = ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getBirthdayCol(), -1);
            return this.makeRes(this.iMatch(date == -1 ? null : new Integer(date), null));
        }

        public void addWheres(Vector target, Vector columns) {
            this.addWheres(target, "MOS_BIRTHDAY");
        }

        public boolean afterIndexCheckNecessary() {
            return false;
        }

        public Object getComparableObject(Object primaryObject) {
            return null;
        }

        public String getTitle() {
            return Babel.get("FS_M_BIRTHDAY");
        }

        public String getDescription() {
            return Babel.get("FS_M_BIRTHDAY");
        }
    }

    public static class SearcherExitday
    extends MausoSearcherDate {
        public boolean checkWithIndex(Long id, String index) {
            int date = ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getEndCol(), -1);
            return this.makeRes(this.iMatch(date == -1 ? null : new Integer(date), null));
        }

        public void addWheres(Vector target, Vector columns) {
            this.addWheres(target, "IDO_END_DATE");
        }

        public boolean afterIndexCheckNecessary() {
            return false;
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject((IDObject)primaryObject, "IDO_END_DATE");
        }

        public String getTitle() {
            return Babel.get("SD_END_DATE");
        }

        public String getDescription() {
            return Babel.get("SD_END_DATE");
        }
    }

    public static class SearcherStartday
    extends MausoSearcherDate {
        public boolean checkWithIndex(Long id, String index) {
            int date = ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getStartCol(), -1);
            return this.makeRes(this.iMatch(date == -1 ? null : new Integer(date), null));
        }

        public void addWheres(Vector target, Vector columns) {
            this.addWheres(target, "IDO_START_DATE");
        }

        public boolean afterIndexCheckNecessary() {
            return false;
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject((IDObject)primaryObject, "IDO_START_DATE");
        }

        public String getTitle() {
            return Babel.get("SD_START_DATE");
        }

        public String getDescription() {
            return Babel.get("SD_START_DATE");
        }
    }
}

