/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.searcher;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.util.Babel;
import java.util.Date;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import mausoleum.helper.ZeileAbstr;
import mausoleum.mouse.Mouse;
import mausoleum.search.profisearch.basic.SDSearcher;
import mausoleum.search.profisearch.basic.SDSearcherINT;

public abstract class MausoSearcherInt
extends SDSearcherINT {
    public static void init() {
        SDSearcher.register(new SearcherEarTag());
        SDSearcher.register(new SearcherMouseAgeDays());
        SDSearcher.register(new SearcherMouseAgeWeeks());
    }

    public void fillComponents(JComponent[] carr) {
        if (carr != null && carr.length != 0) {
            JTextComponent tf;
            if (carr[0] instanceof JTextComponent) {
                tf = (JTextComponent)carr[0];
                if (this.ivVal != null) {
                    tf.setText(this.ivVal.toString());
                } else {
                    tf.setText("");
                }
            }
            if (carr.length >= 2 && carr[1] instanceof JTextComponent) {
                tf = (JTextComponent)carr[1];
                if (this.ivSecondVal != null) {
                    tf.setText(this.ivSecondVal.toString());
                } else {
                    tf.setText("");
                }
            }
        }
    }

    public static class SearcherEarTag
    extends MausoSearcherInt {
        public boolean checkWithIndex(Long id, String index) {
            return true;
        }

        public boolean afterIndexCheckNecessary() {
            return !DataLayer.USE_DB;
        }

        public void addWheres(Vector target, Vector columns) {
            this.addWheres(target, "MOS_EARTAG", this.ivVal.intValue(), this.ivSecondVal != null ? this.ivSecondVal.intValue() : -1);
        }

        public Object getComparableObject(Object primaryObject) {
            Integer etInti = (Integer)this.getComparableObject(primaryObject, "MOS_EARTAG");
            if (etInti != null && etInti != 0) {
                return etInti;
            }
            return null;
        }

        public String getTitle() {
            return Babel.get("FS_M_EARTAG");
        }

        public String getDescription() {
            return Babel.get("FS_M_EARTAG");
        }
    }

    public static class SearcherMouseAgeDays
    extends MausoSearcherInt {
        private transient int heute = (int)(System.currentTimeMillis() / 86400000L);

        public boolean checkWithIndex(Long id, String index) {
            Integer alter = null;
            int birthday = ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getBirthdayCol(), -1);
            if (birthday != -1) {
                int enddate = ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getEndCol(), this.heute);
                alter = new Integer(enddate - birthday);
            }
            return this.makeRes(this.iMatch(alter, null));
        }

        public boolean afterIndexCheckNecessary() {
            return true;
        }

        public void addWheres(Vector target, Vector columns) {
            columns.add("MOS_BIRTHDAY");
            columns.add("IDO_END_DATE");
        }

        public Object getComparableObject(Object primaryObject) {
            Date startDate = (Date)this.getComparableObject(primaryObject, "MOS_BIRTHDAY");
            Date endDate = (Date)this.getComparableObject(primaryObject, "IDO_END_DATE");
            int age = startDate != null ? Mouse.getRealAgeInDays(startDate, endDate) : -1;
            return age >= 0 ? new Integer(age) : null;
        }

        public String getTitle() {
            return Babel.get("PS_MOUSE_AGE_DAYS");
        }

        public String getDescription() {
            return Babel.get("PS_MOUSE_AGE_DAYS");
        }
    }

    public static class SearcherMouseAgeWeeks
    extends MausoSearcherInt {
        private transient int heute = (int)(System.currentTimeMillis() / 86400000L);

        public boolean checkWithIndex(Long id, String index) {
            Integer alter = null;
            int birthday = ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getBirthdayCol(), -1);
            if (birthday != -1) {
                int enddate = ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getEndCol(), this.heute);
                alter = new Integer(enddate - birthday);
            }
            return this.makeRes(this.iMatch(alter, null));
        }

        public boolean afterIndexCheckNecessary() {
            return true;
        }

        public void addWheres(Vector target, Vector columns) {
            columns.add("MOS_BIRTHDAY");
            columns.add("IDO_END_DATE");
        }

        public Object getComparableObject(Object primaryObject) {
            Date startDate = (Date)this.getComparableObject(primaryObject, "MOS_BIRTHDAY");
            Date endDate = (Date)this.getComparableObject(primaryObject, "IDO_END_DATE");
            int age = startDate != null ? Mouse.getRealAgeInDays(startDate, endDate) : -1;
            return age >= 0 ? new Integer(age) : null;
        }

        public String getTitle() {
            return Babel.get("PS_MOUSE_AGE_WEEKS");
        }

        public String getDescription() {
            return Babel.get("PS_MOUSE_AGE_WEEKS");
        }

        public void prepareForSearch(boolean onServer) {
            if (this.ivVal != null) {
                this.ivVal = new Integer(this.ivVal.intValue() * 7);
            }
            if (this.ivSecondVal != null) {
                this.ivSecondVal = new Integer(this.ivSecondVal.intValue() * 7);
            }
        }

        public void searchFinished(boolean onServer) {
            if (this.ivVal != null) {
                this.ivVal = new Integer(this.ivVal.intValue() / 7);
            }
            if (this.ivSecondVal != null) {
                this.ivSecondVal = new Integer(this.ivSecondVal.intValue() / 7);
            }
        }
    }
}

