/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.searcher;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.util.Babel;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import mausoleum.helper.ZeileAbstr;
import mausoleum.search.profisearch.basic.SDSearcher;
import mausoleum.search.profisearch.basic.SDSearcherINT_SET;

public abstract class MausoSearcherIntSet
extends SDSearcherINT_SET {
    public static void init() {
        SDSearcher.register(new SearcherSex());
        SDSearcher.register(new SearcherStartMode());
        SDSearcher.register(new SearcherEndMode());
    }

    public void fillComponents(JComponent[] carr) {
        if (this.ivVal != null) {
            int[] valarr = this.getIntValues();
            int myVal = this.ivVal.intValue();
            int i = 0;
            while (i < valarr.length) {
                if (valarr[i] == myVal) {
                    ((JComboBox)carr[0]).setSelectedIndex(i);
                }
                ++i;
            }
        }
    }

    public static class SearcherEndMode
    extends MausoSearcherIntSet {
        private static String[] DIS_VALS = new String[]{Babel.get("BYDEATH"), Babel.get("BYSACRIFICE"), Babel.get("BYEXPORT"), Babel.get("BYREMOVAL")};
        private static int[] INT_VALS = new int[]{4, 5, 6, 8};

        public boolean checkWithIndex(Long id, String index) {
            return true;
        }

        public void addWheres(Vector target, Vector columns) {
            this.addWheres(target, "MOS_ENDMODE", this.ivVal.intValue(), -1);
        }

        public boolean afterIndexCheckNecessary() {
            return !DataLayer.USE_DB;
        }

        public String[] getDisplayValues() {
            return DIS_VALS;
        }

        public int[] getIntValues() {
            return INT_VALS;
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject(primaryObject, "MOS_ENDMODE");
        }

        public String getTitle() {
            return Babel.get("SD_END_MODE");
        }

        public String getDescription() {
            return Babel.get("MTC_TT_ENDMODE");
        }
    }

    public static class SearcherSex
    extends MausoSearcherIntSet {
        private static String[] DIS_VALS = new String[]{Babel.get("MALE"), Babel.get("FEMALE")};
        private static int[] INT_VALS = new int[]{1, 2};

        public boolean checkWithIndex(Long id, String index) {
            int sex = ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getSexCol(), -1);
            return this.makeRes(this.iMatch(sex == -1 ? null : new Integer(sex), null));
        }

        public void addWheres(Vector target, Vector columns) {
            this.addWheres(target, "IDX_SEX", this.ivVal != null ? this.ivVal.intValue() : -1, -1);
        }

        public boolean afterIndexCheckNecessary() {
            return false;
        }

        public String[] getDisplayValues() {
            return DIS_VALS;
        }

        public int[] getIntValues() {
            return INT_VALS;
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject(primaryObject, "MOS_SEX");
        }

        public String getTitle() {
            return Babel.get("FS_M_SEX");
        }

        public String getDescription() {
            return Babel.get("FS_M_SEX");
        }
    }

    public static class SearcherStartMode
    extends MausoSearcherIntSet {
        private static String[] DIS_VALS = new String[]{Babel.get("BYBIRTH"), Babel.get("BYIMPORT")};
        private static int[] INT_VALS = new int[]{1, 3};

        public boolean checkWithIndex(Long id, String index) {
            return true;
        }

        public boolean afterIndexCheckNecessary() {
            return !DataLayer.USE_DB;
        }

        public void addWheres(Vector target, Vector columns) {
            this.addWheres(target, "MOS_STARTMODE", this.ivVal.intValue(), -1);
        }

        public String[] getDisplayValues() {
            return DIS_VALS;
        }

        public int[] getIntValues() {
            return INT_VALS;
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject(primaryObject, "MOS_STARTMODE");
        }

        public String getTitle() {
            return Babel.get("SD_START_MODE");
        }

        public String getDescription() {
            return Babel.get("MTC_TT_STARTMODE");
        }
    }
}

