/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.searcher;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.XMLNode;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.locus.LocusManager;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TissueSample;
import mausoleum.search.profisearch.basic.SDSearcher;
import mausoleum.search.profisearch.basic.SDSearcherOBJECT;
import mausoleum.search.profisearch.display.SDGenotypeSelector;

public abstract class MausoSearcherObject
extends SDSearcherOBJECT {
    public static void init() {
        SDSearcher.register(new SearcherGenotype());
        SDSearcher.register(new SearcherTissueSample());
    }

    public static class SearcherGenotype
    extends MausoSearcherObject {
        public static final int[] GT_SET_QUALS = new int[]{1, 2, 16, 17, 3, 14, 18, 19, 20};

        public static boolean isGenotypeSet(Mouse mouse, LocusAndAlleles[] mv, Line line, LocusAndAlleles[] lv) {
            return mv != null;
        }

        public static boolean isGenotypePartiallySet(Mouse mouse, LocusAndAlleles[] mv, Line line, LocusAndAlleles[] lv) {
            return lv != null && mv != null && lv.length != mv.length;
        }

        public static boolean isGenotypeFullySet(Mouse mouse, LocusAndAlleles[] mv, Line line, LocusAndAlleles[] lv) {
            return lv != null && mv != null && lv.length == mv.length;
        }

        public static boolean isPureWildType(Mouse mouse, LocusAndAlleles[] mv, Line line, LocusAndAlleles[] lv) {
            if (lv != null && mv != null && lv.length == mv.length) {
                int i = 0;
                while (i < mv.length) {
                    if (mv[i].ivAllele == null) {
                        return false;
                    }
                    Locus locus = (Locus)ObjectStore.getObjectDeadOrAlive(14, mv[i].ivLocusID, mouse.getGroup(), null, false);
                    if (locus == null) {
                        return false;
                    }
                    String wt = locus.getString("LOC_WT_ALLEL", null);
                    if (wt == null) {
                        return false;
                    }
                    int j = 0;
                    while (j < mv[i].ivAllele.length) {
                        if (!wt.equals(mv[i].ivAllele[j])) {
                            return false;
                        }
                        ++j;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public static boolean isPureNonWildType(Mouse mouse, LocusAndAlleles[] mv, Line line, LocusAndAlleles[] lv) {
            if (lv != null && mv != null && lv.length == mv.length) {
                int i = 0;
                while (i < mv.length) {
                    if (mv[i].ivAllele == null) {
                        return false;
                    }
                    Locus locus = (Locus)ObjectStore.getObjectDeadOrAlive(14, mv[i].ivLocusID, mouse.getGroup(), null, false);
                    if (locus == null) {
                        return false;
                    }
                    String wt = locus.getString("LOC_WT_ALLEL", null);
                    if (wt == null) {
                        return false;
                    }
                    int j = 0;
                    while (j < mv[i].ivAllele.length) {
                        if (wt.equals(mv[i].ivAllele[j])) {
                            return false;
                        }
                        ++j;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public static boolean isMixedGenoType(Mouse mouse, LocusAndAlleles[] mv, Line line, LocusAndAlleles[] lv) {
            if (lv != null && lv.length == mv.length) {
                int anzwt = 0;
                int nonwt = 0;
                int i = 0;
                while (i < mv.length) {
                    if (mv[i].ivAllele == null) {
                        return false;
                    }
                    Locus locus = (Locus)ObjectStore.getObjectDeadOrAlive(14, mv[i].ivLocusID, mouse.getGroup(), null, false);
                    if (locus == null) {
                        return false;
                    }
                    String wt = locus.getString("LOC_WT_ALLEL", null);
                    if (wt == null) {
                        return false;
                    }
                    int j = 0;
                    while (j < mv[i].ivAllele.length) {
                        if (mv[i].ivAllele[j] == null) {
                            return false;
                        }
                        if (wt.equals(mv[i].ivAllele[j])) {
                            ++anzwt;
                        } else {
                            ++nonwt;
                        }
                        ++j;
                    }
                    ++i;
                }
                return anzwt != 0 && nonwt != 0;
            }
            return false;
        }

        public int[] getPossibleQuals() {
            return GT_SET_QUALS;
        }

        public boolean checkWithIndex(Long id, String index) {
            return true;
        }

        public boolean afterIndexCheckNecessary() {
            return true;
        }

        public void addWheres(Vector target, Vector columns) {
            columns.add("MOS_LOCUSGENOTYPES");
        }

        public int iMatch(Object comparableObject, Object originalObject) {
            LocusAndAlleles[] lv;
            Mouse mouse = (Mouse)originalObject;
            LocusAndAlleles[] mv = (LocusAndAlleles[])comparableObject;
            Line line = mouse.getLine();
            LocusAndAlleles[] locusAndAllelesArray = lv = line == null ? null : (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
            if (this.ivQual == 16) {
                return SearcherGenotype.isGenotypePartiallySet(mouse, mv, line, lv) ? 1 : 2;
            }
            if (this.ivQual == 17) {
                return SearcherGenotype.isGenotypeFullySet(mouse, mv, line, lv) ? 1 : 2;
            }
            if (this.ivQual == 18) {
                return SearcherGenotype.isPureWildType(mouse, mv, line, lv) ? 1 : 2;
            }
            if (this.ivQual == 19) {
                return SearcherGenotype.isPureNonWildType(mouse, mv, line, lv) ? 1 : 2;
            }
            if (this.ivQual == 20) {
                return SearcherGenotype.isMixedGenoType(mouse, mv, line, lv) ? 1 : 2;
            }
            if ((this.ivQual == 3 || this.ivQual == 14) && this.ivVal != null) {
                LocusAndAlleles valueLal = (LocusAndAlleles)this.ivVal;
                if (valueLal.ivAllele == null) {
                    if (lv != null) {
                        int i = 0;
                        while (i < lv.length) {
                            if (lv[i].ivLocusID == valueLal.ivLocusID) {
                                boolean genotypeMissing = true;
                                if (mv != null) {
                                    int j = 0;
                                    while (j < mv.length && genotypeMissing) {
                                        if (mv[j].ivLocusID == valueLal.ivLocusID) {
                                            genotypeMissing = false;
                                        }
                                        ++j;
                                    }
                                }
                                if (this.ivQual == 3 && genotypeMissing) {
                                    return 1;
                                }
                                if (this.ivQual == 14 && !genotypeMissing) {
                                    return 1;
                                }
                            }
                            ++i;
                        }
                    }
                    return 2;
                }
            }
            if (this.ivQual == 2) {
                return SearcherGenotype.isGenotypeSet(mouse, mv, line, lv) ? 2 : 1;
            }
            if (this.ivQual == 1) {
                return SearcherGenotype.isGenotypeSet(mouse, mv, line, lv) ? 1 : 2;
            }
            return super.iMatch(comparableObject, originalObject);
        }

        public boolean iiMatch(Object co) {
            LocusAndAlleles[] lalarr = (LocusAndAlleles[])co;
            int i = 0;
            while (i < lalarr.length) {
                if (this.ivVal.equals(lalarr[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public String getQualString(int qual) {
            if (qual == 3) {
                return Babel.get("SD_QUAL_CONTAINS");
            }
            if (qual == 14) {
                return Babel.get("SD_QUAL_CONTAINS_NOT");
            }
            return super.getQualString(qual);
        }

        public void fillComponents(JComponent[] carr) {
            if (this.ivVal != null && carr != null && carr.length >= 1) {
                SDGenotypeSelector gs = (SDGenotypeSelector)carr[0];
                gs.setGenotype((LocusAndAlleles)this.ivVal);
            }
        }

        public void fillFromComponents(JComponent[] carr) {
            if (carr != null && carr.length >= 1) {
                SDGenotypeSelector gs = (SDGenotypeSelector)carr[0];
                this.ivVal = gs.getGenotype();
            }
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject(primaryObject, "MOS_LOCUSGENOTYPES");
        }

        public JComponent[] getDialogComponent() {
            return new JComponent[]{new SDGenotypeSelector()};
        }

        public void getValXML(StringBuilder msb) {
            if (this.ivVal != null) {
                msb.append(" ").append("val").append("=\"");
                msb.append(LocusAndAlleles.getTransportString(new LocusAndAlleles[]{(LocusAndAlleles)this.ivVal})).append("\"");
            }
        }

        public void iInit(XMLNode node) {
            LocusAndAlleles[] lalarr;
            this.ivVal = null;
            String vals = node.getAttributeValue("val", null);
            if (vals != null && (lalarr = LocusAndAlleles.decodeFromTransportString(vals)) != null && lalarr.length != 0) {
                this.ivVal = lalarr[0];
            }
        }

        public String getValueDisplay() {
            if (this.ivVal != null) {
                LocusAndAlleles lal = (LocusAndAlleles)this.ivVal;
                Locus locus = LocusManager.getLocus(lal.ivLocusID, UserManager.getFirstGroup());
                if (locus != null) {
                    if (lal.ivAllele == null) {
                        return String.valueOf(locus.getName()) + " " + Babel.get("SD_QUAL_JUST_NOT_SET");
                    }
                    return String.valueOf(locus.getName()) + " " + locus.getAllelString(lal);
                }
            }
            return "";
        }

        public String getTitle() {
            return Babel.get("FS_M_GENOTYPE");
        }

        public String getDescription() {
            return Babel.get("FS_M_GENOTYPE");
        }
    }

    public static class SearcherTissueSample
    extends MausoSearcherObject {
        public static final int[] TS_SET_QUALS = new int[]{1, 2, 3};

        public int[] getPossibleQuals() {
            return TS_SET_QUALS;
        }

        public boolean checkWithIndex(Long id, String index) {
            return true;
        }

        public boolean afterIndexCheckNecessary() {
            return true;
        }

        public void addWheres(Vector target, Vector columns) {
            columns.add("MOS_TISSUE");
        }

        public int iMatch(Object comparableObject, Object originalObject) {
            if (this.ivQual == 3) {
                if (this.ivVal != null && comparableObject != null && TissueSample.matchesTissue((String)comparableObject, (Integer)this.ivVal)) {
                    return 1;
                }
                return 2;
            }
            return super.iMatch(comparableObject, originalObject);
        }

        public boolean iiMatch(Object co) {
            LocusAndAlleles[] lalarr = (LocusAndAlleles[])co;
            int i = 0;
            while (i < lalarr.length) {
                if (this.ivVal.equals(lalarr[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public String getQualString(int qual) {
            if (qual == 3) {
                return Babel.get("TISSUE");
            }
            return super.getQualString(qual);
        }

        public void fillComponents(JComponent[] carr) {
            if (this.ivVal != null && carr != null && carr.length >= 1) {
                int sid = (Integer)this.ivVal;
                JComboBox jc = (JComboBox)carr[0];
                int ind = -1;
                int anz = jc.getItemCount();
                int i = 0;
                while (i < anz && ind == -1) {
                    ListDefinition ld = (ListDefinition)jc.getItemAt(i);
                    if (ld.ivID == sid) {
                        ind = i;
                    }
                    ++i;
                }
                if (ind != -1) {
                    jc.setSelectedIndex(ind);
                }
            }
        }

        public void fillFromComponents(JComponent[] carr) {
            if (carr != null && carr.length >= 1) {
                JComboBox jc = (JComboBox)carr[0];
                ListDefinition ld = (ListDefinition)jc.getSelectedItem();
                this.ivVal = new Integer(ld.ivID);
            }
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject(primaryObject, "MOS_TISSUE");
        }

        public JComponent[] getDialogComponent() {
            return new JComponent[]{new JComboBox(ListDefinition.getItems(UserManager.getGroupAndService(UserManager.getFirstGroup()), 2, false, false, false))};
        }

        public void getValXML(StringBuilder msb) {
            if (this.ivVal != null) {
                msb.append(" ").append("val").append("=\"");
                msb.append(this.ivVal.toString()).append("\"");
            }
        }

        public void iInit(XMLNode node) {
            this.ivVal = null;
            String vals = node.getAttributeValue("val", null);
            if (vals != null) {
                this.ivVal = new Integer(vals);
            }
        }

        public String getValueDisplay() {
            if (this.ivVal != null) {
                return ListDefinition.getName(UserManager.getFirstGroup(), 2, (Integer)this.ivVal, "");
            }
            return "";
        }

        public String getTitle() {
            return Babel.get("FS_M_TISSUE_SAMPLE");
        }

        public String getDescription() {
            return Babel.get("FS_M_TISSUE_SAMPLE");
        }
    }
}

