/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.server.export;

import de.hannse.netobjects.datalayer.DataFile;
import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectPortal;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.datalayer.DataLayerMausoleum;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.rack.Rack;
import mausoleum.util.InstallationType;

public abstract class DemoExporteur {
    public static final String EXPORT_DIR = "export";
    private static final String HTML_DIR = "HTML";
    private static final String[] DIRECT_COPY_FILES = new String[]{InstallationType.isMouse() ? "HTML/favicon.ico" : "HTML/faviconF.ico", InstallationType.isMouse() ? "HTML/home.html" : "HTML/homeF.html", "HTML/LOGIN.GIF", "HTML/key.gif"};
    private static final String[] INDIRECT_COPY_FILES = new String[]{InstallationType.isMouse() ? "data/mausoleum_demo.key" : "data/mausoleum_demo_fish.key", "mausoleum.key", InstallationType.isMouse() ? "data/mausoleum_demo.key" : "data/mausoleum_demo_fish.key", "HTML/mausoleum.key", "Server.jar", "Server.jar", "HTML/Client.jar", "Client.jar"};
    private static final String[] BATCHES = new String[]{"java -cp Server.jar mausoleum.main.MausoleumServer", "serverJar.bat", "java -cp Client.jar mausoleum.main.MausoleumClient", "clientJar.bat"};
    static /* synthetic */ Class class$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean importFromDemo(ObjectRequest or) {
        block12: {
            if (ProcessDefinition.isServer()) {
                String newGroupname = (String)or.ivObject;
                try {
                    or.ivObject = null;
                    byte[] data = (byte[])or.ivExtraObject;
                    or.ivExtraObject = null;
                    newGroupname = newGroupname.trim();
                    String[] gnarr = DataLayer.cvDataLayer.getGroupStringArray(false);
                    if (gnarr != null && gnarr.length != 0) {
                        int i = 0;
                        while (i < gnarr.length) {
                            if (newGroupname.equals(gnarr[i])) {
                                or.ivObject = "Group name is already in use";
                                return false;
                            }
                            ++i;
                        }
                    }
                    HashMap entries = FileManager.digestZIPBytes(data);
                    String newGroupDir = GroupFileManager.getGroupDir(newGroupname);
                    FileManager.prepareDirs(newGroupDir);
                    if (DataLayer.cvDataLayer instanceof DataLayerMausoleum) {
                        DataLayerMausoleum dlm = (DataLayerMausoleum)DataLayer.cvDataLayer;
                        ObjectPolisher polisher = new ObjectPolisher();
                        Iterator iter = entries.keySet().iterator();
                        while (true) {
                            int type;
                            if (!iter.hasNext()) {
                                GroupFileManager.prepareGroupDir(newGroupname);
                                dlm.initSingleGroupData(newGroupname);
                                dlm.storeGroupName(newGroupname);
                                break;
                            }
                            String filename = (String)iter.next();
                            FileManager.saveBytesToFile(String.valueOf(newGroupDir) + "/" + filename, (byte[])entries.get(filename));
                            if (!filename.endsWith(".data") || (type = IDObject.getTypeForStringServerSide(filename.substring(0, filename.length() - 5))) == -1) continue;
                            polisher.polish(newGroupname, type, String.valueOf(newGroupDir) + "/" + filename);
                        }
                    }
                    ObjectPortal.lookForGroup(newGroupname);
                    return true;
                }
                catch (Exception e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("mausoleum.server.export.DemoExporteur");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz2;
                    }
                    Log.error("Problem at import group from Demo", e, clazz);
                    or.ivObject = "Problem at import group from Demo";
                    if (newGroupname == null) break block12;
                    FileManager.deleteDir(GroupFileManager.getGroupDir(newGroupname), true);
                }
            }
        }
        return false;
    }

    public static boolean createDemo(ObjectRequest or) {
        if (or != null) {
            String group = or.ivGroup;
            if (group != null) {
                String origGroupDir = GroupFileManager.getGroupDir(group);
                if (new File(origGroupDir).exists()) {
                    boolean res;
                    String targetDirInExport = "Mausoleum_Demo_" + group + "_" + MilliSpender.getMillis();
                    String targetDirPath = "export/" + targetDirInExport;
                    FileManager.prepareDirs(targetDirPath);
                    FileManager.prepareDirs(String.valueOf(targetDirPath) + "/" + HTML_DIR);
                    int i = 0;
                    while (i < DIRECT_COPY_FILES.length) {
                        res = FileManager.copyAlsoFromJar(DIRECT_COPY_FILES[i], String.valueOf(targetDirPath) + "/" + DIRECT_COPY_FILES[i]);
                        if (!res) {
                            or.ivObject = "Couldnt copy file: " + DIRECT_COPY_FILES[i];
                            return false;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < INDIRECT_COPY_FILES.length) {
                        res = FileManager.copyAlsoFromJar(INDIRECT_COPY_FILES[i], String.valueOf(targetDirPath) + "/" + INDIRECT_COPY_FILES[i + 1]);
                        if (!res) {
                            or.ivObject = "Couldnt copy file: " + INDIRECT_COPY_FILES[i];
                            return false;
                        }
                        i += 2;
                    }
                    i = 0;
                    while (i < BATCHES.length) {
                        res = FileManager.saveStringToFile(String.valueOf(targetDirPath) + "/" + BATCHES[i + 1], BATCHES[i]);
                        if (!res) {
                            or.ivObject = "Couldnt create batch file: " + BATCHES[i + 1];
                            return false;
                        }
                        i += 2;
                    }
                    String newGroupDirTarget = String.valueOf(targetDirPath) + "/" + origGroupDir;
                    FileManager.prepareDirs(newGroupDirTarget);
                    FileManager.copyDir(origGroupDir, newGroupDirTarget, true);
                    if (!DemoExporteur.removeServiceStuff(group, targetDirPath)) {
                        or.ivObject = "Couldn't remove Service group implications";
                        return false;
                    }
                    String zipFilePath = String.valueOf(targetDirPath) + ".zip";
                    FileManager.zip(targetDirPath, zipFilePath, null, null);
                    FileManager.deleteDir(targetDirPath, true);
                    or.ivObject = zipFilePath;
                    if (or.ivObject != null && or.ivObject instanceof String) {
                        return true;
                    }
                    or.ivObject = "The zip-File couldn't be created";
                } else {
                    or.ivObject = "The group couldn't be found";
                }
            } else {
                or.ivObject = "Missing group";
            }
        }
        return false;
    }

    private static boolean removeServiceStuff(String group, String groupfilestarget) {
        if (!DemoExporteur.removeServiceStuff(group, groupfilestarget, 3)) {
            return false;
        }
        return DemoExporteur.removeServiceStuff(group, groupfilestarget, 10);
    }

    private static boolean removeServiceStuff(String group, String groupfilestarget, int objTyp) {
        DataFile df = new DataFile(group, objTyp, String.valueOf(groupfilestarget) + "/" + GroupFileManager.getDataFilePath(group, IDObject.getFilenameForTypeServerSide(objTyp)));
        try {
            Hashtable ht = df.getAllObjects();
            Iterator iter = ht.values().iterator();
            while (iter.hasNext()) {
                Rack rack;
                boolean changed = false;
                IDObject ido = (IDObject)iter.next();
                if (ido.get("IDO_SERVID") != null) {
                    ido.set("IDO_SERVID", null);
                    changed = true;
                }
                if (ido instanceof Rack && (rack = (Rack)ido).get("RCK_OCC") != null) {
                    ido.set("RCK_OCC", null);
                    changed = true;
                }
                if (!changed) continue;
                ido.commit(true);
                df.putObject(ido);
            }
            return true;
        }
        catch (Exception e) {
            String string = "Problem bei removeServiceStuff " + objTyp;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.server.export.DemoExporteur");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
            return false;
        }
    }

    public static class ObjectPolisher
    implements ObjectConsumer {
        private String ivNewGroupName;
        private DataFile ivDatafile;

        public void polish(String newGroupname, int type, String path) {
            this.ivDatafile = new DataFile(newGroupname, type, path);
            this.ivNewGroupName = newGroupname;
            this.ivDatafile.giveAllObjectsToConsumer(this);
            this.ivDatafile = null;
        }

        public void handleNewObjects(Vector idObjects) {
            Iterator iterator = idObjects.iterator();
            while (iterator.hasNext()) {
                this.handleNewObject((IDObject)iterator.next());
            }
        }

        public void handleNewObject(IDObject ido) {
            ObjectPolisher.polishImportObject(ido, this.ivNewGroupName);
            ido.commit(false);
            this.ivDatafile.putObject(ido);
        }

        public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        }

        private static void polishImportObject(IDObject ido, String newGroupname) {
            TreeSet ts;
            String oldGroup = ido.getGroup();
            ido.set("IDO_GROUP", newGroupname);
            if (ido.get("IDO_SERVID") != null) {
                ido.set("IDO_SERVID", null);
            }
            if (ido instanceof Rack) {
                ido.set("RCK_OCC", null);
            }
            if (ido instanceof Mouse) {
                ObjectPolisher.polishTaskArray(ido, "MOS_TASKSEXT", oldGroup, newGroupname);
            }
            if (ido instanceof User) {
                ObjectPolisher.polishTaskArray(ido, "USR_TASKS", oldGroup, newGroupname);
            }
            if ((ts = ido.getSessions()) != null) {
                TreeSet<Long> realSessions = new TreeSet<Long>();
                Iterator iter = ts.iterator();
                while (iter.hasNext()) {
                    Long sid = (Long)iter.next();
                    if (sid <= 0L) continue;
                    realSessions.add(sid);
                }
                ido.setSessions(realSessions);
            }
        }

        private static void polishTaskArray(IDObject ido, String taskKey, String oldGroup, String newGroupname) {
            TaskExtended[] tarr = (TaskExtended[])ido.get(taskKey);
            if (tarr != null) {
                Vector<TaskExtended> ntv = new Vector<TaskExtended>();
                int i = 0;
                while (i < tarr.length) {
                    TaskExtended tx = tarr[i];
                    if (tx != null) {
                        if (oldGroup.equals(tx.ivErledigerGroup)) {
                            tx.ivErledigerGroup = newGroupname;
                        } else {
                            tx.ivErledigerGroup = null;
                            tx.ivErledigerID = 0L;
                        }
                        if (oldGroup.equals(tx.ivFavoritGroup)) {
                            tx.ivFavoritGroup = newGroupname;
                        } else {
                            tx.ivFavoritGroup = null;
                            tx.ivFavoritID = 0L;
                        }
                        if (oldGroup.equals(tx.ivIssuerGroup)) {
                            tx.ivIssuerGroup = newGroupname;
                        } else {
                            tx.ivIssuerGroup = null;
                            tx.ivIssuerID = 0L;
                        }
                        ntv.add(tx);
                    }
                    ++i;
                }
                TaskExtended[] ntarr = null;
                if (!ntv.isEmpty()) {
                    ntarr = new TaskExtended[ntv.size()];
                    int i2 = 0;
                    while (i2 < ntv.size()) {
                        ntarr[i2] = (TaskExtended)ntv.elementAt(i2);
                        ++i2;
                    }
                }
                ido.set(taskKey, ntarr);
            }
        }
    }
}

