/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.server.export;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableSheet;
import mausoleum.datalayer.DataLayerMausoleum;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.gui.MusterColor;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.mouse.Mouse;
import mausoleum.rack.Rack;
import mausoleum.rack.RackPos;
import mausoleum.result.GPSCoordinates;
import mausoleum.result.ResultObjectImage;
import mausoleum.server.export.CageSheet;
import mausoleum.server.export.ExcelReadAfterBurner;
import mausoleum.server.export.ExperimentSheet;
import mausoleum.server.export.IDObjectGroupSheet;
import mausoleum.server.export.LicenseSheet;
import mausoleum.server.export.LineAllelesSheet;
import mausoleum.server.export.LineSheet;
import mausoleum.server.export.LocusSheet;
import mausoleum.server.export.MailSheet;
import mausoleum.server.export.MouseGenotypeSheet;
import mausoleum.server.export.MouseSheet;
import mausoleum.server.export.MouseStrainSheet;
import mausoleum.server.export.RackSheet;
import mausoleum.server.export.ResultSheet;
import mausoleum.server.export.RoomSheet;
import mausoleum.server.export.SessionCommandSheet;
import mausoleum.server.export.SessionSheet;
import mausoleum.server.export.SonderObjectReader;
import mausoleum.server.export.StrainSheet;
import mausoleum.server.export.TasksSheet;
import mausoleum.server.export.UserSheet;
import mausoleum.server.export.VisitSheet;
import mausoleum.task.standards.StandardTask;
import mausoleum.util.PathStore;

public class ExcelManager {
    public static final String HEADER_ID = "ID";
    public static final String HEADER_START = "START";
    public static final String HEADER_END = "END";
    public static final String HEADER_UNIQUELONG = "UNIQUE";
    public static final String HEADER_VISIBLE = "VISIBLE";
    public static final String HEADER_FOREIGN_KEY = "FOREIGN_KEY";
    public static final String HEADER_SESSION_IDS = "SESSION_IDS";
    public static final String[] HEADERS1 = new String[]{"ID", "START", "END"};
    public static final String[] HEADERS2 = new String[]{"UNIQUE", "VISIBLE", "FOREIGN_KEY", "SESSION_IDS"};
    private static final String[] PRIMARY_TABLES = new String[]{"users", "loci", "lines", "strains", "rooms", "racks", "cages", "mice", "mail", "experiments", "mouse_results", "licenses", "object_groups", "sessions"};
    public static final String HT_VISITS_BY_CAGE = "HT_VISITS_BY_CAGE";
    public static final String HT_VISITS_BY_MOUSE = "HT_VISITS_BY_MOUSE";
    public static final String HT_LINE_ALLELES = "HT_LINE_ALLELES";
    public static final String HT_MOUSE_STRAINS = "HT_MOUSE_STRAINS";
    public static final String HT_MOUSE_TASKS = "HT_MOUSE_TASKS";
    public static final String HT_CAGE_TASKS = "HT_CAGE_TASKS";
    public static final String HT_MOUSE_GENOTYPES = "HT_MOUSE_GENOTYPES";
    public static final String HT_SESSION_COMMANDS = "HT_SESSION_COMMANDS";
    public static final String HT_MOUSE_RESULTS = "HT_MOUSE_RESULTS";
    public static HashMap cvDict = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;

    static {
        cvDict = new HashMap(10);
        cvDict.put(HEADER_ID, "IDO_ID");
        cvDict.put(HEADER_START, "IDO_START_DATE");
        cvDict.put(HEADER_END, "IDO_END_DATE");
        cvDict.put(HEADER_UNIQUELONG, "IDO_UNIQUELONG");
        cvDict.put(HEADER_VISIBLE, "IDO_VISIBLE");
        cvDict.put(HEADER_FOREIGN_KEY, "IDO_FKEY");
        cvDict.put(HEADER_SESSION_IDS, HEADER_SESSION_IDS);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage ExcelManager [FILE]");
            System.exit(1);
        }
        try {
            Workbook wb = Workbook.getWorkbook(new File(args[0]));
            if (wb != null) {
                Sheet[] sheets = wb.getSheets();
                int i = 0;
                while (i < sheets.length) {
                    String sname = sheets[i].getName().toLowerCase().trim();
                    System.out.println(sname);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean readGroupFromExcel(byte[] data, String groupname, StringBuffer errorBuffer) {
        String path = String.valueOf(PathStore.getServerDir()) + "/test.xls";
        FileManager.saveBytesToFile(path, data);
        try {
            HashMap<String, Sheet> sheetsByLabel = new HashMap<String, Sheet>(20);
            Vector<String> sheetNames = new Vector<String>();
            Workbook wb = Workbook.getWorkbook(new File(path));
            if (wb != null) {
                Sheet[] sheets = wb.getSheets();
                int i = 0;
                while (true) {
                    if (i >= sheets.length) break;
                    String sname = sheets[i].getName().toLowerCase().trim();
                    sheetsByLabel.put(sname, sheets[i]);
                    sheetNames.add(sname);
                    ++i;
                }
                boolean gef = false;
                int i2 = 0;
                while (true) {
                    if (i2 >= PRIMARY_TABLES.length) {
                        if (gef) break;
                        errorBuffer.append("No valid input sheet found. Please try saving as Excel 2000 or on a windows system");
                        return false;
                    }
                    if (sheetsByLabel.get(PRIMARY_TABLES[i2].toLowerCase().trim()) != null) {
                        gef = true;
                    }
                    ++i2;
                }
                if (!(DataLayer.cvDataLayer instanceof DataLayerMausoleum)) {
                    errorBuffer.append("Unsupported Data layer!");
                    return false;
                }
                DataLayerMausoleum dlfs = (DataLayerMausoleum)DataLayer.cvDataLayer;
                if (!dlfs.addGroup(groupname, null)) {
                    errorBuffer.append("Group could not be created");
                    return false;
                }
                HashMap sonderObjects = new HashMap();
                ExcelManager.checkExtraSheets("visits", VisitSheet.cvCols, sonderObjects, VisitSheet.SERVED_EXTRA_HASHMAPS, new VisitSheet(), sheetNames, sheetsByLabel);
                ExcelManager.checkExtraSheets("line_alleles", LineAllelesSheet.cvCols, sonderObjects, LineAllelesSheet.SERVED_EXTRA_HASHMAPS, new LineAllelesSheet(), sheetNames, sheetsByLabel);
                ExcelManager.checkExtraSheets("mouse_genotypes", MouseGenotypeSheet.cvCols, sonderObjects, MouseGenotypeSheet.SERVED_EXTRA_HASHMAPS, new MouseGenotypeSheet(), sheetNames, sheetsByLabel);
                ExcelManager.checkExtraSheets("mouse_strains", MouseStrainSheet.cvCols, sonderObjects, MouseStrainSheet.SERVED_EXTRA_HASHMAPS, new MouseStrainSheet(), sheetNames, sheetsByLabel);
                ExcelManager.checkExtraSheets("mouse_results", ResultSheet.cvCols, sonderObjects, ResultSheet.SERVED_EXTRA_HASHMAPS, new ResultSheet(), sheetNames, sheetsByLabel);
                ExcelManager.checkExtraSheets("tasks", TasksSheet.cvCols, sonderObjects, TasksSheet.SERVED_EXTRA_HASHMAPS, new TasksSheet(), sheetNames, sheetsByLabel);
                ExcelManager.checkExtraSheets("session_commands", SessionCommandSheet.cvCols, sonderObjects, SessionCommandSheet.SERVED_EXTRA_HASHMAPS, new SessionCommandSheet(), sheetNames, sheetsByLabel);
                HashMap mice = new HashMap(3000);
                HashMap cages = new HashMap(3000);
                HashMap racks = new HashMap(50);
                ExcelManager.checkSheets("users", UserSheet.cvCols, 6, UserSheet.cvDict, sheetNames, sheetsByLabel, null, sonderObjects, dlfs, groupname, null);
                ExcelManager.checkSheets("loci", LocusSheet.cvCols, 14, LocusSheet.cvDict, sheetNames, sheetsByLabel, null, sonderObjects, dlfs, groupname, null);
                ExcelManager.checkSheets("lines", LineSheet.cvCols, 7, LineSheet.cvDict, sheetNames, sheetsByLabel, new LineSheet(), sonderObjects, dlfs, groupname, null);
                ExcelManager.checkSheets("strains", StrainSheet.cvCols, 8, StrainSheet.cvDict, sheetNames, sheetsByLabel, null, sonderObjects, dlfs, groupname, null);
                ExcelManager.checkSheets("rooms", RoomSheet.cvCols, 10, RoomSheet.cvDict, sheetNames, sheetsByLabel, null, sonderObjects, dlfs, groupname, null);
                ExcelManager.checkSheets("racks", RackSheet.cvCols, 3, RackSheet.cvDict, sheetNames, sheetsByLabel, null, sonderObjects, dlfs, groupname, racks);
                ExcelManager.checkSheets("cages", CageSheet.cvCols, 2, CageSheet.cvDict, sheetNames, sheetsByLabel, new CageSheet(), sonderObjects, dlfs, groupname, cages);
                ExcelManager.checkSheets("mice", MouseSheet.cvCols, 1, MouseSheet.cvDict, sheetNames, sheetsByLabel, new MouseSheet(), sonderObjects, dlfs, groupname, mice);
                ExcelManager.checkSheets("mail", MailSheet.cvCols, 11, MailSheet.cvDict, sheetNames, sheetsByLabel, null, sonderObjects, dlfs, groupname, null);
                ExcelManager.checkSheets("experiments", ExperimentSheet.cvCols, 12, ExperimentSheet.cvDict, sheetNames, sheetsByLabel, new ExperimentSheet(), sonderObjects, dlfs, groupname, null);
                ExcelManager.checkSheets("licenses", LicenseSheet.cvCols, 16, LicenseSheet.cvDict, sheetNames, sheetsByLabel, new LicenseSheet(), sonderObjects, dlfs, groupname, null);
                ExcelManager.checkSheets("object_groups", IDObjectGroupSheet.cvCols, 19, IDObjectGroupSheet.cvDict, sheetNames, sheetsByLabel, null, sonderObjects, dlfs, groupname, null);
                ExcelManager.checkSheets("sessions", SessionSheet.cvCols, 5, SessionSheet.cvDict, sheetNames, sheetsByLabel, new SessionSheet(), sonderObjects, dlfs, groupname, null);
                ExcelManager.checkMice(mice, dlfs);
                ExcelManager.checkRacks(racks, cages, dlfs);
                Vector standardTasks = ExcelManager.checkStringMatrixSheet("standard_tasks", sheetNames, sheetsByLabel);
                if (standardTasks != null) {
                    StandardTask.readExcelVector(standardTasks, groupname);
                }
                Vector defilists = ExcelManager.checkStringMatrixSheet("list_definitions", sheetNames, sheetsByLabel);
                if (standardTasks != null) {
                    ListDefinition.readExcelVector(defilists, groupname);
                }
            }
            FileManager.deleteFile(path);
            return true;
        }
        catch (Throwable e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("mausoleum.server.export.ExcelManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            Log.error("Problem bei Excel-Import", e, clazz);
            return false;
        }
    }

    protected static void add(String[] arr, Vector v) {
        if (arr != null && v != null) {
            int i = 0;
            while (i < arr.length) {
                v.add(arr[i]);
                ++i;
            }
        }
    }

    protected static void add(HashMap source, HashMap target) {
        if (source != null && target != null) {
            Iterator iter = source.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                target.put(key, source.get(key));
            }
        }
    }

    private static void checkMice(HashMap mice, DataLayerMausoleum dlfs) {
        Iterator iter = mice.keySet().iterator();
        while (iter.hasNext()) {
            Long motherID;
            Long id = (Long)iter.next();
            Mouse mouse = (Mouse)mice.get(id);
            Long fatherID = (Long)mouse.get("MOS_FATHER");
            if (fatherID != null) {
                Mouse father = (Mouse)mice.get(fatherID);
                if (father == null) {
                    mouse.set("MOS_FATHER", null);
                    mouse.commit(true);
                    dlfs.saveIDObject(mouse);
                } else {
                    ExcelManager.checkPresenceOfKid(father, id, dlfs);
                }
            }
            if ((motherID = (Long)mouse.get("MOS_MOTHER")) == null) continue;
            Mouse mother = (Mouse)mice.get(motherID);
            if (mother == null) {
                mouse.set("MOS_MOTHER", null);
                mouse.commit(true);
                dlfs.saveIDObject(mouse);
                continue;
            }
            ExcelManager.checkPresenceOfKid(mother, id, dlfs);
        }
    }

    private static void checkPresenceOfKid(Mouse parent, long kidID, DataLayerMausoleum dlfs) {
        long[] kidIDs = (long[])parent.get("MOS_KID");
        if (kidIDs == null) {
            kidIDs = new long[]{kidID};
            parent.set("MOS_KID", kidIDs);
            parent.commit(true);
            dlfs.saveIDObject(parent);
        } else {
            boolean da = false;
            int i = 0;
            while (i < kidIDs.length) {
                if (kidIDs[i] == kidID) {
                    da = true;
                }
                ++i;
            }
            if (!da) {
                long[] nkidids = new long[kidIDs.length + 1];
                int i2 = 0;
                while (i2 < kidIDs.length) {
                    nkidids[i2] = kidIDs[i2];
                    ++i2;
                }
                nkidids[nkidids.length - 1] = kidID;
                parent.set("MOS_KID", nkidids);
                parent.commit(true);
                dlfs.saveIDObject(parent);
            }
        }
    }

    private static void checkRacks(HashMap racks, HashMap cages, DataLayerMausoleum dlfs) {
        Iterator iter = racks.keySet().iterator();
        while (iter.hasNext()) {
            Long id = (Long)iter.next();
            Rack rack = (Rack)racks.get(id);
            boolean didSth = false;
            int arraySize = rack.getArraySize();
            long[] arr = (long[])rack.get("RCK_CAGES");
            if (arraySize == 0) {
                if (arr != null) {
                    rack.set("RCK_CAGES", null);
                    didSth = true;
                }
            } else {
                if (arr != null && arr.length != arraySize) {
                    arr = null;
                }
                if (arr == null) {
                    arr = new long[arraySize];
                    rack.set("RCK_CAGES", arr);
                    didSth = true;
                }
                int i = 0;
                while (i < arr.length) {
                    if (arr[i] != 0L && cages.get(new Long(arr[i])) == null) {
                        arr[i] = 0L;
                        didSth = true;
                    }
                    ++i;
                }
            }
            if (!didSth) continue;
            rack.commit(true);
            dlfs.saveIDObject(rack);
        }
    }

    private static Vector checkStringMatrixSheet(String sheetNamePrefix, Vector sheetNames, HashMap sheetsByLabel) {
        Iterator iter = sheetNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.toLowerCase().trim().startsWith(sheetNamePrefix.toLowerCase().trim())) continue;
            Sheet sheet = (Sheet)sheetsByLabel.get(name);
            Vector lines = new Vector();
            int row = 0;
            while (row < sheet.getRows()) {
                Vector<String> line = new Vector<String>();
                lines.add(line);
                int col = 0;
                while (col < sheet.getColumns()) {
                    Cell cell = sheet.getCell(col, row);
                    if (cell != null) {
                        String cont = cell.getContents();
                        if (cont != null) {
                            line.add(cont);
                        } else {
                            line.add("");
                        }
                    }
                    ++col;
                }
                ++row;
            }
            return lines;
        }
        return null;
    }

    protected static void checkSheets(String sheetNamePrefix, Vector potHeaders, int typ, HashMap headerDict, Vector sheetNames, HashMap sheetsByLabel, ExcelReadAfterBurner afterBurner, HashMap sonderObjects, DataLayerMausoleum dlfs, String groupname, HashMap neuObjektSammler) {
        Iterator iter = sheetNames.iterator();
        while (iter.hasNext()) {
            Sheet sheet;
            Vector headers;
            String name = (String)iter.next();
            if (!name.toLowerCase().trim().startsWith(sheetNamePrefix.toLowerCase().trim()) || (headers = ExcelManager.getColumnTitels(sheet = (Sheet)sheetsByLabel.get(name), potHeaders)) == null) continue;
            int row = 1;
            while (row < sheet.getRows()) {
                Object key;
                IDObject ido = ExcelManager.createIDObject(sheet, row, typ, headers, headerDict, afterBurner, sonderObjects, groupname, dlfs);
                if (ido != null && neuObjektSammler != null && (key = ido.get("IDO_ID")) != null) {
                    neuObjektSammler.put(key, ido);
                }
                ++row;
            }
        }
    }

    protected static void checkExtraSheets(String sheetNamePrefix, Vector potHeaders, HashMap sonderObjects, String[] servedSonderObjects, SonderObjectReader reader, Vector sheetNames, HashMap sheetsByLabel) {
        int i = 0;
        while (i < servedSonderObjects.length) {
            sonderObjects.put(servedSonderObjects[i], new HashMap());
            ++i;
        }
        Iterator iter = sheetNames.iterator();
        while (iter.hasNext()) {
            Sheet sheet;
            Vector headers;
            String name = (String)iter.next();
            if (!name.toLowerCase().trim().startsWith(sheetNamePrefix.toLowerCase().trim()) || (headers = ExcelManager.getColumnTitels(sheet = (Sheet)sheetsByLabel.get(name), potHeaders)) == null) continue;
            int row = 1;
            while (row < sheet.getRows()) {
                reader.readSonderLine(sheet, row, headers, sonderObjects);
                ++row;
            }
        }
    }

    protected static Vector getColumnTitels(Sheet sheet, Vector potHeaders) {
        Vector<String> res = new Vector<String>();
        int col = 0;
        while (col < sheet.getColumns()) {
            String rein = "";
            Cell cell = sheet.getCell(col, 0);
            if (cell != null) {
                String cont = cell.getContents();
                int i = 0;
                while (i < potHeaders.size()) {
                    if (cont.equalsIgnoreCase((String)potHeaders.elementAt(i))) {
                        rein = (String)potHeaders.elementAt(i);
                    }
                    ++i;
                }
            }
            res.add(rein);
            ++col;
        }
        return res;
    }

    protected static IDObject createIDObject(Sheet sheet, int row, int typ, Vector colNames, HashMap headerDict, ExcelReadAfterBurner afterBurner, HashMap sonderObjects, String groupname, DataLayerMausoleum dlfs) {
        IDObject ido = IDObject.giveNewObjectOfType(typ);
        boolean warWas = false;
        int col = 0;
        while (col < colNames.size()) {
            String header = (String)colNames.elementAt(col);
            if (header != null && header.length() != 0) {
                if (header.equals(HEADER_SESSION_IDS)) {
                    String cont;
                    Cell cell;
                    if (!(ido instanceof Session) && (cell = sheet.getCell(col, row)) != null && (cont = cell.getContents()) != null) {
                        Vector v = StringHelper.splitStringByAny(cont, "|");
                        Iterator iter = v.iterator();
                        while (iter.hasNext()) {
                            String s = (String)iter.next();
                            try {
                                ido.addSession(new Long(s));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                } else {
                    Object val;
                    String cont;
                    Cell cell;
                    Class cl = ExcelManager.getClass(header, ido, headerDict);
                    if (cl != null && (cell = sheet.getCell(col, row)) != null && (cont = cell.getContents()) != null && (val = ExcelManager.getObject(cont, cl)) != null) {
                        ido.set((String)headerDict.get(header), val);
                        warWas = true;
                    }
                }
            }
            ++col;
        }
        if (warWas) {
            ido.set("IDO_GROUP", groupname);
            Boolean b = (Boolean)ido.get("IDO_VISIBLE");
            if (b != null && b.booleanValue()) {
                ido.set("IDO_VISIBLE", null);
            }
            if (afterBurner != null) {
                afterBurner.alterObject(ido, sheet, row, colNames, sonderObjects);
            }
            ido.commit(true);
            dlfs.saveIDObject(ido);
            return ido;
        }
        return null;
    }

    protected static Class getClass(String header, IDObject ido, HashMap headerDict) {
        String key;
        if (header != null && header.length() != 0 && (key = (String)headerDict.get(header)) != null) {
            return ido.getClass(key);
        }
        return null;
    }

    protected static void handle(Object o, int row, int col, WritableSheet sheet) {
        block39: {
            if (o != null) {
                try {
                    if (o instanceof String) {
                        sheet.addCell(new Label(col, row, (String)o));
                        break block39;
                    }
                    if (o instanceof Character) {
                        Character character = (Character)o;
                        char c = character.charValue();
                        if (c == '\u0001') {
                            sheet.addCell(new Label(col, row, "1"));
                        } else if (c != '\u0000') {
                            sheet.addCell(new Label(col, row, Character.toString(c)));
                        }
                        break block39;
                    }
                    if (o instanceof Integer) {
                        sheet.addCell(new Label(col, row, o.toString()));
                        break block39;
                    }
                    if (o instanceof Double) {
                        sheet.addCell(new Label(col, row, o.toString()));
                        break block39;
                    }
                    if (o instanceof Long) {
                        sheet.addCell(new Label(col, row, o.toString()));
                        break block39;
                    }
                    if (o instanceof Date) {
                        Date d = (Date)o;
                        sheet.addCell(new Label(col, row, DatumFormat.getDateTimeString(d.getTime())));
                        break block39;
                    }
                    if (o instanceof Boolean) {
                        Boolean b = (Boolean)o;
                        if (b.booleanValue()) {
                            sheet.addCell(new Label(col, row, "yes"));
                        } else {
                            sheet.addCell(new Label(col, row, "no"));
                        }
                        break block39;
                    }
                    if (o instanceof Color) {
                        StringBuffer msb = new StringBuffer();
                        if (o instanceof MusterColor) {
                            MusterColor mc = (MusterColor)o;
                            Color color = mc;
                            msb.append(color.getRed()).append("|");
                            msb.append(color.getGreen()).append("|");
                            msb.append(color.getBlue()).append("|");
                            color = mc.ivSecondColor;
                            msb.append(color.getRed()).append("|");
                            msb.append(color.getGreen()).append("|");
                            msb.append(color.getBlue()).append("|");
                            msb.append(mc.ivMuster);
                        } else {
                            Color color = (Color)o;
                            msb.append(color.getRed()).append("|");
                            msb.append(color.getGreen()).append("|");
                            msb.append(color.getBlue());
                        }
                        sheet.addCell(new Label(col, row, msb.toString()));
                        break block39;
                    }
                    if (o instanceof String[]) {
                        String[] arr = (String[])o;
                        StringBuffer msb = new StringBuffer();
                        int i = 0;
                        while (i < arr.length) {
                            if (i != 0) {
                                msb.append("|");
                            }
                            msb.append(arr[i]);
                            ++i;
                        }
                        sheet.addCell(new Label(col, row, msb.toString()));
                        break block39;
                    }
                    if (o instanceof int[]) {
                        int[] arr = (int[])o;
                        StringBuffer msb = new StringBuffer();
                        int i = 0;
                        while (i < arr.length) {
                            if (i != 0) {
                                msb.append(",");
                            }
                            msb.append(arr[i]);
                            ++i;
                        }
                        sheet.addCell(new Label(col, row, msb.toString()));
                        break block39;
                    }
                    if (o instanceof long[]) {
                        long[] arr = (long[])o;
                        StringBuffer msb = new StringBuffer();
                        int i = 0;
                        while (i < arr.length) {
                            if (i != 0) {
                                msb.append(",");
                            }
                            msb.append(arr[i]);
                            ++i;
                        }
                        sheet.addCell(new Label(col, row, msb.toString()));
                        break block39;
                    }
                    if (o instanceof Object[]) {
                        Object[] arr = (Object[])o;
                        StringBuffer msb = new StringBuffer();
                        int i = 0;
                        while (i < arr.length) {
                            if (i != 0) {
                                msb.append("|");
                            }
                            msb.append(arr[i].toString());
                            ++i;
                        }
                        sheet.addCell(new Label(col, row, msb.toString()));
                        break block39;
                    }
                    if (o instanceof RackPos) {
                        RackPos d = (RackPos)o;
                        sheet.addCell(new Label(col, row, String.valueOf(d.ivRackID) + "|" + d.ivSide + "|" + d.ivRow + "|" + d.ivColumn));
                        break block39;
                    }
                    if (o instanceof GPSCoordinates) {
                        GPSCoordinates gc = (GPSCoordinates)o;
                        sheet.addCell(new Label(col, row, gc.getAddrString()));
                        break block39;
                    }
                    if (o instanceof ResultObjectImage) {
                        sheet.addCell(new Label(col, row, "- Images are not supported -"));
                        break block39;
                    }
                    String string = "Unknown object: " + o.getClass().getName();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.server.export.ExcelManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, null, clazz);
                }
                catch (Exception e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.server.export.ExcelManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Problem bei handle ", e, clazz);
                }
            }
        }
    }

    protected static Object getObject(Sheet sheet, int col, int row, Class cl) {
        String cont;
        Cell cell = sheet.getCell(col, row);
        if (cell != null && (cont = cell.getContents()) != null) {
            return ExcelManager.getObject(cont, cl);
        }
        return null;
    }

    protected static Object getObject(String s, Class cl) {
        block97: {
            if (cl == null) {
                String string = "Missing class at getObject for String >" + s + "<";
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.server.export.ExcelManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn(string, clazz);
                return null;
            }
            if (s != null && (s = s.trim()).length() != 0) {
                try {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz)) {
                        return s;
                    }
                    Class<?> clazz2 = class$2;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$2 = Class.forName("java.lang.Character");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz2)) {
                        if (s.equals("1")) {
                            return new Character('\u0001');
                        }
                        if (s.length() == 1) {
                            return new Character(s.charAt(0));
                        }
                        break block97;
                    }
                    Class<?> clazz3 = class$3;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$3 = Class.forName("java.lang.Integer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz3)) {
                        return new Integer(s);
                    }
                    Class<?> clazz4 = class$4;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$4 = Class.forName("java.lang.Double");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz4)) {
                        return new Double(s);
                    }
                    Class<?> clazz5 = class$5;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$5 = Class.forName("java.lang.Long");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz5)) {
                        return new Long(s);
                    }
                    Class<?> clazz6 = class$6;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$6 = Class.forName("java.util.Date");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz6)) {
                        return MyDate.getDateFromExcelDateString(s);
                    }
                    Class<?> clazz7 = class$7;
                    if (clazz7 == null) {
                        try {
                            clazz7 = class$7 = Class.forName("java.lang.Boolean");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz7)) {
                        if (s.equalsIgnoreCase("yes")) {
                            return new Boolean(true);
                        }
                        if (s.equalsIgnoreCase("no")) {
                            return new Boolean(false);
                        }
                        break block97;
                    }
                    Class<?> clazz8 = class$8;
                    if (clazz8 == null) {
                        try {
                            clazz8 = class$8 = Class.forName("java.awt.Color");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz8)) {
                        Zeile z = new Zeile(s, '|');
                        if (z.size() == 3) {
                            return new Color(z.getInt(0, 0), z.getInt(1, 0), z.getInt(2, 0));
                        }
                        if (z.size() == 7) {
                            Color c1 = new Color(z.getInt(0, 0), z.getInt(1, 0), z.getInt(2, 0));
                            Color c2 = new Color(z.getInt(3, 0), z.getInt(4, 0), z.getInt(5, 0));
                            return new MusterColor(c1, c2, z.getInt(6, 0));
                        }
                        break block97;
                    }
                    Class<?> clazz9 = class$9;
                    if (clazz9 == null) {
                        try {
                            clazz9 = class$9 = Class.forName("[Ljava.lang.String;");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz9)) {
                        Zeile z = new Zeile(s, '|');
                        String[] res = new String[z.size()];
                        int i = 0;
                        while (i < res.length) {
                            res[i] = z.getString(i, "");
                            ++i;
                        }
                        return res;
                    }
                    Class<?> clazz10 = class$10;
                    if (clazz10 == null) {
                        try {
                            clazz10 = class$10 = Class.forName("[I");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz10)) {
                        Zeile z = new Zeile(s, ',');
                        int[] res = new int[z.size()];
                        int i = 0;
                        while (i < res.length) {
                            res[i] = z.getInt(i, 0);
                            ++i;
                        }
                        return res;
                    }
                    Class<?> clazz11 = class$11;
                    if (clazz11 == null) {
                        try {
                            clazz11 = class$11 = Class.forName("[J");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz11)) {
                        if (s.length() != 0) {
                            Zeile z = new Zeile(s, ',');
                            long[] res = new long[z.size()];
                            int i = 0;
                            while (i < res.length) {
                                res[i] = z.getLong(i, 0L);
                                ++i;
                            }
                            return res;
                        }
                        break block97;
                    }
                    Class<?> clazz12 = class$12;
                    if (clazz12 == null) {
                        try {
                            clazz12 = class$12 = Class.forName("mausoleum.result.GPSCoordinates");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz12)) {
                        if (s.length() == 0) break block97;
                        try {
                            return new GPSCoordinates(s);
                        }
                        catch (Exception e) {
                            String string = "Malformed GPS-Coordinates " + s + ": " + e.getMessage();
                            Class<?> clazz13 = class$0;
                            if (clazz13 == null) {
                                try {
                                    clazz13 = class$0 = Class.forName("mausoleum.server.export.ExcelManager");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, null, clazz13);
                            break block97;
                        }
                    }
                    Class<?> clazz14 = class$13;
                    if (clazz14 == null) {
                        try {
                            clazz14 = class$13 = Class.forName("mausoleum.rack.RackPos");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz14)) {
                        Zeile z = new Zeile(s, '|');
                        return new RackPos(z.getLong(0, 0L), z.getInt(1, 0), z.getInt(2, 0), z.getInt(3, 0));
                    }
                    Class<?> clazz15 = class$14;
                    if (clazz15 == null) {
                        try {
                            clazz15 = class$14 = Class.forName("[Ljava.lang.Object;");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz15)) {
                        String string = "Object[] not supported for Excel import (might be OK)" + s;
                        Class<?> clazz16 = class$0;
                        if (clazz16 == null) {
                            try {
                                clazz16 = class$0 = Class.forName("mausoleum.server.export.ExcelManager");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.warn(string, clazz16);
                        break block97;
                    }
                    Class<?> clazz17 = class$15;
                    if (clazz17 == null) {
                        try {
                            clazz17 = class$15 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz17)) {
                        String string = "Object not supported for Excel import (might be OK) " + s;
                        Class<?> clazz18 = class$0;
                        if (clazz18 == null) {
                            try {
                                clazz18 = class$0 = Class.forName("mausoleum.server.export.ExcelManager");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.warn(string, clazz18);
                        break block97;
                    }
                    String string = "Unknown class at getObject " + cl.getName();
                    Class<?> clazz19 = class$0;
                    if (clazz19 == null) {
                        try {
                            clazz19 = class$0 = Class.forName("mausoleum.server.export.ExcelManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.warn(string, clazz19);
                }
                catch (Exception e) {
                    String string = "Problem in getObject for String >" + s + "< and class " + cl.getName() + " -> " + e.getMessage();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.server.export.ExcelManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, null, clazz);
                }
            }
        }
        return null;
    }
}

