/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.server.export;

import de.hannse.netobjects.objectstore.IDObject;
import java.util.HashMap;
import java.util.Vector;
import jxl.Sheet;
import jxl.write.WritableSheet;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mouse.Mouse;
import mausoleum.server.export.ExcelManager;
import mausoleum.server.export.SonderObjectReader;
import mausoleum.server.export.SpecialHandler;

public class MouseGenotypeSheet
implements SpecialHandler,
SonderObjectReader {
    public static final String SHEET_NAME = "mouse_genotypes";
    private static final String HEADER_MOUSEID = "MOUSE_ID";
    private static final String HEADER_LOCUSID = "LOCUS_ID";
    private static final String HEADER_ALLELES = "ALLELES";
    public static SpecialHandler cvHandler = new MouseGenotypeSheet();
    private static final String[] HEADERS = new String[]{"MOUSE_ID", "LOCUS_ID", "ALLELES"};
    private static final int COL_MOUSEID = 0;
    private static final int COL_LOCUSID = 1;
    private static final int COL_ALLELES = 2;
    public static final String[] SERVED_EXTRA_HASHMAPS = new String[]{"HT_MOUSE_GENOTYPES"};
    public static Vector cvCols = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        cvCols = new Vector(20);
        ExcelManager.add(HEADERS, cvCols);
    }

    public int handle(IDObject ido, WritableSheet sheet, int row) {
        Mouse mouse;
        LocusAndAlleles[] arr;
        if (ido instanceof Mouse && (arr = (LocusAndAlleles[])(mouse = (Mouse)ido).get("MOS_LOCUSGENOTYPES")) != null) {
            int i = 0;
            while (i < arr.length) {
                ExcelManager.handle(mouse.get("IDO_ID"), row, 0, sheet);
                if (arr[i].ivLocusID != 0L) {
                    ExcelManager.handle(new Long(arr[i].ivLocusID), row, 1, sheet);
                }
                ExcelManager.handle(arr[i].ivAllele, row, 2, sheet);
                ++row;
                ++i;
            }
        }
        return row;
    }

    public void readSonderLine(Sheet sheet, int row, Vector headers, HashMap sonderObjects) {
        Long locusID = null;
        Long mouseID = null;
        String[] alleles = null;
        int col = 0;
        while (col < headers.size()) {
            String header = (String)headers.elementAt(col);
            if (header != null && header.length() != 0) {
                if (header.equals(HEADER_MOUSEID)) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.Long");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    mouseID = (Long)ExcelManager.getObject(sheet, col, row, clazz);
                } else if (header.equals(HEADER_LOCUSID)) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.Long");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    locusID = (Long)ExcelManager.getObject(sheet, col, row, clazz);
                } else if (header.equals(HEADER_ALLELES)) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("[Ljava.lang.String;");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    alleles = (String[])ExcelManager.getObject(sheet, col, row, clazz);
                }
            }
            ++col;
        }
        if (mouseID == null || locusID == null || alleles == null) {
            return;
        }
        LocusAndAlleles lal = new LocusAndAlleles();
        lal.ivLocusID = locusID;
        lal.ivAllele = alleles;
        HashMap hm = (HashMap)sonderObjects.get("HT_MOUSE_GENOTYPES");
        Vector<LocusAndAlleles> v = (Vector<LocusAndAlleles>)hm.get(mouseID);
        if (v == null) {
            v = new Vector<LocusAndAlleles>();
            hm.put(mouseID, v);
        }
        v.add(lal);
    }
}

