/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.server.export;

import de.hannse.netobjects.objectstore.IDObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import jxl.Sheet;
import jxl.write.WritableSheet;
import mausoleum.cage.Cage;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.server.export.ExcelManager;
import mausoleum.server.export.SonderObjectReader;
import mausoleum.server.export.SpecialHandler;

public class TasksSheet
implements SpecialHandler,
SonderObjectReader {
    public static final String SHEET_NAME = "tasks";
    private static final String HEADER_OBJECT_ID = "OBJECT_ID";
    private static final String HEADER_OBJECT_TYPE = "OBJECT_TYPE";
    private static final String HEADER_DUE_DATE = "DUE_DATE";
    private static final String HEADER_TIME_PREFERENCE = "TIME_PREFERENCE";
    private static final String HEADER_DESCRIPTION = "DESCRIPTION";
    private static final String HEADER_PSEUDOID = "PSEUDOID";
    private static final String HEADER_STATUS = "STATUS";
    private static final String HEADER_PROC_TYPE = "PROCEDURE";
    private static final String HEADER_ISSUE_MILLIS = "ISSUE_MILLIS";
    private static final String HEADER_ISSUER_ID = "ISSUER_ID";
    private static final String HEADER_ISSUER_GROUP = "ISSUER_GROUP";
    private static final String HEADER_COMMENT = "COMMENT";
    private static final String HEADER_COMPLETOR_ID = "COMPLETOR_ID";
    private static final String HEADER_COMPLETOR_GROUP = "COMPLETOR_GROUP";
    private static final String HEADER_FAVORIT_ID = "FAVORIT_ID";
    private static final String HEADER_FAVORIT_GROUP = "FAVORIT_GROUP";
    private static final String HEADER_COMPLETION_TIMESTAMP = "COMPLETION_TIMESTAMP";
    public static SpecialHandler cvHandler = new TasksSheet();
    private static final String[] HEADERS = new String[]{"OBJECT_ID", "OBJECT_TYPE", "STATUS", "DUE_DATE", "TIME_PREFERENCE", "DESCRIPTION", "PSEUDOID", "PROCEDURE", "ISSUE_MILLIS", "ISSUER_ID", "ISSUER_GROUP", "COMMENT", "FAVORIT_ID", "FAVORIT_GROUP", "COMPLETOR_ID", "COMPLETOR_GROUP", "COMPLETION_TIMESTAMP"};
    private static final int COL_OBJECT_ID = 0;
    private static final int COL_OBJECT_TYPE = 1;
    private static final int COL_STATUS = 2;
    private static final int COL_DUE_DATE = 3;
    private static final int COL_TIME_PREFERENCE = 4;
    private static final int COL_DESCRIPTION = 5;
    private static final int COL_PSEUDOID = 6;
    private static final int COL_PROC_TYPE = 7;
    private static final int COL_ISSUE_MILLIS = 8;
    private static final int COL_ISSUER_ID = 9;
    private static final int COL_ISSUER_GROUP = 10;
    private static final int COL_COMMENT = 11;
    private static final int COL_FAVORIT_ID = 12;
    private static final int COL_FAVORIT_GROUP = 13;
    private static final int COL_COMPLETOR_ID = 14;
    private static final int COL_COMPLETOR_GROUP = 15;
    private static final int COL_COMPLETION_TIMESTAMP = 16;
    public static final String[] SERVED_EXTRA_HASHMAPS = new String[]{"HT_MOUSE_TASKS", "HT_CAGE_TASKS"};
    public static Vector cvCols = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        cvCols = new Vector(20);
        ExcelManager.add(HEADERS, cvCols);
    }

    public int handle(IDObject ido, WritableSheet sheet, int row) {
        if (ido instanceof Mouse || ido instanceof Cage) {
            TaskExtended[] arr = (TaskExtended[])ido.get(ido.getTaskKey());
            int objType = 0;
            if (ido instanceof Mouse) {
                objType = 1;
            }
            if (ido instanceof Cage) {
                objType = 2;
            }
            if (arr != null) {
                int i = 0;
                while (i < arr.length) {
                    ExcelManager.handle(ido.get("IDO_ID"), row, 0, sheet);
                    ExcelManager.handle(new Integer(objType), row, 1, sheet);
                    if (arr[i].ivStatus != 0) {
                        ExcelManager.handle(new Integer(arr[i].ivStatus), row, 2, sheet);
                    }
                    if (arr[i].ivDatum != 0) {
                        ExcelManager.handle(new Integer(arr[i].ivDatum), row, 3, sheet);
                    }
                    if (arr[i].ivTime != 0) {
                        ExcelManager.handle(new Integer(arr[i].ivTime), row, 4, sheet);
                    }
                    if (arr[i].ivDescription != null) {
                        ExcelManager.handle(arr[i].ivDescription, row, 5, sheet);
                    }
                    if (arr[i].ivPseudoID != 0L) {
                        ExcelManager.handle(new Long(arr[i].ivPseudoID), row, 6, sheet);
                    }
                    if (arr[i].ivProcType != 0) {
                        ExcelManager.handle(new Integer(arr[i].ivProcType), row, 7, sheet);
                    }
                    if (arr[i].ivIssueMillis != 0L) {
                        ExcelManager.handle(new Long(arr[i].ivIssueMillis), row, 8, sheet);
                    }
                    if (arr[i].ivIssuerID != 0L) {
                        ExcelManager.handle(new Long(arr[i].ivIssuerID), row, 9, sheet);
                    }
                    if (arr[i].ivIssuerGroup != null) {
                        ExcelManager.handle(arr[i].ivIssuerGroup, row, 10, sheet);
                    }
                    if (arr[i].ivComment != null) {
                        ExcelManager.handle(arr[i].ivComment, row, 11, sheet);
                    }
                    if (arr[i].ivFavoritGroup != null) {
                        ExcelManager.handle(arr[i].ivFavoritGroup, row, 13, sheet);
                    }
                    if (arr[i].ivFavoritID != 0L) {
                        ExcelManager.handle(new Long(arr[i].ivFavoritID), row, 12, sheet);
                    }
                    if (arr[i].ivErledigerGroup != null) {
                        ExcelManager.handle(arr[i].ivErledigerGroup, row, 15, sheet);
                    }
                    if (arr[i].ivErledigerID != 0L) {
                        ExcelManager.handle(new Long(arr[i].ivErledigerID), row, 14, sheet);
                    }
                    if (arr[i].ivFinishMillis != 0L) {
                        ExcelManager.handle(new Date(arr[i].ivFinishMillis), row, 16, sheet);
                    }
                    ++row;
                    ++i;
                }
            }
        }
        return row;
    }

    public void readSonderLine(Sheet sheet, int row, Vector headers, HashMap sonderObjects) {
        Long objectID = null;
        TaskExtended taskEx = new TaskExtended();
        int col = 0;
        while (col < headers.size()) {
            String header = (String)headers.elementAt(col);
            if (header != null && header.length() != 0) {
                if (header.equals(HEADER_OBJECT_ID)) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.Long");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    objectID = (Long)ExcelManager.getObject(sheet, col, row, clazz);
                } else if (header.equals(HEADER_DUE_DATE)) {
                    taskEx.ivDatum = this.getInt(sheet, col, row, taskEx.ivDatum);
                } else if (header.equals(HEADER_TIME_PREFERENCE)) {
                    taskEx.ivTime = this.getInt(sheet, col, row, taskEx.ivTime);
                } else if (header.equals(HEADER_OBJECT_TYPE)) {
                    taskEx.ivObjectType = this.getInt(sheet, col, row, taskEx.ivObjectType);
                } else if (header.equals(HEADER_STATUS)) {
                    taskEx.ivStatus = this.getInt(sheet, col, row, taskEx.ivStatus);
                } else if (header.equals(HEADER_PROC_TYPE)) {
                    taskEx.ivProcType = this.getInt(sheet, col, row, taskEx.ivProcType);
                } else if (header.equals(HEADER_PSEUDOID)) {
                    taskEx.ivPseudoID = this.getLong(sheet, col, row, taskEx.ivPseudoID);
                } else if (header.equals(HEADER_ISSUE_MILLIS)) {
                    taskEx.ivIssueMillis = this.getLong(sheet, col, row, taskEx.ivIssueMillis);
                } else if (header.equals(HEADER_ISSUER_ID)) {
                    taskEx.ivIssuerID = this.getLong(sheet, col, row, taskEx.ivIssuerID);
                } else if (header.equals(HEADER_ISSUER_GROUP)) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    taskEx.ivIssuerGroup = (String)ExcelManager.getObject(sheet, col, row, clazz);
                } else if (header.equals(HEADER_COMPLETOR_ID)) {
                    taskEx.ivErledigerID = this.getLong(sheet, col, row, taskEx.ivErledigerID);
                } else if (header.equals(HEADER_FAVORIT_ID)) {
                    taskEx.ivFavoritID = this.getLong(sheet, col, row, taskEx.ivFavoritID);
                } else if (header.equals(HEADER_DESCRIPTION)) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    taskEx.ivDescription = (String)ExcelManager.getObject(sheet, col, row, clazz);
                } else if (header.equals(HEADER_COMMENT)) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    taskEx.ivComment = (String)ExcelManager.getObject(sheet, col, row, clazz);
                } else if (header.equals(HEADER_COMPLETOR_GROUP)) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    taskEx.ivErledigerGroup = (String)ExcelManager.getObject(sheet, col, row, clazz);
                } else if (header.equals(HEADER_FAVORIT_GROUP)) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    taskEx.ivFavoritGroup = (String)ExcelManager.getObject(sheet, col, row, clazz);
                } else if (header.equals(HEADER_COMPLETION_TIMESTAMP)) {
                    Date date;
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.util.Date");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((date = (Date)ExcelManager.getObject(sheet, col, row, clazz)) != null) {
                        taskEx.ivFinishMillis = date.getTime();
                    }
                }
            }
            ++col;
        }
        if (objectID == null) {
            return;
        }
        taskEx.ivObjectID = objectID;
        HashMap hm = null;
        if (taskEx.ivObjectType == 1) {
            hm = (HashMap)sonderObjects.get("HT_MOUSE_TASKS");
        } else if (taskEx.ivObjectType == 2) {
            hm = (HashMap)sonderObjects.get("HT_CAGE_TASKS");
        }
        if (hm != null) {
            Vector<TaskExtended> v = (Vector<TaskExtended>)hm.get(objectID);
            if (v == null) {
                v = new Vector<TaskExtended>();
                hm.put(objectID, v);
            }
            v.add(taskEx);
        }
    }

    private int getInt(Sheet sheet, int col, int row, int defVal) {
        Object o;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = ExcelManager.getObject(sheet, col, row, clazz)) != null && o instanceof Integer) {
            Integer inti = (Integer)o;
            return inti;
        }
        return defVal;
    }

    private long getLong(Sheet sheet, int col, int row, long defVal) {
        Object o;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = ExcelManager.getObject(sheet, col, row, clazz)) != null && o instanceof Long) {
            Long longi = (Long)o;
            return longi;
        }
        return defVal;
    }
}

