/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.sonderreports;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.building.Building;
import mausoleum.cage.Cage;
import mausoleum.helper.ClipboardObject;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.rack.Rack;
import mausoleum.room.Room;
import mausoleum.visit.Visit;

public class SonderReportCecad {
    public static final String FILE_PREF_SRC_1 = "src1_";
    public static final String FILE_PREF_SRC_2 = "src2_";
    static /* synthetic */ Class class$0;

    public static String getBabel() {
        return "SR_CECAD";
    }

    public static void makeStartUpReport() {
        SonderReportCecad.makeReport(false);
    }

    public static void makeMidnightReport() {
        SonderReportCecad.makeReport(true);
    }

    public static boolean needsStartAndEnd() {
        return true;
    }

    public static void modeAndDatesSelected(int[] modeAndDates) {
        String res = (String)RequestManager.createSendAndGetObjectIfFinished((byte)84, modeAndDates, "service");
        if (res != null) {
            TreeSet<String> allGroups = new TreeSet<String>();
            TreeMap infosByDay = new TreeMap();
            Vector lines = StringHelper.splitStringByAny(res, "\n");
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                if ((line = line.trim()).length() == 0) continue;
                Vector blocks = StringHelper.splitStringByAny(line, "|");
                String date = (String)blocks.elementAt(0);
                blocks.remove(0);
                Integer dayKey = new Integer(date);
                HashMap<String, int[]> dayHM = new HashMap<String, int[]>();
                infosByDay.put(dayKey, dayHM);
                Iterator iterator2 = blocks.iterator();
                while (iterator2.hasNext()) {
                    int ind;
                    String groupBlock = (String)iterator2.next();
                    if (groupBlock.length() == 0 || (ind = groupBlock.indexOf(";")) == -1) continue;
                    String group = Base64Manager.getDecodedString(groupBlock.substring(0, ind));
                    allGroups.add(group);
                    String rest = groupBlock.substring(ind + 1, groupBlock.length());
                    Zeile z = new Zeile(rest, ',');
                    dayHM.put(group, new int[]{z.getInt(0, 0), z.getInt(1, 0), z.getInt(2, 0), z.getInt(3, 0)});
                }
            }
            StringBuilder msb = new StringBuilder();
            msb.append("\t");
            Iterator<Object> iterator2 = allGroups.iterator();
            while (iterator2.hasNext()) {
                String group = (String)iterator2.next();
                msb.append("\t").append(group);
            }
            msb.append("\n");
            iterator2 = infosByDay.keySet().iterator();
            while (iterator2.hasNext()) {
                Integer dayInti = (Integer)iterator2.next();
                msb.append(DatumFormat.getVeryShortDateString(dayInti)).append("\t");
                msb.append(DatumFormat.weekday(MyDate.getWochentag(dayInti))).append("\t");
                HashMap dayHM = (HashMap)infosByDay.get(dayInti);
                if (dayHM != null) {
                    Iterator iterator22 = allGroups.iterator();
                    while (iterator22.hasNext()) {
                        String group = (String)iterator22.next();
                        int[] vals = (int[])dayHM.get(group);
                        if (vals != null) {
                            msb.append(vals[0]).append("\t");
                            continue;
                        }
                        msb.append("\t");
                    }
                }
                msb.append("\n");
            }
            ClipboardObject.manageCopy(null, msb.toString());
            Alert.showAlert(Babel.get("DATAINCLIPBOARD"), true);
        }
    }

    private static void makeReport(boolean isMidnight) {
        MyDate md = new MyDate(new GregorianCalendar());
        if (isMidnight) {
            md = new MyDate(md.getTage() - 1);
        }
        StringBuilder scr1SB = new StringBuilder();
        scr1SB.append(md.getTage()).append("|");
        StringBuilder scr2SB = new StringBuilder();
        scr2SB.append(md.getTage()).append("|");
        StringBuilder keySB = new StringBuilder();
        HashMap<String, Point> valuesByKey = new HashMap<String, Point>();
        String defaultName = Base64Manager.encodeBase64("?");
        Enumeration en = DataLayer.cvDataLayer.getAllGroupnames(true);
        while (en.hasMoreElements()) {
            String group = (String)en.nextElement();
            if (group.equals("service") || group.equals("null")) continue;
            String groupName64 = Base64Manager.encodeBase64(group);
            scr1SB.append(Base64Manager.encodeBase64(group)).append(";");
            int totalS = 0;
            int filledS = 0;
            int totalX = 0;
            int filledX = 0;
            Vector aktCages = ObjectStore.getActualObjects(2, group);
            Iterator iterator = aktCages.iterator();
            while (iterator.hasNext()) {
                Cage cage = (Cage)iterator.next();
                cage = cage.getSuperCageIfThere();
                boolean inService = false;
                Rack rack = cage.getRack();
                if (rack != null && rack.isSharedWithOtherGroups()) {
                    inService = true;
                }
                String rackName64 = defaultName;
                String roomName64 = defaultName;
                String buildingName64 = defaultName;
                if (rack != null && inService) {
                    rackName64 = Base64Manager.encodeBase64(rack.getBrowseNameWITHOUTServicePrefix());
                    Room room = rack.getRoom();
                    if (room != null) {
                        Building serviceBuilding;
                        Room serviceRoom;
                        roomName64 = Base64Manager.encodeBase64(room.getBrowseNameWITHOUTServicePrefix());
                        if (room.isSharedWithOtherGroups() && (serviceRoom = (Room)room.getServiceGroupObject(null)) != null && (serviceBuilding = serviceRoom.getBuilding()) != null) {
                            buildingName64 = Base64Manager.encodeBase64(serviceBuilding.getBrowseNameWITHOUTServicePrefix());
                        }
                    }
                }
                boolean hasMice = false;
                Visit[] vs = (Visit[])cage.get("CAG_VISIT");
                if (vs != null) {
                    int i = 0;
                    while (i < vs.length && !hasMice) {
                        if (vs[i].ivEndDate == null) {
                            hasMice = true;
                        }
                        ++i;
                    }
                }
                if (inService) {
                    ++totalS;
                    if (hasMice) {
                        ++filledS;
                    }
                } else {
                    ++totalX;
                    if (hasMice) {
                        ++filledX;
                    }
                }
                if (!inService) continue;
                keySB.setLength(0);
                keySB.append(groupName64).append(" ").append(rackName64).append(" ").append(roomName64).append(" ").append(buildingName64);
                String key = keySB.toString();
                Point p = (Point)valuesByKey.get(keySB.toString());
                if (p == null) {
                    p = new Point(0, 0);
                    valuesByKey.put(key, p);
                }
                if (hasMice) {
                    ++p.x;
                    continue;
                }
                ++p.y;
            }
            scr1SB.append(filledS).append(",").append(totalS).append(",").append(filledX).append(",").append(totalX).append("|");
        }
        scr1SB.append("\n");
        Iterator iterator = valuesByKey.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Point p = (Point)valuesByKey.get(key);
            scr2SB.append(key).append(";").append(p.x).append(",").append(p.y).append("|");
        }
        scr2SB.append("\n");
        String dir = GroupFileManager.getReportsDir("service");
        FileManager.prepareDirs(dir);
        FileManager.appendStringToServerFile(String.valueOf(dir) + "/" + FILE_PREF_SRC_1 + md.ivJahr + ".txt", scr1SB.toString());
        FileManager.appendStringToServerFile(String.valueOf(dir) + "/" + FILE_PREF_SRC_2 + md.ivJahr + ".txt", scr2SB.toString());
    }

    public static boolean handleRequest(ObjectRequest or) {
        return SonderReportCecad.handleRequest(or, FILE_PREF_SRC_1);
    }

    public static boolean handleRequest(ObjectRequest or, String filePrefix) {
        int[] limArr;
        if (or.ivObject instanceof int[] && (limArr = (int[])or.ivObject).length == 3) {
            String dir = GroupFileManager.getReportsDir("service");
            StringBuilder msb = new StringBuilder();
            int startDay = limArr[1];
            int endDay = limArr[2];
            int sJahr = new MyDate((int)startDay).ivJahr;
            int eJahr = new MyDate((int)endDay).ivJahr;
            int jahr = sJahr;
            while (jahr <= eJahr) {
                String path = String.valueOf(dir) + "/" + filePrefix + jahr + ".txt";
                if (new File(path).exists()) {
                    try {
                        BufferedReader lnr = new BufferedReader(new FileReader(path));
                        String line = lnr.readLine();
                        while (line != null) {
                            int tag;
                            int ind;
                            if (line.length() != 0 && (ind = line.indexOf("|")) != -1 && (tag = Integer.parseInt(line.substring(0, ind))) >= startDay && tag <= endDay) {
                                msb.append(line).append("\n");
                            }
                            line = lnr.readLine();
                        }
                        lnr.close();
                        lnr = null;
                    }
                    catch (Throwable e) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("mausoleum.sonderreports.SonderReportCecad");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error("Problem while generating Sonderreport", e, clazz);
                    }
                }
                ++jahr;
            }
            or.ivObject = msb.toString();
            return true;
        }
        return false;
    }
}

