/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.sonderreports;

import de.hannse.netobjects.java.MCLK;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.actions.OAGetConfigValue;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.util.HashSet;
import java.util.Vector;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.TaskExtended;
import mausoleum.mouse.tierschutz.TierschutzReport;
import mausoleum.sonderreports.SonderReportCecad;
import mausoleum.sonderreports.SonderReportCecad2;

public abstract class SonderReports {
    private static final int SONDERREPORT_UNDEFINED = -1;
    private static final int SONDERREPORT_NIX = 0;
    private static final int SONDERREPORT_CECAD = 1;
    public static final int SONDERREPORT_TIERSCHUTZ = 2;
    public static final int SONDERREPORT_ALL_TASKS = 4;
    private static final int SONDERREPORT_CECAD2 = 8;
    public static int cvSonderReports = -1;

    static {
        if (ProcessDefinition.isServer()) {
            cvSonderReports = MCLK.getDefinedIntVal("SR:", null, 4);
        } else if (ProcessDefinition.isClient() && cvSonderReports == -1) {
            Integer sonderreportsServerVal = (Integer)RequestManager.createSendAndGetObjectIfFinished((byte)71, "SONDERREPORTS", null, OAGetConfigValue.MARK_JUST_INTEGER);
            cvSonderReports = sonderreportsServerVal != null ? sonderreportsServerVal : 0;
        }
    }

    public static String[] enrichHOSReportStrings(String[] orig, HashSet sonderChoices) {
        if (SonderReports.hasSonderReports()) {
            Vector<String> addons = new Vector<String>();
            if ((cvSonderReports & 1) != 0) {
                addons.add(Babel.get(SonderReportCecad.getBabel()));
                addons.add(Babel.get(SonderReportCecad2.getBabel()));
            }
            if (!addons.isEmpty()) {
                sonderChoices.addAll(addons);
                orig = ArrayHelper.enlargeStringArray(orig, addons);
            }
        }
        return orig;
    }

    public static int[] enrichHOSReportModes(int[] orig) {
        if (SonderReports.hasSonderReports() && (cvSonderReports & 1) != 0) {
            orig = ArrayHelper.enlargeIntArray(orig, 1001, 1008);
        }
        return orig;
    }

    public static void modeAndDatesSelected(int[] modeAndDates) {
        if (modeAndDates[0] == 1) {
            SonderReportCecad.modeAndDatesSelected(modeAndDates);
        } else if (modeAndDates[0] == 8) {
            SonderReportCecad2.modeAndDatesSelected(modeAndDates);
        }
    }

    public static boolean needsStartAndEnd(int sonderReportMode) {
        if (sonderReportMode == 1) {
            return SonderReportCecad.needsStartAndEnd();
        }
        if (sonderReportMode == 8) {
            return SonderReportCecad2.needsStartAndEnd();
        }
        return false;
    }

    public static boolean hasSonderReports() {
        return cvSonderReports != 0;
    }

    public static void makeStartUpReport() {
        if (ProcessDefinition.isServer() && (cvSonderReports & 1) != 0) {
            SonderReportCecad.makeStartUpReport();
        }
    }

    public static void makeMidnightReport() {
        if (ProcessDefinition.isServer() && (cvSonderReports & 1) != 0) {
            SonderReportCecad.makeMidnightReport();
        }
    }

    public static boolean handleRequest(ObjectRequest or) {
        int[] modeAndDates = (int[])or.ivObject;
        if (modeAndDates[0] == 1) {
            return SonderReportCecad.handleRequest(or);
        }
        if (modeAndDates[0] == 8) {
            return SonderReportCecad2.handleRequest(or);
        }
        if (modeAndDates[0] == 2) {
            return TierschutzReport.handleRequest(or, modeAndDates);
        }
        if (modeAndDates[0] == 4) {
            long mouseID = modeAndDates[1];
            or.ivObject = TaskExtended.collectDeletedTasks(mouseID, or.ivGroup);
            return true;
        }
        return false;
    }
}

