/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import de.hannse.netobjects.util.Babel;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.JTableHeader;
import mausoleum.inspector.Inspector;
import mausoleum.requester.Requester;
import mausoleum.tables.MausoleumTableModel;

public class FilterCombo
extends JComboBox {
    private static final long serialVersionUID = 11531353L;
    private final String ivColKennung;
    private final MausoleumTableModel ivMausoleumTableModel;
    private boolean ivActive = true;

    public FilterCombo(Vector v, String colKennung, MausoleumTableModel sortableTable, int index) {
        super(v);
        this.setSelectedIndex(index);
        this.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                FilterCombo.this.doit();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                FilterCombo.this.doit();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        this.ivMausoleumTableModel = sortableTable;
        this.ivColKennung = colKennung;
    }

    private void doit() {
        if (this.ivActive) {
            this.ivActive = false;
            JTableHeader th = this.ivMausoleumTableModel.getJTable().getTableHeader();
            if (th != null) {
                th.remove(this);
                th.repaint();
            }
            boolean doit = false;
            int ind = this.getSelectedIndex();
            if (ind != -1 && this.ivMausoleumTableModel != null) {
                if (ind == 3 || ind == 4) {
                    String spec = Requester.getString(Inspector.getInspector(), Babel.get("SPECIFY_TEXT"), "");
                    if (spec != null && (spec = spec.trim()).length() != 0) {
                        this.ivMausoleumTableModel.setSpecifiedFilterString(this.ivColKennung, spec, ind == 4);
                        doit = true;
                    }
                } else {
                    this.ivMausoleumTableModel.setSpecifiedFilterString(this.ivColKennung, null, false);
                    doit = true;
                }
                if (doit) {
                    this.ivMausoleumTableModel.filterClicked(this.ivColKennung, ind);
                }
                if (th != null) {
                    this.ivMausoleumTableModel.getJTable().getTableHeader().repaint();
                }
            }
        }
    }
}

