/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import java.awt.Component;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.Inspector;
import mausoleum.tables.MausoleumTable;

public class MausoleumTableTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1234234L;

    public static void setCountTitleFor(String titelPrefix, MausoleumTable table) {
        MausoleumTableTabbedPane.setCountTitleFor(titelPrefix, table, -1);
    }

    public static void setCountTitleFor(String titelPrefix, MausoleumTable table, int secVal) {
        int ind;
        JTabbedPane tp = WindowUtils.getJTabbedPane(table);
        if (tp != null && (ind = tp.indexOfComponent(table)) != -1) {
            if (secVal == -1) {
                tp.setTitleAt(ind, String.valueOf(titelPrefix) + " [" + table.ivModel.getRowCount() + "]");
            } else {
                tp.setTitleAt(ind, String.valueOf(titelPrefix) + " [" + table.ivModel.getRowCount() + "/" + secVal + "]");
            }
        }
    }

    public MausoleumTableTabbedPane() {
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                Component selComp = pane.getSelectedComponent();
                if (selComp instanceof MausoleumTable) {
                    MausoleumTable mt = (MausoleumTable)selComp;
                    Inspector.adjustToTable(mt);
                } else {
                    Inspector.adjustToTable(null);
                }
            }
        });
        this.setOpaque(false);
    }

    public Component add(String title, Component component) {
        Component res = super.add(title, component);
        if (res instanceof MausoleumTable) {
            MausoleumTable mt = (MausoleumTable)res;
            mt.ivModel.ownerFilterAlarm();
        }
        return res;
    }
}

