/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.BorderLayout;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import mausoleum.alert.Alert;
import mausoleum.gui.ClosableTabbedPane;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.models.MTCagePool;
import mausoleum.tables.models.MTMousePool;
import mausoleum.ui.UIDef;

public class PoolFrame
extends JFrame {
    private static final long serialVersionUID = 14861313L;
    private static PoolFrame cvInstance = null;
    private final ClosableTabbedPane ivTabbedPane = new ClosableTabbedPane(true, true);

    public static void hideIt() {
        if (cvInstance != null) {
            cvInstance.setVisible(false);
        }
    }

    public static void showPool(Vector mice, Vector cages) {
        if (cvInstance == null) {
            cvInstance = new PoolFrame();
        }
        String datum = DatumFormat.getTimeString(new MyDate(new GregorianCalendar()));
        MausoleumTable mausTable = null;
        MausoleumTable cageTable = null;
        if (mice != null && !mice.isEmpty()) {
            mausTable = new MausoleumTable(new MTMousePool(), false);
            mausTable.setIsSubdisplay();
            mausTable.setHeader(String.valueOf(Babel.get("POOL_SNAPSHOT_MICE")) + " (" + datum + ")");
            mausTable.ivModel.setTable(mice);
        }
        if (cages != null && !cages.isEmpty()) {
            cageTable = new MausoleumTable(new MTCagePool(), false);
            cageTable.setIsSubdisplay();
            cageTable.setHeader(String.valueOf(Babel.get("POOL_SNAPSHOT_CAGES")) + " (" + datum + ")");
            cageTable.ivModel.setTable(cages);
        }
        JComponent comp = null;
        if (mausTable == null && cageTable == null) {
            Alert.showAlert(Babel.get("POOL_EMPTY"), true);
        } else if (mausTable != null && cageTable == null) {
            comp = mausTable;
        } else if (mausTable == null && cageTable != null) {
            comp = cageTable;
        } else if (mausTable != null && cageTable != null) {
            comp = new JSplitPane(0, mausTable, cageTable);
        }
        if (comp != null) {
            PoolFrame.cvInstance.ivTabbedPane.addTab(datum, comp);
            PoolFrame.cvInstance.ivTabbedPane.setSelectedComponent(comp);
            WindowUtils.bringUpFrame(cvInstance);
            if (comp instanceof JSplitPane) {
                JSplitPane jsp = (JSplitPane)comp;
                jsp.setDividerLocation(0.5);
            }
        }
    }

    public PoolFrame() {
        this.setTitle(Babel.get("MOUSOLEUM_POOLS"));
        this.setIconImage(MausoleumImageStore.getLogo());
        this.setContentPane(new RequesterPane(new BorderLayout()));
        this.getContentPane().add("Center", this.ivTabbedPane);
        this.setBounds(UIDef.getScaled(10), UIDef.getScaled(10), UIDef.getScaled(500), UIDef.getScaled(400));
    }
}

