/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTabbedPane;
import mausoleum.cage.Cage;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.ImageProvider;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.mouse.tierschutz.Stress;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.room.RoomStatusListener;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableTabbedPane;
import mausoleum.tables.OwnAllListener;
import mausoleum.tables.TableFrameForCollections;
import mausoleum.tables.models.MTAgeGroup;
import mausoleum.tables.models.MTCohort;
import mausoleum.tables.models.MTKilledForUser;
import mausoleum.tables.models.MTKilledInService;
import mausoleum.tables.models.MTMouse;
import mausoleum.tables.models.MTMouseCreated;
import mausoleum.tables.models.MTMouseKilled;
import mausoleum.tables.models.MTMouseKilledThirdParty;
import mausoleum.tables.models.MTMouseMikroCohort;
import mausoleum.tables.models.MTMouseStressHighLevel;
import mausoleum.tables.models.MTMouseStressMissingLevel;
import mausoleum.tables.models.MTMouseWeaned;

public class TableFrameMouse
extends TableFrameForCollections
implements RoomStatusListener,
OwnAllListener {
    private static final long serialVersionUID = 8454581561067341175L;
    private static String PREFIX = Babel.get("MOUSE_COLLECTIONS");
    private static MausoleumTable cvKilledMice = null;
    private static MausoleumTable cvNewMice = null;
    private static MausoleumTable cvWeanedMice = null;
    public static MausoleumTable cvCohorts = null;
    private static TableFrameMouse cvInstance = null;
    static /* synthetic */ Class class$0;

    public static void removeSessionTables() {
        if (cvKilledMice != null) {
            cvKilledMice = null;
        }
        if (cvNewMice != null) {
            cvNewMice = null;
        }
        if (cvWeanedMice != null) {
            cvWeanedMice = null;
        }
    }

    public static void addKilledMice(Vector mice) {
        TableFrameMouse.addReportObjects(mice, cvKilledMice, Babel.get("KILLED_MICE"), 2);
    }

    public static void addNewMice(Vector mice) {
        TableFrameMouse.addReportObjects(mice, cvNewMice, Babel.get("CREATED_MICE"), 1);
    }

    public static void addWeanedMice(Vector mice) {
        TableFrameMouse.addReportObjects(mice, cvWeanedMice, Babel.get("WEANED_MICE"), 3);
    }

    public static void getNewMiceOfSession(Vector target) {
        TableFrameMouse.cvNewMice.ivModel.addOriginalObjects(target);
    }

    public static void getKilledMiceOfSession(Vector target) {
        TableFrameMouse.cvKilledMice.ivModel.addOriginalObjects(target);
    }

    public static void getWeanedMiceOfSession(Vector target) {
        TableFrameMouse.cvWeanedMice.ivModel.addOriginalObjects(target);
    }

    public static JTabbedPane createMainTabbedPane() {
        MausoleumTableTabbedPane mainPane = new MausoleumTableTabbedPane();
        mainPane.setOpaque(false);
        MTMouse inner = new MTMouse(){

            public void tableChanged(Vector vorherSelektiert) {
                super.tableChanged(vorherSelektiert);
                MausoleumTableTabbedPane.setCountTitleFor(Babel.get("ALLMICE"), this.ivMausoleumTable, this.getAnzOrigObjects());
            }
        };
        MausoleumTable mainTable = new MausoleumTable(inner, false);
        mainPane.add(Babel.get("ALLMICE"), mainTable);
        mainTable.ivModel.fillMainTable();
        if (cvCohorts == null) {
            cvCohorts = TableFrameMouse.createSpecialTable(new MTCohort());
        }
        if (MausoleumClient.isRegularOrTGService()) {
            TableFrameMouse.cvCohorts.ivModel.fillMainTable();
            mainPane.add(Babel.get("COHORTS"), cvCohorts);
        }
        MausoleumTableFrame.MAIN_TABLES.put(new Integer(1), mainTable);
        MausoleumTableFrame.MAIN_TABLES.put(new Integer(21), cvCohorts);
        if (cvKilledMice == null) {
            cvKilledMice = TableFrameMouse.createSpecialTable(new MTMouseKilled());
        }
        if (cvNewMice == null) {
            cvNewMice = TableFrameMouse.createSpecialTable(new MTMouseCreated());
        }
        if (cvWeanedMice == null) {
            cvWeanedMice = TableFrameMouse.createSpecialTable(new MTMouseWeaned());
        }
        mainPane.add(Babel.get("KILLED_MICE"), cvKilledMice);
        TableFrameMouse.cvKilledMice.ivModel.tableChanged(null);
        mainPane.add(Babel.get("CREATED_MICE"), cvNewMice);
        TableFrameMouse.cvNewMice.ivModel.tableChanged(null);
        mainPane.add(Babel.get("WEANED_MICE"), cvWeanedMice);
        TableFrameMouse.cvWeanedMice.ivModel.tableChanged(null);
        mainPane.add("< 1 M", MTAgeGroup.getTable(Integer.MIN_VALUE, 30, 0));
        mainPane.add("1 - 2 M", MTAgeGroup.getTable(30, 60, 1));
        mainPane.add("2 - 3 M", MTAgeGroup.getTable(60, 92, 2));
        mainPane.add("3 - 6 M", MTAgeGroup.getTable(92, 183, 3));
        mainPane.add("6 - 12 M", MTAgeGroup.getTable(183, 365, 4));
        mainPane.add("> 12 M", MTAgeGroup.getTable(365, Integer.MAX_VALUE, 5));
        MTAgeGroup.initAgeTables();
        if (MausoleumClient.isServiceCaretaker()) {
            mainPane.add(Babel.get("KILLED_IN_SERVICE_ROOM"), MTKilledInService.getTable());
        } else if (MausoleumClient.isRegular() && Privileges.hasPrivilege("CAN_OWN")) {
            MausoleumTable k3pTable = MTMouseKilledThirdParty.getKilledThirdPartyTable();
            mainPane.add(Babel.get("KILLED_THIRD_PARTY"), k3pTable);
            if (k3pTable.ivModel.getRowCount() > 0) {
                mainPane.setIconAt(mainPane.getTabCount() - 1, ImageProvider.getBulletIcon(Color.red));
            }
            MausoleumTable mkfoTable = MTKilledForUser.getTable();
            mainPane.add(Babel.get("REMOVED_OWN_MICE"), mkfoTable);
            if (mkfoTable.ivModel.getRowCount() > 0) {
                mainPane.setIconAt(mainPane.getTabCount() - 1, ImageProvider.getBulletIcon(Color.red));
            }
        }
        if (TierSchutz.belastungNeeded()) {
            String group;
            String s;
            Vector<Mouse> hsMice = new Vector<Mouse>();
            MouseManager om = MouseManager.cvInstance;
            if (om != null) {
                try {
                    Vector ori = om.getActualObjectVectorAllGroups();
                    Iterator iter = ori.iterator();
                    while (iter.hasNext()) {
                        Mouse mouse = (Mouse)iter.next();
                        if (!mouse.isAliveAndVisible()) continue;
                        int mLifeSL = mouse.getMouseLifeStressLevel();
                        int mLineSL = mouse.getAktLineStressLevel();
                        if (mLifeSL != 40 && mLineSL != 40) continue;
                        hsMice.add(mouse);
                    }
                }
                catch (Exception e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.tables.models.MTAgeGroup");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Problem fillMainTable", e, clazz);
                }
            }
            int aktIndex = mainPane.getTabCount();
            MausoleumTable mkfoTable = new MausoleumTable(new MTMouseStressHighLevel(hsMice), false);
            mkfoTable.setIsSubdisplay();
            mainPane.add(Babel.get("MICE_WITH_HIGH_STRESS_LEVEL"), mkfoTable);
            if (!hsMice.isEmpty()) {
                mainPane.setIconAt(aktIndex, ImageProvider.getBulletIcon(Color.red));
            }
            if (MausoleumClient.isRegular() && Privileges.hasPrivilege("CAN_OWN") && Privileges.hasPrivilege("MOS_DEFINE_STRESS_LEVELS") && (s = Stress.getMiceIDsWithMissingStressClientSide(group = UserManager.getFirstGroup())) != null && s.length() != 0) {
                Vector<Long> ids = new Vector<Long>();
                Iterator iterator = StringHelper.splitStringByAny(s, "\n").iterator();
                while (iterator.hasNext()) {
                    String idS = ((String)iterator.next()).trim();
                    if (idS.length() == 0) continue;
                    try {
                        ids.add(new Long(idS));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!ids.isEmpty()) {
                    long[] arr = new long[ids.size()];
                    int i = 0;
                    while (i < arr.length) {
                        arr[i] = (Long)ids.elementAt(i);
                        ++i;
                    }
                    Vector mice = ObjectStore.getObjects(1, arr, group);
                    if (mice != null && !mice.isEmpty()) {
                        aktIndex = mainPane.getTabCount();
                        mkfoTable = new MausoleumTable(new MTMouseStressMissingLevel(mice), false);
                        mkfoTable.setIsSubdisplay();
                        mainPane.add(Babel.get("MICE_WITH_MISSING_STRESS_LEVEL"), mkfoTable);
                        mainPane.setIconAt(aktIndex, ImageProvider.getBulletIcon(Color.red));
                    }
                }
            }
        }
        return mainPane;
    }

    public static void showNewMice(Vector sentObjects, HashSet specialCommands) {
        if (sentObjects != null && !sentObjects.isEmpty()) {
            String title = null;
            String tabtitle = null;
            boolean sortByAge = false;
            if (specialCommands != null && (specialCommands.contains("MFULI") || specialCommands.contains("MFULIET"))) {
                title = Babel.get("NM_CRETAED_LITTER");
                sortByAge = true;
                tabtitle = Babel.get("NMF_LITTER");
            } else if (specialCommands != null && (specialCommands.contains("MI") || specialCommands.contains("MIRID"))) {
                title = Babel.get("NM_CREATED_MICE");
                tabtitle = Babel.get("NMF_NEW");
            } else if (specialCommands != null && specialCommands.contains("MTAKEMICE")) {
                title = Babel.get("NM_EXTRACTED_MICE");
                tabtitle = Babel.get("NMF_IMPORT");
            } else if (specialCommands != null && specialCommands.contains("MAI_EXTRACT")) {
                title = Babel.get("NM_EXTRACTED_MICE");
                tabtitle = Babel.get("NMF_IMPORT");
            } else if (specialCommands != null && specialCommands.contains("MAI_IMPORT_WITH_ROOM")) {
                title = Babel.get("NM_TRANSFERED_MICE");
                tabtitle = Babel.get("NMF_TRANSFER");
            } else if (specialCommands != null && specialCommands.contains("MAI_IMPORT")) {
                title = Babel.get("NM_EXTRACTED_MICE");
                tabtitle = Babel.get("NMF_IMPORT");
            }
            if (title != null) {
                TableFrameMouse.displayMiceAndSort(sentObjects, title, tabtitle, sortByAge ? "AGE" : null);
            }
        }
    }

    public static void showCohorts(Vector cohorts) {
        if (cohorts != null && !cohorts.isEmpty()) {
            Vector<IDObjectGroup> v = new Vector<IDObjectGroup>();
            int i = 0;
            while (i < cohorts.size()) {
                v.clear();
                IDObjectGroup cohort = (IDObjectGroup)cohorts.elementAt(i);
                v.add(cohort);
                Vector erg = ObjectManager.getAllMembersOfIDObjectGroups(MouseManager.cvInstance, v);
                String datum = DatumFormat.getTimeString(new MyDate(new GregorianCalendar()));
                String title = String.valueOf(Babel.get("COHORT")) + ": " + cohort.getName() + " (" + datum + ")";
                MTMouseMikroCohort mtm = new MTMouseMikroCohort(erg);
                if (cvInstance == null) {
                    cvInstance = new TableFrameMouse();
                }
                cvInstance.showCollection(mtm, title, String.valueOf(Babel.get("COHORT")) + " " + cohort.getName());
                ++i;
            }
        }
    }

    public static void showCageContents(Vector cages, boolean allMice) {
        if (cages != null && !cages.isEmpty()) {
            int i = 0;
            while (i < cages.size()) {
                Cage c = (Cage)cages.elementAt(i);
                String title = "";
                String datum = DatumFormat.getTimeString(new MyDate(new GregorianCalendar()));
                Vector erg = null;
                if (allMice) {
                    erg = c.getAllMiceEverVisited();
                    title = Babel.get("ALL_MICE_IN_CAGE");
                    title = StringHelper.gSub(title, "_CAGID_", c.getNumberString(), true);
                    title = String.valueOf(title) + " (" + datum + ")";
                } else {
                    erg = new Vector();
                    erg.addAll(c.getActualMice());
                    title = String.valueOf(Babel.get("CAGESNAPSHOT")) + " ";
                    title = String.valueOf(title) + Babel.get("CAGE") + ":" + c.getNumberString() + " (" + datum + ")";
                }
                TableFrameMouse.displayMice(erg, title, String.valueOf(Babel.get("CAGE")) + " " + c.getName());
                ++i;
            }
        }
    }

    public static void hideIt() {
        if (cvInstance != null) {
            cvInstance.setVisible(false);
        }
    }

    public static void displayMice(Vector mice, String header, String tabTitle) {
        TableFrameMouse.displayMiceAndSort(mice, header, tabTitle, null);
    }

    public static void displayMiceAndSort(Vector mice, String header, String tabTitle, String sortCol) {
        TableFrameMouse.displayMiceAndSort(new MTMouse(mice), header, tabTitle, sortCol);
    }

    public static void displayMiceAndSort(MTMouse mtm, String header, String tabTitle, String sortCol) {
        if (cvInstance == null) {
            cvInstance = new TableFrameMouse();
        }
        if (sortCol != null) {
            mtm.sortObjectsByColumn(sortCol);
        }
        cvInstance.showCollection(mtm, header, tabTitle);
    }

    private static MausoleumTable createSpecialTable(MausoleumTableModel model) {
        MausoleumTable res = new MausoleumTable(model, false);
        res.setIsSubdisplay();
        model.setTable(new Vector());
        return res;
    }

    public String getTitelPrefix() {
        return PREFIX;
    }
}

