/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.ImageProvider;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.Inspector;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableSelectionListener;
import mausoleum.tables.models.MTCageWeaning;
import mausoleum.tables.models.MTMousePlugAlert;
import mausoleum.tables.models.MTMouseSchedule;
import mausoleum.tables.models.MTMouseTaskList;
import mausoleum.tables.models.MTTask;
import mausoleum.tables.models.MTTaskInSchedule;
import mausoleum.task.DisplayTask;
import mausoleum.task.TaskSchedule;
import mausoleum.task.TaskTreeCellRenderer;
import mausoleum.task.TaskTreeNode;
import mausoleum.task.standards.StandardTask;
import mausoleum.task.standards.StandardTaskPanel;
import mausoleum.ui.UIDef;

public abstract class TableFrameTasks {
    public static final JTabbedPane TABBED_PANE = new JTabbedPane();
    private static final Vector VORHER_SELEKTIERT = new Vector();
    private static boolean cvShowFrame = false;
    private static MausoleumTable cvMainTable = null;
    private static MausoleumTable cvWeanAlert = null;
    private static MausoleumTable cvPlugAlert = null;
    private static TaskSchedule cvTaskSchedule = null;
    private static MausoleumTable cvScheduleTable = null;
    private static JSplitPane cvTaskTreePane = null;
    private static JSplitPane cvSplitPane2 = null;

    public static void init() {
        TABBED_PANE.setOpaque(false);
        TABBED_PANE.removeAll();
        cvMainTable = null;
        cvWeanAlert = null;
        cvPlugAlert = null;
        cvTaskSchedule = null;
        cvScheduleTable = null;
        cvTaskTreePane = null;
        cvSplitPane2 = null;
        if (!MausoleumClient.isHeadOfService()) {
            cvMainTable = new MausoleumTable(new MTTask(), false);
            TaskTreeNode.TREE.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    TableFrameTasks.treeSelectionChanged();
                }
            });
            TaskTreeNode.TREE.setCellRenderer(new TaskTreeCellRenderer());
            TaskTreeNode.TREE.setRowHeight(0);
            TaskTreeNode.TREE.setBorder(new EmptyBorder(UIDef.INNER_RAND, UIDef.INNER_RAND, UIDef.INNER_RAND, UIDef.INNER_RAND));
            MausoleumTable listMousePanel = new MausoleumTable(new MTMouseTaskList(), false);
            listMousePanel.setIsSubdisplay();
            ((MTTask)TableFrameTasks.cvMainTable.ivModel).ivDependentMouseTable = listMousePanel;
            TableFrameTasks.cvMainTable.ivModel.addSelectionListener(new MausoleumTableSelectionListener(){

                public void selectionChanged(MausoleumTableModel mt) {
                    TableFrameTasks.manageDependents(mt);
                }
            });
            JSplitPane rechtssplit = new JSplitPane(0, cvMainTable, listMousePanel);
            rechtssplit.setDividerLocation(300);
            cvTaskTreePane = new JSplitPane(1, new JScrollPane(TaskTreeNode.TREE), rechtssplit);
            cvTaskTreePane.setDividerLocation(150);
            TABBED_PANE.add(Babel.get("TASK_LIST"), cvTaskTreePane);
        }
        if (!MausoleumClient.isHeadOfService()) {
            cvTaskSchedule = TaskSchedule.getInstance();
            cvTaskSchedule.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    Vector v = cvTaskSchedule.getHitDisplayTasks(e, null);
                    if (v != null) {
                        cvScheduleTable.ivModel.setTable(v);
                        TableFrameTasks.adaptInspectorToTable(cvScheduleTable);
                    }
                }
            });
            cvScheduleTable = new MausoleumTable(MTTaskInSchedule.getInstance(cvTaskSchedule), false);
            cvScheduleTable.setIsSubdisplay();
            JCheckBox cb = new JCheckBox(Babel.get("SCHEDULE_WITH_COLOR"));
            cb.setOpaque(false);
            cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    JCheckBox jb = (JCheckBox)arg0.getSource();
                    cvTaskSchedule.setWithColor(jb.isSelected());
                }
            });
            cb.setSelected(cvTaskSchedule.useColor());
            JComboBox<String> jcb = new JComboBox<String>(TaskSchedule.COMBO_STRINGS);
            jcb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    JComboBox jb = (JComboBox)arg0.getSource();
                    cvTaskSchedule.setUsedDays(TaskSchedule.COMBO_VALS[jb.getSelectedIndex()]);
                }
            });
            jcb.setSelectedIndex(cvTaskSchedule.getPeriodComboIndex());
            MGButton pb1 = new MGButton(Babel.get("PRINT"));
            pb1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    cvTaskSchedule.printIt(false);
                }
            });
            MGButton pb2 = new MGButton(Babel.get("PRINT_PREVIEW"));
            pb2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    cvTaskSchedule.printIt(true);
                }
            });
            RequesterPane untenPanel = new RequesterPane(new GridLayout(1, 4, 4, 4));
            untenPanel.add(cb);
            untenPanel.add(jcb);
            untenPanel.add(pb1);
            untenPanel.add(pb2);
            JScrollPane schedulePane = new JScrollPane(cvTaskSchedule);
            schedulePane.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    cvTaskSchedule.manageResize();
                }
            });
            JPanel schedPanel = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
            schedPanel.add("Center", schedulePane);
            schedPanel.add("South", untenPanel);
            schedPanel.setOpaque(false);
            MausoleumTable scheduleMousePanel = new MausoleumTable(new MTMouseSchedule(), false);
            scheduleMousePanel.setIsSubdisplay();
            ((MTTaskInSchedule)TableFrameTasks.cvScheduleTable.ivModel).ivDependentMouseTable = scheduleMousePanel;
            TableFrameTasks.cvScheduleTable.ivModel.addSelectionListener(new MausoleumTableSelectionListener(){

                public void selectionChanged(MausoleumTableModel mt) {
                    TableFrameTasks.manageDependents(mt);
                }
            });
            JPanel subPanel = new JPanel(new GridLayout(2, 1));
            subPanel.setOpaque(false);
            subPanel.add(cvScheduleTable);
            subPanel.add(scheduleMousePanel);
            cvSplitPane2 = new JSplitPane(0, schedPanel, subPanel);
            cvSplitPane2.setDividerLocation(300);
            cvSplitPane2.setOpaque(false);
            TABBED_PANE.add(Babel.get("TASK_SCHEDULE"), cvSplitPane2);
        }
        if (Privileges.hasPrivilege("VIEW_STANDARD_TASKS")) {
            TABBED_PANE.addTab(Babel.get("STANDARD_TASKS"), StandardTaskPanel.getPanel());
        }
        MausoleumTableFrame.MAIN_TABLES.put(new Integer(15), TABBED_PANE);
        TABBED_PANE.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TableFrameTasks.manageInspectorAdaption();
            }
        });
    }

    public static void restAlertWindowMarker() {
        cvShowFrame = false;
    }

    public static void windowIsNecessary() {
        cvShowFrame = true;
    }

    public static void showWindowIfNecessary() {
        if (cvShowFrame) {
            MausoleumTableFrame.showMainTableForType(15);
        }
    }

    public static MausoleumTable manageInspectorAdaption() {
        int sel = TABBED_PANE.getSelectedIndex();
        if (sel != -1) {
            Component selComp = TABBED_PANE.getComponentAt(sel);
            if (selComp == cvTaskTreePane) {
                TableFrameTasks.adaptInspectorToTable(cvMainTable);
                return cvMainTable;
            }
            if (selComp == cvSplitPane2) {
                TableFrameTasks.adaptInspectorToTable(cvScheduleTable);
                return cvScheduleTable;
            }
            if (selComp instanceof MausoleumTable) {
                MausoleumTable table = (MausoleumTable)selComp;
                TableFrameTasks.adaptInspectorToTable(table);
                return table;
            }
        }
        TableFrameTasks.adaptInspectorToTable(null);
        return null;
    }

    public static boolean hasMainTable() {
        return cvMainTable != null;
    }

    public static boolean showTasks(Vector mice, boolean withExecution, boolean alsohistorical) {
        if (mice != null && !mice.isEmpty()) {
            boolean tasksDa = false;
            Iterator iter = mice.iterator();
            while (iter.hasNext() && !tasksDa) {
                Mouse mouse = (Mouse)iter.next();
                TaskExtended[] tarr = (TaskExtended[])mouse.get("MOS_TASKSEXT");
                if (tarr == null || tarr.length == 0) continue;
                tasksDa = true;
            }
            if (tasksDa || alsohistorical) {
                if (withExecution) {
                    TableFrameTasks.showTasks(mice, alsohistorical);
                }
                return true;
            }
        }
        return false;
    }

    public static void showWeanAlert(Vector cages, boolean forceShowFrame) {
        if (cages != null && !cages.isEmpty() || forceShowFrame) {
            if (cvWeanAlert == null) {
                cvWeanAlert = new MausoleumTable(new MTCageWeaning(), false);
                cvWeanAlert.setIsSubdisplay();
                cvWeanAlert.setHeader(Babel.get("WEANALERT"));
                TABBED_PANE.insertTab(Babel.get("WEANING"), ImageProvider.getBulletIcon(Color.red), cvWeanAlert, Babel.get("WEANALERT"), 0);
            }
            TableFrameTasks.showAlertTable(cvWeanAlert, cages, forceShowFrame);
        }
    }

    public static void showPlugAlert(Vector mice, boolean forceShowFrame) {
        if (mice != null && !mice.isEmpty()) {
            if (cvPlugAlert == null) {
                cvPlugAlert = new MausoleumTable(new MTMousePlugAlert(), false);
                cvPlugAlert.setIsSubdisplay();
                cvPlugAlert.setHeader(Babel.get("BAMBINIALERT"));
                TABBED_PANE.insertTab(Babel.get("PLUGS"), ImageProvider.getBulletIcon(Color.red), cvPlugAlert, Babel.get("BAMBINIALERT"), 0);
            }
            TableFrameTasks.showAlertTable(cvPlugAlert, mice, forceShowFrame);
        }
    }

    public static void showTasks(Vector mice, boolean alsoHistorical) {
        TaskTreeNode.addTemporaryTasks(mice, alsoHistorical);
        TaskTreeNode.TREE.setSelectionPath(new TreePath(TaskTreeNode.PATH_ARR_TEMPORARY));
        TableFrameTasks.treeSelectionChanged();
        TableFrameTasks.showTaskTree();
    }

    public static void showTaskTree() {
        MausoleumTableFrame.showComponent(cvTaskTreePane);
    }

    public static void standardsChanged(String command) {
        if (StandardTask.reinitForCommand(command) && StandardTaskPanel.hasPanel()) {
            StandardTaskPanel.getPanel().standardsChanged();
        }
    }

    public static void merkeSelektion() {
        VORHER_SELEKTIERT.clear();
        TableFrameTasks.cvMainTable.ivModel.addSelectedObjects(VORHER_SELEKTIERT);
    }

    public static void vergesseSelektion() {
        VORHER_SELEKTIERT.clear();
    }

    public static void treeSelectionChanged() {
        boolean pending = true;
        Vector sammler = null;
        TreePath[] tparr = TaskTreeNode.TREE.getSelectionPaths();
        if (tparr != null) {
            TaskTreeNode[] ttnarr = new TaskTreeNode[tparr.length];
            int sizsum = 0;
            int i = 0;
            while (i < tparr.length) {
                ttnarr[i] = (TaskTreeNode)tparr[i].getLastPathComponent();
                sizsum += ttnarr[i].ivLastCalcedSum;
                if (!ttnarr[i].isUnder(TaskTreeNode.PENDING)) {
                    pending = false;
                }
                ++i;
            }
            sammler = new Vector(sizsum);
            i = 0;
            while (i < tparr.length) {
                ttnarr[i].collectTasks(sammler);
                ++i;
            }
        }
        TableFrameTasks.cvMainTable.ivModel.setTable(sammler == null ? new Vector() : sammler, false);
        ((MTTask)TableFrameTasks.cvMainTable.ivModel).setSortModeOnTop(pending);
        TableFrameTasks.cvMainTable.ivModel.resortOrDefault();
        if (!VORHER_SELEKTIERT.isEmpty()) {
            HashSet<Long> selIDs = new HashSet<Long>();
            Iterator iterator = VORHER_SELEKTIERT.iterator();
            while (iterator.hasNext()) {
                DisplayTask dt = (DisplayTask)iterator.next();
                selIDs.add(new Long(dt.ivTask.ivPseudoID));
            }
            Vector<DisplayTask> prevSel = new Vector<DisplayTask>();
            Iterator iterator2 = TableFrameTasks.cvMainTable.ivModel.ivObjects.iterator();
            while (iterator2.hasNext()) {
                DisplayTask dt = (DisplayTask)iterator2.next();
                if (!selIDs.contains(new Long(dt.ivTask.ivPseudoID))) continue;
                prevSel.add(dt);
            }
            if (!prevSel.isEmpty()) {
                TableFrameTasks.cvMainTable.ivModel.adjustSelection(prevSel);
            }
            prevSel.clear();
            prevSel = null;
            selIDs.clear();
            Object var3_3 = null;
        }
        if (cvMainTable.getIsActive()) {
            TableFrameTasks.adaptInspectorToTable(cvMainTable);
        }
        TableFrameTasks.manageDependents((MTTask)TableFrameTasks.cvMainTable.ivModel);
    }

    public static void adaptInspectorToTable(MausoleumTable table) {
        Inspector.adjustToTable(table);
        if (table != null) {
            TableFrameTasks.manageDependents(table.ivModel);
        }
    }

    private static void showAlertTable(MausoleumTable table, Vector objects, boolean forceShowFrame) {
        table.ivModel.setTable(objects);
        if (table.ivModel.getRowCount() != 0) {
            cvShowFrame = true;
            if (forceShowFrame) {
                JFrame jf = WindowUtils.getJFrameAndSelectTabs(table);
                WindowUtils.bringUpFrame(jf);
            }
        }
    }

    private static void manageDependents(MausoleumTableModel mtm) {
        if (mtm != null && mtm instanceof MTTask) {
            MTTask mtTask = (MTTask)mtm;
            if (mtTask.ivDependentMouseTable != null) {
                Vector erg = TaskExtended.getTheImplicitlySelectedMice(mtTask.getSelectedObjects());
                mtTask.ivDependentMouseTable.ivModel.setTable(erg);
            }
        }
    }
}

