/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManager;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.models.MTMouse;

public abstract class MTAgeGroup
extends MTMouse {
    public static final int TYP_MIKRO = 0;
    public static final int TYP_MINI = 1;
    public static final int TYP_MIDI = 2;
    public static final int TYP_NORMAL = 3;
    public static final int TYP_OLD = 4;
    public static final int TYP_METHUSALEM = 5;
    private static final int ANZ_TYPEN = 6;
    private static final MTAgeGroup[] AGE_TABLES = new MTAgeGroup[6];
    private static final int[] MAX_AGEs = new int[6];
    private int ivMinAge = Integer.MIN_VALUE;
    private int ivMaxAge = Integer.MIN_VALUE;
    static /* synthetic */ Class class$0;

    public static MausoleumTable getTable(int min, int max, int type) {
        MTAgeGroup mtag = null;
        switch (type) {
            case 0: {
                mtag = new MTAgeGroupMikro();
                break;
            }
            case 1: {
                mtag = new MTAgeGroupMini();
                break;
            }
            case 2: {
                mtag = new MTAgeGroupMidi();
                break;
            }
            case 4: {
                mtag = new MTAgeGroupOld();
                break;
            }
            case 5: {
                mtag = new MTAgeGroupMethusalem();
                break;
            }
            default: {
                mtag = new MTAgeGroupNormal();
            }
        }
        mtag.ivMinAge = min;
        MTAgeGroup.MAX_AGEs[type] = mtag.ivMaxAge = max;
        MTAgeGroup.AGE_TABLES[type] = mtag;
        MausoleumTable mt = new MausoleumTable(mtag, false);
        mt.setIsSubdisplay();
        String titel = null;
        if (mtag.ivMinAge != Integer.MIN_VALUE && mtag.ivMaxAge != Integer.MAX_VALUE) {
            titel = String.valueOf(Babel.get("MICE_BORN_BETWEEN")) + " " + DatumFormat.getJustDateString(MyDate.HEUTE - mtag.ivMaxAge, false) + " " + Babel.get("MICE_BORN_AND") + " " + DatumFormat.getJustDateString(MyDate.HEUTE - mtag.ivMinAge, false);
        } else if (mtag.ivMinAge == Integer.MIN_VALUE && mtag.ivMaxAge != Integer.MIN_VALUE) {
            titel = String.valueOf(Babel.get("MICE_BORN_AFTER")) + " " + DatumFormat.getJustDateString(MyDate.HEUTE - mtag.ivMaxAge, false);
        } else if (mtag.ivMinAge != Integer.MIN_VALUE && mtag.ivMaxAge == Integer.MAX_VALUE) {
            titel = String.valueOf(Babel.get("MICE_BORN_BEFORE")) + " " + DatumFormat.getJustDateString(MyDate.HEUTE - mtag.ivMinAge, false);
        }
        if (titel != null) {
            mt.setHeader(titel, FontManager.getFont("SSB12"));
        }
        return mt;
    }

    public static void initAgeTables() {
        MouseManager om = MouseManager.cvInstance;
        if (om != null) {
            Vector[] vectors = new Vector[6];
            int i = 0;
            while (i < 6) {
                vectors[i] = new Vector(400);
                ++i;
            }
            try {
                Vector ori = om.getActualObjectVectorAllGroups();
                Iterator iter = ori.iterator();
                while (iter.hasNext()) {
                    int alter;
                    Mouse mouse = (Mouse)iter.next();
                    if (!mouse.isAliveAndVisible() || (alter = mouse.getAgeInDays(Integer.MIN_VALUE)) == Integer.MIN_VALUE) continue;
                    boolean ndone = true;
                    int i2 = 0;
                    while (i2 < vectors.length && ndone) {
                        if (alter <= MAX_AGEs[i2]) {
                            vectors[i2].add(mouse);
                            ndone = false;
                        }
                        ++i2;
                    }
                }
                int i3 = 0;
                while (i3 < vectors.length) {
                    MTAgeGroup mg = AGE_TABLES[i3];
                    mg.setTable(vectors[i3]);
                    mg.sortDefault();
                    ++i3;
                }
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.tables.models.MTAgeGroup");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Problem fillMainTable", e, clazz);
            }
        }
        int i = 0;
        while (i < AGE_TABLES.length) {
            MTAgeGroup.AGE_TABLES[i] = null;
            ++i;
        }
    }

    public void handleNewObjects(Vector idObjects) {
        boolean changed = false;
        Vector restObjects = new Vector(idObjects.size());
        Vector v = new Vector();
        this.addOriginalObjects(v);
        Iterator iterator = idObjects.iterator();
        while (iterator.hasNext()) {
            Object ooo = iterator.next();
            if (ooo instanceof Mouse) {
                Mouse mouse = (Mouse)ooo;
                changed |= this.handleNewMouse(mouse, v);
                continue;
            }
            restObjects.add(ooo);
        }
        if (changed) {
            this.setTable(v);
        }
        super.handleNewObjects(restObjects);
    }

    public void handleNewObject(IDObject object) {
        if (object instanceof Mouse) {
            Vector v = new Vector();
            this.addOriginalObjects(v);
            if (this.handleNewMouse((Mouse)object, v)) {
                this.setTable(v);
            }
        } else {
            super.handleNewObject(object);
        }
    }

    private boolean handleNewMouse(Mouse mouse, Vector v) {
        boolean changed = false;
        int ind = this.getIndexIfContained(mouse, v);
        if (this.mussRein(mouse)) {
            if (ind != -1) {
                v.setElementAt(mouse, ind);
                changed = true;
            } else {
                v.add(mouse);
                changed = true;
            }
        } else if (ind != -1) {
            v.removeElementAt(ind);
            changed = true;
        }
        return changed;
    }

    private boolean mussRein(Mouse mouse) {
        int alter;
        return !(!mouse.isAliveAndVisible() || (alter = mouse.getAgeInDays(Integer.MIN_VALUE)) == Integer.MIN_VALUE || this.ivMinAge != Integer.MIN_VALUE && alter < this.ivMinAge || this.ivMaxAge != Integer.MIN_VALUE && alter > this.ivMaxAge);
    }

    private static class MTAgeGroupMethusalem
    extends MTAgeGroup {
        private MTAgeGroupMethusalem() {
        }
    }

    private static class MTAgeGroupMidi
    extends MTAgeGroup {
        private MTAgeGroupMidi() {
        }
    }

    private static class MTAgeGroupMikro
    extends MTAgeGroup {
        private MTAgeGroupMikro() {
        }
    }

    private static class MTAgeGroupMini
    extends MTAgeGroup {
        public int getRowCount() {
            return super.getRowCount();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    private static class MTAgeGroupNormal
    extends MTAgeGroup {
        private MTAgeGroupNormal() {
        }
    }

    private static class MTAgeGroupOld
    extends MTAgeGroup {
        private MTAgeGroupOld() {
        }
    }
}

