/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManager;
import mausoleum.mail.Mail;
import mausoleum.mail.MailManager;
import mausoleum.tables.MausoleumTableModel;

public abstract class MTMail
extends MausoleumTableModel {
    protected static final String STR_SENDER = "SENDER";
    protected static final String STR_RECIP = "RECIPIENT";
    protected static final String STR_SUBJ = "SUBJECT";
    protected static final String STR_DATE = "DATE";
    protected static final String STR_ATTACH = "ATTACHMENT";
    private static final String[] TT_DICT = new String[]{"SENDER", "MTMA_TT_SENDER", "RECIPIENT", "MTMA_TT_RECIPIENT", "SUBJECT", "MTMA_TT_SUBJECT", "DATE", "MTMA_TT_DATE", "ATTACHMENT", "MTMA_TT_ATTACHMENT"};
    private static final String[] POSSIBLES = new String[]{"SENDER", "RECIPIENT", "SUBJECT", "DATE", "ATTACHMENT"};
    private static final String[] SORTABLES = new String[]{"SENDER", "RECIPIENT", "SUBJECT", "DATE", "ATTACHMENT"};
    private static final String[] EDITABLES = new String[0];
    private static final String[] COLORABLES = new String[0];
    private static final String[] FILTERABLES = new String[]{"SENDER", "RECIPIENT", "SUBJECT"};
    private static final HashMap PLAIN_SORTINGS = new HashMap(GENERAL_PLAIN_SORTINGS);
    static /* synthetic */ Class class$0;

    static {
        PLAIN_SORTINGS.put(STR_SENDER, "MAI_SENDER");
        PLAIN_SORTINGS.put(STR_RECIP, "MAI_RECEIVER");
        PLAIN_SORTINGS.put(STR_SUBJ, "MAI_SUBJECT");
        PLAIN_SORTINGS.put(STR_ATTACH, "MAI_ATTINFO");
        PLAIN_SORTINGS.put(STR_DATE, "IDO_START_DATE");
    }

    public abstract boolean checkReceiver();

    public int getTableType() {
        return 7;
    }

    public ActionListener getActionListenerForColumn(String colName) {
        return null;
    }

    public int[] getConsumertypes() {
        return new int[]{11};
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getPossibleColumns() {
        return POSSIBLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public HashMap getPlainSortings() {
        return PLAIN_SORTINGS;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[0];
    }

    public int[] getWidths() {
        return new int[]{130, 100, 150, 150};
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.mail.Mail");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return MailManager.cvInstance;
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        Mail s = (Mail)obj;
        if (s.getBoolean("MAI_READ", false)) {
            label.setFont(FontManager.getTableFont(false, this.ivUseDefaultFontSize, this.ivZoom));
        } else {
            label.setFont(FontManager.getTableFont(true, this.ivUseDefaultFontSize, this.ivZoom));
        }
        if (colName.equals(STR_SENDER)) {
            label.setText(s.getCLLWSenderString());
        } else if (colName.equals(STR_RECIP)) {
            label.setText(s.getCLLWReceiverString());
        } else if (colName.equals(STR_SUBJ)) {
            label.setText(s.getString("MAI_SUBJECT"));
        } else if (colName.equals(STR_DATE)) {
            Date d = (Date)s.get("IDO_START_DATE");
            if (d != null) {
                label.setText(DatumFormat.getDateTimeString(d.getTime()));
            }
        } else if (colName.equals(STR_ATTACH)) {
            String rein = "";
            String attinfo = s.getString("MAI_ATTINFO", null);
            if (attinfo != null && attinfo != null && !attinfo.equals("null")) {
                rein = StringHelper.gSub(attinfo, "_", " ");
            }
            label.setText(rein);
        } else {
            super.writeGeneralElement(label, obj, colName, isForFilterSplit);
        }
    }

    public void fillSortVector(Vector mses, String column, int pos) {
    }

    public void sortDefault() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.sortItDirect(new String[]{STR_DATE, this.getDefaultSortColumn()}, blArray);
    }

    public boolean filterObject(Object ooo) {
        if (!UserManager.isPseudoGuruSession() && ooo instanceof Mail) {
            Mail m = (Mail)ooo;
            User user = UserManager.getUser();
            return m.isItOwner(user) && (this.checkReceiver() ? m.isItReceiver(user) : m.isItSender(user));
        }
        return false;
    }
}

