/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.user.UserRoomRestriction;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JSeparator;
import javax.swing.event.TableModelEvent;
import mausoleum.alert.Alert;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.AgeColor;
import mausoleum.cage.colors.LitterColor;
import mausoleum.cage.colors.MissingGenoptypesColor;
import mausoleum.cage.colors.SexColor;
import mausoleum.cage.colors.SymptomColor;
import mausoleum.cage.colors.UntaggedColor;
import mausoleum.cage.colors.WeaningColor;
import mausoleum.experiment.Experiment;
import mausoleum.factsheets.FactSheetFrame;
import mausoleum.factsheets.FactSheetMouse;
import mausoleum.factsheets.FactSheetWurf;
import mausoleum.factsheets.MatingPerformanceCollector;
import mausoleum.factsheets.PlugReport;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MFLabel;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.Code39Creator;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.helper.WindowUtils;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.idobjectgroup.IDObjectGroupManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanelMouse;
import mausoleum.inspector.actions.room.RoomAction;
import mausoleum.inspector.panels.MouseInspHealthReportPanel;
import mausoleum.line.Line;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.CoatColor;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseIDCard;
import mausoleum.mouse.MouseManager;
import mausoleum.mouse.WeaningControl;
import mausoleum.mouse.tierschutz.Stress;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.printing.util.Wurf;
import mausoleum.rack.RackPos;
import mausoleum.rack.frame.MausoleumPool;
import mausoleum.reports.PlaisantReport;
import mausoleum.requester.mouse.SetMouseParentCheckRequester;
import mausoleum.result.MResult;
import mausoleum.result.embryotransfer.EmbryoTransfer;
import mausoleum.room.Room;
import mausoleum.room.RoomStatusListener;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.SplitFilterObject;
import mausoleum.tables.TableFrameMouse;
import mausoleum.tables.models.MTCage;
import mausoleum.tables.models.TableUtil;
import mausoleum.tables.sorting.MultiSortEntry;
import mausoleum.tables.util.MTPUAddDecider;
import mausoleum.tables.util.MTPUItem;
import mausoleum.tables.util.MTPUMenu;
import mausoleum.tables.util.MTPopupHelper;
import mausoleum.ui.UIDef;
import mausoleum.util.InstallationType;
import mausoleum.visit.Visit;

public class MTMouse
extends MausoleumTableModel
implements RoomStatusListener {
    public static final String STR_MARK = "MARKSHORT";
    public static final String STR_OWNER = "OWNERSHORT";
    public static final String STR_ALLOWNER = "ALL_OWNERS";
    public static final String STR_EARTAG = "EARTAGSHORT";
    public static final String STR_EARTAGPLUS = "EARTAGSHORTPLUS";
    public static final String STR_SEX = "S";
    public static final String STR_CAGE = "CAGE";
    public static final String STR_AGE = "AGE";
    public static final String STR_BIRTHDAY = "BIRTHDAY";
    public static final String STR_WEDDING = "WEDDINGSHORT";
    public static final String STR_WEDDING_EXT = "WEDDING_EXT";
    public static final String STR_LINE = "LINE";
    public static final String STR_GT = "GENOTYPE";
    public static final String STR_STRAIN = "STRAIN";
    public static final String STR_RACK = "RACK";
    public static final String STR_RACK_POS = "RACK_POS";
    public static final String STR_RACK_AND_POS = "RACK_AND_POS";
    public static final String STR_ROOM = "ROOM";
    public static final String STR_PLUG = "PD";
    public static final String STR_ANTAG = "ANTAG";
    public static final String STR_MATLIM = "MATLIM";
    public static final String STR_BARCODE = "BARCODE";
    public static final String STR_LICENSE = "LICENSE";
    public static final String STR_KIDS = "KIDS";
    public static final String STR_COHORTS = "COHORTS";
    public static final String STR_STARTMODE = "START_MODE";
    public static final String STR_ENDMODE = "END_MODE";
    public static final String STR_GENERATION_PF = "GENERATION_PF";
    public static final String STR_FATHER_ID = "FATHER_ID";
    public static final String STR_MOTHER_ID = "MOTHER_ID";
    public static final String STR_FOSTER_ID = "FOSTER_ID";
    public static final String STR_FATHER_ET = "FATHER_ET";
    public static final String STR_MOTHER_ET = "MOTHER_ET";
    public static final String STR_FOSTER_ET = "FOSTER_ET";
    public static final String STR_FATHER_GT = "FATHER_GT";
    public static final String STR_MOTHER_GT = "MOTHER_GT";
    public static final String STR_FOSTER_GT = "FOSTER_GT";
    public static final String STR_FATHER_BIRTHDAY = "FATHER_BIRTHDAY";
    public static final String STR_MOTHER_BIRTHDAY = "MOTHER_BIRTHDAY";
    public static final String STR_WEANED = "WEANED";
    public static final String STR_DAYS_TO_WEAN = "DAYS_TO_WEAN";
    public static final String STR_COAT_COLOR = "COAT_COLOR";
    public static final String STR_RESULTS = "RESULTS";
    public static final String STR_COMMENT = "COMMENT";
    public static final String STR_PREGNANT = "PREGANT_DATE";
    public static final String STR_SYMPTOM_LIST = "LAST_SYMPTOM_LIST";
    public static final String STR_ORIGIN = "ORIGIN";
    public static final String STR_DESTINATION = "DESTINATION";
    public static final String STR_SPEC_DATE = "SPECIAL_DATE";
    public static final String STR_DIFF_SPEC_DATE = "DIFF_SPECIAL_DATE";
    public static final String STR_STRESS_LEVEL_LIFE = "STRESS_LEVEL_LIFE";
    public static final String STR_STRESS_LEVEL_EXP = "STRESS_LEVEL_EXPERIMENT";
    public static final String STR_LINE_STRESS_LEVEL = "LINE_STRESS_LEVEL";
    public static final String STR_LITTER_COUNT = "LITTER_COUNT";
    private static final String[] TT_DICT = new String[]{"MARKSHORT", "MTM_TT_MARKSHORT", "OWNERSHORT", "MTM_TT_OWNERSHORT", "ALL_OWNERS", "MTM_TT_ALL_OWNER", "EARTAGSHORT", "MTM_TT_EARTAGSHORT", "EARTAGSHORTPLUS", "MTM_TT_EARTAGSHORTPLUS", "S", "MTM_TT_S", "CAGE", "MTM_TT_CAGE", "AGE", "MTM_TT_AGE", "BIRTHDAY", "MTM_TT_BIRTHDAY", "WEDDINGSHORT", "MTM_TT_WEDDINGSHORT", "WEDDING_EXT", "MTM_TT_WEDDING_EXT", "LINE", "MTM_TT_LINE", "GENOTYPE", "MTM_TT_GENOTYPE", "STRAIN", "MTM_TT_STRAIN", "RACK", "MTM_TT_RACK", "RACK_POS", "MTM_TT_RACK_POS", "RACK_AND_POS", "MTM_TT_RACK_AND_POS", "PD", "MTM_TT_PD", "ANTAG", "MTM_TT_ANTAG", "MATLIM", "MTM_TT_MATLIM", "BARCODE", "MTM_TT_BARCODE", "LICENSE", "MTM_TT_LICENSE", "KIDS", "MTM_TT_KIDS", "COHORTS", "MTM_TT_COHORTS", "START_MODE", "MTC_TT_STARTMODE", "END_MODE", "MTC_TT_ENDMODE", "GENERATION_PF", "MTM_TT_GENERATION_PF", "FATHER_ID", "MTM_TT_FATHER_ID", "MOTHER_ID", "MTM_TT_MOTHER_ID", "FOSTER_ID", "MTM_TT_FOSTER_ID", "FATHER_ET", "MTM_TT_FATHER_ET", "MOTHER_ET", "MTM_TT_MOTHER_ET", "FOSTER_ET", "MTM_TT_FOSTER_ET", "FATHER_GT", "MTM_TT_FATHER_GT", "MOTHER_GT", "MTM_TT_MOTHER_GT", "FOSTER_GT", "MTM_TT_FOSTER_GT", "FATHER_BIRTHDAY", "MTM_TT_FATHER_BIRTHDAY", "MOTHER_BIRTHDAY", "MTM_TT_MOTHER_BIRTHDAY", "WEANED", "MTM_TT_WEANED", "DAYS_TO_WEAN", "MTM_TT_WEANING_DAYS", "COAT_COLOR", "MTM_TT_COAT_COLOR", "ROOM", "TT_ROOM_NAME", "RESULTS", "MT_TT_RESULTS", "PREFIX", "MTM_TT_EARTG_PREFIX", "COMMENT", "MTM_TT_COMMENT", "PREGANT_DATE", "MTM_TT_PREGNANT_DATE", "LAST_SYMPTOM_LIST", "MTM_TT_LAST_SYMPTOM_LIST", "ORIGIN", "MTM_TT_ORIGIN", "DESTINATION", "MTM_TT_DESTINATION", "SPECIAL_DATE", "TT_SPECIAL_DATE", "DIFF_SPECIAL_DATE", "TT_DIFF_SPECIAL_DATE", "STRESS_LEVEL_LIFE", "MTM_TT_STRESS_LEVEL_LIFE", "STRESS_LEVEL_EXPERIMENT", "MTM_TT_STRESS_LEVEL_EXP", "LINE_STRESS_LEVEL", "MTM_TT_LINE_STRESS_LEVEL", "LITTER_COUNT", "MTM_TT_LITTER_COUNT"};
    private static final String[] POSSIBLES = new String[]{"MARKSHORT", "OWNERSHORT", "ALL_OWNERS", "EARTAGSHORT", "EARTAGSHORTPLUS", "S", "CAGE", "AGE", "BIRTHDAY", "WEDDINGSHORT", "WEDDING_EXT", "LINE", "GENOTYPE", "STRAIN", "RACK", "RACK_POS", "RACK_AND_POS", "PD", "ANTAG", "MATLIM", "BARCODE", "LICENSE", "KIDS", "COHORTS", "START_MODE", "END_MODE", "GENERATION_PF", "FATHER_ID", "MOTHER_ID", "FOSTER_ID", "FATHER_ET", "MOTHER_ET", "FOSTER_ET", "FATHER_GT", "MOTHER_GT", "FOSTER_GT", "FATHER_BIRTHDAY", "MOTHER_BIRTHDAY", "WEANED", "DAYS_TO_WEAN", "COAT_COLOR", "ROOM", "RESULTS", "PREFIX", "COMMENT", "PREGANT_DATE", "LAST_SYMPTOM_LIST", "ORIGIN", "DESTINATION", "SPECIAL_DATE", "DIFF_SPECIAL_DATE", "STRESS_LEVEL_LIFE", "STRESS_LEVEL_EXPERIMENT", "LINE_STRESS_LEVEL", "LITTER_COUNT"};
    private static final String[] SORTABLES = new String[]{"EARTAGSHORT", "EARTAGSHORTPLUS", "OWNERSHORT", "ALL_OWNERS", "S", "CAGE", "AGE", "BIRTHDAY", "WEDDINGSHORT", "WEDDING_EXT", "LINE", "GENOTYPE", "STRAIN", "RACK", "RACK_POS", "RACK_AND_POS", "MARKSHORT", "PD", "COHORTS", "ID", "FKEY", "ANTAG", "MATLIM", "BARCODE", "LICENSE", "KIDS", "START_MODE", "END_MODE", "GENERATION_PF", "FATHER_ID", "MOTHER_ID", "FOSTER_ID", "FATHER_ET", "MOTHER_ET", "FOSTER_ET", "FATHER_GT", "MOTHER_GT", "FOSTER_GT", "FATHER_BIRTHDAY", "MOTHER_BIRTHDAY", "WEANED", "DAYS_TO_WEAN", "COAT_COLOR", "ROOM", "RESULTS", "PREFIX", "COMMENT", "PREGANT_DATE", "LAST_SYMPTOM_LIST", "ORIGIN", "DESTINATION", "SPECIAL_DATE", "DIFF_SPECIAL_DATE", "STRESS_LEVEL_LIFE", "STRESS_LEVEL_EXPERIMENT", "LINE_STRESS_LEVEL", "LITTER_COUNT"};
    private static final String[] EDITABLES = new String[]{"EARTAGSHORT", "EARTAGSHORTPLUS", "S", "AGE", "BIRTHDAY", "LINE", "GENOTYPE", "STRAIN", "MARKSHORT", "ANTAG", "MATLIM", "GENERATION_PF", "COAT_COLOR", "SPECIAL_DATE", "STRESS_LEVEL_LIFE", "STRESS_LEVEL_EXPERIMENT"};
    private static final String[] FILTERABLES = new String[]{"MARKSHORT", "OWNERSHORT", "S", "EARTAGSHORT", "EARTAGSHORTPLUS", "AGE", "BIRTHDAY", "CAGE", "WEDDINGSHORT", "WEDDING_EXT", "LINE", "STRAIN", "RACK", "MATLIM", "LICENSE", "START_MODE", "END_MODE", "GENERATION_PF", "FATHER_ID", "MOTHER_ID", "FOSTER_ID", "DAYS_TO_WEAN", "COAT_COLOR", "ROOM", "RESULTS", "PREFIX", "COMMENT", "PREGANT_DATE", "ORIGIN", "DESTINATION", "SPECIAL_DATE", "DIFF_SPECIAL_DATE", "STRESS_LEVEL_LIFE", "STRESS_LEVEL_EXPERIMENT", "LINE_STRESS_LEVEL", "LITTER_COUNT"};
    private static final String[] SPLITTABLES = new String[]{"MARKSHORT", "OWNERSHORT", "S", "EARTAGSHORT", "EARTAGSHORTPLUS", "AGE", "BIRTHDAY", "CAGE", "WEDDINGSHORT", "WEDDING_EXT", "LINE", "STRAIN", "RACK", "MATLIM", "LICENSE", "START_MODE", "END_MODE", "GENERATION_PF", "FATHER_ID", "MOTHER_ID", "FOSTER_ID", "DAYS_TO_WEAN", "COAT_COLOR", "ROOM", "RESULTS", "PREFIX", "GENOTYPE", "PREGANT_DATE", "ORIGIN", "DESTINATION", "STRESS_LEVEL_LIFE", "STRESS_LEVEL_EXPERIMENT", "LINE_STRESS_LEVEL", "LITTER_COUNT"};
    private static final String[] DEFAULT_COLUMNS = new String[]{"MARKSHORT", "EARTAGSHORT", "S", "CAGE", "RACK", "AGE", "WEDDINGSHORT", "LINE", "GENOTYPE", "STRAIN", "PD"};
    private static final String[] COLORABLES = new String[]{"OWNERSHORT", "ALL_OWNERS", "S", "CAGE", "AGE", "BIRTHDAY", "WEDDINGSHORT", "WEDDING_EXT", "LINE", "STRAIN", "RACK", "RACK_AND_POS", "LICENSE", "GENOTYPE", "EARTAGSHORT", "EARTAGSHORTPLUS", "COHORTS", "DAYS_TO_WEAN", "COAT_COLOR", "ROOM", "FATHER_ET", "MOTHER_ET", "FOSTER_ET", "LAST_SYMPTOM_LIST", "STRESS_LEVEL_LIFE", "STRESS_LEVEL_EXPERIMENT", "LINE_STRESS_LEVEL", "LITTER_COUNT", "FATHER_GT", "MOTHER_GT", "FOSTER_GT"};
    private static final String[] FISH_UNWANTED = new String[]{"WEDDINGSHORT", "WEDDING_EXT", "PD", "WEANED", "DAYS_TO_WEAN", "PREGANT_DATE", "LITTER_COUNT", "FATHER_GT", "MOTHER_GT", "FOSTER_GT"};
    private static final String[] UNWANTED_WITHOUT_STRESS = new String[]{"STRESS_LEVEL_LIFE", "STRESS_LEVEL_EXPERIMENT", "LINE_STRESS_LEVEL"};
    private static final String[] UNWANTED_WITHOUT_EMBRYOTRANSFER = new String[]{"FOSTER_ID", "FOSTER_ET"};
    public static final Calendar SOLL_CAL = Calendar.getInstance();
    private static final HashMap PLAIN_SORTINGS = new HashMap(GENERAL_PLAIN_SORTINGS);
    private TableFrameMouse ivTableFrame = null;
    public boolean ivWantOwnerButton = true;
    protected boolean ivFilterByRooms = true;
    private static MTPUItem MATING_REPORT_ITEM;
    private static MTPUItem MATING_REPORT_EXT_ITEM;
    private static MTPUItem MATINGPERFOMANCE_ITEM;
    private static MTPUItem LITTERREPORT_EXTENDED_ITEM;
    private static MTPUItem FOSTERREPORT_EXTENDED_ITEM;
    private static MTPUItem VISITREPORT_ITEM;
    private static MTPUItem PLUG_REPORT_ITEM;
    private static MTPUItem STRESS_REPORT_ITEM;
    private static MTPUItem STRESS_REPORT_ITEM_EXT;
    private static MTPUItem SET_FATHER_ITEM;
    private static MTPUItem SET_MOTHER_ITEM;
    private static MTPUItem PLAISANT_REPORT_ITEM;
    private static MTPUItem POOL_ADD_ITEM;
    private static MTPUItem POOL_REMOVE_ITEM;
    private static MTPUItem POOL_CLEAR_ITEM1;
    private static MTPUItem POOL_CLEAR_ITEM2;
    private static final MTPUItem POOL_SHOW1;
    private static final MTPUItem POOL_SHOW2;
    private static final MTPUMenu POOLMENU_WITH_SELECTEDS;
    private static final MTPUMenu POOLMENU_WITHOUT_SELECTEDS;
    static /* synthetic */ Class class$0;

    static {
        PLAIN_SORTINGS.put(STR_EARTAG, "MOS_EARTAG");
        PLAIN_SORTINGS.put(STR_EARTAGPLUS, "MOS_EARTAG");
        PLAIN_SORTINGS.put(STR_SEX, Mouse.getSexTag());
        PLAIN_SORTINGS.put(STR_STARTMODE, "MOS_STARTMODE");
        PLAIN_SORTINGS.put(STR_ENDMODE, "MOS_ENDMODE");
        PLAIN_SORTINGS.put(STR_MATLIM, "MOS_MATLIM");
        PLAIN_SORTINGS.put(STR_BIRTHDAY, "MOS_BIRTHDAY");
        PLAIN_SORTINGS.put(STR_PLUG, "MOS_PLUGDATE");
        PLAIN_SORTINGS.put(STR_ANTAG, "MOS_ANTAG");
        PLAIN_SORTINGS.put(STR_FATHER_ID, "MOS_FATHER");
        PLAIN_SORTINGS.put(STR_MOTHER_ID, "MOS_MOTHER");
        PLAIN_SORTINGS.put(STR_FOSTER_ID, "MOS_FOSTID");
        PLAIN_SORTINGS.put(STR_MARK, "MOS_FLAG");
        PLAIN_SORTINGS.put(STR_COMMENT, "MOS_COMMENT");
        PLAIN_SORTINGS.put(STR_PREGNANT, "MOS_PREGNANT");
        PLAIN_SORTINGS.put(STR_SPEC_DATE, "MOS_SPDAT");
        MATING_REPORT_ITEM = new MTPUItem("MATINGREPORT", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector vector = MTPopupHelper.getSelectedObjects(e);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.mouse.Mouse");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                FactSheetFrame.showTab(vector, clazz.getName(), FactSheetMouse.SEL_MATING, Babel.get("MATINGREPORT"), Babel.get("MATINGREPORT"));
            }
        }, null);
        MATING_REPORT_EXT_ITEM = new MTPUItem("MATINGREPORT_EXTENDED", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector vector = MTPopupHelper.getSelectedObjects(e);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.mouse.Mouse");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                FactSheetFrame.showTab(vector, clazz.getName(), FactSheetMouse.SEL_MATING_EXT, Babel.get("MATINGREPORT_EXTENDED"), Babel.get("MATINGREPORT_EXTENDED"));
            }
        }, null);
        MATINGPERFOMANCE_ITEM = new MTPUItem("MATINGPERFOMANCE_REPORT", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector<MatingPerformanceCollector> v = new Vector<MatingPerformanceCollector>();
                v.add(new MatingPerformanceCollector(MTPopupHelper.getSelectedObjects(e)));
                FactSheetFrame.showTab(v, Babel.get("MATINGPERFOMANCE_REPORT"));
            }
        }, null);
        LITTERREPORT_EXTENDED_ITEM = new MTPUItem("LITTERREPORT_EXTENDED", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FactSheetWurf.showExtendedLitterReport((Mouse)MTPopupHelper.getSelectedObjects(e).firstElement(), WindowUtils.getJFrame(MTPopupHelper.getTable(e)));
            }
        }, new MTPUAddDecider(){

            public boolean shouldAddItem(Vector selectedObjects) {
                Mouse mouse;
                return selectedObjects.size() == 1 && (mouse = (Mouse)selectedObjects.firstElement()).getSex() == 2 && mouse.get("MOS_KID") != null;
            }
        });
        FOSTERREPORT_EXTENDED_ITEM = new MTPUItem("FOSTERREPORT_EXTENDED", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector pseudoWuerfe = new Vector();
                Vector selElements = MTPopupHelper.getSelectedObjects(e);
                Iterator iterator = selElements.iterator();
                while (iterator.hasNext()) {
                    Vector tPseudoWuerfe;
                    Mouse mouse = (Mouse)iterator.next();
                    if (mouse.getSex() != 2 || !mouse.getBoolean("MOS_WFOST", false) || (tPseudoWuerfe = Wurf.getFosterWuerfeForFactsheet(mouse)) == null) continue;
                    pseudoWuerfe.addAll(tPseudoWuerfe);
                }
                if (!pseudoWuerfe.isEmpty()) {
                    FactSheetWurf.showFosterLitterReport(WindowUtils.getJFrame(MTPopupHelper.getTable(e)), pseudoWuerfe, "FOSTERREPORT_EXTENDED");
                }
            }
        }, new MTPUAddDecider(){

            public boolean shouldAddItem(Vector selectedObjects) {
                if (!selectedObjects.isEmpty()) {
                    Iterator iterator = selectedObjects.iterator();
                    while (iterator.hasNext()) {
                        Mouse mouse = (Mouse)iterator.next();
                        if (mouse.getSex() != 2 || !mouse.getBoolean("MOS_WFOST", false)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        VISITREPORT_ITEM = new MTPUItem("VISITREPORT", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector vector = MTPopupHelper.getSelectedObjects(e);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.mouse.Mouse");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                FactSheetFrame.showTab(vector, clazz.getName(), FactSheetMouse.SEL_VISIT, Babel.get("VISITREPORT"), Babel.get("VISITREPORT"));
            }
        }, null);
        PLUG_REPORT_ITEM = new MTPUItem("PLUG_REPORT", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector vector = PlugReport.getMiceOKForShowingPlugReport(MTPopupHelper.getSelectedObjects(e));
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.mouse.Mouse");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                FactSheetFrame.showTab(vector, clazz.getName(), FactSheetMouse.SEL_PLUG_REPORT, Babel.get("PLUG_REPORT"), Babel.get("PLUG_REPORT"));
            }
        }, new MTPUAddDecider(){

            public boolean shouldAddItem(Vector selectedObjects) {
                return !PlugReport.getMiceOKForShowingPlugReport(selectedObjects).isEmpty();
            }
        });
        STRESS_REPORT_ITEM = new MTPUItem("BELASTUNGS_REPORT", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector vector = MTPopupHelper.getSelectedObjects(e);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.mouse.Mouse");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                FactSheetFrame.showTab(vector, clazz.getName(), FactSheetMouse.SEL_STRESS_DETAILS, Babel.get("BELASTUNGS_REPORT"), Babel.get("BELASTUNGS_REPORT"));
            }
        }, null);
        STRESS_REPORT_ITEM_EXT = new MTPUItem("BELASTUNGS_REPORT_EXT", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector vector = MTPopupHelper.getSelectedObjects(e);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.mouse.Mouse");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                FactSheetFrame.showTab(vector, clazz.getName(), FactSheetMouse.SEL_STRESS_DETAILS_EXT, Babel.get("BELASTUNGS_REPORT_EXT"), Babel.get("BELASTUNGS_REPORT_EXT"));
            }
        }, null);
        SET_FATHER_ITEM = new MTPUItem("DEFINE_FATHER", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((MTMouse)MTPopupHelper.getMTM(e)).setParent(true);
            }
        }, new MTPUAddDecider(){

            public boolean shouldAddItem(Vector selectedObjects) {
                return Mouse.isParentSettable(selectedObjects, true);
            }
        });
        SET_MOTHER_ITEM = new MTPUItem("DEFINE_MOTHER", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((MTMouse)MTPopupHelper.getMTM(e)).setParent(false);
            }
        }, new MTPUAddDecider(){

            public boolean shouldAddItem(Vector selectedObjects) {
                return Mouse.isParentSettable(selectedObjects, false);
            }
        });
        PLAISANT_REPORT_ITEM = new MTPUItem("PLAISANT_REPORT", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlaisantReport.makeReport(MTPopupHelper.getSelectedObjects(e));
            }
        }, null);
        POOL_ADD_ITEM = new MTPUItem("POOL_ADD", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MausoleumPool.addToPool(MTPopupHelper.getSelectedObjects(e));
            }
        }, null);
        POOL_REMOVE_ITEM = new MTPUItem("POOL_REMOVE", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MausoleumPool.removeFromPool(MTPopupHelper.getSelectedObjects(e));
            }
        }, null);
        POOL_CLEAR_ITEM1 = new MTPUItem("POOL_CLEAR", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MausoleumPool.clearPool();
            }
        }, null);
        POOL_CLEAR_ITEM2 = new MTPUItem("POOL_CLEAR", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MausoleumPool.clearPool();
            }
        }, null);
        POOL_SHOW1 = new MTPUItem("POOL_SHOW", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MausoleumPool.showPool();
            }
        }, null);
        POOL_SHOW2 = new MTPUItem("POOL_SHOW", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MausoleumPool.showPool();
            }
        }, null);
        POOLMENU_WITH_SELECTEDS = new MTPUMenu("POPUP_POOL", new MTPUItem[]{POOL_ADD_ITEM, POOL_REMOVE_ITEM, POOL_CLEAR_ITEM1, POOL_SHOW1});
        POOLMENU_WITHOUT_SELECTEDS = new MTPUMenu("POPUP_POOL", new MTPUItem[]{POOL_CLEAR_ITEM2, POOL_SHOW2});
    }

    public MTMouse(Vector mice) {
        this();
        this.setTable(mice);
    }

    public MTMouse() {
        this.ivOwnedObjects = true;
        RoomAction.addListener(this);
    }

    public MTMouse(boolean wantOwner, boolean listenToRoom) {
        this(null, wantOwner, listenToRoom);
    }

    public MTMouse(Vector mice, boolean wantOwner, boolean listenToRoom) {
        if (mice != null) {
            this.setTable(mice);
        }
        this.ivOwnedObjects = wantOwner;
        this.ivWantOwnerButton = wantOwner;
        this.ivFilterByRooms = listenToRoom;
        if (this.ivFilterByRooms) {
            RoomAction.addListener(this);
        }
    }

    public MausoleumTableModel getDefaultModel() {
        return new MTMouse();
    }

    public int getTableType() {
        return 8;
    }

    public String getDisplayName() {
        return Babel.get("TDN_MOUSE");
    }

    public ActionListener getActionListenerForColumn(String colName) {
        if (colName.equals(STR_MARK)) {
            return ((InspectorPanelMouse)Inspector.cvActPanel).ivCSMark;
        }
        if (colName.equals(STR_EARTAG) || colName.equals(STR_EARTAGPLUS)) {
            return ((InspectorPanelMouse)Inspector.cvActPanel).ivCSEartag;
        }
        if (colName.equals(STR_SEX)) {
            return ((InspectorPanelMouse)Inspector.cvActPanel).ivCSSex;
        }
        if (!colName.equals(STR_CAGE) && !colName.equals(STR_WEDDING)) {
            if (colName.equals(STR_GT)) {
                return ((InspectorPanelMouse)Inspector.cvActPanel).ivCSGenotype;
            }
            if (colName.equals(STR_STRAIN)) {
                return ((InspectorPanelMouse)Inspector.cvActPanel).ivCSStrain;
            }
            if (!colName.equals(STR_RACK)) {
                if (colName.equals(STR_LINE)) {
                    return ((InspectorPanelMouse)Inspector.cvActPanel).ivCSLine;
                }
                if (!colName.equals(STR_PLUG)) {
                    if (colName.equals(STR_AGE) || colName.equals(STR_BIRTHDAY)) {
                        return ((InspectorPanelMouse)Inspector.cvActPanel).ivCSBirthDay;
                    }
                    if (colName.equals(STR_ANTAG)) {
                        return ((InspectorPanelMouse)Inspector.cvActPanel).ivCSANTag;
                    }
                    if (colName.equals(STR_MATLIM)) {
                        return ((InspectorPanelMouse)Inspector.cvActPanel).ivCSMatLim;
                    }
                    if (colName.equals(STR_COAT_COLOR)) {
                        return ((InspectorPanelMouse)Inspector.cvActPanel).ivCSCoat;
                    }
                    if (colName.equals(STR_GENERATION_PF)) {
                        return ((InspectorPanelMouse)Inspector.cvActPanel).ivCSGeneration;
                    }
                    if (STR_SPEC_DATE.equals(colName)) {
                        return ((InspectorPanelMouse)Inspector.cvActPanel).ivCSSpecialDate;
                    }
                    if (colName.equals(STR_STRESS_LEVEL_LIFE)) {
                        return ((InspectorPanelMouse)Inspector.cvActPanel).ivStressLevelLife;
                    }
                    if (colName.equals(STR_STRESS_LEVEL_EXP)) {
                        return ((InspectorPanelMouse)Inspector.cvActPanel).ivStressLevelDeath;
                    }
                }
            }
        }
        return null;
    }

    public int[] getConsumertypes() {
        return new int[]{7, 14, 8, 1, 2, 16, 19, 20, 21};
    }

    public String[] getPossibleColumns() {
        return POSSIBLES;
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String getDefaultSortColumn() {
        if (ArrayHelper.contained(STR_EARTAG, this.ivColumnNames)) {
            return STR_EARTAG;
        }
        if (ArrayHelper.contained(STR_EARTAGPLUS, this.ivColumnNames)) {
            return STR_EARTAGPLUS;
        }
        return this.ivColumnNames != null && this.ivColumnNames.length != 0 ? this.ivColumnNames[0] : null;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public String[] getSplitableCols() {
        return SPLITTABLES;
    }

    public HashMap getPlainSortings() {
        return PLAIN_SORTINGS;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[]{STR_CAGE, STR_LINE};
    }

    public int[] getWidths() {
        return new int[]{25, 55, 40, 50, 50, 50, 30, 70, 130, 110, 40};
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public String[] getDefaultColumnNames() {
        return DEFAULT_COLUMNS;
    }

    public String[] checkColumns(String[] arr) {
        int i;
        if (arr != null && arr.length != 0 && !InstallationType.useMatings()) {
            i = 0;
            while (i < FISH_UNWANTED.length) {
                arr = ArrayHelper.getArrayWithout(arr, FISH_UNWANTED[i]);
                ++i;
            }
        }
        if (arr != null && arr.length != 0 && !TierSchutz.belastungNeeded()) {
            i = 0;
            while (i < UNWANTED_WITHOUT_STRESS.length) {
                arr = ArrayHelper.getArrayWithout(arr, UNWANTED_WITHOUT_STRESS[i]);
                ++i;
            }
        }
        if (arr != null && arr.length != 0 && !EmbryoTransfer.useEmbryoTransfer()) {
            i = 0;
            while (i < UNWANTED_WITHOUT_EMBRYOTRANSFER.length) {
                arr = ArrayHelper.getArrayWithout(arr, UNWANTED_WITHOUT_EMBRYOTRANSFER[i]);
                ++i;
            }
        }
        return arr;
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.mouse.Mouse");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return MouseManager.cvInstance;
    }

    public boolean isMutliDimPossible() {
        return true;
    }

    public String getTooltip(int col, Mouse maus) {
        if (this.ivColumnNames[col].equals(STR_SYMPTOM_LIST)) {
            return MouseInspHealthReportPanel.getTooltipForLastHealthReport(maus);
        }
        return maus.getToolTipStringTasks();
    }

    public boolean istDragNDroppable() {
        return true;
    }

    public boolean ichWillEinenOwnerKnopf() {
        if (UserManager.cvIsCareTaker) {
            return false;
        }
        return this.ivWantOwnerButton;
    }

    public boolean ichWillFactSheets() {
        return true;
    }

    public void setTable(Vector v) {
        super.setTable(v);
        if (this.ivTableFrame != null) {
            this.ivTableFrame.setWindowTitle();
        }
    }

    public void setTableFrame(TableFrameMouse mtf) {
        this.ivTableFrame = mtf;
    }

    public void roomStatusChanged() {
        this.setOrigObjectsAgain();
    }

    public boolean filterObject(Object ooo) {
        if (!UserRoomRestriction.isObjectRestricted(ooo) && ooo instanceof Mouse) {
            Mouse mouse = (Mouse)ooo;
            return !(this.ivFilterByRooms && !this.filterByRoom(mouse) || this.ivWantOwnerButton && !this.filterByOwner(mouse));
        }
        return false;
    }

    public boolean filterByOwner(Mouse mouse) {
        boolean res = true;
        if (!UserManager.cvIsCareTaker && this.getOnlyOwnObjects() && !mouse.itsMine(null)) {
            this.ivOwnerFiltered = true;
            res = false;
        }
        return res;
    }

    private boolean filterByRoom(Mouse mouse) {
        boolean res = true;
        if (this.ivFilterByRooms && MausoleumClient.isRegularOrTGService() && RoomAction.cvRoomID != 0L) {
            long mrID;
            long roomid = RoomAction.cvRoomID;
            Cage cage = mouse.getActCage();
            res = cage != null ? cage.isCageInRoomOrTransfer(roomid) : (mrID = mouse.getLong("MOS_ROOM", -1L)) == -1L || mrID == roomid;
        }
        return res;
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        Mouse maus = (Mouse)obj;
        label.setText("");
        label.setIcon(null);
        boolean maytouch = UserManager.cvIsCareTaker || maus.itsMine(null);
        this.setForegroundAccordingToOwnership(label, maytouch);
        if (this.getColumnIndex(colName) == 0 && maus.get("MOS_TASKSEXT") != null) {
            label.setTriangleColor(Mouse.getTaskColor(null, maus));
        }
        if (colName.equals(STR_MARK)) {
            label.setHorizontalAlignment(0);
            if (maus.getChar("MOS_FLAG") == '\u0001') {
                label.setIcon(ImageProvider.HAND_ICON);
            } else if (maus.getChar("MOS_FLAG") != '\u0000') {
                char[] ica = new char[]{maus.getChar("MOS_FLAG")};
                label.setText(new String(ica));
            }
        } else if (colName.equals(STR_OWNER)) {
            Color[] bga = this.ivColouredColumns.contains(colName) ? new Color[1] : null;
            label.setText(maus.getPrimaryOwnerName("", bga));
            if (bga != null) {
                Color bg = bga[0] != null ? bga[0] : UIDef.OBJECT_DEFAULT_COLOR;
                label.setBackground(bg);
                label.setForeground(ColorManager.getForegroundColorForBackground(bg));
            }
        } else if (colName.equals(STR_ALLOWNER)) {
            String group = maus.getGroup();
            if (this.ivColouredColumns.contains(colName)) {
                long[] ownerGroups;
                Vector<MFLabel> multis = new Vector<MFLabel>();
                long[] owners = (long[])maus.get("MOS_OWNER");
                if (owners != null && owners.length != 0) {
                    int i = 0;
                    while (i < owners.length) {
                        User usi = UserManager.getUser(owners[i], group);
                        if (usi != null) {
                            multis.add(new MFLabel(" " + usi.getName() + " ", (Color)usi.get("USR_COLOR", UIDef.OBJECT_DEFAULT_COLOR)));
                        }
                        ++i;
                    }
                }
                if ((ownerGroups = (long[])maus.get("MOS_OWNERGROUPS")) != null && ownerGroups.length != 0) {
                    int i = 0;
                    while (i < ownerGroups.length) {
                        IDObjectGroup iog = (IDObjectGroup)IDObjectGroupManager.cvInstance.getObject(ownerGroups[i], group);
                        if (iog != null) {
                            multis.add(new MFLabel(" " + iog.getName() + " ", (Color)iog.get("IOG_COL", UIDef.OBJECT_DEFAULT_COLOR)));
                        }
                        ++i;
                    }
                }
                label.setMultiBackgroundStrings(multis);
            } else {
                long[] ownerGroups;
                StringBuffer msb = new StringBuffer();
                long[] owners = (long[])maus.get("MOS_OWNER");
                if (owners != null && owners.length != 0) {
                    int i = 0;
                    while (i < owners.length) {
                        User usi = UserManager.getUser(owners[i], group);
                        if (usi != null) {
                            if (msb.length() != 0) {
                                msb.append(", ");
                            }
                            msb.append(usi.getName());
                        }
                        ++i;
                    }
                }
                if ((ownerGroups = (long[])maus.get("MOS_OWNERGROUPS")) != null && ownerGroups.length != 0) {
                    int i = 0;
                    while (i < ownerGroups.length) {
                        IDObjectGroup iog = (IDObjectGroup)IDObjectGroupManager.cvInstance.getObject(ownerGroups[i], group);
                        if (iog != null) {
                            if (msb.length() != 0) {
                                msb.append(", ");
                            }
                            msb.append(iog.getName());
                        }
                        ++i;
                    }
                }
                label.setText(msb.toString());
            }
        } else if (colName.equals(STR_COHORTS)) {
            String group = maus.getGroup();
            if (this.ivColouredColumns.contains(colName)) {
                Vector<MFLabel> multis = new Vector<MFLabel>();
                long[] cohorts = (long[])maus.get("MOS_COHORTS");
                if (cohorts != null && cohorts.length != 0) {
                    int i = 0;
                    while (i < cohorts.length) {
                        IDObjectGroup iog = (IDObjectGroup)IDObjectGroupManager.cvInstance.getObject(cohorts[i], group);
                        if (iog != null) {
                            multis.add(new MFLabel(" " + iog.getName() + " ", (Color)iog.get("IOG_COL", UIDef.OBJECT_DEFAULT_COLOR)));
                        }
                        ++i;
                    }
                }
                label.setMultiBackgroundStrings(multis);
            } else {
                StringBuffer msb = new StringBuffer();
                long[] cohorts = (long[])maus.get("MOS_COHORTS");
                if (cohorts != null && cohorts.length != 0) {
                    int i = 0;
                    while (i < cohorts.length) {
                        IDObjectGroup iog = (IDObjectGroup)IDObjectGroupManager.cvInstance.getObject(cohorts[i], group);
                        if (iog != null) {
                            if (msb.length() != 0) {
                                msb.append(", ");
                            }
                            msb.append(iog.getName());
                        }
                        ++i;
                    }
                }
                label.setText(msb.toString());
            }
        } else if (colName.equals(STR_EARTAG) || colName.equals(STR_EARTAGPLUS)) {
            if (isForFilterSplit) {
                int et = maus.getInt("MOS_EARTAG", 0);
                if (et == 0) {
                    label.setText("");
                } else {
                    int unten = et / 100;
                    label.setText(String.valueOf(unten * 100) + " - " + ((unten + 1) * 100 - 1));
                }
            } else {
                this.handleEartag(maus, label, colName, colName.equals(STR_EARTAG));
            }
        } else if (colName.equals(STR_SEX)) {
            label.setHorizontalAlignment(0);
            label.setText(maus.getCLLWSexString(""));
            if (this.ivColouredColumns.contains(colName) && maus.getSex() != 0) {
                Color c = SexColor.getColor(maus);
                label.setBackground(c);
                label.setForeground(ColorManager.getForegroundColorForBackground(c));
            }
        } else if (colName.equals(STR_CAGE)) {
            MTMouse.writeCage(label, maus, colName, this.ivColouredColumns, isForFilterSplit);
        } else if (STR_WEDDING.equals(colName) || STR_WEDDING_EXT.equals(colName)) {
            Cage cage = maus.getActCage();
            boolean sterile = false;
            boolean isAMating = maus.isActiveInMating();
            if (isAMating) {
                sterile = cage != null ? cage.ivIsSterileWeddingCage : false;
            }
            TableUtil.handleMating(label, this.ivUseDefaultFontSize, sterile, this.ivColouredColumns, colName, maus, cage, isAMating, STR_WEDDING_EXT.equals(colName));
        } else if (colName.equals(STR_GT)) {
            this.writeGenotype(maus, label, colName);
        } else if (colName.equals(STR_STRAIN)) {
            if (this.ivColouredColumns.contains(colName)) {
                label.setMultiBackgroundStrings(AllgUtils.getTypeMultiBackground(null, 1, maus));
            } else {
                label.setText(maus.getCLLWStrainString());
            }
        } else if (colName.equals(STR_RACK)) {
            MTMouse.writeRack(label, maus, colName, this.ivColouredColumns);
        } else if (colName.equals(STR_RACK_POS)) {
            MTMouse.writeRackPos(label, maus, colName, this.ivColouredColumns);
        } else if (colName.equals(STR_RACK_AND_POS)) {
            MTMouse.writeRackAndPos(label, maus, colName, this.ivColouredColumns);
        } else if (colName.equals(STR_ROOM)) {
            MTMouse.writeRoom(label, maus, colName, this.ivColouredColumns);
        } else if (colName.equals(STR_LINE)) {
            MTMouse.writeLine(label, maus, colName, this.ivColouredColumns);
        } else if (colName.equals("PREFIX")) {
            Line line = maus.getLine();
            if (line != null) {
                label.setText(line.getString("LIN_ETPREFIX", ""));
            }
        } else if (colName.equals(STR_PLUG)) {
            label.setHorizontalAlignment(4);
            boolean[] alarm = new boolean[]{false};
            label.setText(maus.getCLLWPlugDateString(alarm));
            if (alarm[0]) {
                label.setBackground(Color.red);
                label.setForeground(Color.white);
            }
        } else if (colName.equals(STR_AGE)) {
            label.setHorizontalAlignment(4);
            if (isForFilterSplit) {
                Date bda = maus.getDate("MOS_BIRTHDAY");
                if (bda == null) {
                    label.setText("-1");
                } else {
                    label.setText(Integer.toString(Mouse.getRealAgeInDays(bda, maus.getDate("IDO_END_DATE"))));
                }
            } else {
                Color c;
                if (maus.getDate("MOS_BIRTHDAY") == null && maus.get("IDO_START_DATE") == null) {
                    label.setText("");
                } else {
                    Date endDate = maus.getDate("IDO_END_DATE");
                    Date startDate = maus.getDate("MOS_BIRTHDAY");
                    if (startDate == null) {
                        startDate = (Date)maus.get("IDO_START_DATE");
                        label.setText("(" + this.getAgeString(startDate, endDate) + ")");
                    } else {
                        label.setText(this.getAgeString(startDate, endDate));
                    }
                }
                if (this.ivColouredColumns.contains(colName) && (c = AgeColor.getAgeColor(maus)) != null) {
                    label.setBackground(c);
                    label.setForeground(ColorManager.getForegroundColorForBackground(c));
                }
            }
        } else if (colName.equals(STR_BIRTHDAY)) {
            if (isForFilterSplit) {
                label.setText(maus.getFilterSplitDateString("MOS_BIRTHDAY"));
            } else {
                Color c;
                label.setText(maus.getCLLWBirthDayString(false));
                label.setHorizontalAlignment(0);
                if (this.ivColouredColumns.contains(colName) && (c = AgeColor.getAgeColor(maus)) != null) {
                    label.setBackground(c);
                    label.setForeground(ColorManager.getForegroundColorForBackground(c));
                }
            }
        } else if (STR_LITTER_COUNT.equals(colName)) {
            int lc = Wurf.getWurfCount(maus, -1);
            label.setText(lc >= 0 ? Integer.toString(lc) : "");
            if (!isForFilterSplit) {
                Color c;
                label.setHorizontalAlignment(4);
                if (this.ivColouredColumns.contains(colName) && (c = LitterColor.getLitterColor(lc)) != null) {
                    label.setBackground(c);
                    label.setForeground(ColorManager.getForegroundColorForBackground(c));
                }
            }
        } else if (colName.equals(STR_PREGNANT)) {
            if (isForFilterSplit) {
                label.setText(maus.getFilterSplitDateIntString("MOS_PREGNANT"));
            } else {
                Color c;
                label.setText(maus.getCLLWPregnantDateString(false));
                label.setHorizontalAlignment(0);
                if (this.ivColouredColumns.contains(colName) && (c = AgeColor.getAgeColor(maus)) != null) {
                    label.setBackground(c);
                    label.setForeground(ColorManager.getForegroundColorForBackground(c));
                }
            }
        } else if (colName.equals(STR_ANTAG)) {
            label.setText(maus.getString("MOS_ANTAG", ""));
        } else if (colName.equals(STR_MATLIM)) {
            Integer ml = (Integer)maus.get("MOS_MATLIM");
            if (ml != null) {
                label.setText(ml.toString());
            }
        } else if (colName.equals(STR_SPEC_DATE)) {
            Integer spDI = (Integer)maus.get("MOS_SPDAT");
            if (spDI != null) {
                label.setText(DatumFormat.getJustDateString(spDI));
                label.setHorizontalAlignment(0);
            }
        } else if (colName.equals(STR_DIFF_SPEC_DATE)) {
            Integer spDI = (Integer)maus.get("MOS_SPDAT");
            Date endDate = maus.getDate("IDO_END_DATE");
            if (spDI != null && endDate != null) {
                label.setText(Integer.toString((int)(endDate.getTime() / 86400000L) - spDI));
                label.setHorizontalAlignment(4);
            }
        } else if (colName.equals(STR_COAT_COLOR)) {
            int cc = maus.getCoatColor();
            TableUtil.handleCoatColor(cc, label, this.ivColouredColumns, colName);
        } else if (colName.equals(STR_BARCODE)) {
            label.setText("");
            label.setIcon(new ImageIcon(Code39Creator.createCode(maus.getBarcodeString())));
            label.setHorizontalAlignment(0);
        } else if (colName.equals(STR_LICENSE)) {
            if (this.ivColouredColumns.contains(colName)) {
                label.setMultiBackgroundStrings(AllgUtils.getTypeMultiBackground(null, 8, maus));
            } else {
                label.setText(maus.getLicenseString(",", null));
            }
        } else if (colName.equals(STR_KIDS)) {
            long[] kids = (long[])maus.get("MOS_KID");
            if (kids != null && kids.length != 0) {
                label.setText(Integer.toString(kids.length));
                label.setHorizontalAlignment(4);
            } else {
                label.setText("");
            }
        } else if (colName.equals(STR_STARTMODE)) {
            int mode = maus.getInt("MOS_STARTMODE", 0);
            if (mode != 0) {
                label.setText(Visit.translateMode(mode));
            } else {
                label.setText("");
            }
        } else if (colName.equals(STR_ENDMODE)) {
            int mode = maus.getInt("MOS_ENDMODE", 0);
            if (mode != 0) {
                label.setText(Visit.translateMode(mode));
            } else {
                label.setText("");
            }
        } else if (colName.equals(STR_GENERATION_PF)) {
            label.setText(maus.getGenerationString(true));
            label.setHorizontalAlignment(0);
        } else if (colName.equals(STR_FATHER_ID)) {
            this.setIDOrETOrGT(maus, label, "MOS_FATHER", "ID", colName);
        } else if (colName.equals(STR_MOTHER_ID)) {
            this.setIDOrETOrGT(maus, label, "MOS_MOTHER", "ID", colName);
        } else if (colName.equals(STR_FOSTER_ID)) {
            this.setIDOrETOrGT(maus, label, "MOS_FOSTID", "ID", colName);
        } else if (colName.equals(STR_WEANED)) {
            if (maus.getBoolean("MOS_ABGES", false)) {
                label.setText("\u2713");
            } else {
                label.setText("");
            }
            label.setHorizontalAlignment(0);
        } else if (colName.equals(STR_DAYS_TO_WEAN)) {
            if (!maus.getBoolean("MOS_ABGES", false)) {
                int tage = WeaningControl.getTimeUntilWeanAlert(maus, maus.getActCage(), System.currentTimeMillis(), true);
                if (tage == Integer.MAX_VALUE) {
                    label.setText("");
                } else {
                    Color c;
                    label.setText(Integer.toString(tage));
                    if (this.ivColouredColumns.contains(colName) && (c = WeaningColor.INSTANCE.getColor(tage)) != null) {
                        label.setBackground(c);
                        label.setForeground(ColorManager.getForegroundColorForBackground(c));
                    }
                    label.setHorizontalAlignment(4);
                }
            } else {
                label.setText("");
            }
        } else if (colName.equals(STR_RESULTS)) {
            label.setText(this.getResultString(maus));
        } else if (colName.equals(STR_FATHER_ET)) {
            this.setIDOrETOrGT(maus, label, "MOS_FATHER", "ET", colName);
        } else if (colName.equals(STR_MOTHER_ET)) {
            this.setIDOrETOrGT(maus, label, "MOS_MOTHER", "ET", colName);
        } else if (colName.equals(STR_FOSTER_ET)) {
            this.setIDOrETOrGT(maus, label, "MOS_FOSTID", "ET", colName);
        } else if (colName.equals(STR_FATHER_GT)) {
            this.setIDOrETOrGT(maus, label, "MOS_FATHER", "GT", colName);
        } else if (colName.equals(STR_MOTHER_GT)) {
            this.setIDOrETOrGT(maus, label, "MOS_MOTHER", "GT", colName);
        } else if (colName.equals(STR_FOSTER_GT)) {
            this.setIDOrETOrGT(maus, label, "MOS_FOSTID", "GT", colName);
        } else if (colName.equals(STR_FATHER_BIRTHDAY) || colName.equals(STR_MOTHER_BIRTHDAY)) {
            Mouse parent;
            long key = maus.getLong(colName.equals(STR_FATHER_BIRTHDAY) ? "MOS_FATHER" : "MOS_MOTHER", -1L);
            if (key != -1L && (parent = (Mouse)ObjectStore.getClientObject(1, key, maus.getGroup())) != null) {
                label.setText(parent.getCLLWBirthDayString(false));
            }
        } else if (colName.equals(STR_COMMENT)) {
            String com = maus.getString("MOS_COMMENT", null);
            if (com != null) {
                if (com.length() > 100) {
                    com = String.valueOf(com.substring(0, 100).trim()) + "...";
                }
                com = com.replace('\n', ' ');
                com = com.replace('\r', ' ');
                com = com.replace('\t', ' ');
                label.setText(com);
                label.setHorizontalAlignment(2);
            }
        } else if (colName.equals(STR_SYMPTOM_LIST)) {
            int date = MouseInspHealthReportPanel.getDateOfLastHealthReport(maus);
            if (date != Integer.MIN_VALUE) {
                Color c;
                label.setText(DatumFormat.getJustDateString(new MyDate(date)));
                label.setHorizontalAlignment(0);
                if (this.ivColouredColumns.contains(colName) && (c = SymptomColor.getBackgroundColorForMouse(maus)) != null) {
                    label.setBackground(c);
                    label.setForeground(ColorManager.getForegroundColorForBackground(c));
                }
            } else {
                label.setText("");
            }
        } else if (colName.equals(STR_ORIGIN)) {
            label.setText(maus.getHerkunftOderZiel(true, !isForFilterSplit));
            label.setHorizontalAlignment(2);
        } else if (colName.equals(STR_DESTINATION)) {
            label.setText(maus.getHerkunftOderZiel(false, !isForFilterSplit));
            label.setHorizontalAlignment(2);
        } else if (colName.equals(STR_STRESS_LEVEL_LIFE) || colName.equals(STR_STRESS_LEVEL_EXP) || colName.equals(STR_LINE_STRESS_LEVEL)) {
            int stress = MTMouse.getAppropriateStress(maus, colName);
            if (stress == 0) {
                label.setText("");
            } else {
                Color c;
                label.setText(StringHelper.getStringForInt(stress, Stress.STRESS_INTS, Stress.STRESS_BABELS, true, ""));
                label.setHorizontalAlignment(0);
                if (this.ivColouredColumns.contains(colName) && (c = Stress.getColor(stress)) != null) {
                    label.setBackground(c);
                    label.setForeground(ColorManager.getForegroundColorForBackground(c));
                }
            }
        } else {
            super.writeGeneralElement(label, obj, colName, isForFilterSplit);
        }
    }

    private void writeGenotype(Mouse maus, MausoleumTableLabel label, String colName) {
        Font defFont = FontManager.getTableFont(true, this.ivUseDefaultFontSize, this.ivZoom);
        label.setMultiFontStrings(maus.getMultiFontGenotype(FontManager.getGenotypeArray(true, defFont, this.ivZoom), false));
        if (this.ivColouredColumns.contains(colName) && !Mouse.isGenotypeComplete(maus, -1L)) {
            Color c = MissingGenoptypesColor.MISSING;
            label.setBackground(c);
            label.setForeground(ColorManager.getForegroundColorForBackground(c));
        }
    }

    private void setIDOrETOrGT(Mouse maus, MausoleumTableLabel label, String tag, String wanted, String colName) {
        Long l;
        if (maus != null && (l = (Long)maus.get(tag)) != null && l > 0L) {
            if ("ID".equalsIgnoreCase(wanted)) {
                label.setHorizontalAlignment(4);
                label.setText(l.toString());
            } else {
                Mouse superMaus = (Mouse)ObjectStore.getClientObject(1, l, maus.getGroup());
                if (superMaus != null) {
                    if ("ET".equalsIgnoreCase(wanted)) {
                        label.setHorizontalAlignment(4);
                        label.setText(superMaus.getCLLWEartagString("", false, true));
                        if (this.ivColouredColumns.contains(colName) && superMaus.get("MOS_EARTAG") == null) {
                            Color c = UntaggedColor.UNTAGGED;
                            if (superMaus.isBreeder()) {
                                c = UntaggedColor.UNTAGGED_BREEDER;
                            }
                            label.setBackground(c);
                            label.setForeground(ColorManager.getForegroundColorForBackground(c));
                        }
                    } else if ("GT".equalsIgnoreCase(wanted)) {
                        this.writeGenotype(superMaus, label, colName);
                    }
                }
            }
        }
    }

    private static int getAppropriateStress(Mouse maus, String colName) {
        if (colName.equals(STR_LINE_STRESS_LEVEL)) {
            return maus.getAktLineStressLevel();
        }
        if (colName.equals(STR_STRESS_LEVEL_LIFE)) {
            return maus.getMouseLifeStressLevel();
        }
        if (colName.equals(STR_STRESS_LEVEL_EXP)) {
            return maus.getMouseDeathStressLevel();
        }
        return 0;
    }

    public SplitFilterObject getSFO(String colKennung, String val) {
        if (colKennung.equals(STR_EARTAG) || colKennung.equals(STR_EARTAGPLUS) || colKennung.equals(STR_CAGE)) {
            Integer key = new Integer(0);
            try {
                int ind = val.indexOf("-");
                if (ind != -1) {
                    key = new Integer(val.substring(0, ind).trim());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new SplitFilterObject(val, val, key);
        }
        if (colKennung.equals(STR_AGE)) {
            int i = Integer.parseInt(val);
            if (i < 0) {
                return new SplitFilterObject(Babel.get("NO_BIRTHDAY"), val, new Integer(-1));
            }
            return new SplitFilterObject(String.valueOf(i /= 7) + " " + (i == 1 ? Babel.get("WEEK") : Babel.get("WEEKS")), val, new Integer(i));
        }
        return super.getSFO(colKennung, val);
    }

    private void handleEartag(Mouse maus, MausoleumTableLabel label, String colName, boolean mitLinienOderStammPrefix) {
        if (maus != null) {
            label.setHorizontalAlignment(4);
            label.setText(maus.getCLLWEartagString("", false, mitLinienOderStammPrefix));
            if (this.ivColouredColumns.contains(colName) && maus.get("MOS_EARTAG") == null) {
                Color c = UntaggedColor.UNTAGGED;
                if (maus.isBreeder()) {
                    c = UntaggedColor.UNTAGGED_BREEDER;
                }
                label.setBackground(c);
                label.setForeground(ColorManager.getForegroundColorForBackground(c));
            }
        } else {
            label.setText("");
        }
    }

    private String getAgeString(Date startDate, Date endDate) {
        if (DefaultManager.getMouseAgeFormat() == 2) {
            return Integer.toString(Mouse.getRealAgeInDays(startDate, endDate) / 7);
        }
        if (DefaultManager.getMouseAgeFormat() == 4) {
            return Integer.toString(Mouse.getRealAgeInDays(startDate, endDate));
        }
        if (DefaultManager.getMouseAgeFormat() == 3) {
            int tage = Mouse.getRealAgeInDays(startDate, endDate);
            int wochen = tage / 7;
            return String.valueOf(Integer.toString(wochen)) + "\\" + (tage -= 7 * wochen);
        }
        if (DefaultManager.getMouseAgeFormat() == 1) {
            MyDate startMD = MyDate.getMyDate(startDate.getTime());
            MyDate endMD = MyDate.getMyDate(endDate == null ? System.currentTimeMillis() : endDate.getTime());
            int dd = endMD.ivTag - startMD.ivTag;
            int dm = endMD.ivMonat - startMD.ivMonat;
            int dy = endMD.ivJahr - startMD.ivJahr;
            while (dd < 0) {
                dd = endMD.ivMonat == 1 ? (dd += MyDate.getTageImMonat(12, endMD.ivJahr - 1)) : (dd += MyDate.getTageImMonat(endMD.ivMonat - 1, endMD.ivJahr));
                --dm;
            }
            while (dm < 0) {
                dm += 12;
                --dy;
            }
            int monate = dy * 12 + dm;
            int ganzeWochen = dd / 7;
            int restTage = dd - ganzeWochen * 7;
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toString(monate)).append(" ");
            sb.append(Integer.toString(ganzeWochen)).append(" ");
            sb.append(Integer.toString(restTage));
            return sb.toString();
        }
        return "?";
    }

    private String getResultString(Mouse maus) {
        Vector results = (Vector)maus.get("MOS_MRESULTS");
        if (results != null) {
            TreeSet<String> ts = new TreeSet<String>();
            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                MResult mresult = (MResult)iter.next();
                Experiment exp = mresult.getExperiment(maus.getGroup());
                if (exp == null) continue;
                ts.add(exp.getBrowseName());
            }
            if (!ts.isEmpty()) {
                StringBuffer msb = new StringBuffer();
                Iterator iter2 = ts.iterator();
                while (iter2.hasNext()) {
                    if (msb.length() != 0) {
                        msb.append(", ");
                    }
                    msb.append(iter2.next());
                }
                return msb.toString();
            }
        }
        return "";
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        block62: {
            Mouse m;
            MultiSortEntry mse;
            Iterator iterator;
            block82: {
                block81: {
                    block80: {
                        block79: {
                            block78: {
                                block77: {
                                    block76: {
                                        block75: {
                                            block74: {
                                                block73: {
                                                    block72: {
                                                        block71: {
                                                            block70: {
                                                                block69: {
                                                                    block68: {
                                                                        block67: {
                                                                            block66: {
                                                                                block65: {
                                                                                    String group;
                                                                                    StringBuilder msb;
                                                                                    block64: {
                                                                                        block63: {
                                                                                            block61: {
                                                                                                RackPos rp;
                                                                                                if (column.equals(STR_CAGE)) {
                                                                                                    iterator = mses.iterator();
                                                                                                    while (iterator.hasNext()) {
                                                                                                        mse = (MultiSortEntry)iterator.next();
                                                                                                        m = (Mouse)mse.ivObject;
                                                                                                        Object so = null;
                                                                                                        Cage c = m.getActCage();
                                                                                                        if (c != null) {
                                                                                                            so = DefaultManager.useCagePseudoIDs() ? c.get("CAG_PSEUDOID") : c.get("IDO_ID");
                                                                                                        }
                                                                                                        mse.ivVals[pos] = MultiSortEntry.getComp(so);
                                                                                                    }
                                                                                                } else if (column.equals(STR_RACK)) {
                                                                                                    iterator = mses.iterator();
                                                                                                    while (iterator.hasNext()) {
                                                                                                        mse = (MultiSortEntry)iterator.next();
                                                                                                        m = (Mouse)mse.ivObject;
                                                                                                        mse.ivVals[pos] = MultiSortEntry.getComp(m.getRackName());
                                                                                                    }
                                                                                                } else if (column.equals(STR_RACK_POS)) {
                                                                                                    iterator = mses.iterator();
                                                                                                    while (iterator.hasNext()) {
                                                                                                        mse = (MultiSortEntry)iterator.next();
                                                                                                        m = (Mouse)mse.ivObject;
                                                                                                        rp = m.getRackPos();
                                                                                                        Comparable<Integer> comparable = mse.ivVals[pos] = rp != null ? new Integer(rp.getSortValue()) : null;
                                                                                                    }
                                                                                                } else if (column.equals(STR_RACK_AND_POS)) {
                                                                                                    iterator = mses.iterator();
                                                                                                    while (iterator.hasNext()) {
                                                                                                        mse = (MultiSortEntry)iterator.next();
                                                                                                        m = (Mouse)mse.ivObject;
                                                                                                        rp = m.getRackPos();
                                                                                                        Comparable comparable = mse.ivVals[pos] = rp != null ? MultiSortEntry.getComp(String.valueOf(m.getRackName()) + rp.getSortValue()) : null;
                                                                                                    }
                                                                                                } else if (column.equals(STR_ROOM)) {
                                                                                                    iterator = mses.iterator();
                                                                                                    while (iterator.hasNext()) {
                                                                                                        mse = (MultiSortEntry)iterator.next();
                                                                                                        m = (Mouse)mse.ivObject;
                                                                                                        mse.ivVals[pos] = MultiSortEntry.getComp(m.getRoomName());
                                                                                                    }
                                                                                                } else if (column.equals(STR_AGE)) {
                                                                                                    iterator = mses.iterator();
                                                                                                    while (iterator.hasNext()) {
                                                                                                        mse = (MultiSortEntry)iterator.next();
                                                                                                        m = (Mouse)mse.ivObject;
                                                                                                        Date sda = m.getDate("MOS_BIRTHDAY");
                                                                                                        if (sda == null) {
                                                                                                            sda = (Date)m.get("IDO_START_DATE");
                                                                                                        }
                                                                                                        long start = System.currentTimeMillis();
                                                                                                        if (sda != null) {
                                                                                                            start = sda.getTime();
                                                                                                        }
                                                                                                        Date eda = m.getDate("IDO_END_DATE");
                                                                                                        long end = System.currentTimeMillis();
                                                                                                        if (eda != null) {
                                                                                                            end = eda.getTime();
                                                                                                        }
                                                                                                        mse.ivVals[pos] = new Long(end - start);
                                                                                                    }
                                                                                                } else if (STR_DIFF_SPEC_DATE.equals(column)) {
                                                                                                    iterator = mses.iterator();
                                                                                                    while (iterator.hasNext()) {
                                                                                                        mse = (MultiSortEntry)iterator.next();
                                                                                                        m = (Mouse)mse.ivObject;
                                                                                                        Integer spda = (Integer)m.get("MOS_SPDAT");
                                                                                                        Date eda = m.getDate("IDO_END_DATE");
                                                                                                        Integer val = null;
                                                                                                        if (spda != null && eda != null) {
                                                                                                            val = new Integer((int)(eda.getTime() / 86400000L) - spda);
                                                                                                        }
                                                                                                        mse.ivVals[pos] = val;
                                                                                                    }
                                                                                                } else if (STR_WEDDING.equals(column) || STR_WEDDING_EXT.equals(column)) {
                                                                                                    iterator = mses.iterator();
                                                                                                    while (iterator.hasNext()) {
                                                                                                        Cage cage;
                                                                                                        mse = (MultiSortEntry)iterator.next();
                                                                                                        m = (Mouse)mse.ivObject;
                                                                                                        Comparable<Integer> comparable = mse.ivVals[pos] = m.isInMatingCage() && m.isSexActive() && m.getSex() != 0 ? NULL_INT : null;
                                                                                                        if (mse.ivVals[pos] != null || !STR_WEDDING_EXT.equals(column) || (cage = m.getActCage()) == null || m.getID() != cage.ivHerzeloydeMouseID) continue;
                                                                                                        mse.ivVals[pos] = new Integer(cage.ivHerzeloydeDays + 1);
                                                                                                    }
                                                                                                }
                                                                                                if (!column.equals(STR_GT)) break block61;
                                                                                                iterator = mses.iterator();
                                                                                                while (iterator.hasNext()) {
                                                                                                    mse = (MultiSortEntry)iterator.next();
                                                                                                    m = (Mouse)mse.ivObject;
                                                                                                    mse.ivVals[pos] = m.getGenotype(null);
                                                                                                }
                                                                                                break block62;
                                                                                            }
                                                                                            if (!column.equals(STR_OWNER)) break block63;
                                                                                            iterator = mses.iterator();
                                                                                            while (iterator.hasNext()) {
                                                                                                mse = (MultiSortEntry)iterator.next();
                                                                                                m = (Mouse)mse.ivObject;
                                                                                                mse.ivVals[pos] = m.getPrimaryOwnerName(null, null);
                                                                                            }
                                                                                            break block62;
                                                                                        }
                                                                                        if (!column.equals(STR_ALLOWNER)) break block64;
                                                                                        iterator = mses.iterator();
                                                                                        while (iterator.hasNext()) {
                                                                                            long[] ownerGroups;
                                                                                            mse = (MultiSortEntry)iterator.next();
                                                                                            m = (Mouse)mse.ivObject;
                                                                                            msb = new StringBuilder();
                                                                                            group = m.getGroup();
                                                                                            long[] owners = (long[])m.get("MOS_OWNER");
                                                                                            if (owners != null && owners.length != 0) {
                                                                                                int i = 0;
                                                                                                while (i < owners.length) {
                                                                                                    User usi = UserManager.getUser(owners[i], group);
                                                                                                    if (usi != null) {
                                                                                                        if (msb.length() != 0) {
                                                                                                            msb.append(", ");
                                                                                                        }
                                                                                                        msb.append(usi.getName());
                                                                                                    }
                                                                                                    ++i;
                                                                                                }
                                                                                            }
                                                                                            if ((ownerGroups = (long[])m.get("MOS_OWNERGROUPS")) != null && ownerGroups.length != 0) {
                                                                                                int i = 0;
                                                                                                while (i < ownerGroups.length) {
                                                                                                    IDObjectGroup iog = (IDObjectGroup)IDObjectGroupManager.cvInstance.getObject(ownerGroups[i], group);
                                                                                                    if (iog != null) {
                                                                                                        if (msb.length() != 0) {
                                                                                                            msb.append(", ");
                                                                                                        }
                                                                                                        msb.append(iog.getName());
                                                                                                    }
                                                                                                    ++i;
                                                                                                }
                                                                                            }
                                                                                            mse.ivVals[pos] = MultiSortEntry.getComp(msb.toString());
                                                                                        }
                                                                                        break block62;
                                                                                    }
                                                                                    if (!column.equals(STR_COHORTS)) break block65;
                                                                                    iterator = mses.iterator();
                                                                                    while (iterator.hasNext()) {
                                                                                        mse = (MultiSortEntry)iterator.next();
                                                                                        m = (Mouse)mse.ivObject;
                                                                                        msb = new StringBuilder();
                                                                                        group = m.getGroup();
                                                                                        long[] cohorts = (long[])m.get("MOS_COHORTS");
                                                                                        if (cohorts != null && cohorts.length != 0) {
                                                                                            int i = 0;
                                                                                            while (i < cohorts.length) {
                                                                                                IDObjectGroup iog = (IDObjectGroup)IDObjectGroupManager.cvInstance.getObject(cohorts[i], group);
                                                                                                if (iog != null) {
                                                                                                    if (msb.length() != 0) {
                                                                                                        msb.append(", ");
                                                                                                    }
                                                                                                    msb.append(iog.getName());
                                                                                                }
                                                                                                ++i;
                                                                                            }
                                                                                        }
                                                                                        mse.ivVals[pos] = MultiSortEntry.getComp(msb.toString());
                                                                                    }
                                                                                    break block62;
                                                                                }
                                                                                if (!column.equals(STR_STRAIN)) break block66;
                                                                                iterator = mses.iterator();
                                                                                while (iterator.hasNext()) {
                                                                                    mse = (MultiSortEntry)iterator.next();
                                                                                    m = (Mouse)mse.ivObject;
                                                                                    mse.ivVals[pos] = MultiSortEntry.getComp(m.getCLLWStrainString(false));
                                                                                }
                                                                                break block62;
                                                                            }
                                                                            if (!column.equals(STR_LINE)) break block67;
                                                                            iterator = mses.iterator();
                                                                            while (iterator.hasNext()) {
                                                                                mse = (MultiSortEntry)iterator.next();
                                                                                m = (Mouse)mse.ivObject;
                                                                                mse.ivVals[pos] = MultiSortEntry.getComp(m.getCLLWLineStringWithoutPrefix());
                                                                            }
                                                                            break block62;
                                                                        }
                                                                        if (!column.equals("PREFIX")) break block68;
                                                                        iterator = mses.iterator();
                                                                        while (iterator.hasNext()) {
                                                                            mse = (MultiSortEntry)iterator.next();
                                                                            m = (Mouse)mse.ivObject;
                                                                            Line line = m.getLine();
                                                                            Comparable comparable = mse.ivVals[pos] = line != null ? line.getString("LIN_ETPREFIX", null) : null;
                                                                        }
                                                                        break block62;
                                                                    }
                                                                    if (!column.equals(STR_COAT_COLOR)) break block69;
                                                                    iterator = mses.iterator();
                                                                    while (iterator.hasNext()) {
                                                                        mse = (MultiSortEntry)iterator.next();
                                                                        m = (Mouse)mse.ivObject;
                                                                        mse.ivVals[pos] = CoatColor.getDescr(m.getCoatColor(), false, null);
                                                                    }
                                                                    break block62;
                                                                }
                                                                if (!column.equals(STR_BARCODE)) break block70;
                                                                iterator = mses.iterator();
                                                                while (iterator.hasNext()) {
                                                                    mse = (MultiSortEntry)iterator.next();
                                                                    m = (Mouse)mse.ivObject;
                                                                    mse.ivVals[pos] = MultiSortEntry.getComp(m.getBarcodeString());
                                                                }
                                                                break block62;
                                                            }
                                                            if (!column.equals(STR_LICENSE)) break block71;
                                                            iterator = mses.iterator();
                                                            while (iterator.hasNext()) {
                                                                mse = (MultiSortEntry)iterator.next();
                                                                m = (Mouse)mse.ivObject;
                                                                mse.ivVals[pos] = m.getLicenseString(",", null);
                                                            }
                                                            break block62;
                                                        }
                                                        if (!column.equals(STR_KIDS)) break block72;
                                                        iterator = mses.iterator();
                                                        while (iterator.hasNext()) {
                                                            mse = (MultiSortEntry)iterator.next();
                                                            m = (Mouse)mse.ivObject;
                                                            long[] kids = (long[])m.get("MOS_KID");
                                                            Comparable<Integer> comparable = mse.ivVals[pos] = kids != null ? new Integer(kids.length) : null;
                                                        }
                                                        break block62;
                                                    }
                                                    if (!column.equals(STR_GENERATION_PF)) break block73;
                                                    iterator = mses.iterator();
                                                    while (iterator.hasNext()) {
                                                        mse = (MultiSortEntry)iterator.next();
                                                        m = (Mouse)mse.ivObject;
                                                        int gen = m.getGeneration(-1, true);
                                                        Comparable<Integer> comparable = mse.ivVals[pos] = gen != -1 ? new Integer(gen) : null;
                                                    }
                                                    break block62;
                                                }
                                                if (!column.equals(STR_WEANED)) break block74;
                                                iterator = mses.iterator();
                                                while (iterator.hasNext()) {
                                                    mse = (MultiSortEntry)iterator.next();
                                                    m = (Mouse)mse.ivObject;
                                                    Comparable<Integer> comparable = mse.ivVals[pos] = m.getBoolean("MOS_ABGES", false) ? EINS : null;
                                                }
                                                break block62;
                                            }
                                            if (!column.equals(STR_DAYS_TO_WEAN)) break block75;
                                            iterator = mses.iterator();
                                            while (iterator.hasNext()) {
                                                mse = (MultiSortEntry)iterator.next();
                                                m = (Mouse)mse.ivObject;
                                                int tage = Integer.MAX_VALUE;
                                                if (!m.getBoolean("MOS_ABGES", false)) {
                                                    tage = WeaningControl.getTimeUntilWeanAlert(m, m.getActCage(), System.currentTimeMillis(), true);
                                                }
                                                Comparable<Integer> comparable = mse.ivVals[pos] = tage != Integer.MAX_VALUE ? new Integer(tage) : null;
                                            }
                                            break block62;
                                        }
                                        if (!column.equals(STR_RESULTS)) break block76;
                                        iterator = mses.iterator();
                                        while (iterator.hasNext()) {
                                            mse = (MultiSortEntry)iterator.next();
                                            m = (Mouse)mse.ivObject;
                                            mse.ivVals[pos] = MultiSortEntry.getComp(this.getResultString(m));
                                        }
                                        break block62;
                                    }
                                    if (!column.equals(STR_FATHER_ET) && !column.equals(STR_MOTHER_ET)) break block77;
                                    MTMouse.handleSortParentInfo(column.equals(STR_FATHER_ET) ? "MOS_FATHER" : "MOS_MOTHER", mses, pos, "MOS_EARTAG");
                                    break block62;
                                }
                                if (!column.equals(STR_FATHER_BIRTHDAY) && !column.equals(STR_MOTHER_BIRTHDAY)) break block78;
                                MTMouse.handleSortParentInfo(column.equals(STR_FATHER_BIRTHDAY) ? "MOS_FATHER" : "MOS_MOTHER", mses, pos, "MOS_BIRTHDAY");
                                break block62;
                            }
                            if (!column.equals(STR_SYMPTOM_LIST)) break block79;
                            iterator = mses.iterator();
                            while (iterator.hasNext()) {
                                mse = (MultiSortEntry)iterator.next();
                                int date = MouseInspHealthReportPanel.getDateOfLastHealthReport((Mouse)mse.ivObject);
                                Comparable<Integer> comparable = mse.ivVals[pos] = date != Integer.MIN_VALUE ? new Integer(date) : null;
                            }
                            break block62;
                        }
                        if (!column.equals(STR_ORIGIN)) break block80;
                        iterator = mses.iterator();
                        while (iterator.hasNext()) {
                            mse = (MultiSortEntry)iterator.next();
                            mse.ivVals[pos] = ((Mouse)mse.ivObject).getHerkunftOderZiel(true, true);
                        }
                        break block62;
                    }
                    if (!column.equals(STR_DESTINATION)) break block81;
                    iterator = mses.iterator();
                    while (iterator.hasNext()) {
                        mse = (MultiSortEntry)iterator.next();
                        mse.ivVals[pos] = ((Mouse)mse.ivObject).getHerkunftOderZiel(false, true);
                    }
                    break block62;
                }
                if (!column.equals(STR_STRESS_LEVEL_LIFE) && !column.equals(STR_STRESS_LEVEL_EXP) && !column.equals(STR_LINE_STRESS_LEVEL)) break block82;
                iterator = mses.iterator();
                while (iterator.hasNext()) {
                    mse = (MultiSortEntry)iterator.next();
                    mse.ivVals[pos] = new Integer(MTMouse.getAppropriateStress((Mouse)mse.ivObject, column));
                }
                break block62;
            }
            if (!column.equals(STR_LITTER_COUNT)) break block62;
            iterator = mses.iterator();
            while (iterator.hasNext()) {
                mse = (MultiSortEntry)iterator.next();
                m = (Mouse)mse.ivObject;
                mse.ivVals[pos] = new Integer(Wurf.getWurfCount(m, -1));
            }
        }
    }

    private static void handleSortParentInfo(String parentTag, Vector mses, int pos, String infoTag) {
        Iterator iterator = mses.iterator();
        while (iterator.hasNext()) {
            Mouse parent;
            MultiSortEntry mse = (MultiSortEntry)iterator.next();
            Mouse m = (Mouse)mse.ivObject;
            Object o = null;
            long key = m.getLong(parentTag, -1L);
            if (key != -1L && (parent = (Mouse)ObjectStore.getClientObject(1, key, m.getGroup())) != null) {
                o = parent.get(infoTag);
            }
            mse.ivVals[pos] = MultiSortEntry.getComp(o);
        }
    }

    public static void writeCage(MausoleumTableLabel label, Mouse maus, String colName, HashSet colouredColumns, boolean isForFilterSplit) {
        Cage cage = maus.getActCage();
        if (cage == null) {
            label.setCage(null);
            label.setText("");
        } else {
            MTCage.writeCageNr(label, cage, colName, colouredColumns, isForFilterSplit);
        }
    }

    public static void writeRack(MausoleumTableLabel label, Mouse maus, String colName, HashSet colouredColumns) {
        label.setHorizontalAlignment(0);
        label.setText(maus.getRackName());
        MTMouse.setBGByRack(label, maus.getRoom(), colName, colouredColumns);
    }

    public static void setBGByRack(MausoleumTableLabel label, Room room, String colName, HashSet colouredColumns) {
        Color c;
        if (colouredColumns.contains(colName) && room != null && (c = (Color)StringHelper.getObjectForInt(room.getInt("ROM_SECURITY", 0), Room.SECURITY_INTS, Room.SECURITY_COLORS, null)) != null) {
            label.setBackground(c);
            label.setForeground(ColorManager.getForegroundColorForBackground(c));
        }
    }

    public static void writeRackPos(MausoleumTableLabel label, Mouse maus, String colName, HashSet colouredColumns) {
        label.setHorizontalAlignment(0);
        label.setText(maus.getRackPosName());
    }

    public static void writeRackAndPos(MausoleumTableLabel label, Mouse maus, String colName, HashSet colouredColumns) {
        label.setHorizontalAlignment(0);
        label.setText(maus.getRackAndPosName());
        MTMouse.setBGByRack(label, maus.getRoom(), colName, colouredColumns);
    }

    public static void writeRoom(MausoleumTableLabel label, Mouse maus, String colName, HashSet colouredColumns) {
        Color c;
        Room room;
        label.setHorizontalAlignment(0);
        label.setText(maus.getRoomName());
        if (colouredColumns.contains(colName) && (room = maus.getRoom()) != null && (c = (Color)StringHelper.getObjectForInt(room.getInt("ROM_SECURITY", 0), Room.SECURITY_INTS, Room.SECURITY_COLORS, null)) != null) {
            label.setBackground(c);
            label.setForeground(ColorManager.getForegroundColorForBackground(c));
        }
    }

    public static void writeLine(MausoleumTableLabel label, Mouse maus, String colName, HashSet colouredColumns) {
        Line line = maus.getLine();
        if (line != null) {
            Color c;
            label.setText(line.getBrowseNameInclServicePrefix());
            if (colouredColumns.contains(colName) && (c = (Color)line.get("LIN_COLOR")) != null) {
                label.setOpaque(true);
                label.setBackground(c);
                label.setForeground(ColorManager.getForegroundColorForBackground(c));
            }
        }
    }

    public Vector getAdditionalPopupItems(Vector selectedObjects) {
        Vector<JSeparator> res = new Vector<JSeparator>();
        if (selectedObjects != null && !selectedObjects.isEmpty()) {
            MATING_REPORT_ITEM.add(selectedObjects, res);
            MATING_REPORT_EXT_ITEM.add(selectedObjects, res);
            MATINGPERFOMANCE_ITEM.add(selectedObjects, res);
            LITTERREPORT_EXTENDED_ITEM.add(selectedObjects, res);
            if (EmbryoTransfer.useEmbryoTransfer()) {
                FOSTERREPORT_EXTENDED_ITEM.add(selectedObjects, res);
            }
            VISITREPORT_ITEM.add(selectedObjects, res);
            PLUG_REPORT_ITEM.add(selectedObjects, res);
            if (TierSchutz.isLineEvaluationPossible()) {
                STRESS_REPORT_ITEM.add(selectedObjects, res);
                STRESS_REPORT_ITEM_EXT.add(selectedObjects, res);
            }
            res.add(new JSeparator());
            PLAISANT_REPORT_ITEM.add(selectedObjects, res);
            res.add(new JSeparator());
            boolean zusatz = SET_FATHER_ITEM.add(selectedObjects, res);
            if (zusatz |= SET_MOTHER_ITEM.add(selectedObjects, res)) {
                res.add(new JSeparator());
            }
            POOLMENU_WITH_SELECTEDS.add(res);
        } else {
            POOLMENU_WITHOUT_SELECTEDS.add(res);
        }
        return res;
    }

    public void processDoubleClick(Point p, Point originalPoint) {
        Vector aktMice = this.getSelectedObjects();
        if (aktMice != null && !aktMice.isEmpty()) {
            new MouseIDCard(aktMice, p);
        }
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        if (objectTyp == 2) {
            Vector<Mouse> raus = new Vector<Mouse>();
            Iterator iter = this.ivOriginalObjects.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                long cid = mouse.getActCageID(-1L);
                if (cid == -1L || !mouse.getGroup().equals(group) || !objectIDs.contains(new Long(cid))) continue;
                raus.add(mouse);
            }
            Vector prevsel = this.getSelectedObjects();
            int sizeVorher = this.ivObjects.size();
            Iterator iter2 = raus.iterator();
            while (iter2.hasNext()) {
                IDObject object = (IDObject)iter2.next();
                this.incorporateObjectInVector(object, this.ivOriginalObjects, true, true);
                this.incorporateObjectInVector(object, this.ivObjects, true, true);
            }
            if (this.ivObjects.size() != sizeVorher) {
                this.getJTable().tableChanged(new TableModelEvent(this.getJTable().getModel()));
                this.adjustSelection(prevsel);
            }
        } else {
            super.objectLeftServiceRoom(objectTyp, group, objectIDs);
        }
    }

    private void setParent(boolean father) {
        Vector mice = this.getSelectedObjects();
        String commonGroup = IDObject.commonGroup(mice);
        if (commonGroup != null) {
            Vector parents = new Vector();
            MausoleumPool.addPoolMice(parents);
            Mouse parent = null;
            Iterator iterator = parents.iterator();
            while (iterator.hasNext()) {
                Object ooo = iterator.next();
                if (!(ooo instanceof Mouse)) continue;
                if (parent != null) {
                    Alert.showAlert(Babel.get("DP_POOL_CROWDED"), true);
                    return;
                }
                parent = (Mouse)ooo;
            }
            if (parent == null) {
                Alert.showAlert(Babel.get("DP_POOL_EMPTY"), true);
                return;
            }
            if (mice.contains(parent)) {
                Alert.showAlert(Babel.get("DP_PARENT_SELECTION_INVALID"), true);
                return;
            }
            int pSex = parent.getSex();
            if (father && pSex != 1 || !father && pSex != 2) {
                Alert.showAlert(Babel.get("DP_POOL_WRONG_SEX"), true);
                return;
            }
            Vector<Mouse> parentVec = new Vector<Mouse>();
            parentVec.add(parent);
            if (SetMouseParentCheckRequester.checkParentSetting(WindowUtils.getJFrame(this.getJTable()), parentVec, mice, father)) {
                // empty if block
            }
            StringBuilder msb = new StringBuilder();
            Iterator iterator2 = mice.iterator();
            while (iterator2.hasNext()) {
                Mouse kid = (Mouse)iterator2.next();
                msb.append(CommandManagerExecutive.getServiceRoomTag(kid, ""));
                msb.append("MOSSETPARENT").append(" ");
                msb.append(kid.getID()).append(" ");
                msb.append(parent.getID()).append(" ");
                msb.append(father ? "1" : "0");
                if (!iterator2.hasNext()) continue;
                msb.append("\n");
            }
            RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), commonGroup);
        }
    }
}

