/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.ObjectManager;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.idobjectgroup.IDObjectGroupManager;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.sorting.MultiSortEntry;

public abstract class MTObjectGroup
extends MausoleumTableModel {
    public static final String STR_NAME = "NAME";
    public static final String STR_ANZAHL = "ANZAHL";
    public static final String STR_COLOR = "COLOR";
    public static final String TT_NAME = "MTIOG_TT_NAME";
    public static final String TT_ANZAHL = "MTIOG_TT_ANZAHL";
    public static final String TT_COLOR = "MTIOG_TT_COLOR";
    private static final String[] TT_DICT = new String[]{"NAME", "MTIOG_TT_NAME", "ANZAHL", "MTIOG_TT_ANZAHL", "COLOR", "MTIOG_TT_COLOR"};
    private static final String[] POSSIBLES = new String[]{"NAME", "ANZAHL", "COLOR"};
    private static final String[] SORTABLES = new String[]{"NAME", "ANZAHL", "COLOR"};
    private static final String[] EDITABLES = new String[]{"NAME", "COLOR"};
    private static final String[] COLORABLES = new String[0];
    private static final String[] FILTERABLES = new String[0];
    private static final HashMap PLAIN_SORTINGS = new HashMap(GENERAL_PLAIN_SORTINGS);

    static {
        PLAIN_SORTINGS.put(STR_NAME, "IOG_N");
        PLAIN_SORTINGS.put(STR_COLOR, "IOG_COL");
    }

    public boolean ichWillEinenSichtbarkeitsKnopf() {
        return true;
    }

    public boolean ichWillFactSheets() {
        return true;
    }

    public String[] getPossibleColumns() {
        return POSSIBLES;
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[0];
    }

    public String getDefaultSortColumn() {
        return STR_NAME;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public HashMap getPlainSortings() {
        return PLAIN_SORTINGS;
    }

    public int[] getWidths() {
        return new int[]{120, 50, 50, 50};
    }

    public String[] getDefaultColumnNames() {
        return new String[]{STR_NAME, STR_ANZAHL};
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public ObjectManager getManager() {
        return IDObjectGroupManager.cvInstance;
    }

    public int[] getConsumertypes() {
        return new int[]{19, 20, 21};
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        IDObjectGroup objGroup = (IDObjectGroup)obj;
        if (colName.equals(STR_NAME)) {
            label.setText(objGroup.getName());
        } else if (colName.equals(STR_ANZAHL)) {
            long[] ids = (long[])objGroup.get("IOG_IDS");
            if (ids == null || ids.length == 0) {
                label.setText("");
            } else {
                label.setText(Integer.toString(ids.length));
                label.setHorizontalAlignment(4);
            }
        } else if (colName.equals(STR_COLOR)) {
            Color col = (Color)objGroup.get("IOG_COL");
            if (col != null) {
                label.setBackground(col);
            }
        } else {
            super.writeGeneralElement(label, obj, colName, isForFilterSplit);
        }
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        if (column.equals(STR_ANZAHL)) {
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                IDObjectGroup objGroup = (IDObjectGroup)mse.ivObject;
                long[] ids = (long[])objGroup.get("IOG_IDS");
                Comparable<Integer> comparable = mse.ivVals[pos] = ids != null ? new Integer(ids.length) : null;
            }
        }
    }
}

