/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.LifeStateReporter;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import mausoleum.alert.Alert;
import mausoleum.factsheets.FactSheetFrame;
import mausoleum.factsheets.SessionInfoHoler;
import mausoleum.factsheets.multidimreport.MultiDimReportFrame;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.inspector.DormantPanel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.IAManager;
import mausoleum.inspector.actions.InspectorAction;
import mausoleum.license.License;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.main.DefaultManager;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.requester.CopyRequester;
import mausoleum.requester.PrintRequester;
import mausoleum.requester.columns.ArrangeColumnRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.requester.preferences.Preferences;
import mausoleum.strain.Strain;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.SplitContentFrame;
import mausoleum.tables.sorting.ExtendedSortDialog;

public class MTPopuMenu {
    private final MausoleumTableModel ivModel;
    private ActionListener ivSplitListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            SplitContentFrame.showSplittedTable(MTPopuMenu.this.ivModel, Integer.parseInt(e.getActionCommand()));
        }
    };

    public MTPopuMenu(MausoleumTable copyableTable) {
        this.ivModel = (MausoleumTableModel)copyableTable.ivJTable.getModel();
        MouseAdapter adapter = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isMetaDown()) {
                    DormantPanel.actionDone();
                    if (MTPopuMenu.this.ivModel != null && MTPopuMenu.this.ivModel.getJTable() != null && MTPopuMenu.this.ivModel.getJTable().isEnabled()) {
                        MTPopuMenu.this.createMenu().show(MTPopuMenu.this.ivModel.getJTable(), e.getX(), e.getY());
                    }
                }
            }
        };
        copyableTable.ivJTable.addMouseListener(adapter);
        copyableTable.ivScrollPane.getViewport().addMouseListener(adapter);
    }

    private JPopupMenu createMenu() {
        Vector additionalMenuItems;
        String[] splitables;
        String[] filterables;
        JPopupMenu erg = new JPopupMenu();
        Vector selecteds = this.ivModel.getSelectedObjects();
        JMenu subMenu = new JMenu(Babel.get("POPUP_TABLE"));
        erg.add(subMenu);
        JMenuItem item = new JMenuItem(Babel.get("COPYTABLE"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new CopyRequester((Frame)Inspector.getInspector(), MTPopuMenu.this.ivModel, MTPopuMenu.this.ivModel, MTPopuMenu.this.ivModel.getSelectRowsAsArray()).setVisible(true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem(Babel.get("PRINTTABLE"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new PrintRequester((Frame)Inspector.getInspector(), MTPopuMenu.this.ivModel).setVisible(true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem(String.valueOf(Babel.get("COUNT_OBJECTS")) + " [" + this.ivModel.getRowCount() + "]");
        item.setFont(FontManager.getFont("SSP11"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String s = null;
                int anz = MTPopuMenu.this.ivModel.getRowCount();
                s = anz == 0 ? Babel.get("TABLEISEMPTY") : (anz == 1 ? Babel.get("TABLEHASONE") : StringHelper.gSub(Babel.get("TABLEHASMORE"), "_NUM_", Integer.toString(anz)));
                if (s != null) {
                    JOptionPane.showMessageDialog(null, s);
                }
            }
        });
        subMenu.add(item);
        item = new JMenuItem(String.valueOf(Babel.get("COUNT_SELECTED_OBJECTS")) + " [" + selecteds.size() + "]");
        item.setFont(FontManager.getFont("SSP11"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String s = null;
                int anz = MTPopuMenu.this.ivModel.getSelectedObjects().size();
                s = anz == 0 ? Babel.get("SELECTED_NONE") : (anz == 1 ? Babel.get("SELECTED_ONE") : StringHelper.gSub(Babel.get("SELECTED_MORE"), "_NUM_", Integer.toString(anz)));
                if (s != null) {
                    JOptionPane.showMessageDialog(null, s);
                }
            }
        });
        subMenu.add(item);
        item = new JMenuItem(Babel.get("ARRANGECOLS"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArrangeColumnRequester.arrange(MTPopuMenu.this.ivModel);
            }
        });
        subMenu.add(item);
        item = new JMenuItem(Babel.get("ADJUSTWIDTHS"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MTPopuMenu.this.ivModel.adjustWidths();
                DefaultManager.storeTableDefObject(MTPopuMenu.this.ivModel);
            }
        });
        subMenu.add(item);
        JMenu zoomSubMenu = new JMenu(Babel.get("CCV_ZOOM"));
        subMenu.add(zoomSubMenu);
        int i = 0;
        while (i < Preferences.ZOOM_FACTORS.length) {
            item = new JMenuItem(String.valueOf(Preferences.ZOOM_STRINGS[i]) + (this.ivModel.ivZoomIndex == i ? " \u2713" : ""));
            item.setActionCommand(Integer.toString(i));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ((MTPopuMenu)MTPopuMenu.this).ivModel.ivZoomIndex = Integer.parseInt(e.getActionCommand());
                    ((MTPopuMenu)MTPopuMenu.this).ivModel.ivZoom = Preferences.ZOOM_FACTORS[((MTPopuMenu)MTPopuMenu.this).ivModel.ivZoomIndex];
                    ((MTPopuMenu)MTPopuMenu.this).ivModel.ivMausoleumTable.ivJTable.repaint();
                    DefaultManager.setTableZoom(MTPopuMenu.this.ivModel);
                }
            });
            zoomSubMenu.add(item);
            ++i;
        }
        if (this.ivModel.isExtendedSortingPossible() && this.ivModel.getRowCount() > 1) {
            JMenu xsortMenu = new JMenu(Babel.get("EXTENDED_SORT"));
            Vector v = ExtendedSortDialog.getSortDefNames(this.ivModel.getTableType());
            if (v != null && !v.isEmpty()) {
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    item = new JMenuItem(name);
                    item.setActionCommand(name);
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            ExtendedSortDialog.runSortDef(MTPopuMenu.this.ivModel, e.getActionCommand());
                        }
                    });
                    xsortMenu.add(item);
                }
                xsortMenu.add(new JSeparator());
            }
            if (ExtendedSortDialog.hasLastDef(this.ivModel.getTableType())) {
                item = new JMenuItem(Babel.get("RUN_LAST_SORT"));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ExtendedSortDialog.runLastSort(MTPopuMenu.this.ivModel);
                    }
                });
                xsortMenu.add(item);
                item = new JMenuItem(Babel.get("EDIT_LAST_DEF"));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ExtendedSortDialog.showDialog(MTPopuMenu.this.ivModel, true);
                    }
                });
                xsortMenu.add(item);
            }
            item = new JMenuItem(Babel.get("EDIT_NEW_DEF"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExtendedSortDialog.showDialog(MTPopuMenu.this.ivModel, false);
                }
            });
            xsortMenu.add(item);
            subMenu.add(xsortMenu);
        }
        if ((filterables = this.ivModel.getAllFilterableCols()) != null && filterables.length != 0) {
            if (this.ivModel.ivFilterableValues == null) {
                item = new JMenuItem(Babel.get("FILTERCOLS"));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        MTPopuMenu.this.ivModel.setFilter(true);
                    }
                });
                subMenu.add(item);
            } else {
                item = new JMenuItem(Babel.get("DONTFILTERCOLS"));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        MTPopuMenu.this.ivModel.setFilter(false);
                    }
                });
                subMenu.add(item);
            }
        }
        if ((splitables = this.ivModel.getAllSplitableCols()) != null && splitables.length != 0) {
            JMenu splitMenu = new JMenu(String.valueOf(Babel.get("SPLIT_TABLES_BY")) + "...");
            TreeMap<String, JMenuItem> itemsByBabel = new TreeMap<String, JMenuItem>();
            int i2 = 0;
            while (i2 < splitables.length) {
                String babel = Babel.get(splitables[i2]);
                item = new JMenuItem(" " + babel + " ");
                item.setActionCommand(Integer.toString(i2));
                item.addActionListener(this.ivSplitListener);
                String tt = this.ivModel.getColumnTooltip(splitables[i2]);
                if (tt != null) {
                    String ttb = Babel.get(tt);
                    if (ttb.equals(tt)) {
                        System.out.println("Missing tooltip-Babel:" + tt);
                    } else {
                        item.setToolTipText(" " + ttb + " ");
                    }
                }
                itemsByBabel.put(babel.toLowerCase().trim(), item);
                ++i2;
            }
            Iterator itter = itemsByBabel.keySet().iterator();
            while (itter.hasNext()) {
                String key = (String)itter.next();
                splitMenu.add((JMenuItem)itemsByBabel.get(key));
            }
            subMenu.add(splitMenu);
        }
        if (this.ivModel.isMutliDimPossible()) {
            subMenu.add(new JSeparator());
            item = new JMenuItem(Babel.get("MULTIDIM_ANALYSIS"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ProcessDefinition.isClient()) {
                        new MultiDimReportFrame(((MTPopuMenu)MTPopuMenu.this).ivModel.ivObjects, MTPopuMenu.this.ivModel.getObjectType(), 0, null);
                    }
                }
            });
            subMenu.add(item);
        }
        Vector<JMenuItem> sammler = new Vector<JMenuItem>();
        if (selecteds != null && !selecteds.isEmpty() && Privileges.hasPrivilege("SHOW_SESSIONS") && this.ivModel.displaysPersistentObjectType()) {
            item = new JMenuItem(Babel.get("TPM_SHOW_OBJECT_SESSIONS"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Vector objects = SessionInfoHoler.getSessionHoler(MTPopuMenu.this.ivModel.getSelectedObjects());
                    if (objects != null && !objects.isEmpty()) {
                        WindowUtils.getJScrollPane(MTPopuMenu.this.ivModel.getJTable()).setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            Iterator iter = objects.iterator();
                            while (iter.hasNext()) {
                                SessionInfoHoler sih = (SessionInfoHoler)iter.next();
                                sih.loadSessionInfo();
                            }
                            JFrame master = WindowUtils.getJFrame(MTPopuMenu.this.ivModel.getJTable());
                            if (master != null && master instanceof FactSheetFrame) {
                                FactSheetFrame fsfs = (FactSheetFrame)master;
                                fsfs.addNewTab(objects);
                            } else {
                                FactSheetFrame.showTab(objects, Babel.get("FS_OBJECT_LOG_HEADER"));
                            }
                        }
                        catch (Exception exc) {
                            Log.error("Problem mit ObjectLog " + MTPopuMenu.this.ivModel.getSelectedObjects(), exc, this);
                        }
                        WindowUtils.getJScrollPane(MTPopuMenu.this.ivModel.getJTable()).setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
            sammler.add(item);
        }
        if (selecteds != null && !selecteds.isEmpty() && this.ivModel.ichWillFactSheets()) {
            item = new JMenuItem(Babel.get("FS_SHOW"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Vector objects = MTPopuMenu.this.ivModel.getSelectedObjects();
                    if (objects != null && !objects.isEmpty()) {
                        WindowUtils.getJScrollPane(MTPopuMenu.this.ivModel.getJTable()).setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            JFrame master = WindowUtils.getJFrame(MTPopuMenu.this.ivModel.getJTable());
                            if (master != null && master instanceof FactSheetFrame) {
                                FactSheetFrame fsfs = (FactSheetFrame)master;
                                fsfs.addNewTab(objects);
                            } else {
                                FactSheetFrame.showTab(objects, Babel.get("FS_HEADER"));
                            }
                        }
                        catch (Exception exc) {
                            Log.error("Problem mit FactSheet " + MTPopuMenu.this.ivModel.getSelectedObjects(), exc, this);
                        }
                        WindowUtils.getJScrollPane(MTPopuMenu.this.ivModel.getJTable()).setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
            sammler.add(item);
        }
        this.ivModel.addAdditionalReportItems(this.ivModel.getSelectedObjects(), sammler);
        if (!sammler.isEmpty()) {
            erg.add(new JSeparator());
            Iterator iter = sammler.iterator();
            while (iter.hasNext()) {
                erg.add((JMenuItem)iter.next());
            }
        }
        if (this.ivModel.displaysPersistentObjectType()) {
            boolean revitalize = false;
            boolean killFinal = false;
            if (selecteds != null) {
                Iterator iter = selecteds.iterator();
                while (iter.hasNext()) {
                    boolean killFinalPossible;
                    Object ooo = iter.next();
                    if (!(ooo instanceof LifeStateReporter)) continue;
                    boolean changeAllowed = true;
                    IDObject ido = null;
                    if (ooo instanceof IDObject) {
                        ido = (IDObject)ooo;
                        changeAllowed = ido.mayAttributeBeChangedByCommand();
                    }
                    LifeStateReporter lsr = (LifeStateReporter)ooo;
                    if (!changeAllowed || !lsr.isDead() && lsr.isVisible()) continue;
                    boolean revitalizePossible = false;
                    boolean bl = killFinalPossible = !lsr.isDead() || !lsr.isVisible();
                    if (killFinalPossible) {
                        if (ido.isServiceGroupObject()) {
                            killFinalPossible = ido.get("IDO_UGROUPS") == null;
                        } else {
                            boolean bl2 = killFinalPossible = !ido.isSharedWithOtherGroups();
                        }
                    }
                    if (lsr instanceof Line) {
                        revitalizePossible = Privileges.hasPrivilege("REVITALIZE_LINE");
                        killFinalPossible &= Privileges.hasPrivilege("LIN_KILL_FINAL");
                    } else if (lsr instanceof License) {
                        revitalizePossible = Privileges.hasPrivilege("REVITALIZE_LICENSE");
                        killFinalPossible &= Privileges.hasPrivilege("LIC_KILL_FINAL");
                    } else if (lsr instanceof Strain) {
                        revitalizePossible = Privileges.hasPrivilege("REVITALIZE_STRAIN");
                        killFinalPossible &= Privileges.hasPrivilege("STR_KILL_FINAL");
                    } else if (lsr instanceof Locus) {
                        revitalizePossible = Privileges.hasPrivilege("REVITALIZE_LOCUS");
                        killFinalPossible &= Privileges.hasPrivilege("LOC_KILL_FINAL");
                    } else if (lsr instanceof User) {
                        revitalizePossible = Privileges.hasPrivilege("REVITALIZE_USER");
                        killFinalPossible &= Privileges.hasPrivilege("USR_KILL_FINAL");
                    } else if (lsr instanceof Mouse) {
                        revitalizePossible = Privileges.hasPrivilege("REVITALIZE_MOUSE");
                    } else if (lsr instanceof IDObjectGroup) {
                        IDObjectGroup iog = (IDObjectGroup)lsr;
                        int st = iog.getInt("IDO_SUBTYP", 0);
                        if (st == 2) {
                            revitalizePossible = Privileges.hasPrivilege("REVITALIZE_MOUSE_COHORT");
                            killFinalPossible &= Privileges.hasPrivilege("MCOH_KILL_FINAL");
                        } else if (st == 1) {
                            revitalizePossible = Privileges.hasPrivilege("REVITALIZE_OWNER_GROUP");
                            killFinalPossible &= Privileges.hasPrivilege("OWG_KILL_FINAL");
                        }
                    }
                    if (revitalizePossible) {
                        revitalize = true;
                    }
                    if (!killFinalPossible) continue;
                    killFinal = true;
                }
            }
            boolean sepAdded = false;
            if (revitalize) {
                item = new JMenuItem(Babel.get("TPM_REVITALIZE"));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Vector ov = MTPopuMenu.this.ivModel.getSelectedObjects();
                        boolean hasMice = false;
                        Iterator iter = ov.iterator();
                        while (iter.hasNext()) {
                            if (!(iter.next() instanceof Mouse)) continue;
                            hasMice = true;
                        }
                        if (hasMice && !PopeAlert.getAnswer(Babel.get("MOUSE_REVIVE"))) {
                            return;
                        }
                        StringBuffer msb = new StringBuffer();
                        Iterator iter2 = ov.iterator();
                        while (iter2.hasNext()) {
                            IDObject ido = (IDObject)iter2.next();
                            if (!ido.isDead() && ido.isVisible()) continue;
                            String com = null;
                            if (ido instanceof Line) {
                                com = "LINREVIT";
                            } else if (ido instanceof Strain) {
                                com = "STRREVIT";
                            } else if (ido instanceof Locus) {
                                com = "LOCREVIT";
                            } else if (ido instanceof User) {
                                com = "USRREVIT";
                            } else if (ido instanceof Mouse) {
                                com = "MREVIT";
                            } else if (ido instanceof License) {
                                com = "LIC_REVIT";
                            } else if (ido instanceof IDObjectGroup) {
                                com = "IOGREVIT";
                            }
                            if (com == null) continue;
                            if (msb.length() != 0) {
                                msb.append("\n");
                            }
                            msb.append(com).append(" ").append(ido.getID());
                        }
                        if (msb.length() != 0) {
                            RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), UserManager.getFirstGroup());
                        }
                    }
                });
                sepAdded = true;
                erg.add(new JSeparator());
                erg.add(item);
            }
            if (killFinal) {
                item = new JMenuItem(Babel.get("TPM_KILL_FINAL"));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        boolean warja = Alert.showAlert(Babel.get("ALERT_REALLY_REMOVE"), Babel.get("YES"), Babel.get("NO"), false);
                        if (warja) {
                            Vector ov = MTPopuMenu.this.ivModel.getSelectedObjects();
                            StringBuffer msb = new StringBuffer();
                            Iterator iter = ov.iterator();
                            while (iter.hasNext()) {
                                boolean killFinalPossible;
                                IDObject ido = (IDObject)iter.next();
                                boolean bl = killFinalPossible = !ido.isDead() || !ido.isVisible();
                                if (killFinalPossible) {
                                    if (ido.isServiceGroupObject()) {
                                        killFinalPossible = ido.get("IDO_UGROUPS") == null;
                                    } else {
                                        boolean bl2 = killFinalPossible = !ido.isSharedWithOtherGroups();
                                    }
                                }
                                if (!killFinalPossible) continue;
                                String com = null;
                                if (ido instanceof Line) {
                                    com = "LIN_KILL_FINAL";
                                } else if (ido instanceof Strain) {
                                    com = "STR_KILL_FINAL";
                                } else if (ido instanceof Locus) {
                                    com = "LOC_KILL_FINAL";
                                } else if (ido instanceof User) {
                                    com = "USR_KILL_FINAL";
                                } else if (ido instanceof License) {
                                    com = "LIC__KILL_FINAL";
                                } else if (ido instanceof IDObjectGroup) {
                                    com = "IOG_KILL_FINAL";
                                }
                                if (com == null) continue;
                                if (msb.length() != 0) {
                                    msb.append("\n");
                                }
                                msb.append(com).append(" ").append(ido.getID());
                            }
                            if (msb.length() != 0) {
                                RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), UserManager.getFirstGroup());
                            }
                        }
                    }
                });
                if (!sepAdded) {
                    erg.add(new JSeparator());
                }
                erg.add(item);
            }
        }
        if ((additionalMenuItems = this.ivModel.getAdditionalPopupItems(this.ivModel.getSelectedObjects())) != null) {
            erg.add(new JSeparator());
            int i3 = 0;
            while (i3 < additionalMenuItems.size()) {
                Object ooo = additionalMenuItems.elementAt(i3);
                if (ooo instanceof JMenuItem) {
                    erg.add((JMenuItem)additionalMenuItems.elementAt(i3));
                } else if (ooo instanceof JComponent) {
                    erg.add((JComponent)additionalMenuItems.elementAt(i3));
                }
                ++i3;
            }
        }
        Vector<InspectorItem> butItems = new Vector<InspectorItem>();
        Vector actions = IAManager.getActions(this.ivModel.getServedClass());
        if (actions != null) {
            String commonGroup = IDObject.commonGroup(selecteds);
            boolean touchable = IDObject.touchable(selecteds);
            boolean inspDisplay = !this.ivModel.ivMausoleumTable.ivInspectorWillReact;
            Iterator iterator = actions.iterator();
            while (iterator.hasNext()) {
                InspectorAction action = (InspectorAction)iterator.next();
                if (!action.availableForPopup() || !action.availableForInspectorTables() && inspDisplay || !action.checkAction(selecteds, false, commonGroup, touchable)) continue;
                butItems.add(new InspectorItem(action));
            }
        }
        if (!butItems.isEmpty()) {
            subMenu = new JMenu(Babel.get("POPUP_ACTIONS"));
            erg.add(subMenu);
            Iterator iter = butItems.iterator();
            while (iter.hasNext()) {
                JMenuItem bitem = (JMenuItem)iter.next();
                subMenu.add(bitem);
            }
        }
        return erg;
    }

    class InspectorItem
    extends JMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 164831L;
        private final InspectorAction ivAction;

        public InspectorItem(InspectorAction iab) {
            super(Babel.get(iab.getBabel()));
            this.ivAction = iab;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent arg0) {
            boolean inspDisplay;
            Vector selecteds = MTPopuMenu.this.ivModel.getSelectedObjects();
            this.ivAction.checkAction(selecteds, true, IDObject.commonGroup(selecteds), IDObject.touchable(selecteds));
            boolean bl = inspDisplay = !((MTPopuMenu)MTPopuMenu.this).ivModel.ivMausoleumTable.ivInspectorWillReact;
            if (inspDisplay && Inspector.cvActPanel != null) {
                Inspector.cvActPanel.adjustToSelectionChange(Inspector.cvActTable, true);
            }
        }
    }
}

