/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanelRack;
import mausoleum.rack.Rack;
import mausoleum.rack.RackManager;
import mausoleum.room.Room;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.sorting.MultiSortEntry;

public class MTRack
extends MausoleumTableModel {
    public static final String STR_NAME = "NAME";
    public static final String STR_SIDES = "SIDES";
    public static final String STR_ROWS = "ROWS";
    public static final String STR_COLUMNS = "COLUMNS";
    public static final String STR_CAGES = "CAGES";
    public static final String STR_GROUPS = "GROUPS";
    public static final String STR_ROOM = "ROOM";
    public static final String STR_HAFO = "RES_TS_WB_HALTUNGSFORM";
    private static final String[] TT_DICT = new String[]{"NAME", "MTRK_TT_NAME", "SIDES", "MTRK_TT_SIDES", "ROWS", "MTRK_TT_ROWS", "COLUMNS", "MTRK_TT_COLUMNS", "CAGES", "MTRK_TT_CAGES", "GROUPS", "MTRK_TT_GROUPS", "ROOM", "MTRK_TT_ROOM", "RES_TS_WB_HALTUNGSFORM", "MTRK_TT_HALTUNGSFORM"};
    private static final String[] POSSIBLES = new String[]{"NAME", "SIDES", "ROWS", "COLUMNS", "CAGES", "GROUPS", "ROOM", "RES_TS_WB_HALTUNGSFORM"};
    private static final String[] SORTABLES = new String[]{"NAME", "SIDES", "ROWS", "COLUMNS", "CAGES", "GROUPS", "ROOM", "RES_TS_WB_HALTUNGSFORM"};
    private static final String[] EDITABLES = new String[]{"NAME"};
    private static final String[] FILTERABLES = new String[]{"SIDES", "ROWS", "COLUMNS", "GROUPS", "ROOM", "RES_TS_WB_HALTUNGSFORM"};
    private static final String[] COLORABLES = new String[]{"ROOM"};
    private static final HashMap PLAIN_SORTINGS = new HashMap(GENERAL_PLAIN_SORTINGS);
    static /* synthetic */ Class class$0;

    static {
        PLAIN_SORTINGS.put(STR_NAME, "RCK_NAME");
        PLAIN_SORTINGS.put(STR_SIDES, "RCK_SIDES");
        PLAIN_SORTINGS.put(STR_ROWS, "RCK_ROWS");
        PLAIN_SORTINGS.put(STR_COLUMNS, "RCK_COLUMNS");
        PLAIN_SORTINGS.put(STR_HAFO, "RCK_HAFO");
    }

    public MausoleumTableModel getDefaultModel() {
        return new MTRack();
    }

    public int getTableType() {
        return 10;
    }

    public boolean ichWillEinenSichtbarkeitsKnopf() {
        return false;
    }

    public boolean ichWillFactSheets() {
        return true;
    }

    public String getDisplayName() {
        return Babel.get("TDN_RACK");
    }

    public ActionListener getActionListenerForColumn(String colName) {
        if (colName.equals(STR_NAME)) {
            return ((InspectorPanelRack)Inspector.cvActPanel).ivNameField;
        }
        if (colName.equals(STR_HAFO)) {
            return ((InspectorPanelRack)Inspector.cvActPanel).ivHaltungsFormField;
        }
        return null;
    }

    public int[] getConsumertypes() {
        return new int[]{3};
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getPossibleColumns() {
        return POSSIBLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public HashMap getPlainSortings() {
        return PLAIN_SORTINGS;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[0];
    }

    public String getDefaultSortColumn() {
        return STR_NAME;
    }

    public int[] getWidths() {
        return new int[]{100, 80, 80, 120};
    }

    public String[] getDefaultColumnNames() {
        return new String[]{STR_NAME, STR_ROOM, STR_CAGES, STR_GROUPS};
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.rack.Rack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return RackManager.cvInstance;
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        Rack rack = (Rack)obj;
        if (colName.equals(STR_NAME)) {
            label.setText(rack.getName());
        } else if (colName.equals(STR_SIDES)) {
            label.setText(Integer.toString(rack.getInt("RCK_SIDES", 0)));
        } else if (colName.equals(STR_ROWS)) {
            label.setText(Integer.toString(rack.getInt("RCK_ROWS", 0)));
        } else if (colName.equals(STR_COLUMNS)) {
            label.setText(Integer.toString(rack.getInt("RCK_COLUMNS", 0)));
        } else if (colName.equals(STR_CAGES)) {
            int possible = rack.getInt("RCK_SIDES", 1) * rack.getInt("RCK_ROWS", 1) * rack.getInt("RCK_COLUMNS", 1);
            int besetzt = 0;
            boolean[] occArr = (boolean[])rack.get("RCK_OCC");
            if (occArr != null) {
                int i = 0;
                while (i < occArr.length) {
                    if (occArr[i]) {
                        ++besetzt;
                    }
                    ++i;
                }
            }
            label.setText(String.valueOf(besetzt) + " / " + possible);
        } else if (colName.equals(STR_GROUPS)) {
            label.setText(rack.getSharedGroupNames());
        } else if (colName.equals(STR_ROOM)) {
            Room room = rack.getRoom();
            if (room != null) {
                Color c;
                label.setText(room.getName());
                if (this.ivColouredColumns.contains(colName) && (c = (Color)StringHelper.getObjectForInt(room.getInt("ROM_SECURITY", 0), Room.SECURITY_INTS, Room.SECURITY_COLORS, null)) != null) {
                    label.setBackground(c);
                    label.setForeground(ColorManager.getForegroundColorForBackground(c));
                }
            } else {
                label.setText("");
            }
        } else if (colName.equals(STR_HAFO)) {
            label.setText(rack.getString("RCK_HAFO", ""));
        } else {
            super.writeGeneralElement(label, obj, colName, isForFilterSplit);
        }
    }

    public boolean isTrafficReportable() {
        return true;
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        block6: {
            block7: {
                block5: {
                    if (!column.equals(STR_CAGES)) break block5;
                    Iterator iterator = mses.iterator();
                    while (iterator.hasNext()) {
                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                        Rack rack = (Rack)mse.ivObject;
                        int besetzt = 0;
                        boolean[] occArr = (boolean[])rack.get("RCK_OCC");
                        if (occArr != null) {
                            int j = 0;
                            while (j < occArr.length) {
                                if (occArr[j]) {
                                    ++besetzt;
                                }
                                ++j;
                            }
                        }
                        mse.ivVals[pos] = new Integer(besetzt);
                    }
                    break block6;
                }
                if (!column.equals(STR_GROUPS)) break block7;
                this.sortBySharedGroups(mses, pos);
                break block6;
            }
            if (!column.equals(STR_ROOM)) break block6;
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                Room room = ((Rack)mse.ivObject).getRoom();
                Object object = mse.ivVals[pos] = room != null ? room.getName() : null;
            }
        }
    }
}

