/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.TaskColor;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.helper.FontManager;
import mausoleum.helper.LongPunkt;
import mausoleum.line.Line;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.rack.RackPos;
import mausoleum.rack.frame.RackFrame;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.SplitFilterObject;
import mausoleum.tables.TableFrameMouse;
import mausoleum.tables.models.MTCage;
import mausoleum.tables.models.MTMouse;
import mausoleum.tables.sorting.MultiSortEntry;
import mausoleum.tables.util.MTPUItem;
import mausoleum.tables.util.MTPopupHelper;
import mausoleum.task.DisplayTask;
import mausoleum.task.TaskTreeNode;

public class MTTask
extends MausoleumTableModel {
    public static final String STR_EARTAG = "EARTAGSHORT";
    public static final String STR_DATE = "DATE";
    public static final String STR_DESCR = "DESCR";
    private static final String STR_TASKID = "TASK_ID";
    private static final String STR_ISSUER = "TASK_ISSUER";
    private static final String STR_ISSUE_DATE = "TASK_ISSUE_DATE";
    public static final String STR_STATUS = "TASK_STATUS";
    private static final String STR_DETAILS = "TASK_DETAILS";
    private static final String STR_COMMENT = "COMMENT";
    private static final String STR_PERFORMER = "TASK_PERF";
    private static final String STR_PERFORM_DATE = "TASK_PERF_DATE";
    private static final String STR_FAVORIT = "TASK_FAVORIT";
    private static final String STR_CAGE = "CAGE";
    private static final String STR_RACK = "RACK";
    private static final String STR_RACK_POS = "RACK_POS";
    private static final String STR_RACK_AND_POS = "RACK_AND_POS";
    private static final String STR_ROOM = "ROOM";
    private static final String STR_LINE = "LINE";
    private static final String[] TT_DICT = new String[]{"EARTAGSHORT", "MTT_TT_EARTAG", "DATE", "MTT_TT_DATE", "DESCR", "MTT_TT_DESCR", "TASK_ISSUER", "MTT_TT_ISSUER", "TASK_ISSUE_DATE", "MTT_TT_ISSUE_DATE", "TASK_STATUS", "MTT_TT_STATUS", "COMMENT", "MTC_TT_COMMENT", "TASK_PERF", "MTT_TT_PERF", "TASK_PERF_DATE", "MTT_TT_PERF_DATE", "TASK_FAVORIT", "MTT_TT_FAVORIT", "TASK_ID", "MTT_TT_TASK_ID", "ROOM", "TT_ROOM_NAME", "CAGE", "MTM_TT_CAGE", "RACK", "MTM_TT_RACK", "RACK_POS", "MTM_TT_RACK_POS", "RACK_AND_POS", "MTM_TT_RACK_AND_POS", "LINE", "MTM_TT_LINE"};
    private static final String[] POSSIBLES = new String[]{"TASK_ID", "EARTAGSHORT", "DATE", "DESCR", "TASK_DETAILS", "TASK_ISSUER", "TASK_ISSUE_DATE", "TASK_STATUS", "COMMENT", "TASK_PERF", "TASK_PERF_DATE", "TASK_FAVORIT", "CAGE", "RACK", "RACK_POS", "RACK_AND_POS", "ROOM", "LINE"};
    private static final String[] SORTABLES = new String[]{"TASK_ID", "EARTAGSHORT", "GROUP", "DATE", "DESCR", "TASK_DETAILS", "TASK_ISSUER", "TASK_ISSUE_DATE", "TASK_STATUS", "COMMENT", "TASK_PERF", "TASK_PERF_DATE", "TASK_FAVORIT", "CAGE", "RACK", "RACK_POS", "RACK_AND_POS", "ROOM", "LINE"};
    private static final String[] EDITABLES = new String[0];
    private static final String[] COLORABLES = new String[]{"DATE", "TASK_ISSUER", "TASK_PERF", "TASK_FAVORIT", "DESCR", "CAGE", "RACK", "RACK_AND_POS", "ROOM", "LINE"};
    private static final String[] FILTERABLES = new String[]{"TASK_ID", "DESCR", "TASK_ISSUER", "TASK_STATUS", "TASK_PERF", "TASK_FAVORIT", "CAGE", "RACK", "ROOM", "LINE"};
    public static final String[] DEFAULT_SORT_COLUMNS = new String[]{"TASK_STATUS", "DATE", "EARTAGSHORT"};
    public static final boolean[] INVERSIONS_NEW_ON_TOP;
    public static final boolean[] INVERSIONS_OLD_ON_TOP;
    private static MTPUItem TASK_SELECT_SIBLINGS_ITEM;
    public MausoleumTable ivDependentMouseTable = null;
    private boolean[] ivInvertedDefaultSortings = INVERSIONS_NEW_ON_TOP;
    static /* synthetic */ Class class$0;

    static {
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        INVERSIONS_NEW_ON_TOP = blArray;
        INVERSIONS_OLD_ON_TOP = new boolean[3];
        TASK_SELECT_SIBLINGS_ITEM = new MTPUItem("TASK_SELECT_SIBLINGS", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MTTask mt = (MTTask)MTPopupHelper.getMTM(e);
                if (mt != null) {
                    mt.extendSelection();
                    mt.selectionChanged();
                    mt.ivMausoleumTable.repaint();
                }
            }
        }, null);
    }

    protected boolean isIDObjectContained(IDObject to, Vector v) {
        DisplayTask dt = (DisplayTask)to;
        String cs = dt.getSortString();
        Iterator iterator = v.iterator();
        while (iterator.hasNext()) {
            dt = (DisplayTask)iterator.next();
            if (!dt.getSortString().equals(cs)) continue;
            return true;
        }
        return false;
    }

    public void setSortModeOnTop(boolean oldOnTop) {
        this.ivInvertedDefaultSortings = oldOnTop ? INVERSIONS_OLD_ON_TOP : INVERSIONS_NEW_ON_TOP;
    }

    public MausoleumTableModel getDefaultModel() {
        return new MTTask();
    }

    public int getTableType() {
        return 15;
    }

    public ActionListener getActionListenerForColumn(String colName) {
        return null;
    }

    public String getDisplayName() {
        return Babel.get("TDN_TASK");
    }

    public int[] getConsumertypes() {
        return new int[]{1, 2, 6};
    }

    public String[] getPossibleColumns() {
        return POSSIBLES;
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public HashMap getPlainSortings() {
        return null;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[]{STR_DATE};
    }

    public boolean sortComplexDefault() {
        this.sortItDirect(DEFAULT_SORT_COLUMNS, this.ivInvertedDefaultSortings);
        return true;
    }

    public String getDefaultSortColumn() {
        return STR_DATE;
    }

    public int[] getWidths() {
        return new int[]{60, 80, 100, 300, 100, 100};
    }

    public String[] getDefaultColumnNames() {
        return new String[]{STR_EARTAG, STR_STATUS, STR_DATE, STR_DESCR, STR_ISSUER, STR_ISSUE_DATE};
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.task.DisplayTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return null;
    }

    public void processDoubleClick(Point p, Point originalPoint) {
        String colName;
        int col = this.getJTable().columnAtPoint(originalPoint);
        if (col != -1 && col < this.ivColumnNames.length && (colName = this.ivColumnNames[col]).equals(STR_RACK_POS)) {
            HashMap<String, Cage> selCages = new HashMap<String, Cage>();
            Vector v = this.getSelectedObjects();
            if (v != null) {
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    Cage cage;
                    DisplayTask displayTask = (DisplayTask)iter.next();
                    if (displayTask.ivTask.ivObjectType == 1 || displayTask.ivTask.ivObjectType == 0) {
                        Cage c;
                        Mouse mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, displayTask.ivTask.ivObjectID, displayTask.getString("IDO_GROUP", ""), null, true);
                        if (mouse == null || (c = mouse.getActCage()) == null) continue;
                        selCages.put(c.getIdentifierString(), c);
                        continue;
                    }
                    if (displayTask.ivTask.ivObjectType != 2 || (cage = (Cage)ObjectStore.getObjectDeadOrAlive(2, displayTask.ivTask.ivObjectID, displayTask.getString("IDO_GROUP", ""), null, true)) == null) continue;
                    selCages.put(cage.getIdentifierString(), cage);
                }
            }
            if (!selCages.isEmpty()) {
                Vector v2 = new Vector();
                v2.addAll(selCages.values());
                RackFrame.showCagePosition(v2);
                return;
            }
        }
        this.displayMice();
    }

    public void fillMainTable() {
        this.setTable(new Vector());
    }

    public boolean ichWillEinenOwnerKnopf() {
        return false;
    }

    public boolean displaysPersistentObjectType() {
        return false;
    }

    public Vector getAdditionalPopupItems(Vector selectedObjects) {
        Vector res = null;
        if (selectedObjects != null && !selectedObjects.isEmpty()) {
            res = new Vector();
            TASK_SELECT_SIBLINGS_ITEM.add(selectedObjects, res);
        }
        return res;
    }

    public void makeAktTable(MouseEvent e) {
        boolean altDown;
        boolean bl = altDown = e == null ? false : e.isAltDown();
        if (!altDown && this.autoExtensionPossible() && DefaultManager.autoSelExtendTasks()) {
            this.extendSelection();
        }
        super.makeAktTable(e);
    }

    public boolean autoExtensionPossible() {
        return true;
    }

    private void extendSelection() {
        HashSet<LongPunkt> hs = new HashSet<LongPunkt>();
        Vector sov = this.getSelectedObjects();
        Iterator iter = sov.iterator();
        while (iter.hasNext()) {
            DisplayTask dt = (DisplayTask)iter.next();
            hs.add(new LongPunkt(dt.ivTask.ivIssueMillis, dt.ivTask.ivIssuerID));
        }
        Vector<DisplayTask> toSelect = new Vector<DisplayTask>();
        Iterator iter2 = this.ivObjects.iterator();
        while (iter2.hasNext()) {
            DisplayTask dt = (DisplayTask)iter2.next();
            if (!hs.contains(new LongPunkt(dt.ivTask.ivIssueMillis, dt.ivTask.ivIssuerID))) continue;
            toSelect.add(dt);
        }
        this.adjustSelection(toSelect);
    }

    public boolean wantsGeneralColumns() {
        return true;
    }

    public void displayMice() {
        TableFrameMouse.displayMice(this.getTheImplicitlySelectedMice(), Babel.get("TASKMICE"), Babel.get("TASK"));
    }

    public Vector getTheImplicitlySelectedMice() {
        return TaskExtended.getTheImplicitlySelectedMice(this.getSelectedObjects());
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        DisplayTask displayTask = (DisplayTask)obj;
        boolean maytouch = true;
        IDObject ido = null;
        Mouse mouse = null;
        Cage cage = null;
        if (displayTask.ivTask.ivObjectType == 1 || displayTask.ivTask.ivObjectType == 0) {
            ido = mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, displayTask.ivTask.ivObjectID, displayTask.getString("IDO_GROUP", ""), null, true);
            if (mouse != null) {
                maytouch = mouse.itsMine(null);
            }
        } else if (displayTask.ivTask.ivObjectType == 2) {
            cage = (Cage)ObjectStore.getObjectDeadOrAlive(2, displayTask.ivTask.ivObjectID, displayTask.getString("IDO_GROUP", ""), null, true);
            ido = cage;
            if (cage != null) {
                maytouch = cage.isTouchable();
            }
        }
        this.setForegroundAccordingToOwnership(label, maytouch);
        if (displayTask.ivTask.isFinished()) {
            label.setFont(FontManager.getTableFont(false, this.ivUseDefaultFontSize, this.ivZoom));
        } else {
            label.setFont(FontManager.getTableFont(true, this.ivUseDefaultFontSize, this.ivZoom));
        }
        if (colName.equals(STR_EARTAG)) {
            if (mouse != null) {
                label.setHorizontalAlignment(4);
                label.setText(mouse.getCLLWEartagString("?", true, true));
            } else if (cage != null) {
                MTCage.writeCageNumber(label, cage);
            }
        } else if (colName.equals(STR_DATE)) {
            label.setHorizontalAlignment(0);
            label.setText(displayTask.ivTask.getDateTime());
            if (this.ivColouredColumns.contains(colName)) {
                Color c = Color.white;
                c = !displayTask.ivTask.isFinished() ? TaskColor.getBackgroundByTaskDays(displayTask.ivTask.getMinimumDays(MyDate.HEUTE)) : TaskColor.getFinishedTaskBackground();
                label.setBackground(c);
                label.setForeground(ColorManager.getForegroundColorForBackground(c));
            }
        } else if (colName.equals(STR_DESCR)) {
            if (this.ivColouredColumns.contains(colName)) {
                Color c = displayTask.ivTask.getColor(displayTask.getString("IDO_GROUP", ""));
                label.setBackground(c);
                label.setForeground(ColorManager.getForegroundColorForBackground(c));
            }
            label.setHorizontalAlignment(2);
            String s = displayTask.ivTask.getDescription(displayTask.getString("IDO_GROUP", ""), true, displayTask.ivTask.ivExtraObject);
            label.setText(s);
        } else if (colName.equals(STR_ISSUER)) {
            this.setUserNameInLabel(label, displayTask.ivTask.getIssuerGroup(displayTask.getString("IDO_GROUP", "")), displayTask.ivTask.ivIssuerID, this.ivColouredColumns.contains(colName));
        } else if (colName.equals(STR_ISSUE_DATE)) {
            this.setDateInLabel(label, displayTask.ivTask.ivIssueMillis);
        } else if (colName.equals(STR_PERFORMER)) {
            this.setUserNameInLabel(label, displayTask.ivTask.ivErledigerGroup, displayTask.ivTask.ivErledigerID, this.ivColouredColumns.contains(colName));
        } else if (colName.equals(STR_PERFORM_DATE)) {
            this.setDateInLabel(label, displayTask.ivTask.ivFinishMillis);
        } else if (colName.equals(STR_STATUS)) {
            label.setText(displayTask.ivTask.getStatusString());
        } else if (colName.equals(STR_DETAILS)) {
            String details = displayTask.ivTask.ivDetails;
            label.setText(details == null ? "" : details);
        } else if (colName.equals(STR_COMMENT)) {
            String comment = displayTask.ivTask.ivComment;
            label.setText(comment == null ? "" : comment);
        } else if (colName.equals(STR_FAVORIT)) {
            this.setUserNameInLabel(label, displayTask.ivTask.ivFavoritGroup, displayTask.ivTask.ivFavoritID, this.ivColouredColumns.contains(colName));
        } else if (colName.equals(STR_TASKID)) {
            label.setText(Long.toString(displayTask.ivTask.ivIssueMillis));
            label.setHorizontalAlignment(4);
        } else if (colName.equals(STR_CAGE)) {
            if (mouse != null) {
                MTMouse.writeCage(label, mouse, colName, this.ivColouredColumns, isForFilterSplit);
            } else if (cage != null) {
                MTCage.writeCageNr(label, cage, colName, this.ivColouredColumns, isForFilterSplit);
            }
        } else if (colName.equals(STR_RACK)) {
            if (mouse != null) {
                MTMouse.writeRack(label, mouse, colName, this.ivColouredColumns);
            } else if (cage != null) {
                MTCage.writeRack(label, cage, colName, this.ivColouredColumns);
            }
        } else if (colName.equals(STR_RACK_POS)) {
            if (mouse != null) {
                MTMouse.writeRackPos(label, mouse, colName, this.ivColouredColumns);
            } else if (cage != null) {
                MTCage.writeRackPos(label, cage, colName, this.ivColouredColumns);
            }
        } else if (colName.equals(STR_RACK_AND_POS)) {
            if (mouse != null) {
                MTMouse.writeRackAndPos(label, mouse, colName, this.ivColouredColumns);
            } else if (cage != null) {
                MTCage.writeRackAndPos(label, cage, colName, this.ivColouredColumns);
            }
        } else if (colName.equals(STR_ROOM)) {
            if (mouse != null) {
                MTMouse.writeRoom(label, mouse, colName, this.ivColouredColumns);
            } else if (cage != null) {
                MTCage.writeRoom(label, cage, colName, this.ivColouredColumns);
            }
        } else if (colName.equals(STR_LINE)) {
            if (mouse != null) {
                MTMouse.writeLine(label, mouse, colName, this.ivColouredColumns);
            } else {
                label.setText("");
            }
        } else if (ido != null) {
            super.writeGeneralElement(label, ido, colName, isForFilterSplit);
        }
    }

    private void setUserNameInLabel(MausoleumTableLabel label, String group, long id, boolean withcolor) {
        if (id == -1L) {
            label.setHorizontalAlignment(2);
            label.setText(" System ");
        } else if (id > 0L) {
            User user = (User)ObjectStore.getObjectDeadOrAlive(6, id, group, null, true);
            if (user != null) {
                Color col;
                label.setHorizontalAlignment(2);
                String uname = user.getName();
                if (!group.equals(UserManager.getFirstGroup())) {
                    uname = String.valueOf(uname) + " [" + group + "]";
                }
                label.setText(uname);
                if (withcolor && (col = (Color)user.get("USR_COLOR")) != null) {
                    label.setBackground(col);
                    label.setForeground(ColorManager.getForegroundColorForBackground(col));
                }
            } else {
                Log.error("setUserNameInLabel: User " + id + " from group " + group + " not found for task.", null, this);
            }
        }
    }

    private String getUserString(String group, long id, String defVal) {
        User user;
        if (id == -1L) {
            return " System ";
        }
        if (id > 0L && (user = (User)ObjectStore.getObjectDeadOrAlive(6, id, group, null, true)) != null) {
            if (!group.equals(UserManager.getFirstGroup())) {
                return String.valueOf(user.getName()) + " [" + group + "]";
            }
            return user.getName();
        }
        return defVal;
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        block49: {
            block70: {
                block69: {
                    block68: {
                        block67: {
                            block66: {
                                block65: {
                                    block64: {
                                        block63: {
                                            block62: {
                                                block61: {
                                                    block60: {
                                                        block59: {
                                                            block58: {
                                                                block57: {
                                                                    block56: {
                                                                        block55: {
                                                                            block54: {
                                                                                block53: {
                                                                                    block52: {
                                                                                        block51: {
                                                                                            block50: {
                                                                                                block48: {
                                                                                                    if (!column.equals("START")) break block48;
                                                                                                    Iterator iterator = mses.iterator();
                                                                                                    while (iterator.hasNext()) {
                                                                                                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                                                        DisplayTask mt = (DisplayTask)mse.ivObject;
                                                                                                        IDObject ido = mt.getUnderlying();
                                                                                                        Comparable comparable = mse.ivVals[pos] = ido == null ? null : MultiSortEntry.getComp(ido.get("IDO_START_DATE"));
                                                                                                    }
                                                                                                    break block49;
                                                                                                }
                                                                                                if (!column.equals("END")) break block50;
                                                                                                Iterator iterator = mses.iterator();
                                                                                                while (iterator.hasNext()) {
                                                                                                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                                                    DisplayTask mt = (DisplayTask)mse.ivObject;
                                                                                                    IDObject ido = mt.getUnderlying();
                                                                                                    Comparable comparable = mse.ivVals[pos] = ido == null ? null : MultiSortEntry.getComp(ido.get("IDO_END_DATE"));
                                                                                                }
                                                                                                break block49;
                                                                                            }
                                                                                            if (!column.equals("FKEY")) break block51;
                                                                                            Iterator iterator = mses.iterator();
                                                                                            while (iterator.hasNext()) {
                                                                                                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                                                DisplayTask mt = (DisplayTask)mse.ivObject;
                                                                                                IDObject ido = mt.getUnderlying();
                                                                                                mse.ivVals[pos] = MultiSortEntry.getComp(ido.get("IDO_FKEY"));
                                                                                            }
                                                                                            break block49;
                                                                                        }
                                                                                        if (!column.equals("GROUP")) break block52;
                                                                                        Iterator iterator = mses.iterator();
                                                                                        while (iterator.hasNext()) {
                                                                                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                                            DisplayTask mt = (DisplayTask)mse.ivObject;
                                                                                            mse.ivVals[pos] = mt.getString("IDO_GROUP", null);
                                                                                        }
                                                                                        break block49;
                                                                                    }
                                                                                    if (!column.equals("ID")) break block53;
                                                                                    Iterator iterator = mses.iterator();
                                                                                    while (iterator.hasNext()) {
                                                                                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                                        DisplayTask mt = (DisplayTask)mse.ivObject;
                                                                                        mse.ivVals[pos] = new Long(mt.ivTask.ivObjectID);
                                                                                    }
                                                                                    break block49;
                                                                                }
                                                                                if (!column.equals(STR_EARTAG)) break block54;
                                                                                Iterator iterator = mses.iterator();
                                                                                while (iterator.hasNext()) {
                                                                                    Cage cage;
                                                                                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                                    DisplayTask mt = (DisplayTask)mse.ivObject;
                                                                                    int et = -1;
                                                                                    if (mt.ivTask.ivObjectType == 1 || mt.ivTask.ivObjectType == 0) {
                                                                                        Mouse mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, mt.ivTask.ivObjectID, mt.getString("IDO_GROUP", ""), null, true);
                                                                                        if (mouse != null) {
                                                                                            et = mouse.getInt("MOS_EARTAG", 0);
                                                                                        }
                                                                                    } else if (mt.ivTask.ivObjectType == 2 && (cage = (Cage)ObjectStore.getObjectDeadOrAlive(2, mt.ivTask.ivObjectID, mt.getString("IDO_GROUP", ""), null, true)) != null) {
                                                                                        et = cage.getIntNumber();
                                                                                    }
                                                                                    mse.ivVals[pos] = new Integer(et);
                                                                                }
                                                                                break block49;
                                                                            }
                                                                            if (!column.equals(STR_DATE)) break block55;
                                                                            Iterator iterator = mses.iterator();
                                                                            while (iterator.hasNext()) {
                                                                                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                                DisplayTask mt = (DisplayTask)mse.ivObject;
                                                                                mse.ivVals[pos] = new Integer(mt.ivTask.getMinimumDays(MyDate.HEUTE));
                                                                            }
                                                                            break block49;
                                                                        }
                                                                        if (!column.equals(STR_DESCR)) break block56;
                                                                        Iterator iterator = mses.iterator();
                                                                        while (iterator.hasNext()) {
                                                                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                            DisplayTask mt = (DisplayTask)mse.ivObject;
                                                                            mse.ivVals[pos] = mt.ivTask.getDescriptionOhneKlammer(mt.getString("IDO_GROUP", ""));
                                                                        }
                                                                        break block49;
                                                                    }
                                                                    if (!column.equals(STR_STATUS)) break block57;
                                                                    Iterator iterator = mses.iterator();
                                                                    while (iterator.hasNext()) {
                                                                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                        DisplayTask mt = (DisplayTask)mse.ivObject;
                                                                        mse.ivVals[pos] = new Integer(mt.ivTask.ivStatus);
                                                                    }
                                                                    break block49;
                                                                }
                                                                if (!column.equals(STR_ISSUE_DATE)) break block58;
                                                                Iterator iterator = mses.iterator();
                                                                while (iterator.hasNext()) {
                                                                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                    DisplayTask mt = (DisplayTask)mse.ivObject;
                                                                    mse.ivVals[pos] = new Long(mt.ivTask.ivIssueMillis);
                                                                }
                                                                break block49;
                                                            }
                                                            if (!column.equals(STR_PERFORM_DATE)) break block59;
                                                            Iterator iterator = mses.iterator();
                                                            while (iterator.hasNext()) {
                                                                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                DisplayTask mt = (DisplayTask)mse.ivObject;
                                                                mse.ivVals[pos] = new Long(mt.ivTask.ivFinishMillis);
                                                            }
                                                            break block49;
                                                        }
                                                        if (!column.equals(STR_COMMENT)) break block60;
                                                        Iterator iterator = mses.iterator();
                                                        while (iterator.hasNext()) {
                                                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                            DisplayTask mt = (DisplayTask)mse.ivObject;
                                                            mse.ivVals[pos] = MultiSortEntry.getComp(mt.ivTask.ivComment);
                                                        }
                                                        break block49;
                                                    }
                                                    if (!column.equals(STR_DETAILS)) break block61;
                                                    Iterator iterator = mses.iterator();
                                                    while (iterator.hasNext()) {
                                                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                        DisplayTask mt = (DisplayTask)mse.ivObject;
                                                        mse.ivVals[pos] = MultiSortEntry.getComp(mt.ivTask.ivDetails);
                                                    }
                                                    break block49;
                                                }
                                                if (!column.equals(STR_ISSUER)) break block62;
                                                Iterator iterator = mses.iterator();
                                                while (iterator.hasNext()) {
                                                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                    DisplayTask mt = (DisplayTask)mse.ivObject;
                                                    mse.ivVals[pos] = this.getUserString(mt.ivTask.getIssuerGroup(mt.getString("IDO_GROUP", "")), mt.ivTask.ivIssuerID, "");
                                                }
                                                break block49;
                                            }
                                            if (!column.equals(STR_FAVORIT)) break block63;
                                            Iterator iterator = mses.iterator();
                                            while (iterator.hasNext()) {
                                                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                DisplayTask mt = (DisplayTask)mse.ivObject;
                                                mse.ivVals[pos] = this.getUserString(mt.ivTask.ivFavoritGroup, mt.ivTask.ivFavoritID, "");
                                            }
                                            break block49;
                                        }
                                        if (!column.equals(STR_PERFORMER)) break block64;
                                        Iterator iterator = mses.iterator();
                                        while (iterator.hasNext()) {
                                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                            DisplayTask mt = (DisplayTask)mse.ivObject;
                                            mse.ivVals[pos] = this.getUserString(mt.ivTask.ivErledigerGroup, mt.ivTask.ivErledigerID, "");
                                        }
                                        break block49;
                                    }
                                    if (!column.equals(STR_TASKID)) break block65;
                                    Iterator iterator = mses.iterator();
                                    while (iterator.hasNext()) {
                                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                        DisplayTask mt = (DisplayTask)mse.ivObject;
                                        mse.ivVals[pos] = new Long(mt.ivTask.ivIssueMillis);
                                    }
                                    break block49;
                                }
                                if (!column.equals(STR_CAGE)) break block66;
                                Iterator iterator = mses.iterator();
                                while (iterator.hasNext()) {
                                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                    DisplayTask mt = (DisplayTask)mse.ivObject;
                                    Cage cage = null;
                                    if (mt.ivTask.ivObjectType == 1 || mt.ivTask.ivObjectType == 0) {
                                        Mouse mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, mt.ivTask.ivObjectID, mt.getString("IDO_GROUP", ""), null, true);
                                        if (mouse != null) {
                                            cage = mouse.getActCage();
                                        }
                                    } else if (mt.ivTask.ivObjectType == 2) {
                                        cage = (Cage)ObjectStore.getObjectDeadOrAlive(2, mt.ivTask.ivObjectID, mt.getString("IDO_GROUP", ""), null, true);
                                    }
                                    Comparable<Integer> comparable = mse.ivVals[pos] = cage != null ? new Integer(cage.getIntNumber()) : null;
                                }
                                break block49;
                            }
                            if (!column.equals(STR_RACK)) break block67;
                            Iterator iterator = mses.iterator();
                            while (iterator.hasNext()) {
                                Cage cage;
                                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                DisplayTask mt = (DisplayTask)mse.ivObject;
                                String rackName = null;
                                if (mt.ivTask.ivObjectType == 1 || mt.ivTask.ivObjectType == 0) {
                                    Mouse mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, mt.ivTask.ivObjectID, mt.getString("IDO_GROUP", ""), null, true);
                                    if (mouse != null) {
                                        rackName = mouse.getRackName();
                                    }
                                } else if (mt.ivTask.ivObjectType == 2 && (cage = (Cage)ObjectStore.getObjectDeadOrAlive(2, mt.ivTask.ivObjectID, mt.getString("IDO_GROUP", ""), null, true)) != null) {
                                    rackName = cage.getRackName();
                                }
                                mse.ivVals[pos] = rackName;
                            }
                            break block49;
                        }
                        if (!column.equals(STR_RACK_POS)) break block68;
                        Iterator iterator = mses.iterator();
                        while (iterator.hasNext()) {
                            Cage cage;
                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                            DisplayTask mt = (DisplayTask)mse.ivObject;
                            RackPos rp = null;
                            if (mt.ivTask.ivObjectType == 1 || mt.ivTask.ivObjectType == 0) {
                                Mouse mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, mt.ivTask.ivObjectID, mt.getString("IDO_GROUP", ""), null, true);
                                if (mouse != null) {
                                    rp = mouse.getRackPos();
                                }
                            } else if (mt.ivTask.ivObjectType == 2 && (cage = (Cage)ObjectStore.getObjectDeadOrAlive(2, mt.ivTask.ivObjectID, mt.getString("IDO_GROUP", ""), null, true)) != null) {
                                rp = (RackPos)cage.get("CAG_POS");
                            }
                            Comparable<Integer> comparable = mse.ivVals[pos] = rp != null ? new Integer(rp.getSortValue()) : null;
                        }
                        break block49;
                    }
                    if (!column.equals(STR_RACK_AND_POS)) break block69;
                    Iterator iterator = mses.iterator();
                    while (iterator.hasNext()) {
                        Cage cage;
                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                        DisplayTask mt = (DisplayTask)mse.ivObject;
                        RackPos rp = null;
                        Object rackName = null;
                        if (mt.ivTask.ivObjectType == 1 || mt.ivTask.ivObjectType == 0) {
                            Mouse mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, mt.ivTask.ivObjectID, mt.getString("IDO_GROUP", ""), null, true);
                            if (mouse != null) {
                                rp = mouse.getRackPos();
                            }
                        } else if (mt.ivTask.ivObjectType == 2 && (cage = (Cage)ObjectStore.getObjectDeadOrAlive(2, mt.ivTask.ivObjectID, mt.getString("IDO_GROUP", ""), null, true)) != null) {
                            rp = (RackPos)cage.get("CAG_POS");
                        }
                        Comparable comparable = mse.ivVals[pos] = rp != null ? MultiSortEntry.getComp(String.valueOf(rackName) + rp.getSortValue()) : null;
                    }
                    break block49;
                }
                if (!column.equals(STR_ROOM)) break block70;
                Iterator iterator = mses.iterator();
                while (iterator.hasNext()) {
                    Cage cage;
                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                    DisplayTask mt = (DisplayTask)mse.ivObject;
                    String roomName = null;
                    if (mt.ivTask.ivObjectType == 1 || mt.ivTask.ivObjectType == 0) {
                        Mouse mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, mt.ivTask.ivObjectID, mt.getString("IDO_GROUP", ""), null, true);
                        if (mouse != null) {
                            roomName = mouse.getRoomName();
                        }
                    } else if (mt.ivTask.ivObjectType == 2 && (cage = (Cage)ObjectStore.getObjectDeadOrAlive(2, mt.ivTask.ivObjectID, mt.getString("IDO_GROUP", ""), null, true)) != null) {
                        roomName = cage.getRoomName();
                    }
                    mse.ivVals[pos] = roomName;
                }
                break block49;
            }
            if (!column.equals(STR_LINE)) break block49;
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                Line line;
                Mouse mouse;
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                DisplayTask mt = (DisplayTask)mse.ivObject;
                String lineName = null;
                if ((mt.ivTask.ivObjectType == 1 || mt.ivTask.ivObjectType == 0) && (mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, mt.ivTask.ivObjectID, mt.getString("IDO_GROUP", ""), null, true)) != null && (line = mouse.getLine()) != null) {
                    lineName = line.getBrowseName();
                }
                mse.ivVals[pos] = lineName;
            }
        }
    }

    public SplitFilterObject getSFO(String colKennung, String val) {
        if (colKennung.equals(STR_EARTAG) || colKennung.equals(STR_CAGE)) {
            Integer key = new Integer(0);
            try {
                int ind = val.indexOf("-");
                if (ind != -1) {
                    key = new Integer(val.substring(0, ind).trim());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new SplitFilterObject(val, val, key);
        }
        return super.getSFO(colKennung, val);
    }

    public void handleNewObject(IDObject obj) {
        TaskTreeNode.handleNewObject(obj);
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        if (MausoleumClient.isServiceCaretaker()) {
            TaskTreeNode.objectLeftServiceRoom(objectTyp, group, objectIDs);
        }
    }
}

