/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.user.UserRoomRestriction;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.CageManager;
import mausoleum.cage.colors.MixColorMode;
import mausoleum.cage.colors.MouseCount;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.helper.AllgUtils;
import mausoleum.inspector.actions.room.RoomAction;
import mausoleum.main.DefaultManager;
import mausoleum.room.RoomStatusListener;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.SplitFilterObject;
import mausoleum.tables.TableFrameMouse;
import mausoleum.tables.models.MTCage;
import mausoleum.tables.sorting.MultiSortEntry;

public class MTWedding
extends MausoleumTableModel
implements RoomStatusListener {
    private static final String STR_CAGE = "CAGE";
    private static final String STR_RACK = "RACK";
    private static final String STR_ROOM = "ROOM";
    private static final String STR_MICE = "MICE";
    private static final String STR_PUPS = "PUPS";
    private static final String STR_LINES = "LINES";
    private static final String STR_STRAINS = "STRAINS";
    private static final String STR_GENOTYPES = "GTS";
    private static final String STR_COMMENT = "COMMENT";
    private static final String[] POSSIBLES = new String[]{"CAGE", "MICE", "PUPS", "LINES", "STRAINS", "GTS", "COMMENT", "RACK", "ROOM"};
    private static final String[] TT_DICT = new String[]{"CAGE", "MTW_TT_CAGE", "MICE", "MTW_TT_MICE", "PUPS", "MTW_TT_PUPS", "LINES", "MTC_TT_LINES", "STRAINS", "MTC_TT_STRAINS", "GTS", "MTC_TT_GENOTYPES", "COMMENT", "MTC_TT_COMMENT", "RACK", "MTC_TT_RACK", "ROOM", "TT_ROOM_NAME"};
    private static final String[] SORTABLES = new String[]{"CAGE", "MICE", "PUPS", "LINES", "STRAINS", "GTS", "COMMENT", "RACK", "ROOM"};
    private static final String[] EDITABLES = new String[0];
    private static final String[] FILTERABLES = new String[]{"CAGE", "MICE", "PUPS", "LINES", "STRAINS", "RACK", "ROOM"};
    private static final String[] COLORABLES = new String[]{"CAGE", "MICE", "LINES", "STRAINS", "RACK", "ROOM"};
    private static final HashMap PLAIN_SORTINGS = new HashMap(GENERAL_PLAIN_SORTINGS);
    static /* synthetic */ Class class$0;

    public MausoleumTableModel getDefaultModel() {
        return new MTWedding();
    }

    public int getTableType() {
        return 18;
    }

    public ActionListener getActionListenerForColumn(String colName) {
        return null;
    }

    public String getDisplayName() {
        return Babel.get("TDN_WEDDING");
    }

    public int[] getConsumertypes() {
        return new int[0];
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public HashMap getPlainSortings() {
        return PLAIN_SORTINGS;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String getDefaultSortColumn() {
        return STR_CAGE;
    }

    public int[] getWidths() {
        return new int[]{30, 30, 30, 200};
    }

    public String[] getPossibleColumns() {
        return POSSIBLES;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[]{STR_CAGE};
    }

    public String[] getDefaultColumnNames() {
        return new String[]{STR_CAGE, STR_MICE, STR_PUPS, STR_LINES};
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.wedding.Wedding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return CageManager.cvInstance;
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public void processDoubleClick(Point p, Point originalPoint) {
        this.displayMice();
    }

    public void fillMainTable() {
        this.setTable(CageManager.cvInstance.getMatingsAllGroups());
    }

    public int getRealObjectType() {
        return 2;
    }

    public boolean ichWillEinenOwnerKnopf() {
        return !UserManager.cvIsCareTaker;
    }

    public boolean ichWillFactSheets() {
        return true;
    }

    public void displayMice() {
        TableFrameMouse.displayMice(this.getTheImplicitlySelectedMice(), Babel.get("WEDDINGSNAPSHOT"), Babel.get("WEDDING"));
    }

    public Vector getTheImplicitlySelectedMice() {
        Vector erg = new Vector();
        Vector v = this.getSelectedObjects();
        if (v != null) {
            int i = 0;
            while (i < v.size()) {
                Cage c = (Cage)v.elementAt(i);
                c.addActualMice(erg);
                ++i;
            }
        }
        return erg;
    }

    public void roomStatusChanged() {
        this.setOrigObjectsAgain();
    }

    public boolean filterObject(Object ooo) {
        if (ooo instanceof Cage) {
            Cage cage = (Cage)ooo;
            return this.filterByRoom(cage) && this.filterByOwner(cage);
        }
        return false;
    }

    public boolean filterByOwner(Cage cage) {
        if (!UserManager.cvIsCareTaker && this.getOnlyOwnObjects()) {
            if (cage.itsMine(null)) {
                return true;
            }
            this.ivOwnerFiltered = true;
            return false;
        }
        return true;
    }

    private boolean filterByRoom(Cage cage) {
        if (!UserRoomRestriction.isObjectRestricted(cage)) {
            long roomid = RoomAction.cvRoomID;
            if (roomid == 0L) {
                return true;
            }
            return cage.isCageInRoomOrTransfer(roomid);
        }
        return false;
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        Cage cage = (Cage)obj;
        boolean maytouch = UserManager.cvIsCareTaker || cage.itsMine(null);
        this.setForegroundAccordingToOwnership(label, maytouch);
        if (colName.equals(STR_CAGE)) {
            MTCage.writeCageNr(label, cage, colName, this.ivColouredColumns, isForFilterSplit);
        } else if (colName.equals(STR_MICE)) {
            label.setHorizontalAlignment(4);
            int numMice = cage.getNumberOfMice();
            if (numMice == 0) {
                label.setText("");
            } else {
                label.setText(Integer.toString(numMice));
                if (this.ivColouredColumns.contains(colName)) {
                    Color c = MixColorMode.getColor(numMice, MouseCount.VALUES, MouseCount.COLORS);
                    label.setBackground(c);
                    label.setForeground(ColorManager.getForegroundColorForBackground(c));
                }
            }
        } else if (colName.equals(STR_PUPS)) {
            label.setHorizontalAlignment(4);
            int num = cage.getNumOfPups();
            if (num <= 0) {
                label.setText(" ");
            } else {
                label.setText(Integer.toString(num));
            }
        } else if (colName.equals(STR_LINES)) {
            if (this.ivColouredColumns.contains(colName)) {
                label.setMultiBackgroundStrings(AllgUtils.getTypeMultiBackground(cage.getActualMice(), 0, null));
            } else {
                String typs = AllgUtils.getTypeString(cage, cage.getActualMice(), 0, true);
                if (typs != null) {
                    label.setText(typs);
                }
            }
        } else if (colName.equals(STR_STRAINS)) {
            if (this.ivColouredColumns.contains(colName)) {
                label.setMultiBackgroundStrings(AllgUtils.getTypeMultiBackground(cage.getActualMice(), 1, null));
            } else {
                String typs = AllgUtils.getTypeString(cage, cage.getActualMice(), 1, true);
                if (typs != null) {
                    label.setText(typs);
                }
            }
        } else if (colName.equals(STR_GENOTYPES)) {
            String typs = AllgUtils.getTypeString(cage, cage.getActualMice(), 2, true);
            if (typs != null) {
                label.setText(typs);
            }
        } else if (colName.equals(STR_COMMENT)) {
            String typs = AllgUtils.getTypeString(cage, cage.getActualMice(), 3, true);
            if (typs != null) {
                label.setText(typs);
            }
        } else if (colName.equals(STR_RACK)) {
            MTCage.writeRack(label, cage, colName, this.ivColouredColumns);
        } else if (colName.equals(STR_ROOM)) {
            MTCage.writeRoom(label, cage, colName, this.ivColouredColumns);
        } else {
            super.writeGeneralElement(label, obj, colName, isForFilterSplit);
        }
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        block11: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block10: {
                                            if (!column.equals(STR_CAGE)) break block10;
                                            if (DefaultManager.useCagePseudoIDs()) {
                                                MultiSortEntry.fillSortVector(mses, "CAG_PSEUDOID", pos);
                                            } else {
                                                MultiSortEntry.fillSortVector(mses, "IDO_ID", pos);
                                            }
                                            break block11;
                                        }
                                        if (!column.equals(STR_MICE)) break block12;
                                        Iterator iterator = mses.iterator();
                                        while (iterator.hasNext()) {
                                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                            Cage c = (Cage)mse.ivObject;
                                            mse.ivVals[pos] = new Integer(c.getNumberOfMice());
                                        }
                                        break block11;
                                    }
                                    if (!column.equals(STR_PUPS)) break block13;
                                    Iterator iterator = mses.iterator();
                                    while (iterator.hasNext()) {
                                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                        Cage c = (Cage)mse.ivObject;
                                        int numPup = c.getNumOfPups();
                                        Comparable<Integer> comparable = mse.ivVals[pos] = numPup != 0 ? new Integer(numPup) : null;
                                    }
                                    break block11;
                                }
                                if (!column.equals(STR_LINES)) break block14;
                                Iterator iterator = mses.iterator();
                                while (iterator.hasNext()) {
                                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                    Cage c = (Cage)mse.ivObject;
                                    mse.ivVals[pos] = MultiSortEntry.getComp(AllgUtils.getTypeString(c, c.getActualMice(), 0, false));
                                }
                                break block11;
                            }
                            if (!column.equals(STR_STRAINS)) break block15;
                            Iterator iterator = mses.iterator();
                            while (iterator.hasNext()) {
                                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                Cage c = (Cage)mse.ivObject;
                                mse.ivVals[pos] = MultiSortEntry.getComp(AllgUtils.getTypeString(c, c.getActualMice(), 1, false));
                            }
                            break block11;
                        }
                        if (!column.equals(STR_GENOTYPES)) break block16;
                        Iterator iterator = mses.iterator();
                        while (iterator.hasNext()) {
                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                            Cage c = (Cage)mse.ivObject;
                            mse.ivVals[pos] = MultiSortEntry.getComp(AllgUtils.getTypeString(c, c.getActualMice(), 2, false));
                        }
                        break block11;
                    }
                    if (!column.equals(STR_COMMENT)) break block17;
                    Iterator iterator = mses.iterator();
                    while (iterator.hasNext()) {
                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                        Cage c = (Cage)mse.ivObject;
                        mse.ivVals[pos] = MultiSortEntry.getComp(AllgUtils.getTypeString(c, c.getActualMice(), 3, false));
                    }
                    break block11;
                }
                if (!column.equals(STR_RACK)) break block18;
                Iterator iterator = mses.iterator();
                while (iterator.hasNext()) {
                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                    Cage c = (Cage)mse.ivObject;
                    mse.ivVals[pos] = c.getSuperCageIfThere().getRackName();
                }
                break block11;
            }
            if (!column.equals(STR_ROOM)) break block11;
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                Cage c = (Cage)mse.ivObject;
                mse.ivVals[pos] = c.getSuperCageIfThere().getRoomName();
            }
        }
    }

    public SplitFilterObject getSFO(String colKennung, String val) {
        if (colKennung.equals(STR_CAGE)) {
            Integer key = new Integer(0);
            try {
                int ind = val.indexOf("-");
                if (ind != -1) {
                    key = new Integer(val.substring(0, ind).trim());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new SplitFilterObject(val, val, key);
        }
        return super.getSFO(colKennung, val);
    }
}

