/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.sorting;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IdentifiableObject;
import java.awt.Color;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.tables.MausoleumTableModel;

public class MultiSortEntry {
    public IdentifiableObject ivObject;
    public final int ivPos;
    public final Comparable[] ivVals;

    public static void sort(MausoleumTableModel model, String[] colnames, boolean[] inverteds, Vector originalObjects, Vector visibleObjects) {
        TreeSet<String> ts = new TreeSet<String>();
        Iterator iterator = visibleObjects.iterator();
        while (iterator.hasNext()) {
            IdentifiableObject ido = (IdentifiableObject)iterator.next();
            ts.add(ido.getIdentifierString());
        }
        Vector<MultiSortEntry> mses = new Vector<MultiSortEntry>(originalObjects.size());
        int pos = 0;
        Iterator iterator2 = originalObjects.iterator();
        while (iterator2.hasNext()) {
            mses.add(new MultiSortEntry((IdentifiableObject)iterator2.next(), pos++, colnames.length));
        }
        int sc = 0;
        while (sc < colnames.length) {
            String tag;
            String string = tag = model.getPlainSortings() != null ? (String)model.getPlainSortings().get(colnames[sc]) : null;
            if (tag != null) {
                MultiSortEntry.fillSortVector(mses, tag, sc);
            } else {
                model.fillSortVector(mses, colnames[sc], sc);
            }
            ++sc;
        }
        Collections.sort(mses, new MultiEntrySorter(inverteds));
        originalObjects.clear();
        visibleObjects.clear();
        int i = 0;
        while (i < mses.size()) {
            MultiSortEntry mse = (MultiSortEntry)mses.elementAt(i);
            originalObjects.add(mse.ivObject);
            if (ts.contains(mse.ivObject.getIdentifierString())) {
                visibleObjects.add(mse.ivObject);
            }
            mse.dispose();
            ++i;
        }
        ts.clear();
        mses.clear();
    }

    public static void fillSortVector(Vector mses, String idoTag, int col) {
        Iterator iter = mses.iterator();
        while (iter.hasNext()) {
            MultiSortEntry mse = (MultiSortEntry)iter.next();
            if (mse.ivObject instanceof IDObject) {
                IDObject ido = (IDObject)mse.ivObject;
                mse.ivVals[col] = MultiSortEntry.getComp(ido.get(idoTag));
                continue;
            }
            mse.ivVals[col] = "";
        }
    }

    public static Comparable getComp(Object ooo) {
        if (ooo != null) {
            if (ooo instanceof String) {
                String s = (String)ooo;
                if (s.trim().length() != 0) {
                    return s;
                }
            } else {
                if (ooo instanceof Color) {
                    Color col = (Color)ooo;
                    return new Integer(col.getRGB());
                }
                if (ooo instanceof Comparable) {
                    return (Comparable)ooo;
                }
                if (ooo instanceof Date) {
                    return new Long(((Date)ooo).getTime());
                }
            }
        }
        return null;
    }

    public static MultiSortEntry findByPos(Vector entries, int pos) {
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            MultiSortEntry entry = (MultiSortEntry)iterator.next();
            if (entry.ivPos != pos) continue;
            return entry;
        }
        return null;
    }

    public MultiSortEntry(IdentifiableObject ido, int pos, int anz) {
        this.ivObject = ido;
        this.ivPos = pos;
        this.ivVals = new Comparable[anz];
    }

    private void dispose() {
        int i = 0;
        while (i < this.ivVals.length) {
            this.ivVals[i] = null;
            ++i;
        }
        this.ivObject = null;
    }

    private int compareTo(MultiSortEntry mse, boolean[] inverteds) {
        int i = 0;
        while (i < this.ivVals.length) {
            if (this.ivVals[i] != null || mse.ivVals[i] != null) {
                if (this.ivVals[i] != null && mse.ivVals[i] == null) {
                    return -1;
                }
                if (this.ivVals[i] == null && mse.ivVals[i] != null) {
                    return 1;
                }
                int res = 0;
                res = this.ivVals[i] instanceof String ? ((String)((Object)this.ivVals[i])).compareToIgnoreCase((String)((Object)mse.ivVals[i])) : this.ivVals[i].compareTo(mse.ivVals[i]);
                if (res != 0) {
                    return inverteds[i] ? -res : res;
                }
            }
            ++i;
        }
        return this.ivPos < mse.ivPos ? -1 : 1;
    }

    private static class MultiEntrySorter
    implements Comparator {
        private final boolean[] ivInverteds;

        public MultiEntrySorter(boolean[] inverteds) {
            this.ivInverteds = inverteds;
        }

        public int compare(Object arg0, Object arg1) {
            MultiSortEntry mse0 = (MultiSortEntry)arg0;
            MultiSortEntry mse1 = (MultiSortEntry)arg1;
            return mse0.compareTo(mse1, this.ivInverteds);
        }
    }
}

