/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.task;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.TreePath;
import mausoleum.cage.colors.TaskColor;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManager;
import mausoleum.inspector.actions.task.TaskAction;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.mouse.TaskExtended;
import mausoleum.tables.TableFrameTasks;
import mausoleum.task.PeriodTaskHelper;
import mausoleum.task.TaskTreeNode;

public class DisplayTask
extends IDObject {
    private static final long serialVersionUID = 1456L;
    public static final boolean CAGE_TASKS_POSSIBLE = false;
    public static final int TYP_FIXED = 1;
    public static final int TYP_PERIOD = 2;
    public TaskExtended ivTask = null;
    public final long ivComeFromID;
    public final int ivComeFromType;
    public transient String ivSortString = null;
    static /* synthetic */ Class class$0;

    public static void init() {
        Vector tasks = new Vector();
        Vector idoTarget = new Vector();
        int jetzt = (int)(System.currentTimeMillis() / 86400000L);
        HashMap displaytasksToRemoveByObjectGroup = new HashMap();
        boolean showFrame = false;
        showFrame = DisplayTask.collect(MouseManager.getActualObjectsOfAllGroups(), tasks, idoTarget, jetzt, displaytasksToRemoveByObjectGroup);
        if (showFrame |= DisplayTask.collect(AllgUtils.getVec(UserManager.getUserWithoutDisguise()), tasks, idoTarget, jetzt, displaytasksToRemoveByObjectGroup)) {
            TableFrameTasks.windowIsNecessary();
        }
        TaskTreeNode.ROOT.removeAllTasks();
        TaskTreeNode.clearUnterhaenger();
        TaskTreeNode.insert(tasks, idoTarget);
        if (!displaytasksToRemoveByObjectGroup.isEmpty()) {
            TaskExtended.removeTasks(displaytasksToRemoveByObjectGroup);
        }
        if (TableFrameTasks.hasMainTable()) {
            TreePath tp = new TreePath(new TaskTreeNode[]{TaskTreeNode.ROOT, TaskTreeNode.PENDING});
            TaskTreeNode.TREE.setSelectionPath(tp);
            TableFrameTasks.treeSelectionChanged();
        }
    }

    private static boolean collect(Vector idObjects, Vector taskSammler, Vector idoSammler, int jetzt, HashMap displayTasksToRemove) {
        long now = System.currentTimeMillis();
        int heute = new MyDate(new GregorianCalendar()).getTage();
        boolean showFrame = false;
        if (idObjects != null) {
            int i = 0;
            while (i < idObjects.size()) {
                TaskExtended[] arr;
                String pseudoGuruAttentionGroup = null;
                IDObject ido = (IDObject)idObjects.elementAt(i);
                boolean useObject = false;
                if (ido instanceof Mouse) {
                    Mouse mouse = (Mouse)ido;
                    useObject = mouse.isTouchable();
                } else if (ido instanceof User) {
                    useObject = true;
                    if (ido.getInt("USR_MODE", 0) == 500) {
                        pseudoGuruAttentionGroup = UserManager.getFirstGroup();
                    }
                }
                if (useObject && (arr = (TaskExtended[])ido.get(ido.getTaskKey())) != null) {
                    int j = 0;
                    while (j < arr.length) {
                        if (arr[j] == null || arr[j].ivProcType == 0) {
                            System.out.println("Ignoring empty Task-entry for " + ido);
                        } else {
                            arr[j].clientSafety(ido);
                            if (DisplayTask.shouldTaskBeRemoved(arr[j], now, heute)) {
                                DisplayTask.getRidOfTask(ido, displayTasksToRemove, arr[j]);
                            } else if (pseudoGuruAttentionGroup != null && !pseudoGuruAttentionGroup.equals(arr[j].ivHoSIssuedGroup)) {
                                System.out.println("Ignoring Task not issued for group " + pseudoGuruAttentionGroup);
                            } else {
                                int datumsDifferenz = arr[j].getMinimumDays(jetzt);
                                String group = ido.getGroup();
                                if (group != null && TaskExtended.shouldTaskBeShown(arr[j], group, false)) {
                                    taskSammler.addElement(new DisplayTask(arr[j], ido));
                                    idoSammler.add(ido);
                                    if (datumsDifferenz <= 2) {
                                        showFrame = true;
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return showFrame;
    }

    private static boolean shouldTaskBeRemoved(TaskExtended task, long now, int today) {
        if (task.ivDatum == Integer.MIN_VALUE) {
            return true;
        }
        if (task.isFixedDayTask()) {
            return task.isFinished() && now - task.ivFinishMillis > 3628800000L;
        }
        if (task.isPeriodTask()) {
            return task.ivPeriodEnd < today;
        }
        return false;
    }

    private static void getRidOfTask(IDObject ido, HashMap displayTasksToRemove, TaskExtended task) {
        String group = ido.getGroup();
        if (group != null) {
            Vector<DisplayTask> ttr = (Vector<DisplayTask>)displayTasksToRemove.get(group);
            if (ttr == null) {
                ttr = new Vector<DisplayTask>();
                displayTasksToRemove.put(group, ttr);
            }
            ttr.add(new DisplayTask(task, ido));
        }
    }

    public static void getPermittedDateChangeDisplayTasks(Vector orig, Vector target) {
        target.clear();
        Iterator iter = orig.iterator();
        while (iter.hasNext()) {
            DisplayTask dt = (DisplayTask)iter.next();
            if (dt.ivTask.isFinished() || !dt.ivTask.isFixedDayTask() || !TaskAction.privilegeCheck(dt, "TASK_COM_CHANGE_DATE")) continue;
            target.add(dt);
        }
    }

    public static Vector getChangingTaskVec(Vector orig, int neuTage, int neuTimePref) {
        Vector<DisplayTask> res = new Vector<DisplayTask>();
        if (orig != null) {
            Iterator iter = orig.iterator();
            while (iter.hasNext()) {
                DisplayTask dt = (DisplayTask)iter.next();
                if (neuTimePref != Integer.MAX_VALUE && dt.ivTask.ivTime != neuTimePref) {
                    res.add(dt);
                    continue;
                }
                if (dt.ivTask.ivDatum == neuTage) continue;
                res.add(dt);
            }
        }
        return res;
    }

    public static Cursor createCursor(Vector displayTasks, boolean withColor) {
        try {
            int sizz = 32;
            Dimension bd = Toolkit.getDefaultToolkit().getBestCursorSize(sizz, sizz);
            if (bd.width < sizz) {
                sizz = bd.width;
            }
            BufferedImage img = new BufferedImage(sizz, sizz, 2);
            DisplayTask dt = (DisplayTask)displayTasks.firstElement();
            Color fg = Color.black;
            Color bg = Color.white;
            if (withColor) {
                int index = dt.ivTask.getMinimumDays(MyDate.HEUTE) + 1;
                if (index < 0) {
                    index = 0;
                }
                if (index < TaskColor.TASK_DAYS_SCHEDULE_BOX_BACKGROUNDS.length) {
                    bg = TaskColor.TASK_DAYS_SCHEDULE_BOX_BACKGROUNDS[index];
                    fg = TaskColor.TASK_DAYS_SCHEDULE_BOX_FOREGROUNDS[index];
                }
            }
            Graphics g = img.getGraphics();
            g.setColor(bg);
            g.fillRect(0, 0, sizz, sizz);
            g.setColor(fg);
            g.drawRect(0, 0, sizz - 1, sizz - 1);
            String s = Integer.toString(displayTasks.size());
            g.setFont(FontManager.getFont("SSB12"));
            int sw = g.getFontMetrics().stringWidth(s);
            g.drawString(s, (sizz - sw) / 2, sizz / 2 + 5);
            return Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(10, 10), "TASKS");
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.task.DisplayTask");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem while creating task cursor", e, clazz);
            return null;
        }
    }

    public DisplayTask(TaskExtended task, IDObject ido) {
        this(task, ido.getGroup(), ido.getTyp(), ido.getID());
    }

    public DisplayTask(TaskExtended task, String group, int objType, long objID) {
        this.ivTask = new TaskExtended(task);
        this.ivComeFromID = objID;
        this.ivComeFromType = objType;
        this.set("IDO_GROUP", group);
        this.setLong("IDO_ID", MilliSpender.getMillis());
        this.commit(false);
        HashSet<String> hs = new HashSet<String>();
        hs.add(group);
        hs.add("service");
        if (this.ivTask.ivIssuerGroup == null || !hs.contains(this.ivTask.ivIssuerGroup)) {
            this.ivTask.ivIssuerID = 0L;
        }
        if (this.ivTask.ivFavoritGroup == null || !hs.contains(this.ivTask.ivFavoritGroup)) {
            this.ivTask.ivFavoritID = 0L;
        }
        if (this.ivTask.ivErledigerGroup == null || !hs.contains(this.ivTask.ivErledigerGroup)) {
            this.ivTask.ivErledigerID = 0L;
        }
        if (this.ivTask.isPeriodTask()) {
            this.ivTask.ivNextExecDates = PeriodTaskHelper.getDates(this.ivTask, MyDate.HEUTE);
        }
    }

    public boolean equals(Object no) {
        if (no instanceof DisplayTask) {
            DisplayTask displayTask = (DisplayTask)no;
            return displayTask.ivTask.ivObjectID == this.ivTask.ivObjectID && displayTask.ivTask.ivObjectType == this.ivTask.ivObjectType && displayTask.ivTask.ivIssueMillis == this.ivTask.ivIssueMillis && displayTask.ivTask.ivPseudoID == this.ivTask.ivPseudoID;
        }
        return false;
    }

    public String getName() {
        return this.ivTask.ivDescription;
    }

    public String getSortString() {
        if (this.ivSortString == null) {
            this.ivSortString = String.valueOf(this.getGroup()) + "|" + this.ivComeFromID + "|" + this.ivComeFromType + "|" + this.ivTask.ivPseudoID;
        }
        return this.ivSortString;
    }

    public String getIdentifierString() {
        return this.getSortString();
    }

    public String getToolTipString() {
        boolean doit;
        String res = null;
        boolean bl = doit = this.ivTask.ivComment != null && this.ivTask.ivComment.trim().length() != 0 || this.ivTask.isPeriodTask() && this.ivTask.ivNextExecDates != null && !this.ivTask.ivNextExecDates.isEmpty();
        if (doit) {
            StringBuilder msb = new StringBuilder("<HTML><body marginwidth=\"5\" marginheight=\"5\">");
            boolean hat = false;
            if (this.ivTask.ivComment != null && this.ivTask.ivComment.trim().length() != 0) {
                msb.append("<b>").append(StringHelper.breakIntoHTMLLines(this.ivTask.ivComment, 70, new StringBuilder())).append("</b>");
                hat = true;
            }
            if (this.ivTask.isPeriodTask() && this.ivTask.ivNextExecDates != null && !this.ivTask.ivNextExecDates.isEmpty()) {
                if (hat) {
                    msb.append("<hr>\n");
                }
                msb.append("<table>");
                msb.append("<tr>");
                msb.append("<td colspan=2>").append(Babel.get("NEXT_DATES")).append("</td>");
                msb.append("</tr>");
                int anz = 0;
                Iterator iterator = this.ivTask.ivNextExecDates.iterator();
                while (iterator.hasNext() && anz < 6) {
                    Integer date = (Integer)iterator.next();
                    int tage = date;
                    msb.append("<tr>");
                    if (tage < MyDate.HEUTE) {
                        msb.append("<td><i>").append(DatumFormat.weekday(MyDate.getWochentag(tage))).append("</i></td>");
                        msb.append("<td><i>").append(DatumFormat.getJustDateString(tage)).append("</i></td>");
                    } else {
                        msb.append("<td><b>").append(DatumFormat.weekday(MyDate.getWochentag(tage))).append("</b></td>");
                        msb.append("<td><b>").append(DatumFormat.getJustDateString(tage)).append("</b></td>");
                    }
                    msb.append("</tr>");
                    ++anz;
                }
                msb.append("</table>");
                hat = true;
            }
            msb.append("</body>");
            res = msb.toString();
            msb.setLength(0);
            Object var3_3 = null;
        }
        return res;
    }

    public String getName(String nullVal) {
        return nullVal;
    }

    public String getBrowseName() {
        return "DisplayTask " + this.getID();
    }

    public int getDateTyp() {
        return this.ivTask.isFixedDayTask() ? 1 : 2;
    }

    public IDObject getUnderlying() {
        IDObject underlying = null;
        if (this.ivTask.ivObjectType == 1 || this.ivTask.ivObjectType == 0) {
            underlying = ObjectStore.getObjectDeadOrAlive(1, this.ivTask.ivObjectID, this.getString("IDO_GROUP", ""), null, true);
        } else if (this.ivTask.ivObjectType == 2) {
            underlying = ObjectStore.getObjectDeadOrAlive(2, this.ivTask.ivObjectID, this.getString("IDO_GROUP", ""), null, true);
        }
        return underlying;
    }
}

